/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.plugins.LegendPlugin.Component;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.scec.vtk.plugins.utils.components.ColorButton;
import org.scec.vtk.plugins.utils.components.SingleColorChooser;

public class FontDialog
extends JDialog
implements ActionListener,
ListSelectionListener {
    private static final long serialVersionUID = 1L;
    private Component owner;
    private JLabel fontLabel;
    private JTextField fontField;
    private JList fontList;
    private JLabel styleLabel;
    private JTextField styleField;
    private JList styleList;
    private JLabel sizeLabel;
    private JTextField sizeField;
    private JList sizeList;
    private JLabel colorLabel;
    private ColorButton colorButton;
    private JLabel sample;
    private JButton okButton;
    private JButton cancelButton;
    private Font selectedFont;
    private Color selectedColor;
    protected boolean cancelled;
    protected boolean okay;

    public FontDialog(Component owner) {
        this.owner = owner;
        this.cancelled = false;
        this.selectedFont = new Font("Arial", 1, 12);
        this.selectedColor = Color.WHITE;
        this.setTitle("Font Chooser");
        this.setModal(true);
        this.selectedFont = new Font("Arial", 0, 12);
        this.setLayout(new GridLayout(2, 4));
        this.setSize(500, 300);
        this.setDefaultCloseOperation(1);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                FontDialog.this.cancelled = true;
            }
        });
        this.setResizable(false);
        this.fontLabel = new JLabel("Font:");
        this.fontField = new JTextField("");
        this.fontField.addActionListener(this);
        this.fontList = new JList<String>(this.getSystemFonts());
        this.fontList.setSelectedIndex(0);
        this.fontField.setText((String)this.fontList.getSelectedValue());
        this.fontList.addListSelectionListener(this);
        JScrollPane fontListScroll = new JScrollPane(this.fontList);
        JPanel fontPanel = new JPanel();
        fontPanel.setLayout(new BoxLayout(fontPanel, 1));
        fontPanel.setBorder(new EmptyBorder(5, 0, 0, 0));
        fontPanel.add(this.fontField);
        fontPanel.add(fontListScroll);
        fontPanel.add(this.fontLabel);
        this.styleLabel = new JLabel("Style:");
        this.styleField = new JTextField("");
        this.styleField.addActionListener(this);
        this.styleList = new JList<String>(this.getFontStyles());
        this.styleList.setSelectedIndex(0);
        this.styleField.setText((String)this.styleList.getSelectedValue());
        this.styleList.addListSelectionListener(this);
        JScrollPane styleListScroll = new JScrollPane(this.styleList);
        JPanel stylePanel = new JPanel();
        stylePanel.setLayout(new BoxLayout(stylePanel, 1));
        stylePanel.setBorder(new EmptyBorder(5, 0, 0, 0));
        stylePanel.add(this.styleField);
        stylePanel.add(styleListScroll);
        stylePanel.add(this.styleLabel);
        this.sizeLabel = new JLabel("Font:");
        this.sizeField = new JTextField("");
        this.sizeField.addActionListener(this);
        this.sizeList = new JList<String>(this.getFontSizes());
        this.sizeList.setSelectedIndex(0);
        this.sizeField.setText((String)this.sizeList.getSelectedValue());
        this.sizeList.addListSelectionListener(this);
        JScrollPane sizeListScroll = new JScrollPane(this.sizeList);
        JPanel sizePanel = new JPanel();
        sizePanel.setLayout(new BoxLayout(sizePanel, 1));
        sizePanel.setBorder(new EmptyBorder(5, 0, 0, 0));
        sizePanel.add(this.sizeField);
        sizePanel.add(sizeListScroll);
        sizePanel.add(this.sizeLabel);
        this.colorLabel = new JLabel("");
        this.colorButton = new ColorButton(this, "Select a Color");
        this.colorButton.setEnabled(true);
        JPanel colorPanel = new JPanel();
        colorPanel.setLayout(new BoxLayout(colorPanel, 1));
        colorPanel.setBorder(BorderFactory.createTitledBorder("Color"));
        colorPanel.add(this.colorButton);
        colorPanel.add(this.colorLabel);
        this.sample = new JLabel("");
        this.sample.setFont(this.selectedFont);
        this.sample.setText(this.fontField.getText());
        JPanel samplePanel = new JPanel();
        samplePanel.setLayout(new BoxLayout(samplePanel, 1));
        samplePanel.setBorder(BorderFactory.createTitledBorder("Sample"));
        samplePanel.add(this.sample);
        this.okButton = new JButton("OK");
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(this);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 1));
        buttonPanel.add(this.okButton);
        buttonPanel.add(this.cancelButton);
        this.add(fontPanel);
        this.add(stylePanel);
        this.add(sizePanel);
        this.add(buttonPanel);
        this.add(new JPanel());
        this.add(colorPanel);
        this.add(samplePanel);
        this.add(new JPanel());
    }

    private String[] getSystemFonts() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] fontNames = ge.getAvailableFontFamilyNames();
        return fontNames;
    }

    private String[] getFontStyles() {
        String[] styles = new String[]{"Regular", "Italic", "Bold"};
        return styles;
    }

    private String[] getFontSizes() {
        String[] sizes = new String[]{"8", "9", "10", "12", "14", "16", "18", "20", "22", "24", "26", "28", "36", "48", "72"};
        return sizes;
    }

    private int getSelectedFontStyle() {
        String style = (String)this.styleList.getSelectedValue();
        if (style.equals("Regular")) {
            return 0;
        }
        if (style.equals("Italic")) {
            return 2;
        }
        return 1;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        Object source = e.getSource();
        this.selectedFont = new Font(this.fontField.getText(), this.getSelectedFontStyle(), Integer.valueOf(this.sizeField.getText()));
        if (source == this.fontList) {
            this.fontField.setText((String)this.fontList.getSelectedValue());
        } else if (source == this.styleList) {
            this.styleField.setText((String)this.styleList.getSelectedValue());
        } else if (source == this.sizeList) {
            this.sizeField.setText((String)this.sizeList.getSelectedValue());
        }
        this.draw();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        this.selectedFont = new Font(this.fontField.getText(), this.getSelectedFontStyle(), Integer.valueOf(this.sizeField.getText()));
        if (source == this.colorButton) {
            this.selectedColor = new SingleColorChooser((Component)this).getColor();
            if (this.selectedColor != null) {
                this.colorLabel.setBackground(this.selectedColor);
            }
        } else if (source == this.okButton) {
            this.selectedFont = new Font(this.fontField.getText(), this.getSelectedFontStyle(), Integer.valueOf(this.sizeField.getText()));
            this.cancelled = true;
            this.okay = true;
            this.hide();
        } else if (source == this.cancelButton) {
            this.cancelled = true;
            this.okay = false;
            this.hide();
        } else if (source == this.fontField) {
            for (int i = 0; i < this.fontList.getModel().getSize(); ++i) {
                if (!this.fontList.getModel().getElementAt(i).equals(this.fontField.getText())) continue;
                this.fontList.setSelectedIndex(i);
            }
        } else if (source == this.styleField) {
            for (int i = 0; i < this.styleList.getModel().getSize(); ++i) {
                if (!this.styleList.getModel().getElementAt(i).equals(this.styleField.getText())) continue;
                this.styleList.setSelectedIndex(i);
            }
        } else if (source == this.sizeField) {
            for (int i = 0; i < this.sizeList.getModel().getSize(); ++i) {
                if (!this.sizeList.getModel().getElementAt(i).equals(this.sizeField.getText())) continue;
                this.sizeList.setSelectedIndex(i);
            }
        }
        this.draw();
    }

    private void draw() {
        this.sample.setFont(this.selectedFont);
        this.sample.setText(this.fontField.getText());
    }

    @Override
    public Font getFont() {
        return this.selectedFont;
    }

    public Color getColor() {
        return this.selectedColor;
    }

    public boolean windowWasCancelled() {
        return this.cancelled;
    }

    public boolean selectedOkay() {
        return this.okay;
    }

    public void deselect() {
        this.okay = false;
    }

    public void showDialog() {
        this.setLocationRelativeTo(this.owner);
        this.setVisible(true);
    }
}

