/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.plugins.LegendPlugin;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.scec.vtk.commons.legend.LegendItem;
import org.scec.vtk.commons.legend.LegendUtils;
import org.scec.vtk.main.Info;
import org.scec.vtk.main.MainGUI;
import org.scec.vtk.plugins.LegendPlugin.Component.FontDialog;
import org.scec.vtk.plugins.LegendPlugin.CreateLegendsGUI;
import org.scec.vtk.plugins.LegendPlugin.LegendPlugin;
import org.scec.vtk.plugins.Plugin;
import org.scec.vtk.plugins.PluginActors;
import org.scec.vtk.plugins.PluginActorsChangeListener;
import org.scec.vtk.plugins.utils.components.ImageFileChooser;
import org.scec.vtk.plugins.utils.components.SingleColorChooser;
import vtk.vtkActor2D;
import vtk.vtkDataObject;
import vtk.vtkImageMapper;
import vtk.vtkImageResize;
import vtk.vtkProp;
import vtk.vtkScalarBarActor;
import vtk.vtkTextActor;

public class LegendPluginGUI
extends JPanel
implements ActionListener,
ChangeListener,
ListSelectionListener,
PluginActorsChangeListener {
    private static final long serialVersionUID = 1L;
    private JButton displayButton;
    private JButton moveLeftButton;
    private JButton moveRightButton;
    private JButton moveUpButton;
    private JButton moveDownButton;
    private JButton imageButton;
    private JButton textButton;
    private JButton removeButton;
    private JButton createButton;
    private JButton editButton;
    private SingleColorChooser colorChooser = new SingleColorChooser(this);
    private JSlider transparencySlider;
    private JTextField scaleField;
    private JList<LegendItem> legendSelectList;
    private DefaultListModel<LegendItem> model;
    final float SCALE = 0.5f;
    public CreateLegendsGUI createLeg;
    private LegendPlugin plugin;
    private PluginActors legendActors;
    private ImageFileChooser chooser;

    public LegendPluginGUI(LegendPlugin plugin) {
        this.plugin = plugin;
        this.legendActors = plugin.getPluginActors();
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.setLayout(new BoxLayout(this, 1));
        this.displayButton = new JButton("Display");
        this.displayButton.setEnabled(false);
        this.displayButton.addActionListener(this);
        this.moveLeftButton = new JButton("Move Left");
        this.moveLeftButton.setEnabled(false);
        this.moveLeftButton.addActionListener(this);
        this.moveRightButton = new JButton("Move Right");
        this.moveRightButton.setEnabled(false);
        this.moveRightButton.addActionListener(this);
        this.moveUpButton = new JButton("Move Up");
        this.moveUpButton.setEnabled(false);
        this.moveUpButton.addActionListener(this);
        this.moveDownButton = new JButton("Move Down");
        this.moveDownButton.setEnabled(false);
        this.moveDownButton.addActionListener(this);
        JPanel upperButtonPanel = new JPanel();
        upperButtonPanel.setLayout(new BoxLayout(upperButtonPanel, 0));
        upperButtonPanel.setBorder(new EmptyBorder(5, 0, 0, 0));
        upperButtonPanel.add(this.displayButton);
        upperButtonPanel.add(this.moveLeftButton);
        upperButtonPanel.add(this.moveRightButton);
        upperButtonPanel.add(this.moveUpButton);
        upperButtonPanel.add(this.moveDownButton);
        this.model = new DefaultListModel();
        this.legendSelectList = new JList<LegendItem>(this.model);
        this.legendSelectList.addListSelectionListener(this);
        JScrollPane listScroll = new JScrollPane(this.legendSelectList);
        JPanel listPanel = new JPanel();
        listPanel.setLayout(new BoxLayout(listPanel, 1));
        listPanel.setBorder(BorderFactory.createTitledBorder("Legends"));
        listPanel.add(upperButtonPanel);
        listPanel.add(listScroll);
        this.imageButton = new JButton("Add Image");
        this.imageButton.setEnabled(true);
        this.imageButton.addActionListener(this);
        this.createButton = new JButton("Create Legend");
        this.createButton.setEnabled(true);
        this.createButton.addActionListener(this);
        this.textButton = new JButton("Add Text");
        this.textButton.addActionListener(this);
        this.textButton.setEnabled(true);
        this.editButton = new JButton("Edit Text");
        this.editButton.addActionListener(this);
        this.editButton.setEnabled(false);
        this.removeButton = new JButton("Remove");
        this.removeButton.addActionListener(this);
        this.removeButton.setEnabled(false);
        JPanel lowerButtonPanel = new JPanel();
        lowerButtonPanel.setLayout(new BoxLayout(lowerButtonPanel, 0));
        lowerButtonPanel.setBorder(new EmptyBorder(5, 0, 0, 0));
        lowerButtonPanel.add(this.imageButton);
        lowerButtonPanel.add(this.createButton);
        lowerButtonPanel.add(this.textButton);
        lowerButtonPanel.add(this.editButton);
        lowerButtonPanel.add(this.removeButton);
        listPanel.add(lowerButtonPanel);
        this.add(listPanel);
        Info.getMainGUI().addPluginActorsChangeListener(this);
        for (LegendItem legend : Info.getMainGUI().getDisplayedLegends()) {
            this.legendAdded(legend);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        LegendItem legend;
        Object source = e.getSource();
        if (source == this.legendSelectList && (legend = this.legendSelectList.getSelectedValue()) != null) {
            int visibility = legend.getActor().GetVisibility();
            if (visibility == 1) {
                this.displayButton.setText("Hide");
                this.setMoveButtonsEnabled(true);
                this.displayButton.setEnabled(true);
                if (legend.getActor() instanceof vtkTextActor) {
                    this.editButton.setEnabled(true);
                } else {
                    this.editButton.setEnabled(false);
                }
                this.removeButton.setEnabled(true);
            } else {
                this.displayButton.setText("Display");
                if (legend.getActor() instanceof vtkTextActor) {
                    this.editButton.setEnabled(false);
                }
                this.setMoveButtonsEnabled(false);
                this.removeButton.setEnabled(false);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.imageButton) {
            int returnVal;
            if (this.chooser == null) {
                this.chooser = new ImageFileChooser();
                File dataDir = new File(MainGUI.getCWD(), "data");
                if (dataDir.exists()) {
                    this.chooser.setCurrentDirectory(dataDir);
                }
            }
            if ((returnVal = this.chooser.showOpenDialog(this)) == 0) {
                File file = this.chooser.getSelectedFile();
                try {
                    LegendItem legend = LegendUtils.buildImageLegend(this.plugin, file, 0.0, 0.0);
                    this.legendActors.addLegend(legend);
                    MainGUI.updateRenderWindow();
                }
                catch (IOException e1) {
                    JOptionPane.showMessageDialog(this, e1.getMessage(), "Error loading image", 0);
                }
                catch (NullPointerException e2) {
                    JOptionPane.showMessageDialog(this, "That image type is not supported. Please use a .jpg, .png, or .tiff image.", "Error loading image.", 0);
                }
            }
        } else if (source == this.textButton) {
            TextDialogBox textDialog = new TextDialogBox("");
            String text = textDialog.getText();
            if (text != null && !text.equals("")) {
                Font font = textDialog.getFont();
                Color color = textDialog.getColor();
                LegendItem legend = LegendUtils.buildTextLegend(this.plugin, text, font, color, 0.0, 0.0);
                this.legendActors.addLegend(legend);
                MainGUI.updateRenderWindow();
            }
        } else if (source == this.removeButton) {
            LegendItem legend = this.legendSelectList.getSelectedValue();
            if (legend != null) {
                Plugin plugin = legend.getSource();
                plugin.getPluginActors().removeLegend(legend);
                MainGUI.updateRenderWindow();
            }
        } else if (source == this.displayButton) {
            LegendItem legend = this.legendSelectList.getSelectedValue();
            if (legend != null) {
                vtkActor2D legendActor = legend.getActor();
                int visibility = legendActor.GetVisibility();
                if (visibility == 1) {
                    legendActor.SetVisibility(0);
                    this.displayButton.setText("Display");
                    this.enableButtons(false);
                } else {
                    legendActor.SetVisibility(1);
                    this.displayButton.setText("Hide");
                    this.enableButtons(true);
                }
                legendActor.Modified();
                MainGUI.updateRenderWindow();
            }
        } else if (source == this.editButton) {
            LegendItem legend = this.legendSelectList.getSelectedValue();
            if (legend != null) {
                vtkTextActor actor = (vtkTextActor)legend.getActor();
                TextDialogBox textDialog = new TextDialogBox(actor.GetInput());
                String text = textDialog.getText();
                Font font = textDialog.getFont();
                Color color = textDialog.getColor();
                actor.SetInput(text);
                actor.GetTextProperty().SetFontFamilyAsString(font.getFamily());
                actor.GetTextProperty().SetFontSize(font.getSize());
                actor.GetProperty().SetColor((double)color.getRed(), (double)color.getGreen(), (double)color.getBlue());
                actor.Modified();
                legend.setTitle(text);
                MainGUI.updateRenderWindow();
                this.legendSelectList.updateUI();
            }
        } else if (source == this.moveLeftButton) {
            LegendItem legend = this.legendSelectList.getSelectedValue();
            if (legend != null) {
                this.moveLegend(legend, -5.0, 0.0);
            }
        } else if (source == this.moveRightButton) {
            LegendItem legend = this.legendSelectList.getSelectedValue();
            if (legend != null) {
                this.moveLegend(legend, 5.0, 0.0);
            }
        } else if (source == this.moveUpButton) {
            System.out.println("move up");
            LegendItem legend = this.legendSelectList.getSelectedValue();
            if (legend != null) {
                this.moveLegend(legend, 0.0, 5.0);
            }
        } else if (source == this.moveDownButton) {
            LegendItem legend = this.legendSelectList.getSelectedValue();
            if (legend != null) {
                this.moveLegend(legend, 0.0, -5.0);
            }
        } else if (source == this.scaleField) {
            this.updateScale();
        } else if (source == this.createButton) {
            this.createLeg = new CreateLegendsGUI(this.scaleField, this.displayButton, this.transparencySlider);
            this.createLeg.setLocation(Info.getMainGUI().getLocation());
            this.createLeg.setVisible(true);
        }
    }

    private void moveLegend(LegendItem legend, double x, double y) {
        vtkActor2D actor = legend.getActor();
        double[] position = actor.GetPosition();
        if (actor instanceof vtkScalarBarActor) {
            actor.SetPosition(position[0] + x * 0.01, position[1] + y * 0.01);
        } else {
            actor.SetPosition(position[0] + x, position[1] + y);
        }
        actor.Modified();
        MainGUI.updateRenderWindow();
    }

    private void updateScale() {
        LegendItem legend = this.legendSelectList.getSelectedValue();
        if (legend != null) {
            try {
                double scaleFactor = Double.valueOf(this.scaleField.getText());
                System.out.println(scaleFactor);
                if (scaleFactor == 0.0) {
                    return;
                }
                vtkImageResize resize = new vtkImageResize();
                vtkActor2D actor = legend.getActor();
                resize.SetInputData((vtkDataObject)((vtkImageMapper)actor.GetMapper()).GetInput());
                resize.SetOutputDimensions((int)(actor.GetHeight() * scaleFactor), (int)(actor.GetWidth() * scaleFactor), 1);
                resize.Update();
                actor.GetMapper().SetInputConnection(resize.GetOutputPort());
                actor.Modified();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            MainGUI.updateRenderWindow();
        }
    }

    private void setMoveButtonsEnabled(boolean enabled) {
        this.moveUpButton.setEnabled(enabled);
        this.moveDownButton.setEnabled(enabled);
        this.moveLeftButton.setEnabled(enabled);
        this.moveRightButton.setEnabled(enabled);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        LegendItem legend;
        JSlider source = (JSlider)e.getSource();
        if (source == this.transparencySlider && (legend = this.legendSelectList.getSelectedValue()) != null) {
            int transparency = source.getValue();
            if (transparency == 0) {
                return;
            }
            vtkActor2D actor = legend.getActor();
            actor.GetProperty().SetOpacity((double)transparency);
            actor.Modified();
            MainGUI.updateRenderWindow();
        }
    }

    public void itemStateChanged(ItemEvent e) {
    }

    public void unload() {
        Info.getMainGUI().removePluginActorsChangeListener(this);
        this.legendActors.clearLegends();
        this.model.clear();
        MainGUI.updateRenderWindow();
    }

    public JList<LegendItem> getLegendSelectList() {
        return this.legendSelectList;
    }

    public DefaultListModel<LegendItem> getLegendModel() {
        return this.model;
    }

    public LegendPlugin getPlugin() {
        return this.plugin;
    }

    public void addLegend(LegendItem legend) {
        this.legendActors.addLegend(legend);
        this.displayButton.setEnabled(true);
        this.enableButtons(true);
    }

    private void enableButtons(boolean visibility) {
        this.setMoveButtonsEnabled(visibility);
        this.editButton.setEnabled(visibility);
        this.removeButton.setEnabled(visibility);
    }

    @Override
    public void actorAdded(vtkProp actor) {
    }

    @Override
    public void actorRemoved(vtkProp actor) {
    }

    @Override
    public synchronized void legendAdded(LegendItem legend) {
        if (!this.model.contains(legend)) {
            this.model.addElement(legend);
        }
    }

    @Override
    public synchronized void legendRemoved(LegendItem legend) {
        this.model.removeElement(legend);
    }

    class TextDialogBox {
        private JDialog dialog = new JDialog();
        private JTextArea textField;
        private JPanel upperPanel;
        private JPanel lowerPanel;
        private JButton fontButton;
        private JButton okButton;
        private FontDialog fontGUI;
        private String text;
        private JScrollPane scrollPane;

        public TextDialogBox(String s) {
            this.dialog.setSize(400, 300);
            this.dialog.setLocation(500, 500);
            this.dialog.setModal(true);
            this.dialog.setTitle("Text To Add");
            this.dialog.getContentPane().setLayout(new BoxLayout(this.dialog.getContentPane(), 1));
            this.upperPanel = new JPanel();
            this.textField = new JTextArea(12, 30);
            this.textField.setText(s);
            this.scrollPane = new JScrollPane(this.textField);
            this.upperPanel.add(this.scrollPane);
            this.lowerPanel = new JPanel();
            this.lowerPanel.setLayout(new BoxLayout(this.lowerPanel, 0));
            this.fontButton = new JButton("Font");
            this.fontButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TextDialogBox.this.fontGUI = new FontDialog(TextDialogBox.this.textField);
                    TextDialogBox.this.fontGUI.setVisible(true);
                    if (!TextDialogBox.this.fontGUI.isVisible()) {
                        TextDialogBox.this.textField.setFont(TextDialogBox.this.fontGUI.getFont());
                        if (TextDialogBox.this.fontGUI.getColor() == Color.WHITE && TextDialogBox.this.textField.getBackground().equals(new Color(255, 255, 255))) {
                            TextDialogBox.this.textField.setForeground(Color.BLACK);
                        } else {
                            TextDialogBox.this.textField.setForeground(TextDialogBox.this.fontGUI.getColor());
                        }
                    }
                }
            });
            this.okButton = new JButton("OK");
            this.okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TextDialogBox.this.text = TextDialogBox.this.textField.getText();
                    TextDialogBox.this.dialog.setVisible(false);
                    TextDialogBox.this.dialog.dispose();
                }
            });
            this.lowerPanel.add(this.fontButton);
            this.lowerPanel.add(this.okButton);
            this.dialog.add(this.upperPanel);
            this.dialog.add(this.lowerPanel);
            this.dialog.pack();
            this.dialog.setVisible(true);
        }

        public String getText() {
            return this.text;
        }

        public Font getFont() {
            return this.textField.getFont();
        }

        public Color getColor() {
            if (this.fontGUI != null && this.fontGUI.getColor() != null) {
                return this.fontGUI.getColor();
            }
            return Color.WHITE;
        }
    }
}

