/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.plugins.LegendPlugin;

import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.dom4j.Element;
import org.scec.vtk.commons.legend.LegendItem;
import org.scec.vtk.commons.legend.LegendUtils;
import org.scec.vtk.main.Info;
import org.scec.vtk.main.MainGUI;
import org.scec.vtk.plugins.LegendPlugin.LegendPluginGUI;
import org.scec.vtk.plugins.PluginState;
import vtk.vtkActor2D;
import vtk.vtkTextActor;

public class LegendPluginState
implements PluginState {
    private LegendPluginGUI parent;
    private ArrayList<String> imagePath;
    private ArrayList<double[]> coordinates;
    private ArrayList<String> text;
    private ArrayList<String> font;
    private ArrayList<Integer> fontSize;
    private ArrayList<double[]> color;
    private ArrayList<Integer> visibility;

    LegendPluginState(LegendPluginGUI parent) {
        this.parent = parent;
        this.imagePath = new ArrayList();
        this.coordinates = new ArrayList();
        this.visibility = new ArrayList();
        this.text = new ArrayList();
        this.font = new ArrayList();
        this.fontSize = new ArrayList();
        this.color = new ArrayList();
    }

    public void copyLatestCatalogDetails() {
        this.imagePath.clear();
        this.coordinates.clear();
        this.text.clear();
        this.font.clear();
        this.fontSize.clear();
        this.color.clear();
        this.visibility.clear();
        for (int i = 0; i < this.parent.getLegendModel().size(); ++i) {
            LegendItem legend = this.parent.getLegendModel().getElementAt(i);
            if (legend != null) {
                if (legend.getActor() instanceof vtkActor2D) {
                    this.imagePath.add(legend.getImagePath());
                } else if (legend.getActor() instanceof vtkTextActor) {
                    this.text.add(legend.getTitle());
                    this.font.add(((vtkTextActor)legend.getActor()).GetTextProperty().GetFontFamilyAsString());
                    this.fontSize.add(((vtkTextActor)legend.getActor()).GetTextProperty().GetFontSize());
                    this.color.add(((vtkTextActor)legend.getActor()).GetTextProperty().GetColor());
                }
                this.visibility.add(legend.getActor().GetVisibility());
                this.coordinates.add(legend.getActor().GetPosition());
                continue;
            }
            this.visibility.add(0);
            this.coordinates.add(null);
            this.imagePath.add(null);
            this.text.add(null);
            this.font.add(null);
            this.fontSize.add(null);
            this.color.add(null);
        }
    }

    @Override
    public void load() {
        for (int i = 0; i < this.parent.getLegendModel().getSize() && !this.visibility.isEmpty(); ++i) {
            if (this.parent.getLegendModel().get(i) == null) continue;
            if (i < this.visibility.size()) {
                this.parent.getLegendModel().get(i).getActor().SetVisibility(this.visibility.get(i).intValue());
                continue;
            }
            this.parent.getLegendModel().get(i).getActor().SetVisibility(0);
        }
    }

    private void createElement(Element stateEl) {
        for (int i = 0; i < this.parent.getLegendModel().getSize(); ++i) {
            Element propertyEl;
            LegendItem legend = this.parent.getLegendModel().getElementAt(i);
            if (legend == null) continue;
            if (legend.getActor() instanceof vtkTextActor) {
                propertyEl = stateEl.addElement("TextLegend");
                propertyEl.addElement("legendName").addText(legend.toString());
                propertyEl.addElement("text").addText(((vtkTextActor)legend.getActor()).GetInput());
                propertyEl.addElement("font-family").addText(((vtkTextActor)legend.getActor()).GetTextProperty().GetFontFamilyAsString());
                propertyEl.addElement("font-size").addText("" + ((vtkTextActor)legend.getActor()).GetTextProperty().GetFontSize());
                propertyEl.addElement("colorR").addText("" + ((vtkTextActor)legend.getActor()).GetTextProperty().GetColor()[0]);
                propertyEl.addElement("colorG").addText("" + ((vtkTextActor)legend.getActor()).GetTextProperty().GetColor()[1]);
                propertyEl.addElement("colorB").addText("" + ((vtkTextActor)legend.getActor()).GetTextProperty().GetColor()[2]);
                propertyEl.addElement("x-coordinate").addText("" + legend.getActor().GetPosition()[0]);
                propertyEl.addElement("y-coordinate").addText("" + legend.getActor().GetPosition()[1]);
                propertyEl.addElement("visibility").addText("" + legend.getActor().GetVisibility());
                continue;
            }
            if (!(legend.getActor() instanceof vtkActor2D) || legend.getImagePath() == null) continue;
            propertyEl = stateEl.addElement("ImageLegend");
            propertyEl.addElement("legendName").addText(legend.toString());
            propertyEl.addElement("imagePath").addText(legend.getImagePath());
            propertyEl.addElement("x-coordinate").addText("" + legend.getActor().GetPosition()[0]);
            propertyEl.addElement("y-coordinate").addText("" + legend.getActor().GetPosition()[1]);
            propertyEl.addElement("visibility").addText("" + legend.getActor().GetVisibility());
        }
    }

    @Override
    public void toXML(Element stateEl) {
        this.copyLatestCatalogDetails();
        this.createElement(stateEl);
    }

    public void showLegends() {
        int i = 0;
        for (i = 0; i < this.text.size(); ++i) {
            Color c = new Color((float)this.color.get(i)[0], (float)this.color.get(i)[1], (float)this.color.get(i)[2]);
            LegendItem legendItem = LegendUtils.buildTextLegend(this.parent.getPlugin(), this.text.get(i), this.font.get(i), this.fontSize.get(i), c, this.coordinates.get(i)[0], this.coordinates.get(i)[1]);
            this.parent.addLegend(legendItem);
        }
        for (int j = 0; j < this.imagePath.size(); ++j) {
            File file = new File(this.imagePath.get(j));
            try {
                LegendItem legendItem = LegendUtils.buildImageLegend(this.parent.getPlugin(), file, this.coordinates.get(i)[0], this.coordinates.get(i)[1]);
                this.parent.addLegend(legendItem);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ++i;
        }
        Info.getMainGUI();
        MainGUI.updateRenderWindow();
    }

    @Override
    public void fromXML(Element stateEl) {
        Element e;
        Iterator i = stateEl.elementIterator("TextLegend");
        while (i.hasNext()) {
            e = (Element)i.next();
            this.text.add(e.elementText("text"));
            this.font.add(e.elementText("font-family"));
            this.fontSize.add(Integer.parseInt(e.elementText("font-size")));
            double[] textColor = new double[]{Double.parseDouble(e.elementText("colorR")), Double.parseDouble(e.elementText("colorG")), Double.parseDouble(e.elementText("colorB"))};
            this.color.add(textColor);
            double[] coord = new double[]{Double.parseDouble(e.elementText("x-coordinate")), Double.parseDouble(e.elementText("y-coordinate"))};
            this.coordinates.add(coord);
            this.visibility.add(Integer.parseInt(e.elementText("visibility")));
        }
        i = stateEl.elementIterator("ImageLegend");
        while (i.hasNext()) {
            e = (Element)i.next();
            this.imagePath.add(e.elementText("imagePath"));
            double[] coord = new double[]{Double.parseDouble(e.elementText("x-coordinate")), Double.parseDouble(e.elementText("y-coordinate"))};
            this.coordinates.add(coord);
            this.visibility.add(Integer.parseInt(e.elementText("visibility")));
        }
        this.showLegends();
    }

    @Override
    public PluginState deepCopy() {
        LegendPluginState state = new LegendPluginState(this.parent);
        state.copyLatestCatalogDetails();
        return state;
    }
}

