/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.plugins.PickingTestPlugin;

import com.google.common.base.Preconditions;
import java.awt.Color;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import org.opensha.commons.geo.GriddedRegion;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.param.ParameterList;
import org.opensha.sha.faultSurface.Surface3D;
import org.scec.vtk.commons.opensha.faults.AbstractFaultSection;
import org.scec.vtk.commons.opensha.surfaces.FaultActorBundle;
import org.scec.vtk.commons.opensha.surfaces.FaultActorBundler;
import org.scec.vtk.commons.opensha.surfaces.FaultSectionActorList;
import org.scec.vtk.commons.opensha.surfaces.FaultSectionBundledActorList;
import org.scec.vtk.commons.opensha.surfaces.GeometryGenerator;
import org.scec.vtk.commons.opensha.surfaces.PolygonSurfaceGenerator;
import org.scec.vtk.main.MainGUI;
import org.scec.vtk.plugins.ActionPlugin;
import org.scec.vtk.plugins.PickingTestPlugin.PickingTestPluginGUI;
import org.scec.vtk.tools.picking.PickEnabledActor;
import org.scec.vtk.tools.picking.PickHandler;
import org.scec.vtk.tools.picking.PointPickEnabledActor;
import vtk.vtkActor;
import vtk.vtkCellPicker;
import vtk.vtkProp;

public class PickingTestPlugin
extends ActionPlugin
implements FaultActorBundler {
    private GriddedRegion reg = new GriddedRegion(new Location(32.0, -125.0), new Location(43.0, -114.0), 0.2, null);
    private NoBundlePickHandler noBundlePick = new NoBundlePickHandler();
    private BundlePickHandler bundlePick = new BundlePickHandler();
    private PolygonSurfaceGenerator polyGen;
    private FaultActorBundle bundle;
    private Map<AbstractFaultSection, FaultSectionBundledActorList> sectMap;
    private static final Color pickedColor = Color.RED;
    private static final double[] pickedColorArray = GeometryGenerator.getColorDoubleArray(pickedColor);
    private static final Color regColor = Color.BLUE;
    private static final double[] regColorArray = GeometryGenerator.getColorDoubleArray(regColor);

    public void clear() {
        this.getPluginActors().clearActors();
    }

    public void display() {
        System.out.println("Displaying " + this.reg.getNodeCount() + " actors (no bundle)");
        LocationList nodeList = this.reg.getNodeList();
        this.polyGen = new PolygonSurfaceGenerator();
        this.polyGen.setBundlerEneabled(false);
        this.polyGen.setPickHandler(this.noBundlePick);
        for (int n = 0; n < this.reg.getNodeCount(); ++n) {
            FaultSectionActorList actorList = this.polyGen.createFaultActors(GeometryGenerator.GeometryType.POLYGON, this.getPoly((Location)nodeList.get(n)), regColor, 0.7, null);
            this.getPluginActors().addActor((vtkProp)actorList.get(0));
        }
    }

    @Override
    public synchronized FaultActorBundle getBundle(AbstractFaultSection fault) {
        if (this.bundle == null) {
            this.bundle = new FaultActorBundle();
        }
        return this.bundle;
    }

    @Override
    public synchronized void clearBundles() {
        this.bundle = null;
    }

    public void displayBundled() {
        System.out.println("Displaying bundled!");
        this.sectMap = new HashMap<AbstractFaultSection, FaultSectionBundledActorList>();
        LocationList nodeList = this.reg.getNodeList();
        this.polyGen = new PolygonSurfaceGenerator();
        this.polyGen.setBundlerEneabled(true);
        this.polyGen.setFaultActorBundler(this);
        this.polyGen.setPickHandler(this.bundlePick);
        this.clearBundles();
        for (int n = 0; n < this.reg.getNodeCount(); ++n) {
            FakeFaultSection sect = new FakeFaultSection("Sect " + n, n);
            FaultSectionActorList actorList = this.polyGen.createFaultActors(GeometryGenerator.GeometryType.POLYGON, this.getPoly((Location)nodeList.get(n)), regColor, 0.7, sect);
            Preconditions.checkState((boolean)(actorList instanceof FaultSectionBundledActorList));
            this.sectMap.put(sect, (FaultSectionBundledActorList)actorList);
        }
        for (FaultSectionBundledActorList actorList : this.sectMap.values()) {
            actorList.getBundle().setVisible(actorList, true);
        }
        PointPickEnabledActor<AbstractFaultSection> actor = this.getBundle(null).getActor();
        actor.Modified();
        actor.SetVisibility(1);
        actor.SetPickable(1);
        this.getPluginActors().addActor((vtkProp)actor);
    }

    private List<GeometryGenerator.PointArray> getPoly(Location loc) {
        double spacing = this.reg.getSpacing();
        Location ll = loc;
        double lat = ll.getLatitude();
        double lon = ll.getLongitude();
        Location ul = new Location(lat + spacing, lon);
        Location ur = new Location(lat + spacing, lon + spacing);
        Location lr = new Location(lat, lon + spacing);
        ArrayList<GeometryGenerator.PointArray> polygons = new ArrayList<GeometryGenerator.PointArray>();
        double[][] points = new double[][]{GeometryGenerator.getPointForLoc(ll), GeometryGenerator.getPointForLoc(ul), GeometryGenerator.getPointForLoc(ur), GeometryGenerator.getPointForLoc(lr)};
        polygons.add(new GeometryGenerator.PointArray(points));
        return polygons;
    }

    @Override
    protected JPanel createGUI() throws IOException {
        PickingTestPluginGUI dpg = new PickingTestPluginGUI(this);
        return dpg.getPanel();
    }

    private class NoBundlePickHandler
    implements PickHandler<AbstractFaultSection> {
        private vtkActor prev = null;

        private NoBundlePickHandler() {
        }

        @Override
        public synchronized void actorPicked(PickEnabledActor<AbstractFaultSection> actor, AbstractFaultSection reference, vtkCellPicker picker, MouseEvent e) {
            System.out.println("Picked!");
            actor.GetProperty().SetColor(pickedColorArray);
            actor.Modified();
            if (this.prev != null) {
                this.prev.GetProperty().SetColor(regColorArray);
                this.prev.Modified();
            }
            this.prev = actor;
            MainGUI.updateRenderWindow();
        }
    }

    private class BundlePickHandler
    implements PickHandler<AbstractFaultSection> {
        private FaultSectionBundledActorList prev = null;

        private BundlePickHandler() {
        }

        @Override
        public synchronized void actorPicked(PickEnabledActor<AbstractFaultSection> actor, AbstractFaultSection reference, vtkCellPicker picker, MouseEvent e) {
            FaultSectionBundledActorList list = PickingTestPlugin.this.sectMap.get(reference);
            if (list != null) {
                System.out.println("Picked!");
                PickingTestPlugin.this.polyGen.updateColor(list, pickedColor);
                if (this.prev != null) {
                    PickingTestPlugin.this.polyGen.updateColor(this.prev, regColor);
                }
                this.prev = list;
                MainGUI.updateRenderWindow();
            }
        }
    }

    private static class FakeFaultSection
    extends AbstractFaultSection {
        public FakeFaultSection(String name, int id) {
            super(name, id);
        }

        @Override
        public Surface3D createSurface(ParameterList faultRepresentationParams) {
            return null;
        }

        @Override
        public double getSlipRate() {
            return 0.0;
        }

        @Override
        public double getAvgRake() {
            return 0.0;
        }

        @Override
        public double getAvgStrike() {
            return 0.0;
        }

        @Override
        public double getAvgDip() {
            return 0.0;
        }
    }
}

