/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.plugins;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.scec.vtk.commons.legend.LegendItem;
import org.scec.vtk.main.MainGUI;
import org.scec.vtk.plugins.PluginActorsChangeListener;
import vtk.vtkActor;
import vtk.vtkProp;

public class PluginActors {
    private HashSet<vtkProp> actors;
    private HashSet<LegendItem> legends;
    private List<PluginActorsChangeListener> listeners = new ArrayList<PluginActorsChangeListener>();

    public PluginActors() {
        this.actors = new HashSet();
        this.legends = new HashSet();
    }

    public void addActorsChangeListener(PluginActorsChangeListener l) {
        this.listeners.add(l);
    }

    public synchronized void addActor(vtkProp actor) {
        if (!this.actors.contains(actor)) {
            this.actors.add(actor);
            for (PluginActorsChangeListener l : this.listeners) {
                l.actorAdded(actor);
            }
        }
    }

    public synchronized void removeActor(vtkProp actor) {
        if (this.actors.contains(actor)) {
            this.actors.remove(actor);
            for (PluginActorsChangeListener l : this.listeners) {
                l.actorRemoved(actor);
            }
        }
    }

    public boolean containsActor(vtkProp actor) {
        return this.actors.contains(actor);
    }

    public synchronized void clearActors() {
        for (vtkProp actor : new ArrayList<vtkProp>(this.actors)) {
            this.removeActor(actor);
        }
    }

    public synchronized void addLegend(LegendItem legend) {
        if (!this.legends.contains(legend)) {
            this.legends.add(legend);
            for (PluginActorsChangeListener l : this.listeners) {
                l.legendAdded(legend);
            }
        }
    }

    public synchronized void removeLegend(LegendItem legend) {
        if (this.legends.contains(legend)) {
            this.legends.remove(legend);
            for (PluginActorsChangeListener l : this.listeners) {
                l.legendRemoved(legend);
            }
        }
    }

    public boolean containsLegend(LegendItem legend) {
        return this.legends.contains(legend);
    }

    public synchronized void clearLegends() {
        for (LegendItem legend : new ArrayList<LegendItem>(this.legends)) {
            this.removeLegend(legend);
        }
    }

    public Set<vtkProp> getActors() {
        return Collections.unmodifiableSet(this.actors);
    }

    public Set<LegendItem> getLegends() {
        return Collections.unmodifiableSet(this.legends);
    }

    public void visibilityOff() {
        for (vtkProp actor : this.actors) {
            for (PluginActorsChangeListener l : this.listeners) {
                l.actorRemoved(actor);
            }
        }
        for (LegendItem legend : this.legends) {
            for (PluginActorsChangeListener l : this.listeners) {
                l.legendRemoved(legend);
            }
        }
    }

    public void visibilityOn() {
        for (vtkProp vtkProp2 : this.actors) {
            for (PluginActorsChangeListener l : this.listeners) {
                l.actorAdded(vtkProp2);
            }
        }
        for (LegendItem legendItem : this.legends) {
            for (PluginActorsChangeListener l : this.listeners) {
                l.legendAdded(legendItem);
            }
        }
    }

    public void deepCopy(PluginActors source) {
        for (vtkProp actor : source.getActors()) {
            if (!(actor instanceof vtkActor)) continue;
            vtkActor copy = new vtkActor();
            copy.SetVisibility(actor.GetVisibility());
            copy.SetPickable(actor.GetPickable());
            copy.SetDragable(actor.GetDragable());
            copy.SetUseBounds(actor.GetUseBounds());
            copy.SetAllocatedRenderTime(actor.GetAllocatedRenderTime(), null);
            copy.SetEstimatedRenderTime(actor.GetEstimatedRenderTime());
            copy.SetRenderTimeMultiplier(actor.GetRenderTimeMultiplier());
            for (int i = 0; i < actor.GetNumberOfConsumers(); ++i) {
                copy.AddConsumer(actor.GetConsumer(i));
            }
            copy.SetPropertyKeys(actor.GetPropertyKeys());
            copy.SetDebug(actor.GetDebug());
            copy.SetReferenceCount(actor.GetReferenceCount());
            copy.SetMapper(((vtkActor)actor).GetMapper());
            copy.GetProperty().SetColor(((vtkActor)actor).GetProperty().GetColor());
            copy.GetProperty().SetOpacity(((vtkActor)actor).GetProperty().GetOpacity());
            copy.GetProperty().SetTexture("0", ((vtkActor)actor).GetProperty().GetTexture("0"));
            copy.SetPosition(((vtkActor)actor).GetPosition());
            System.out.println(copy.GetProperty().GetColor()[0]);
            this.addActor((vtkProp)copy);
        }
        MainGUI.updateRenderWindow();
    }
}

