/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.plugins.ShakeMapPlugin;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.opensha.commons.util.cpt.CPT;
import org.opensha.sha.gui.infoTools.CalcProgressBar;
import org.scec.vtk.commons.legend.LegendItem;
import org.scec.vtk.commons.legend.LegendUtils;
import org.scec.vtk.main.Info;
import org.scec.vtk.main.MainGUI;
import org.scec.vtk.plugins.Plugin;
import org.scec.vtk.plugins.PluginActors;
import org.scec.vtk.plugins.ShakeMapPlugin.Component.ShakeMap;
import org.scec.vtk.plugins.ShakeMapPlugin.USGSShakeMapDownloader;
import org.scec.vtk.plugins.SurfacePlugin.SurfaceTableModel;
import org.scec.vtk.tools.Prefs;
import vtk.vtkActor;
import vtk.vtkActor2D;
import vtk.vtkProp;

public class ShakeMapGUI
extends JPanel
implements ItemListener,
ChangeListener,
ListSelectionListener,
TableModelListener {
    private static final long serialVersionUID = 1L;
    static final String dataPath = String.valueOf(MainGUI.getCWD()) + File.separator + "data/ShakeMapPlugin";
    static final String moreMaps = "More_USGS_Maps";
    static final String openSHAFile = "openSHA.txt";
    static final String openSHAMapURL = "http://zero.usc.edu/gmtData/1468263306257/map_data.txt";
    static final String colorFilePath = String.valueOf(MainGUI.getCWD()) + File.separator + "data/ShakeMapPlugin/Extra/";
    private JPanel shakeMapLibraryPanel = new JPanel();
    JPanel panel1 = new JPanel();
    private JPanel loadFilePanel = new JPanel();
    private JTabbedPane tabbedPane = new JTabbedPane();
    JPanel bottomPane = new JPanel();
    JPanel presets = new JPanel();
    JPanel panesPanel = new JPanel();
    JPanel tab2 = new JPanel();
    JTextField eventIdBox = new JTextField("Enter Shakemap XML Link Here");
    final JTextField usgsURL = new JTextField("http://earthquake.usgs.gov/data/shakemap/");
    private ArrayList<JCheckBox> checkBoxList;
    private ArrayList<ShakeMap> shakeMapsList;
    private PluginActors pluginActors;
    private ArrayList<vtkActor> actorList;
    JButton browse = new JButton("Load File");
    JButton downloadUSGSButton = new JButton("Download USGS Shake Map");
    JButton usgsLink = new JButton("Open USGS Website");
    JButton openSHAButton = new JButton("Download OpenSHA File");
    String[] header = new String[]{"Name", "List Index"};
    public SurfaceTableModel surfaceTableModel = new SurfaceTableModel(this.header);
    public JTable surfaceTable = new JTable(this.surfaceTableModel);
    private JSlider transparencySlider = new JSlider();
    private JCheckBox legendCheckBox;
    private LegendItem legend;
    private Plugin plugin;

    public ShakeMapGUI(Plugin plugin, PluginActors pluginActors) {
        this.plugin = plugin;
        File f = new File(dataPath + "/More_USGS_Maps");
        if (!f.exists()) {
            f.mkdirs();
        }
        this.checkBoxList = new ArrayList();
        this.pluginActors = pluginActors;
        this.shakeMapsList = new ArrayList();
        this.actorList = new ArrayList();
        this.presets.setLayout(new GridLayout(0, 2));
        File dataDirectory = new File(dataPath);
        if (dataDirectory.isDirectory()) {
            File[] files = dataDirectory.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].isFile()) continue;
                String tempName = files[i].getName();
                JCheckBox tempCheckbox = new JCheckBox(tempName);
                tempCheckbox.setName(files[i].getPath());
                tempCheckbox.addItemListener(this);
                this.presets.add(tempCheckbox);
                this.checkBoxList.add(tempCheckbox);
                this.shakeMapsList.add(null);
                this.actorList.add(null);
            }
        }
        this.surfaceTable.setPreferredScrollableViewportSize(new Dimension(350, 70));
        this.surfaceTable.getSelectionModel().addListSelectionListener(this);
        this.surfaceTableModel.addTableModelListener(this);
        JScrollPane scrollPane = new JScrollPane(this.surfaceTable);
        this.panesPanel.setLayout(new GridLayout(1, 2, 10, 10));
        this.panesPanel.add(scrollPane);
        this.panel1.setLayout(new GridLayout(1, 0, 0, 15));
        this.panel1.add(new JScrollPane(this.presets));
        JPanel sliderPanel = new JPanel(new BorderLayout());
        this.transparencySlider.setMajorTickSpacing(10);
        this.transparencySlider.setMinorTickSpacing(5);
        this.transparencySlider.setPaintLabels(true);
        this.transparencySlider.setPaintTicks(true);
        this.transparencySlider.addChangeListener(this);
        this.transparencySlider.setEnabled(false);
        sliderPanel.add((Component)new JLabel("Transparency"), "North");
        sliderPanel.add((Component)this.transparencySlider, "Center");
        this.legendCheckBox = new JCheckBox("Add Legend");
        this.legendCheckBox.setEnabled(false);
        sliderPanel.add((Component)this.legendCheckBox, "South");
        this.bottomPane.setLayout(new GridLayout(2, 0, 0, 15));
        this.bottomPane.add(this.panesPanel);
        this.bottomPane.add(sliderPanel);
        this.loadFilePanel.setLayout(new GridLayout(0, 2));
        File usgsDirectory = new File(dataPath + "/More_USGS_Maps");
        if (usgsDirectory.isDirectory()) {
            File[] files = usgsDirectory.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].isFile()) continue;
                String tempName = files[i].getName();
                JCheckBox tempCheckbox = new JCheckBox(tempName);
                tempCheckbox.setName(files[i].getPath());
                tempCheckbox.addItemListener(this);
                this.loadFilePanel.add(tempCheckbox);
                this.checkBoxList.add(tempCheckbox);
                this.shakeMapsList.add(null);
                this.actorList.add(null);
            }
        }
        JPanel USGSPanel = new JPanel();
        USGSPanel.setLayout(new FlowLayout());
        USGSPanel.add(new JLabel("Visit website, locate shakemap, and enter URL of Shakemap's XML file: "));
        this.eventIdBox.setPreferredSize(new Dimension(200, 20));
        USGSPanel.add(this.usgsLink);
        USGSPanel.add(this.eventIdBox);
        USGSPanel.add(this.downloadUSGSButton);
        this.tabbedPane.setPreferredSize(new Dimension(Prefs.getPluginWidth(), Prefs.getPluginHeight() / 2));
        this.tabbedPane.addTab("Presets", this.panel1);
        this.tab2.setLayout(new BorderLayout());
        this.tab2.add((Component)this.loadFilePanel, "North");
        this.tab2.add((Component)this.browse, "South");
        this.tabbedPane.addTab("Load Map", this.tab2);
        this.tabbedPane.addTab("Download USGS Map", USGSPanel);
        JPanel shaPanel = new JPanel(new FlowLayout());
        shaPanel.add(this.openSHAButton);
        this.shakeMapLibraryPanel.setLayout(new BorderLayout());
        this.shakeMapLibraryPanel.add((Component)this.tabbedPane, "North");
        this.shakeMapLibraryPanel.add((Component)this.bottomPane, "South");
        this.add(this.shakeMapLibraryPanel);
        this.legendCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBox cb = (JCheckBox)e.getSource();
                if (cb.isSelected()) {
                    ShakeMapGUI.this.addLegendScalarBar();
                } else {
                    ShakeMapGUI.this.removeLegend();
                }
            }
        });
        this.browse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShakeMapGUI.this.loadShakeMapFile();
            }
        });
        this.usgsLink.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ShakeMapGUI.openWebpage(new URL(ShakeMapGUI.this.usgsURL.getText()));
                }
                catch (MalformedURLException e1) {
                    e1.printStackTrace();
                }
            }
        });
        this.eventIdBox.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent arg0) {
                ShakeMapGUI.this.eventIdBox.setText("");
            }

            @Override
            public void focusLost(FocusEvent arg0) {
                if (ShakeMapGUI.this.eventIdBox.getText() == "" || ShakeMapGUI.this.eventIdBox.getText() == " ") {
                    ShakeMapGUI.this.eventIdBox.setText("Enter XML Link");
                }
            }
        });
        this.downloadUSGSButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final String id = ShakeMapGUI.this.eventIdBox.getText();
                if (id.length() > 0) {
                    final CalcProgressBar progress = new CalcProgressBar(null, "Downloading the ShakeMap...", "Please Wait.", false);
                    progress.setVisible(true);
                    progress.setIndeterminate(true);
                    final Runnable fireRunnable = new Runnable(){

                        @Override
                        public void run() {
                            USGSShakeMapDownloader smd = new USGSShakeMapDownloader(id);
                            String d = smd.downloadShakeMap(id + ".txt");
                            if (d.length() <= 0) {
                                System.out.println("Failure");
                                JOptionPane.showMessageDialog(Info.getMainGUI(), "File not found on USGS site.\nPlease Try Again.");
                            } else {
                                progress.setProgressMessage("Loaded!");
                                progress.setProgressMessage("Adding...");
                                System.out.println("showing new map: " + dataPath + "/More_USGS_Maps/" + d + ".txt");
                                ShakeMapGUI.this.showNewMap(dataPath + "/More_USGS_Maps/" + d + ".txt", "mmi");
                                ShakeMapGUI.this.addNewCheckBox(d + ".txt", dataPath + "/More_USGS_Maps/" + d + ".txt");
                                progress.setProgressMessage("Finished!");
                            }
                            progress.setVisible(false);
                            progress.dispose();
                        }
                    };
                    Runnable downloadRunnable = new Runnable(){

                        @Override
                        public void run() {
                            progress.setIndeterminate(true);
                            SwingUtilities.invokeLater(fireRunnable);
                        }
                    };
                    new Thread(downloadRunnable).start();
                } else {
                    JOptionPane.showMessageDialog(ShakeMapGUI.this.shakeMapLibraryPanel, "Enter link to Shakemap XML");
                }
            }
        });
        this.openSHAButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    URL openSHA = new URL(ShakeMapGUI.openSHAMapURL);
                    Files.copy(openSHA.openStream(), Paths.get(dataPath + "/openSHA.txt", new String[0]), StandardCopyOption.REPLACE_EXISTING);
                }
                catch (MalformedURLException e1) {
                    e1.printStackTrace();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                    JOptionPane.showMessageDialog(ShakeMapGUI.this.shakeMapLibraryPanel, "There is no file on OpenSHA right now.");
                }
            }
        });
    }

    public JPanel getPanel() {
        return this;
    }

    public void addMap(String name, String filepath, String scaleChoice) {
        this.showNewMap(filepath, scaleChoice);
        this.addNewCheckBox(name, filepath);
    }

    private String getColorFilePath(String scaleChoice) {
        String colorFile = "";
        if (scaleChoice.equals("pga")) {
            colorFile = "colors_pga.cpt";
        } else if (scaleChoice.equals("pgv")) {
            colorFile = "colors_pgv.cpt";
        } else if (scaleChoice.equals("mmi")) {
            colorFile = "colors.cpt";
        }
        return colorFilePath + colorFile;
    }

    private void showNewMap(String path, String scaleChoice) {
        System.out.println("file path: " + path);
        ShakeMap shakeMap = new ShakeMap(this.getColorFilePath(scaleChoice), scaleChoice);
        try {
            shakeMap.loadFromFileToGriddedGeoDataSet(path);
        }
        catch (Exception e) {
            shakeMap.loadOpenSHAFileToGriddedGeoDataSet(path);
        }
        shakeMap.setActor(shakeMap.builtPolygonSurface());
        shakeMap.getActor().GetProperty().SetOpacity(0.5);
        this.actorList.add(shakeMap.getActor());
        this.pluginActors.addActor((vtkProp)shakeMap.getActor());
        this.shakeMapsList.add(shakeMap);
        System.out.println("Entry in list" + this.shakeMapsList.size());
        Info.getMainGUI();
        MainGUI.updateRenderWindow();
    }

    private void addNewCheckBox(String checkBoxName, String filepath) {
        JCheckBox tempCheckbox = new JCheckBox(checkBoxName);
        tempCheckbox.setName(filepath);
        tempCheckbox.setSelected(true);
        tempCheckbox.addItemListener(this);
        this.loadFilePanel.add(tempCheckbox);
        this.checkBoxList.add(tempCheckbox);
        this.surfaceTableModel.addRow(new Object[]{checkBoxName, this.checkBoxList.size() - 1});
        this.tab2.revalidate();
    }

    private void loadShakeMapFile() {
        int returnVal;
        JFileChooser chooser = new JFileChooser();
        FileNameExtensionFilter filter = new FileNameExtensionFilter("Text files", "txt", "xyz");
        chooser.setFileFilter(filter);
        String s = File.separator;
        File defaultDir = new File(MainGUI.getCWD(), "data" + s + "ShakeMapPlugin");
        if (defaultDir.exists()) {
            chooser.setCurrentDirectory(defaultDir);
        }
        if ((returnVal = chooser.showOpenDialog(this)) == 0) {
            try {
                Object[] choices = new String[]{"mmi", "pga", "pgv"};
                String scaleChoice = (String)JOptionPane.showInputDialog(this.shakeMapLibraryPanel, "Choose a scale", "Choose a scale", 3, null, choices, choices[1]);
                if (scaleChoice == null) {
                    scaleChoice = "mmi";
                }
                this.addMap(chooser.getSelectedFile().getName(), chooser.getSelectedFile().toString(), scaleChoice);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(this.shakeMapLibraryPanel, "This is an invalid shakeMap file.");
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(this.shakeMapLibraryPanel, "This is an invalid shakeMap file.");
            }
        }
    }

    private void addLegendScalarBar() {
        ListSelectionModel model = this.surfaceTable.getSelectionModel();
        int idx = (Integer)this.surfaceTableModel.getValueAt(model.getMinSelectionIndex(), 1);
        if (idx != -1) {
            ShakeMap shakeMap = this.shakeMapsList.get(idx);
            PluginActors actors = this.plugin.getPluginActors();
            vtkActor2D prevActor = null;
            double x = 0.05;
            double y = 0.05;
            if (this.legend != null) {
                prevActor = this.legend.getActor();
                double[] position = prevActor.GetPosition();
                x = position[0];
                y = position[1];
                actors.removeLegend(this.legend);
            }
            CPT cpt = shakeMap.getCPT();
            this.legend = LegendUtils.buildColorBarLegend(this.plugin, cpt, "ShakeMap Scale (MMI)", x, y);
            if (prevActor != null) {
                vtkActor2D newActor = this.legend.getActor();
                newActor.SetWidth(prevActor.GetWidth());
                newActor.SetHeight(prevActor.GetHeight());
                newActor.GetProperty().SetColor(prevActor.GetProperty().GetColor());
            }
            actors.addLegend(this.legend);
            MainGUI.updateRenderWindow();
        }
    }

    private void removeLegend() {
        if (this.legend != null) {
            this.plugin.getPluginActors().removeLegend(this.legend);
            MainGUI.updateRenderWindow();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Object src = e.getSource();
        for (int i = 0; i < this.checkBoxList.size(); ++i) {
            if (src != this.checkBoxList.get(i)) continue;
            File f = new File(this.checkBoxList.get(i).getName());
            System.out.println(f.getPath());
            if (e.getStateChange() == 1) {
                if (this.shakeMapsList.get(i) == null) {
                    System.out.println();
                    this.addShakemap(f.getName(), f.getPath(), i, this.getColorFilePath("mmi"), "mmi");
                } else {
                    this.shakeMapsList.get(i).getActor().SetVisibility(1);
                }
                this.surfaceTableModel.addRow(new Object[]{f.getName(), i});
            } else {
                this.shakeMapsList.get(i).getActor().SetVisibility(0);
                System.out.println(f.getName());
                System.out.println(this.surfaceTableModel.getRowCount());
                for (int j = 0; j < this.surfaceTableModel.getRowCount(); ++j) {
                    if (!f.getName().equals(this.surfaceTableModel.getValueAt(j, 0))) continue;
                    System.out.println("list index is " + String.valueOf(this.surfaceTableModel.getValueAt(j, 1)));
                    this.surfaceTableModel.removeRow(j);
                }
            }
            Info.getMainGUI();
            MainGUI.updateRenderWindow();
        }
    }

    public void unloadPlugin() {
        for (vtkActor actor : this.actorList) {
            this.pluginActors.removeActor((vtkProp)actor);
        }
        Info.getMainGUI();
        MainGUI.updateRenderWindow();
    }

    @Override
    public void tableChanged(TableModelEvent e) {
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        Object src = e.getSource();
        this.surfaceTable.getModel();
        if (e.getValueIsAdjusting()) {
            return;
        }
        if (src == this.surfaceTable.getSelectionModel()) {
            this.processTableSelectionChange();
        }
    }

    public void processTableSelectionChange() {
        int[] selectedRows = this.surfaceTable.getSelectedRows();
        if (selectedRows.length > 0) {
            this.transparencySlider.setEnabled(true);
            this.legendCheckBox.setEnabled(true);
        } else {
            this.transparencySlider.setEnabled(false);
            this.legendCheckBox.setEnabled(false);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Object src = e.getSource();
        if (src == this.transparencySlider) {
            double transparency = (double)this.transparencySlider.getValue() / 100.0;
            ListSelectionModel model = this.surfaceTable.getSelectionModel();
            for (int i = model.getMinSelectionIndex(); i <= model.getMaxSelectionIndex(); ++i) {
                int idx = (Integer)this.surfaceTableModel.getValueAt(i, 1);
                this.shakeMapsList.get(idx).getActor().GetProperty().SetOpacity(transparency);
            }
            Info.getMainGUI();
            MainGUI.updateRenderWindow();
        }
    }

    public static void openWebpage(URI uri) {
        Desktop desktop;
        Desktop desktop2 = desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
        if (desktop != null && desktop.isSupported(Desktop.Action.BROWSE)) {
            try {
                desktop.browse(uri);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void openWebpage(URL url) {
        try {
            ShakeMapGUI.openWebpage(url.toURI());
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }

    void addShakemap(String fname, String path, int i, String color_file_path, String scaleMode) {
        ShakeMap shakeMap = new ShakeMap(color_file_path, scaleMode);
        if (fname.equals(openSHAFile)) {
            shakeMap.loadOpenSHAFileToGriddedGeoDataSet(path);
        } else {
            shakeMap.loadFromFileToGriddedGeoDataSet(path);
        }
        shakeMap.setActor(shakeMap.builtPolygonSurface());
        this.actorList.set(i, shakeMap.getActor());
        this.pluginActors.addActor((vtkProp)shakeMap.getActor());
        this.shakeMapsList.set(i, shakeMap);
        this.shakeMapsList.get(i).getActor().GetProperty().SetOpacity(0.5);
    }

    public ArrayList<JCheckBox> getCheckBoxList() {
        return this.checkBoxList;
    }

    public void setCheckBoxList(ArrayList<JCheckBox> checkBoxList) {
        this.checkBoxList = checkBoxList;
    }

    public ArrayList<ShakeMap> getShakeMapsList() {
        return this.shakeMapsList;
    }

    public void setShakeMapsList(ArrayList<ShakeMap> shakeMapsList) {
        this.shakeMapsList = shakeMapsList;
    }

    public PluginActors getPluginActors() {
        return this.pluginActors;
    }

    public void setPluginActors(PluginActors pluginActors) {
        this.pluginActors = pluginActors;
    }

    public ArrayList<vtkActor> getActorList() {
        return this.actorList;
    }

    public void setActorList(ArrayList<vtkActor> actorList) {
        this.actorList = actorList;
    }
}

