/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.plugins.ShakeMapPlugin;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JCheckBox;
import org.dom4j.Element;
import org.scec.vtk.main.Info;
import org.scec.vtk.main.MainGUI;
import org.scec.vtk.plugins.PluginState;
import org.scec.vtk.plugins.ShakeMapPlugin.Component.ShakeMap;
import org.scec.vtk.plugins.ShakeMapPlugin.ShakeMapGUI;
import vtk.vtkProp;

public class ShakeMapPluginState
implements PluginState {
    private ShakeMapGUI parent;
    private ArrayList<String> filePath;
    private ArrayList<Double> transparency;
    private ArrayList<String> mapParameter;
    private ArrayList<Integer> visibility;
    private ArrayList<Integer> selectedIndexes;
    private ArrayList<Double> setTransparencies;

    ShakeMapPluginState(ShakeMapGUI parent) {
        this.parent = parent;
        this.filePath = new ArrayList();
        this.transparency = new ArrayList();
        this.mapParameter = new ArrayList();
        this.visibility = new ArrayList();
        this.selectedIndexes = new ArrayList();
        this.setTransparencies = new ArrayList();
    }

    void copyLatestCatalogDetails() {
        this.filePath.clear();
        this.transparency.clear();
        this.selectedIndexes.clear();
        this.mapParameter.clear();
        int shakeIndex = 0;
        for (ShakeMap shake : this.parent.getShakeMapsList()) {
            if (shake != null) {
                this.visibility.add(shake.getActor().GetVisibility());
                this.selectedIndexes.add(shakeIndex);
                this.setTransparencies.add(shake.getActor().GetProperty().GetOpacity());
            } else {
                this.visibility.add(0);
                this.setTransparencies.add(null);
            }
            ++shakeIndex;
        }
    }

    @Override
    public void load() {
        int v_size = this.visibility.size();
        for (int i = 0; i < this.parent.getShakeMapsList().size() && !this.visibility.isEmpty(); ++i) {
            if (this.parent.getShakeMapsList().get(i) == null) continue;
            if (i < this.visibility.size()) {
                this.parent.getShakeMapsList().get(i).getActor().SetVisibility(this.visibility.get(i).intValue());
                this.parent.getCheckBoxList().get(i).setSelected(this.visibility.get(i) == 1);
                continue;
            }
            this.parent.getShakeMapsList().get(i).getActor().SetVisibility(0);
            this.parent.getCheckBoxList().get(i).setSelected(false);
        }
        for (int i : this.selectedIndexes) {
            this.parent.getShakeMapsList().get(i).getActor().GetProperty().SetOpacity(this.setTransparencies.get(i).doubleValue());
        }
    }

    private void createElement(Element stateEl) {
        int i = 0;
        for (JCheckBox box : this.parent.getCheckBoxList()) {
            if (box.isSelected()) {
                Element propertyEl = stateEl.addElement("ShakeMaps");
                propertyEl.addElement("filePath").addText(box.getName());
                propertyEl.addElement("transparency").addText(Double.toString(this.parent.getShakeMapsList().get(i).getActor().GetProperty().GetOpacity()));
                propertyEl.addElement("parameter").addText(this.parent.getShakeMapsList().get(i).getParameter());
            }
            ++i;
        }
    }

    @Override
    public void toXML(Element stateEl) {
        this.copyLatestCatalogDetails();
        this.createElement(stateEl);
    }

    public void showMaps(ArrayList<String> filepaths, ArrayList<Double> transparentValues) {
        int i = 0;
        for (String path : filepaths) {
            boolean checked = false;
            int checkBoxIndex = 0;
            for (JCheckBox box : this.parent.getCheckBoxList()) {
                if (path.equals(box.getName())) {
                    Info.getMainGUI();
                    ShakeMap shakeMap = new ShakeMap(String.valueOf(MainGUI.getCWD()) + File.separator + "data/ShakeMapPlugin/Extra/colors.cpt", this.mapParameter.get(i));
                    File f = new File(this.parent.getCheckBoxList().get(checkBoxIndex).getName());
                    if (f.getName().equals("openSHA.txt")) {
                        shakeMap.loadOpenSHAFileToGriddedGeoDataSet(f.getPath());
                    } else {
                        shakeMap.loadFromFileToGriddedGeoDataSet(f.getPath());
                    }
                    shakeMap.setActor(shakeMap.builtPolygonSurface());
                    shakeMap.getActor().GetProperty().SetOpacity(transparentValues.get(i).doubleValue());
                    this.parent.getActorList().set(checkBoxIndex, shakeMap.getActor());
                    this.parent.getPluginActors().addActor((vtkProp)shakeMap.getActor());
                    this.parent.getShakeMapsList().set(checkBoxIndex, shakeMap);
                    this.parent.getCheckBoxList().get(checkBoxIndex).setSelected(true);
                    ++i;
                    checked = true;
                    break;
                }
                ++checkBoxIndex;
            }
            if (checked) continue;
            File f = new File(path);
            this.parent.addMap(f.getName(), path, this.mapParameter.get(i));
            int latestIndex = this.parent.getShakeMapsList().size() - 1;
            this.parent.getShakeMapsList().get(latestIndex).getActor().GetProperty().SetOpacity(transparentValues.get(i).doubleValue());
            ++i;
        }
        Info.getMainGUI();
        MainGUI.updateRenderWindow();
    }

    @Override
    public void fromXML(Element stateEl) {
        Iterator i = stateEl.elementIterator("ShakeMaps");
        while (i.hasNext()) {
            Element e = (Element)i.next();
            this.filePath.add(e.elementText("filePath"));
            this.transparency.add(Double.parseDouble(e.elementText("transparency")));
            this.mapParameter.add(e.elementText("parameter"));
        }
        this.showMaps(this.filePath, this.transparency);
    }

    @Override
    public PluginState deepCopy() {
        ShakeMapPluginState state = new ShakeMapPluginState(this.parent);
        state.copyLatestCatalogDetails();
        return state;
    }
}

