/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.plugins.ShakeMapPlugin;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Scanner;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.scec.vtk.main.Info;
import org.scec.vtk.main.MainGUI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class USGSShakeMapDownloader {
    static final String URLSTART = "http://earthquake.usgs.gov/realtime/product/shakemap";
    static final String URLEND = "download/grid.xyz.zip";
    static final String URLTEST = "http://earthquake.usgs.gov/realtime/product/shakemap/nc73027396/nc/1528505370051/download/grid.xml.zip";
    static final String USGSDataPath = String.valueOf(MainGUI.getCWD()) + File.separator + "data/ShakeMapPlugin/More_USGS_Maps";
    private String urlNumber;

    public USGSShakeMapDownloader(String shakeUrl) {
        this.urlNumber = shakeUrl;
    }

    public String downloadShakeMap(String destinationFile) {
        String idName = "";
        try {
            URL url = new URL(this.urlNumber);
            InputStream stream = url.openStream();
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(stream);
            doc.getDocumentElement().normalize();
            NodeList nList = doc.getElementsByTagName("shakemap_grid");
            Node gridData = nList.item(0);
            System.out.println(gridData.getNodeName());
            Element eElement = (Element)gridData;
            String tempName = JOptionPane.showInputDialog(Info.getMainGUI(), (Object)"Input the name of this ShakeMap. \nPressing \"Cancel\" will default name to ID Name.");
            if (tempName == null || tempName.length() == 0 || tempName.matches("\\s*")) {
                idName = eElement.getAttribute("shakemap_id");
            } else {
                tempName.trim();
                idName = tempName;
            }
            System.out.println("id: " + idName);
            String filePath = USGSDataPath + "/" + idName + ".txt";
            FileWriter writ = new FileWriter(new File(filePath));
            String gridString = eElement.getElementsByTagName("grid_data").item(0).getTextContent();
            Scanner scanner = new Scanner(gridString);
            scanner.nextLine();
            while (scanner.hasNextLine()) {
                String[] line = scanner.nextLine().split("\\s+");
                writ.write(line[0] + " " + line[1] + " " + line[2] + " " + line[3] + " " + line[4]);
                writ.write("\n");
            }
            scanner.close();
            writ.close();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        return idName;
    }
}

