/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.plugins.SurfacePlugin.Component;

import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.scec.vtk.plugins.SurfacePlugin.Component.LatLonBoundingBox;
import org.scec.vtk.plugins.SurfacePlugin.Component.WMSService;
import org.scec.vtk.plugins.SurfacePlugin.Component.WMSStyle;

public class WMSLayer {
    String name;
    String title;
    LatLonBoundingBox box;
    ArrayList<WMSStyle> styles = new ArrayList();

    public WMSLayer(String name, String title, LatLonBoundingBox box, ArrayList<WMSStyle> styles) {
        this.name = name;
        this.title = title;
        this.box = box;
        this.styles = styles;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public LatLonBoundingBox getBox() {
        return this.box;
    }

    public void setBox(LatLonBoundingBox box) {
        this.box = box;
    }

    public ArrayList<WMSStyle> getStyles() {
        return this.styles;
    }

    public void setStyles(ArrayList<WMSStyle> styles) {
        this.styles = styles;
    }

    public String toString() {
        return this.getName();
    }

    public static WMSLayer fromXML(Element layer) {
        String name = WMSService.getElement(layer, "Name").getValue();
        String title = WMSService.getElement(layer, "Title").getValue();
        LatLonBoundingBox box = layer.getChild("LatLonBoundingBox") != null ? LatLonBoundingBox.fromXML(WMSService.getElement(layer, "LatLonBoundingBox")) : (layer.getChild("BoundingBox") != null ? LatLonBoundingBox.fromXML(WMSService.getElement(layer, "BoundingBox")) : new LatLonBoundingBox(-90.0, -180.0, 90.0, 180.0));
        List<Element> styleList = WMSService.getElements(layer, "Style");
        ArrayList<WMSStyle> styles = new ArrayList<WMSStyle>();
        for (Element syle : styleList) {
            styles.add(WMSStyle.fromXML(syle));
        }
        return new WMSLayer(name, title, box, styles);
    }
}

