/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.plugins.SurfacePlugin.Component;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.scec.vtk.plugins.SurfacePlugin.Component.WMSLayer;
import org.scec.vtk.plugins.SurfacePlugin.Component.WMSStyle;

public class WMSService {
    private String baseUrl = "";
    private ArrayList<WMSLayer> layers = new ArrayList();
    private int currentLayer = 0;

    public WMSService(String baseUrl, ArrayList<WMSLayer> layers) {
        if (!((String)baseUrl).endsWith("?")) {
            baseUrl = (String)baseUrl + "?";
        }
        this.baseUrl = baseUrl;
        this.layers = layers;
    }

    public WMSLayer getCurrentLayer() {
        return this.layers.get(this.currentLayer);
    }

    public ArrayList<WMSLayer> getLayers() {
        return this.layers;
    }

    public static WMSService fromXML(String baseUrl) throws MalformedURLException, JDOMException, IOException {
        Object url = baseUrl;
        url = ((String)url).contains("?") ? (String)url + "&" : (String)url + "?";
        url = (String)url + "SERVICE=WMS&REQUEST=GetCapabilities";
        System.out.println("URL: " + (String)url);
        SAXBuilder builder = new SAXBuilder();
        Document doc = builder.build(new URL((String)url));
        Element root = doc.getRootElement();
        Preconditions.checkNotNull((Object)root, (Object)"No root element");
        Element caps = WMSService.getElement(root, "Capability");
        Preconditions.checkNotNull((Object)caps, (Object)("No capability element. Parent children: " + WMSService.getChildrenNames(root)));
        Element layersEl = WMSService.getElement(caps, "Layer");
        Preconditions.checkNotNull((Object)layersEl, (Object)("No layer element. Parent children: " + WMSService.getChildrenNames(caps)));
        ArrayList<WMSLayer> layers = WMSService.getLayers(layersEl);
        return new WMSService(baseUrl, layers);
    }

    private static ArrayList<WMSLayer> getLayers(Element parentEl) {
        List<Element> layerList = WMSService.getElements(parentEl, "Layer");
        ArrayList layers = Lists.newArrayList();
        if (!layerList.isEmpty()) {
            for (Element layer : layerList) {
                layers.addAll(WMSService.getLayers(layer));
            }
        } else {
            layers.add(WMSLayer.fromXML(parentEl));
        }
        return layers;
    }

    static Element getElement(Element root, String name) {
        for (Element el : root.getChildren()) {
            if (!el.getName().trim().equals(name.trim())) continue;
            return el;
        }
        return null;
    }

    static List<Element> getElements(Element root, String name) {
        ArrayList els = Lists.newArrayList();
        for (Element el : root.getChildren()) {
            if (!el.getName().trim().equals(name.trim())) continue;
            els.add(el);
        }
        return els;
    }

    private static String getChildrenNames(Element elem) {
        ArrayList names = Lists.newArrayList();
        for (Element e : elem.getChildren()) {
            names.add(e.getName());
        }
        return Joiner.on((String)",").join((Iterable)names);
    }

    public static void main(String[] args) {
        try {
            WMSService service = WMSService.fromXML("http://www.nasa.network.com/wms");
            for (WMSLayer layer : service.getLayers()) {
                System.out.println();
                System.out.println("Layer: " + layer.getName() + ": " + layer.getTitle());
                System.out.println("BBox: " + String.valueOf(layer.getBox()));
                for (WMSStyle style : layer.getStyles()) {
                    System.out.println("Style: " + style.getName() + ": " + style.getTitle());
                }
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (JDOMException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }
}

