/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.plugins.SurfacePlugin.Component;

public class WMSUrlGenerator {
    private String baseUrl;
    private String layer;
    private String style = "";

    public WMSUrlGenerator(String baseUrl, String layer) {
        this(baseUrl, layer, "");
    }

    public WMSUrlGenerator(String baseUrl, String layer, String style) {
        this.baseUrl = baseUrl;
        this.layer = layer;
        this.style = style;
    }

    public String toWMSURL(double latS, double latN, double lonE, double lonW, int pixelsPerDegree) {
        double maxLon;
        double minLon;
        double maxLat;
        double minLat;
        String format = "image/jpeg";
        String styles = this.style;
        String srs = "EPSG:4326";
        if (latS > latN) {
            minLat = latN;
            maxLat = latS;
        } else {
            minLat = latS;
            maxLat = latN;
        }
        if (lonW > lonE) {
            minLon = lonE;
            maxLon = lonW;
        } else {
            minLon = lonW;
            maxLon = lonE;
        }
        int width = (int)((maxLon - minLon) * (double)pixelsPerDegree + 0.5);
        int height = (int)((maxLat - minLat) * (double)pixelsPerDegree + 0.5);
        String bbox = minLon + "," + minLat + "," + maxLon + "," + maxLat;
        String url = this.getBaseUrl() + "version=1.1.1&request=GetMap&Layers=" + this.layer + "&format=" + format + "&BBOX=" + bbox + "&width=" + width + "&height=" + height + "&SRS=" + srs;
        if (styles == null) {
            styles = "";
        }
        url = url + "&Styles=" + styles;
        return url;
    }

    public String getLayer() {
        return this.layer;
    }

    public void setLayer(String layer) {
        this.layer = layer;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }
}

