/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.plugins.SurfacePlugin;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.scec.vtk.main.Info;
import org.scec.vtk.main.MainGUI;
import org.scec.vtk.plugins.SurfacePlugin.Component.GoogleStaticMapsURLGenerator;
import org.scec.vtk.plugins.SurfacePlugin.Component.LatLonBoundingBox;
import org.scec.vtk.plugins.SurfacePlugin.Component.LoadedFilesProperties;
import org.scec.vtk.plugins.SurfacePlugin.Component.WMSLayer;
import org.scec.vtk.plugins.SurfacePlugin.Component.WMSService;
import org.scec.vtk.plugins.SurfacePlugin.Component.WMSStyle;
import org.scec.vtk.plugins.SurfacePlugin.Component.WMSUrlGenerator;
import org.scec.vtk.plugins.SurfacePlugin.GeographicSurfaceInfo;
import org.scec.vtk.plugins.SurfacePlugin.ImageInfo;
import org.scec.vtk.plugins.SurfacePlugin.SurfacePlugin;
import org.scec.vtk.plugins.SurfacePlugin.SurfacePluginGUI;
import org.scec.vtk.plugins.utils.components.DataFileChooser;
import org.scec.vtk.tools.Prefs;
import vtk.vtkActor;

public class MapSetCreatePluginGUI
extends JFrame
implements ActionListener,
DocumentListener {
    private SurfacePluginGUI parent;
    private static final long serialVersionUID = 1L;
    private JPanel mainPanel = new JPanel();
    JTabbedPane surfaceImageTabPane;
    private JPanel surfacePanel = new JPanel();
    private JPanel surfaceFilePanel = new JPanel();
    private JPanel surfaceCoordPanel = new JPanel();
    private JPanel surfaceLabelPanel = new JPanel();
    private JPanel surfaceCoordLabelPanel = new JPanel();
    protected JTextField surfaceFilePath = new JTextField("", 30);
    protected JTextField surfaceRightLatitude = new JTextField("32", 6);
    protected JTextField surfaceLeftLatitude = new JTextField("43", 6);
    protected JTextField surfaceUpperLongitude = new JTextField("-125", 6);
    protected JTextField surfaceLowerLongitude = new JTextField("-114", 6);
    protected JTextField surfaceAltitude = new JTextField("0.0", 6);
    protected JTextField surfaceScale = new JTextField("1.0");
    private JTextField surfacePixelField = new JTextField("1", 5);
    private JLabel surfaceUpperLeftCorner = new JLabel("Upper left corner (lat,long): ");
    private JLabel surfaceLowerRightCorner = new JLabel("Lower right corner (lat,long): ");
    private JLabel surfaceAltitudeLabel = new JLabel("Altitude, in km:  ");
    private JLabel surfaceScaleLabel = new JLabel("Scale Factor: ");
    private JLabel surfacePixelLabel = new JLabel("Pixel Spacing (1/2 min): ");
    private JRadioButton surfaceDiskButton = new JRadioButton("Disk");
    private JRadioButton surfaceWebButton = new JRadioButton("Internet");
    private JPanel imagePanel = new JPanel();
    private JPanel imageFilePanel = new JPanel();
    private JPanel imageCoordPanel = new JPanel();
    private JPanel imageLabelPanel = new JPanel();
    private JPanel imageCoordLabelPanel = new JPanel();
    private JLabel selectImage = new JLabel("Image File:    ");
    private JLabel imageSourceLabel = new JLabel("Load Image From: ");
    protected JTextField imageFilePath = new JTextField("", 30);
    protected JTextField imageRightLatitude = new JTextField("32", 6);
    protected JTextField imageLeftLatitude = new JTextField("43", 6);
    protected JTextField imageUpperLongitude = new JTextField("-125", 6);
    protected JTextField imageLowerLongitude = new JTextField("-114", 6);
    protected JTextField imageAltitude = new JTextField("0.0", 6);
    private JTextField imagePixelField = new JTextField("240", 5);
    private JLabel imageUpperLeftCorner = new JLabel("Upper left corner (lat,long): ");
    private JLabel imageLowerRightCorner = new JLabel("Lower right corner (lat,long): ");
    private JLabel imageAltitudeLabel = new JLabel("Altitude, in km:  ");
    private JLabel imagePixelLabel = new JLabel("Pixels/Degree: ");
    private JRadioButton imageDiskButton = new JRadioButton("Disk");
    private JRadioButton imageWebButton = new JRadioButton("Internet");
    private JCheckBox differentImageBox = new JCheckBox("Different Image Coordinates?", false);
    private JPanel buttonsPanel = new JPanel();
    private JPanel bottomPanel = new JPanel(new BorderLayout());
    private JButton displayButton = new JButton("Display");
    private JButton saveDisplayButton = new JButton("Save & Display");
    private JButton cancelButton = new JButton("Cancel");
    private JButton browseSurfaceButton = new JButton("...");
    private JButton browseImageButton = new JButton("...");
    private boolean surfaceFile = false;
    private boolean imageFile = false;
    private double[] surfaceData = new double[5];
    private double[] imageData = new double[5];
    private JPanel addFilePanel = new JPanel();
    private JPanel surfaceSourcePanel = new JPanel(new BorderLayout());
    private JPanel surfaceSourceChoosePanel = new JPanel(new FlowLayout(0));
    private boolean webSurface = false;
    private String surfaceServerURL = "http://scecdata.usc.edu/topo/cgi-bin/topo.pl";
    private JPanel imageSourcePanel = new JPanel(new BorderLayout());
    private JPanel imageSourceChoosePanel = new JPanel(new FlowLayout(0));
    private boolean webImage = false;
    private JPanel imageLoadPanel = new JPanel(new BorderLayout());
    private JPanel imageWebLayerPanel = new JPanel(new FlowLayout(0));
    private JProgressBar downloadProgressBar = new JProgressBar(0, 100);
    private JCheckBox reDownloadBox = new JCheckBox("Delete and Re-Download Internet Content?", false);
    private File groupFile;
    private Document groupDoc;
    String surfaceError = "";
    WMSService wms = null;
    private String loadedFilePath;
    private String filePath;
    public static final double optimalSurfacePoints = 691200.0;
    public static final double optimalImagePoints = 1843200.0;
    private String imageError;
    private static final String wms_url = "https://data.worldwind.arc.nasa.gov/wms";
    Logger log = Logger.getLogger(MapSetCreatePluginGUI.class);
    JComboBox mapLayersBox = new JComboBox();
    JComboBox mapStylesBox = new JComboBox();
    JLabel mapLayerLabel = new JLabel("Layer: ");
    JLabel mapStyleLabel = new JLabel("Style: ");
    private String googleName = "Google Static Maps";
    private boolean enableGoogle = false;
    private static final String wms_layer_default = "bmng200407";
    private String imageName;
    private vtkActor mapSetActor = new vtkActor();

    public MapSetCreatePluginGUI(String imgName, double[] imageData) {
        this.imageData = imageData;
        this.imageName = imgName;
    }

    public MapSetCreatePluginGUI(SurfacePluginGUI ipg) {
        this.parent = ipg;
        this.surfaceImageTabPane = new JTabbedPane();
        JPanel surfaceTab = new JPanel();
        JPanel imageTab = new JPanel();
        this.surfaceImageTabPane.add("Load a Surface (topography)", surfaceTab);
        this.surfaceImageTabPane.add("Load an Image", imageTab);
        FlowLayout layout = new FlowLayout();
        layout.setAlignment(0);
        this.surfaceDiskButton.setSelected(true);
        this.surfaceDiskButton.addActionListener(this);
        this.surfaceWebButton.setSelected(false);
        this.surfaceWebButton.setEnabled(false);
        this.reDownloadBox.setEnabled(false);
        this.surfaceWebButton.addActionListener(this);
        this.surfacePixelField.setEnabled(false);
        this.surfaceSourceChoosePanel.add(new JLabel("Load Surface(topography) From: "));
        this.surfaceSourceChoosePanel.add(this.surfaceDiskButton);
        this.surfaceSourceChoosePanel.add(this.surfaceWebButton);
        this.surfaceSourceChoosePanel.add(this.surfacePixelLabel);
        this.surfaceSourceChoosePanel.add(this.surfacePixelField);
        this.surfaceFilePanel.setLayout(layout);
        this.surfaceFilePanel.add(new JLabel("Surface(topography) File:  "));
        this.surfaceFilePanel.add(this.surfaceFilePath);
        this.surfaceFilePanel.add(this.browseSurfaceButton);
        this.surfaceSourcePanel.add((Component)this.reDownloadBox, "North");
        this.surfaceSourcePanel.add((Component)this.surfaceSourceChoosePanel, "Center");
        this.surfaceSourcePanel.add((Component)this.surfaceFilePanel, "South");
        this.surfaceCoordPanel.setLayout(new GridLayout(4, 2, 10, 10));
        this.surfaceCoordPanel.add(this.surfaceLeftLatitude);
        this.surfaceCoordPanel.add(this.surfaceUpperLongitude);
        this.surfaceCoordPanel.add(this.surfaceRightLatitude);
        this.surfaceCoordPanel.add(this.surfaceLowerLongitude);
        this.surfaceCoordPanel.add(this.surfaceAltitude);
        this.surfaceCoordPanel.add(new JLabel());
        this.surfaceCoordPanel.add(this.surfaceScale);
        this.surfaceLabelPanel.setLayout(new GridLayout(4, 1, 10, 10));
        this.surfaceLabelPanel.add(this.surfaceUpperLeftCorner);
        this.surfaceLabelPanel.add(this.surfaceLowerRightCorner);
        this.surfaceLabelPanel.add(this.surfaceAltitudeLabel);
        this.surfaceLabelPanel.add(this.surfaceScaleLabel);
        this.surfaceCoordLabelPanel.setLayout(layout);
        this.surfaceCoordLabelPanel.add(this.surfaceLabelPanel);
        this.surfaceCoordLabelPanel.add(this.surfaceCoordPanel);
        this.surfacePanel.setLayout(new BorderLayout());
        this.surfacePanel.add((Component)this.surfaceSourcePanel, "North");
        this.surfacePanel.add((Component)this.surfaceCoordLabelPanel, "Center");
        this.imageDiskButton.setSelected(true);
        this.imageWebButton.setSelected(false);
        this.imageWebButton.setEnabled(false);
        this.imageDiskButton.addActionListener(this);
        this.imageWebButton.addActionListener(this);
        this.imagePixelField.setEnabled(false);
        this.imageSourceChoosePanel.add(this.imageSourceLabel);
        this.imageSourceChoosePanel.add(this.imageDiskButton);
        this.imageSourceChoosePanel.add(this.imageWebButton);
        this.imageSourceChoosePanel.add(this.imagePixelLabel);
        this.imageSourceChoosePanel.add(this.imagePixelField);
        this.imageFilePanel.add(this.selectImage);
        this.imageFilePanel.add(this.imageFilePath);
        this.imageFilePanel.add(this.browseImageButton);
        this.imageSourcePanel.add((Component)this.imageSourceChoosePanel, "North");
        this.imageLoadPanel.add((Component)this.imageFilePanel, "North");
        this.imageLoadPanel.add((Component)this.imageWebLayerPanel, "South");
        this.imageSourcePanel.add((Component)this.imageLoadPanel, "South");
        this.imageCoordPanel.setLayout(new GridLayout(3, 2, 10, 10));
        this.imageCoordPanel.add(this.imageLeftLatitude);
        this.imageCoordPanel.add(this.imageUpperLongitude);
        this.imageCoordPanel.add(this.imageRightLatitude);
        this.imageCoordPanel.add(this.imageLowerLongitude);
        this.imageCoordPanel.add(this.imageAltitude);
        this.imageCoordPanel.add(new JLabel());
        this.imageLabelPanel.setLayout(new GridLayout(3, 1, 10, 10));
        this.imageLabelPanel.add(this.imageUpperLeftCorner);
        this.imageLabelPanel.add(this.imageLowerRightCorner);
        this.imageLabelPanel.add(this.imageAltitudeLabel);
        this.imageCoordLabelPanel.setLayout(layout);
        this.imageCoordLabelPanel.add(this.imageLabelPanel);
        this.imageCoordLabelPanel.add(this.imageCoordPanel);
        this.imagePanel.setLayout(new BorderLayout());
        this.imagePanel.add((Component)this.imageSourcePanel, "North");
        this.imagePanel.add((Component)this.differentImageBox, "Center");
        this.imagePanel.add((Component)this.imageCoordLabelPanel, "South");
        this.addFilePanel.setLayout(layout);
        surfaceTab.setLayout(new BorderLayout());
        surfaceTab.add((Component)this.surfacePanel, "Center");
        surfaceTab.setLayout(layout);
        imageTab.setLayout(new BorderLayout());
        imageTab.add((Component)this.imagePanel, "Center");
        imageTab.setLayout(layout);
        this.differentImageBox.addActionListener(this);
        this.imageLeftLatitude.setEnabled(false);
        this.imageUpperLongitude.setEnabled(false);
        this.imageRightLatitude.setEnabled(false);
        this.imageLowerLongitude.setEnabled(false);
        this.imageAltitude.setEnabled(false);
        this.imageUpperLeftCorner.setEnabled(false);
        this.imageLowerRightCorner.setEnabled(false);
        this.imageAltitudeLabel.setEnabled(false);
        this.buttonsPanel.setLayout(new FlowLayout());
        this.buttonsPanel.add(this.displayButton);
        this.buttonsPanel.add(this.saveDisplayButton);
        this.buttonsPanel.add(this.cancelButton);
        this.mainPanel.setSize(1000, 1050);
        this.mainPanel.setIgnoreRepaint(true);
        this.bottomPanel.add((Component)this.buttonsPanel, "North");
        this.bottomPanel.add((Component)this.downloadProgressBar, "South");
        this.mainPanel.setLayout(new BorderLayout());
        this.mainPanel.add((Component)this.surfaceImageTabPane, "North");
        this.mainPanel.add((Component)this.bottomPanel, "South");
        this.displayButton.addActionListener(this);
        this.saveDisplayButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.browseSurfaceButton.addActionListener(this);
        this.browseImageButton.addActionListener(this);
        this.saveDisplayButton.setEnabled(false);
        this.getContentPane().add(this.mainPanel);
        this.pack();
        this.setResizable(false);
        this.setVisible(true);
        this.setLocationRelativeTo(null);
        this.toFront();
        this.setTitle("Add new: Surface/Image/Preset Surface & Image");
        this.imageRightLatitude.getDocument().addDocumentListener(this);
        this.imageLeftLatitude.getDocument().addDocumentListener(this);
        this.imageUpperLongitude.getDocument().addDocumentListener(this);
        this.imageLowerLongitude.getDocument().addDocumentListener(this);
        this.surfaceRightLatitude.getDocument().addDocumentListener(this);
        this.surfaceLeftLatitude.getDocument().addDocumentListener(this);
        this.surfaceUpperLongitude.getDocument().addDocumentListener(this);
        this.surfaceLowerLongitude.getDocument().addDocumentListener(this);
    }

    public double[] setSurfaceData() {
        this.surfaceData = new double[5];
        try {
            this.surfaceData[0] = Double.parseDouble(this.surfaceLeftLatitude.getText());
            this.surfaceData[1] = Double.parseDouble(this.surfaceRightLatitude.getText());
            this.surfaceData[2] = Double.parseDouble(this.surfaceLowerLongitude.getText());
            this.surfaceData[3] = Double.parseDouble(this.surfaceUpperLongitude.getText());
            this.surfaceData[4] = Double.parseDouble(this.surfaceAltitude.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return this.surfaceData;
    }

    public double[] setImageData() {
        this.imageData = new double[5];
        if (this.isDifferentImageCoords()) {
            this.imageData[0] = Double.parseDouble(this.imageLeftLatitude.getText());
            this.imageData[1] = Double.parseDouble(this.imageRightLatitude.getText());
            this.imageData[2] = Double.parseDouble(this.imageLowerLongitude.getText());
            this.imageData[3] = Double.parseDouble(this.imageUpperLongitude.getText());
            this.imageData[4] = Double.parseDouble(this.imageAltitude.getText());
            return this.imageData;
        }
        this.imageData = new double[5];
        this.imageData[0] = Double.parseDouble(this.surfaceLeftLatitude.getText());
        this.imageData[1] = Double.parseDouble(this.surfaceRightLatitude.getText());
        this.imageData[2] = Double.parseDouble(this.surfaceLowerLongitude.getText());
        this.imageData[3] = Double.parseDouble(this.surfaceUpperLongitude.getText());
        this.imageData[4] = Double.parseDouble(this.surfaceAltitude.getText());
        return this.imageData;
    }

    public void setMapSetActor(vtkActor actor) {
        this.mapSetActor = actor;
    }

    public vtkActor getMapSetActor() {
        return this.mapSetActor;
    }

    public boolean isDifferentImageCoords() {
        return this.differentImageBox.isSelected();
    }

    public String saveToMemory() {
        int end;
        int begin;
        String surfaceTemp = new String();
        String imageTemp = new String();
        File groupDir = new File(Prefs.getLibLoc() + File.separator + SurfacePlugin.dataStoreDir + File.separator + "data");
        if (!groupDir.exists()) {
            groupDir.mkdirs();
        }
        if (this.surfaceData != null) {
            begin = this.surfaceFilePath.getText().lastIndexOf(File.separator) + 1;
            end = this.surfaceFilePath.getText().length() - 1;
            end = this.surfaceFilePath.getText().endsWith(".txt") ? this.surfaceFilePath.getText().indexOf(".txt") : this.surfaceFilePath.getText().indexOf(".dem");
            try {
                surfaceTemp = this.surfaceFilePath.getText().substring(begin, end);
            }
            catch (StringIndexOutOfBoundsException e) {
                surfaceTemp = "-";
            }
        } else {
            surfaceTemp = "-";
        }
        if (this.imageData != null && this.imageFilePath.getText().length() > 0) {
            String name = this.imageFilePath.getText();
            begin = name.lastIndexOf(File.separator);
            if (name.toLowerCase().contains(".jpg")) {
                end = name.toLowerCase().indexOf(".jpg");
            } else if (name.toLowerCase().contains(".png")) {
                end = name.toLowerCase().indexOf(".png");
            } else {
                throw new IllegalStateException("Only JPG/PNG supported");
            }
            imageTemp = this.imageFilePath.getText().substring(begin + 1, end);
        } else {
            imageTemp = "-";
        }
        this.loadedFilePath = groupDir.toString() + File.separator + surfaceTemp + "_" + imageTemp + ".xml";
        this.groupFile = new File(this.loadedFilePath);
        if (!this.groupFile.exists()) {
            this.groupDoc = this.createXML(false);
            this.writeToFile();
            return this.loadedFilePath;
        }
        JOptionPane.showMessageDialog(this, "Files already in memory!");
        return this.loadedFilePath;
    }

    private void writeToFile() {
        try {
            XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
            BufferedWriter xmlOut = new BufferedWriter(new FileWriter(this.groupFile, true));
            outputter.output(this.groupDoc, (Writer)xmlOut);
            xmlOut.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private Document createXML(boolean groupFile) {
        Element LoadedFilesRoot = this.setElements(groupFile);
        Document doc = new Document(LoadedFilesRoot);
        return doc;
    }

    private Element setElements(boolean groupFile) {
        String coord;
        Element surfaceImageRoot = new Element("SurfaceImage");
        Element surface = new Element("surface");
        Element image = new Element("image");
        Element group = new Element("group");
        Element imageSourceFile = new Element("imageSourceFile");
        Element surfaceSourceFile = new Element("surfaceSourceFile");
        Element imageCoordinates = new Element("imageCoordinates");
        Element surfaceCoordinates = new Element("surfaceCoordinates");
        if (this.surfaceData != null) {
            surfaceSourceFile.setText(this.surfaceFilePath.getText());
            coord = this.surfaceData[0] + " " + this.surfaceData[1] + " " + this.surfaceData[2] + " " + this.surfaceData[3] + " " + this.surfaceData[4];
            surfaceCoordinates.setText(coord);
        } else {
            surfaceSourceFile.setText("-");
            surfaceCoordinates.setText("-");
        }
        surface.addContent(surfaceSourceFile);
        surface.addContent(surfaceCoordinates);
        if (this.imageData != null) {
            imageSourceFile.setText(this.imageFilePath.getText());
            coord = this.imageData[0] + " " + this.imageData[1] + " " + this.imageData[2] + " " + this.imageData[3] + " " + this.imageData[4];
            imageCoordinates.setText(coord);
        } else {
            imageSourceFile.setText("-");
            surfaceCoordinates.setText("-");
        }
        if (groupFile && this.filePath != null) {
            group.setText(this.filePath);
        } else {
            group.setText("-");
        }
        image.addContent(imageSourceFile);
        image.addContent(imageCoordinates);
        surfaceImageRoot.addContent(surface);
        surfaceImageRoot.addContent(image);
        surfaceImageRoot.addContent(group);
        return surfaceImageRoot;
    }

    private void setProgressIndeterminate(boolean ind) {
        final boolean ind2 = ind;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MapSetCreatePluginGUI.this.downloadProgressBar.setIndeterminate(ind2);
            }
        });
    }

    private void setProgressStringPainted(boolean painted) {
        final boolean painted2 = painted;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MapSetCreatePluginGUI.this.downloadProgressBar.setStringPainted(painted2);
            }
        });
    }

    private void setProgressString(String str) {
        final String str2 = str;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MapSetCreatePluginGUI.this.downloadProgressBar.setString(str2);
            }
        });
    }

    private boolean loadSurfaceFromWeb() {
        double[] region;
        this.surfaceError = "";
        this.setProgressString("Downloading Surface...");
        this.setProgressStringPainted(true);
        this.setProgressIndeterminate(true);
        String tempPath = Prefs.getLibLoc() + File.separator + SurfacePlugin.dataStoreDir + File.separator + "DEMs" + File.separator;
        File tempDir = new File(tempPath);
        if (!tempDir.isDirectory()) {
            tempDir.mkdirs();
        }
        try {
            region = this.setSurfaceData();
        }
        catch (NumberFormatException e) {
            this.setProgressString("The selected range is invalid!");
            this.setProgressIndeterminate(false);
            e.printStackTrace();
            return false;
        }
        double latN = region[0];
        double latS = region[1];
        double lonE = region[2];
        double lonW = region[3];
        int ndel = Integer.parseInt(this.surfacePixelField.getText());
        double numSurfacePts = Math.abs(latN - latS) * Math.abs(lonE - lonW) * Math.pow(120.0 / (double)ndel, 2.0);
        if (numSurfacePts > 2764800.0) {
            System.out.println("Trying to download something too big...");
            this.setProgressString("Surface is too large, increase Pixel Spacing!");
            this.setProgressIndeterminate(false);
            return false;
        }
        String filename = String.valueOf(latN).replace(".", "p") + "_" + String.valueOf(latS).replace(".", "p") + "_" + String.valueOf(lonW).replace(".", "p") + "_" + String.valueOf(lonE).replace(".", "p") + "_" + ndel + ".txt";
        System.out.println("Downloading topography to: " + tempPath + filename);
        File outFile = new File(tempPath + filename);
        boolean reDownload = this.reDownloadBox.isSelected();
        if (outFile.exists()) {
            System.out.print("You've already downloaded this...");
            if (reDownload) {
                System.out.print("deleting...");
                reDownload = outFile.delete();
            }
            System.out.println();
        }
        if (!outFile.exists() || reDownload) {
            try {
                URL url = new URL(this.surfaceServerURL + "?latN=" + latN + "&latS=" + latS + "&lonW=" + lonW + "&lonE=" + lonE + "&ndel=" + ndel);
                System.out.println("Downloading from: " + this.surfaceServerURL + "?latN=" + latN + "&latS=" + latS + "&lonW=" + lonW + "&lonE=" + lonE + "&ndel=" + ndel);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                String line = in.readLine();
                if (line.contains("<MOVED>")) {
                    this.surfaceServerURL = line.substring(line.indexOf("<MOVED>") + 7, line.indexOf("</MOVED>"));
                    System.out.println("Web service moved to: " + this.surfaceServerURL);
                    return this.loadSurfaceFromWeb();
                }
                if (line.contains("ERROR")) {
                    this.surfaceError = "Surface service suplied incorrect paramaters!";
                    System.out.println(this.surfaceError);
                    this.setProgressString("The selected range is invalid!");
                    this.setProgressIndeterminate(false);
                    return false;
                }
                System.out.println(outFile);
                System.out.flush();
                BufferedWriter out = new BufferedWriter(new FileWriter(outFile));
                out.append(line + "\n");
                while ((line = in.readLine()) != null) {
                    out.append(line + "\n");
                }
                out.flush();
                out.close();
            }
            catch (MalformedURLException e) {
                this.setProgressString("Malformed URL Exception!");
                this.setProgressIndeterminate(false);
                this.imageError = "Malformed URL Exception";
                e.printStackTrace();
                return false;
            }
            catch (IOException e) {
                this.setProgressString("IO Exception! Check internet connection.");
                this.setProgressIndeterminate(false);
                this.imageError = "IO Exception";
                e.printStackTrace();
                return false;
            }
        }
        this.surfaceFilePath.setText(outFile.getAbsolutePath());
        this.surfaceFile = true;
        this.setProgressIndeterminate(false);
        return true;
    }

    private boolean loadImageFromWeb() {
        double[] region;
        this.imageError = "";
        this.setProgressString("Downloading Surface Image...");
        this.setProgressStringPainted(true);
        this.setProgressIndeterminate(true);
        String tempPath = Prefs.getLibLoc() + File.separator + SurfacePlugin.dataStoreDir + File.separator + "Maps" + File.separator;
        File tempDir = new File(tempPath);
        if (!tempDir.isDirectory()) {
            tempDir.mkdirs();
        }
        try {
            region = this.setImageData();
        }
        catch (NumberFormatException e) {
            this.setProgressString("The selected range is invalid!");
            this.setProgressIndeterminate(false);
            return false;
        }
        double latN = region[0];
        double latS = region[1];
        double lonE = region[2];
        double lonW = region[3];
        int pixelsPerDegree = Integer.parseInt(this.imagePixelField.getText());
        String layer = "";
        String style = "";
        String filename = String.valueOf(latN).replace(".", "p") + "_" + String.valueOf(latS).replace(".", "p") + "_" + String.valueOf(lonW).replace(".", "p") + "_" + String.valueOf(lonE).replace(".", "p") + "_" + pixelsPerDegree;
        LatLonBoundingBox box = null;
        boolean useWMS = true;
        if (this.mapLayersBox.getSelectedItem() instanceof WMSLayer) {
            layer = ((WMSLayer)this.mapLayersBox.getSelectedItem()).getName();
            if (this.mapStylesBox.getSelectedItem() != null) {
                style = ((WMSStyle)this.mapStylesBox.getSelectedItem()).getName();
            }
            box = ((WMSLayer)this.mapLayersBox.getSelectedItem()).getBox();
            filename = filename + "_" + layer;
            if (style.length() > 0) {
                filename = filename + "_" + style;
            }
        } else {
            useWMS = false;
            filename = filename + "_google";
        }
        filename = filename + ".jpg";
        System.out.println("Downloading Surface Image to: " + tempPath + filename);
        File outFile = new File(tempPath + filename);
        boolean reDownload = this.reDownloadBox.isSelected();
        if (outFile.exists()) {
            System.out.print("You've already downloaded this...");
            if (reDownload) {
                System.out.print("deleting...");
                reDownload = outFile.delete();
            }
            System.out.println();
        }
        if (!outFile.exists() || reDownload) {
            try {
                BufferedImage image;
                String type = "jpg";
                if (useWMS) {
                    WMSUrlGenerator wms = new WMSUrlGenerator(this.wms.getBaseUrl(), layer, style);
                    URL url = new URL(wms.toWMSURL(latS, latN, lonE, lonW, pixelsPerDegree));
                    System.out.println("Downloading image from: " + String.valueOf(url));
                    HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                    if (!conn.getContentType().contains("jpeg")) {
                        BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                        String line = "";
                        while (in.ready() && !(line = in.readLine()).contains("<ServiceException>")) {
                        }
                        this.imageError = in.readLine();
                        while (this.imageError.charAt(0) == ' ') {
                            this.imageError = this.imageError.substring(1);
                        }
                        System.out.println("WMS ERROR: " + this.imageError);
                        this.setProgressString(this.imageError);
                        this.setProgressIndeterminate(false);
                        return false;
                    }
                    image = ImageIO.read(conn.getInputStream());
                } else {
                    URL url = new URL(GoogleStaticMapsURLGenerator.toURL(latS, latN, lonE, lonW, pixelsPerDegree));
                    System.out.println("Downloading image from: " + String.valueOf(url));
                    HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                    if (!conn.getContentType().contains("jpeg") && !conn.getContentType().contains("png")) {
                        System.out.println("AHHHHHHHHH!");
                        this.setProgressString(this.imageError);
                        this.setProgressIndeterminate(false);
                        return false;
                    }
                    if (conn.getContentType().contains("png")) {
                        type = "png";
                    }
                    image = ImageIO.read(conn.getInputStream());
                }
                ImageIO.write((RenderedImage)image, type, outFile);
            }
            catch (MalformedURLException e) {
                this.setProgressString("Malformed URL Exception!");
                this.setProgressIndeterminate(false);
                this.imageError = "Malformed URL Exception";
                e.printStackTrace();
                return false;
            }
            catch (IOException e) {
                this.setProgressString("IO Exception! Check internet connection or decrease Pixels/Degree");
                this.setProgressIndeterminate(false);
                this.imageError = "IO Exception";
                e.printStackTrace();
                return false;
            }
        }
        this.imageFilePath.setText(outFile.getAbsolutePath());
        this.imageFile = true;
        this.setProgressIndeterminate(false);
        return true;
    }

    public void createSurface(LoadedFilesProperties temp, SurfacePluginGUI ipg) {
        double[] ul = new double[3];
        double[] lr = new double[3];
        try {
            double ulLat = this.surfaceData[0];
            double lrLat = this.surfaceData[1];
            double lrLong = this.surfaceData[2];
            double ulLong = this.surfaceData[3];
            ul[0] = ulLat;
            ul[1] = ulLong;
            ul[2] = this.surfaceData[4];
            lr[0] = lrLat;
            lr[1] = lrLong;
            lr[2] = this.surfaceData[4];
            if (ulLat <= lrLat || ulLong >= lrLong || ulLat > 90.0 || ulLong < -180.0 || lrLat < -90.0 || lrLong > 180.0) {
                JOptionPane.showMessageDialog(this, "Bad coordinates.", "Oops!", 2);
                return;
            }
        }
        catch (NumberFormatException nfe) {
            JOptionPane.showMessageDialog(this, "Bad data.");
        }
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public void createImage(LoadedFilesProperties temp, SurfacePluginGUI ipg) {
        double[] ul = new double[3];
        double[] lr = new double[3];
        try {
            double ulLat = this.imageData[0];
            double lrLat = this.imageData[1];
            double lrLong = this.imageData[2];
            double ulLong = this.imageData[3];
            ul[0] = ulLat;
            ul[1] = ulLong;
            ul[2] = this.imageData[4];
            lr[0] = lrLat;
            lr[1] = lrLong;
            lr[2] = this.imageData[4];
            System.out.println(ulLat + " " + ulLong + " " + lrLat + " " + lrLong);
            boolean meshType = false;
            if (ulLat <= lrLat || ulLong == lrLong || ulLat > 90.0 || ulLong < -180.0 || lrLat < -90.0 || lrLong > 180.0) {
                JOptionPane.showMessageDialog(this, "Bad coordinates.", "Oops!", 2);
                return;
            }
            if (ulLong > lrLong) {
                int option = JOptionPane.showConfirmDialog(this, "Do you want this image across the International Date Line?", "Across hemispheres?", 0);
                if (option == 1) {
                    return;
                }
                lr[1] = lr[1] + 360.0;
            }
            temp.addImageInfo(new ImageInfo(this.imageName, temp.getImageFilePath(), ul, lr, meshType));
            if (!temp.getSurfaceFilePath().equals("-")) {
                temp.addGeographicSurfaceInfo(new GeographicSurfaceInfo(temp.getSurfaceFilePath(), ul, lr));
                ipg.display(temp.getGeoInfo(), temp.getImageInfo());
            } else {
                ipg.display(temp.getImageInfo());
            }
            System.out.println("ipg == null");
        }
        catch (NumberFormatException nfe) {
            JOptionPane.showMessageDialog(this, "Bad data.");
        }
    }

    @Override
    public void changedUpdate(DocumentEvent arg0) {
    }

    @Override
    public void insertUpdate(DocumentEvent arg0) {
    }

    @Override
    public void removeUpdate(DocumentEvent arg0) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        DataFileChooser fileChooser;
        Object source = e.getSource();
        if (source == this.surfaceDiskButton) {
            this.surfaceWebButton.setSelected(!this.surfaceDiskButton.isSelected());
            this.webSurface = this.surfaceWebButton.isSelected();
            if (this.webSurface) {
                this.surfaceFilePath.setEnabled(false);
                this.surfacePixelField.setEnabled(true);
                this.browseSurfaceButton.setEnabled(false);
                this.displayButton.setEnabled(true);
            } else {
                this.surfaceFilePath.setEnabled(true);
                this.surfacePixelField.setEnabled(false);
                this.browseSurfaceButton.setEnabled(true);
                if (!(this.surfaceFile || this.imageFile || this.webImage)) {
                    this.displayButton.setEnabled(false);
                }
            }
        } else if (source == this.surfaceWebButton) {
            this.surfaceDiskButton.setSelected(!this.surfaceWebButton.isSelected());
            this.webSurface = this.surfaceWebButton.isSelected();
            if (this.webSurface) {
                this.surfaceFilePath.setEnabled(false);
                this.surfacePixelField.setEnabled(true);
                this.browseSurfaceButton.setEnabled(false);
                this.displayButton.setEnabled(true);
            } else {
                this.surfaceFilePath.setEnabled(true);
                this.surfacePixelField.setEnabled(false);
                this.browseSurfaceButton.setEnabled(true);
                if (!(this.surfaceFile || this.imageFile || this.webImage)) {
                    this.displayButton.setEnabled(false);
                }
            }
        } else if (source == this.imageDiskButton) {
            this.imageWebButton.setSelected(!this.imageDiskButton.isSelected());
            this.webImage = this.imageWebButton.isSelected();
            this.setImageLoadPanel(this.webImage);
            if (this.webImage) {
                this.imagePixelField.setEnabled(true);
                this.displayButton.setEnabled(true);
            } else {
                this.imagePixelField.setEnabled(false);
                if (!(this.surfaceFile || this.imageFile || this.webSurface)) {
                    this.displayButton.setEnabled(false);
                }
            }
        } else if (source == this.imageWebButton) {
            this.imageDiskButton.setSelected(!this.imageWebButton.isSelected());
            this.webImage = this.imageWebButton.isSelected();
            this.setImageLoadPanel(this.webImage);
            if (this.webImage) {
                this.imagePixelField.setEnabled(true);
                this.displayButton.setEnabled(true);
            } else {
                this.imagePixelField.setEnabled(false);
                if (!(this.surfaceFile || this.imageFile || this.webSurface)) {
                    this.displayButton.setEnabled(false);
                }
            }
        } else if (source == this.browseSurfaceButton) {
            Info.getMainGUI();
            fileChooser = new DataFileChooser(this, "Import Surface Data", false, new File(String.valueOf(MainGUI.getRootPluginDir()) + File.separator + "DEMs"));
            fileChooser.setCurrentFilter(".dem", "DEM Files");
            fileChooser.setCurrentFilter(".txt", "Text Files");
            File sFileName = fileChooser.getFile();
            if (sFileName != null) {
                this.surfaceFilePath.setText(sFileName.getAbsolutePath());
                this.surfaceFile = true;
                this.displayButton.setEnabled(true);
            }
        } else if (source == this.browseImageButton) {
            Info.getMainGUI();
            fileChooser = new DataFileChooser(this, "Import Image Data", false, new File(String.valueOf(MainGUI.getRootPluginDir()) + File.separator + "Maps"));
            ImageFileFilter filter = new ImageFileFilter();
            fileChooser.setFileFilter(filter);
            File iFileName = fileChooser.getFile();
            if (iFileName != null) {
                this.imageFilePath.setText(iFileName.getAbsolutePath());
                this.displayButton.setEnabled(true);
                this.imageFile = true;
                if (this.surfaceFile) {
                    this.saveDisplayButton.setEnabled(true);
                }
            }
        }
        if (source == this.cancelButton) {
            this.dispose();
        }
        if (source == this.displayButton) {
            this.displayButton.setEnabled(false);
            this.saveDisplayButton.setEnabled(false);
            this.cancelButton.setEnabled(false);
            boolean fail = false;
            if (this.webSurface && !this.loadSurfaceFromWeb()) {
                fail = true;
            }
            if (this.webImage && !fail && !this.loadImageFromWeb()) {
                fail = true;
            }
            if (!fail) {
                String loadedFilePath;
                this.setProgressString("Displaying Surface...");
                this.setProgressStringPainted(true);
                this.setProgressIndeterminate(true);
                if (this.surfaceFile && !this.imageFile) {
                    this.parent.setScaleFactor(Double.parseDouble(this.surfaceScale.getText()));
                    this.surfaceData = this.setSurfaceData();
                    loadedFilePath = this.saveToMemory();
                    if (loadedFilePath == null) {
                        this.setProgressString("Couldn't Find File...");
                        this.setProgressIndeterminate(false);
                        return;
                    }
                    LoadedFilesProperties lfp = new LoadedFilesProperties(this.imageFilePath.getText(), this.imageData, "-", null, null, false, loadedFilePath);
                    lfp.setPlot(true);
                    lfp.setShow(true);
                    this.createSurface(lfp, this.parent);
                    this.dispose();
                } else if (!this.surfaceFile && this.imageFile) {
                    this.parent.setScaleFactor(Double.parseDouble(this.surfaceScale.getText()));
                    this.imageData = this.setImageData();
                    loadedFilePath = this.saveToMemory();
                    if (loadedFilePath == null) {
                        this.setProgressString("Couldn't Find File...");
                        this.setProgressIndeterminate(false);
                        return;
                    }
                    LoadedFilesProperties lfp = new LoadedFilesProperties(this.imageFilePath.getText(), this.imageData, "-", null, null, false, loadedFilePath);
                    lfp.setPlot(true);
                    lfp.setShow(true);
                    this.createImage(lfp, this.parent);
                    this.dispose();
                } else if (this.surfaceFile && this.imageFile) {
                    this.parent.setScaleFactor(Double.parseDouble(this.surfaceScale.getText()));
                    this.surfaceData = this.setSurfaceData();
                    this.imageData = this.setImageData();
                    loadedFilePath = this.saveToMemory();
                    if (loadedFilePath == null) {
                        this.setProgressString("Couldn't Find File...");
                        this.setProgressIndeterminate(false);
                        return;
                    }
                    LoadedFilesProperties lfp = new LoadedFilesProperties(this.imageFilePath.getText(), this.imageData, this.surfaceFilePath.getText(), this.surfaceData, null, false, loadedFilePath);
                    lfp.setPlot(true);
                    lfp.setShow(true);
                    this.createSurface(lfp, this.parent);
                    this.createImage(lfp, this.parent);
                    this.dispose();
                }
            }
            if (fail) {
                this.displayButton.setEnabled(true);
                if ((this.surfaceFile || this.webSurface) && (this.imageFile || this.webImage)) {
                    this.saveDisplayButton.setEnabled(true);
                }
                this.cancelButton.setEnabled(true);
            }
        }
        if (source == this.differentImageBox) {
            this.imageLeftLatitude.setEnabled(true);
            this.imageRightLatitude.setEnabled(true);
            this.imageLowerLongitude.setEnabled(true);
            this.imageUpperLongitude.setEnabled(true);
            this.imageAltitude.setEnabled(true);
        }
    }

    private void setImageLoadPanel(boolean internet) {
        if (internet && this.wms == null) {
            boolean retry = true;
            while (retry) {
                this.log.debug((Object)"Downloading WMS capabilities XML from: https://data.worldwind.arc.nasa.gov/wms");
                try {
                    this.wms = WMSService.fromXML(wms_url);
                    retry = false;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    String message = "Error contacting Web Map Service.\nThis means that the service is down or overloaded,\nor you are not connected to the internet.\n\nRetry?";
                    String title = "WMS Error";
                    int ret = JOptionPane.showConfirmDialog(this, message, title, 0);
                    if (ret == 0) {
                        this.log.debug((Object)"Retrying WMS capabilities download...");
                        retry = true;
                        continue;
                    }
                    retry = false;
                    this.imageDiskButton.doClick();
                    return;
                }
            }
        }
        if (internet) {
            this.mapLayersBox.removeAllItems();
            if (this.enableGoogle) {
                this.mapLayersBox.addItem(this.googleName);
            }
            int index = 0;
            if (this.wms != null) {
                for (WMSLayer layer : this.wms.getLayers()) {
                    this.mapLayersBox.addItem(layer);
                    if (!layer.getName().equals(wms_layer_default)) continue;
                    if (this.enableGoogle) {
                        index = this.wms.getLayers().indexOf(layer) + 1;
                        continue;
                    }
                    index = this.wms.getLayers().indexOf(layer);
                }
            }
            this.mapLayersBox.setSelectedIndex(index);
        } else if (this.mapLayersBox.getItemCount() == 0) {
            this.mapLayersBox.removeAllItems();
            this.mapLayersBox.addItem("< none >");
            this.mapStylesBox.removeAllItems();
            this.mapStylesBox.addItem("< none >");
        }
        this.imageFilePanel.setEnabled(!internet);
        this.browseImageButton.setEnabled(!internet);
        this.imageFilePath.setEnabled(!internet);
        this.selectImage.setEnabled(!internet);
        this.imageWebLayerPanel.setEnabled(internet);
        this.mapLayersBox.setEnabled(internet);
        this.mapStylesBox.setEnabled(internet);
        this.mapLayerLabel.setEnabled(internet);
        this.mapStyleLabel.setEnabled(internet);
        this.imageLoadPanel.repaint();
    }

    public class ImageFileFilter
    extends FileFilter {
        private final String[] okFileExtensions = new String[]{"jpg", "png"};

        @Override
        public boolean accept(File file) {
            for (String extension : this.okFileExtensions) {
                if (!file.getName().toLowerCase().endsWith(extension)) continue;
                return true;
            }
            return false;
        }

        @Override
        public String getDescription() {
            return "JPEG and PNG image files";
        }
    }
}

