/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.plugins.SurfacePlugin;

import com.google.common.base.Throwables;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.scec.vtk.main.Info;
import org.scec.vtk.main.MainGUI;
import org.scec.vtk.plugins.PluginActors;
import org.scec.vtk.plugins.SurfacePlugin.Component.LoadedFilesProperties;
import org.scec.vtk.plugins.SurfacePlugin.GeographicSurfaceInfo;
import org.scec.vtk.plugins.SurfacePlugin.ImageInfo;
import org.scec.vtk.plugins.SurfacePlugin.MapSetCreatePluginGUI;
import org.scec.vtk.plugins.SurfacePlugin.Surface;
import org.scec.vtk.plugins.SurfacePlugin.SurfacePlugin;
import org.scec.vtk.plugins.SurfacePlugin.SurfaceTableModel;
import org.scec.vtk.plugins.utils.components.AddButton;
import org.scec.vtk.plugins.utils.components.RemoveButton;
import org.scec.vtk.plugins.utils.components.ShowButton;
import org.scec.vtk.tools.Prefs;
import org.scec.vtk.tools.Transform;
import vtk.vtkActor;
import vtk.vtkCell;
import vtk.vtkCellArray;
import vtk.vtkDataArray;
import vtk.vtkDoubleArray;
import vtk.vtkFloatArray;
import vtk.vtkJPEGReader;
import vtk.vtkMapper;
import vtk.vtkPNGReader;
import vtk.vtkPoints;
import vtk.vtkPolyData;
import vtk.vtkPolyDataMapper;
import vtk.vtkPolygon;
import vtk.vtkProp;
import vtk.vtkTexture;
import vtk.vtkTriangleStrip;

public class SurfacePluginGUI
extends JPanel
implements ActionListener,
ChangeListener,
ListSelectionListener,
TableModelListener {
    private static final long serialVersionUID = 1L;
    private JPanel mainPanel = new JPanel();
    private JPanel topPanel = new JPanel();
    private JPanel bottomPanel = new JPanel();
    private JPanel sliderPanel = new JPanel();
    private JPanel panesPanel = new JPanel();
    private JPanel defaultPanel = new JPanel();
    private JPanel checkboxPanel = new JPanel();
    private JScrollPane defaultScrollPane = new JScrollPane(this.checkboxPanel);
    private JLabel defaultSurfaces = new JLabel("Default Surfaces:");
    private JCheckBox wm = new JCheckBox("World Map");
    private JCheckBox sc = new JCheckBox("Southern California Map");
    private JCheckBox cm = new JCheckBox("California Map");
    private JCheckBox jm = new JCheckBox("Japan Map");
    private JCheckBox nz = new JCheckBox("New Zealand Map");
    private JCheckBox im = new JCheckBox("Indonesia Map");
    private JCheckBox hm = new JCheckBox("Haiti Map");
    private JCheckBox mm = new JCheckBox("Mexico Map");
    private JCheckBox sa = new JCheckBox("South America Map");
    private JCheckBox cd = new JCheckBox("California DEM");
    private JCheckBox cdc = new JCheckBox("California DEM Colored");
    private JLabel addRemLabel = new JLabel("Add / Remove ");
    protected RemoveButton remISButton;
    private AddButton newISButton;
    protected ShowButton showImageButton;
    private JSlider transparencySlider = new JSlider();
    String[] columnNames = new String[]{"Visible", "Image(s)", "Surface(s)"};
    public SurfaceTableModel surfaceTableModel = new SurfaceTableModel(this.columnNames);
    public JTable surfaceTable = new JTable(this.surfaceTableModel);
    public static Vector<Surface> surfaceArray = new Vector();
    private MapSetCreatePluginGUI mscpg;
    private PluginActors surfaceActors;
    private String filename;
    private double n;
    private double w;
    private double s;
    private double e;
    private double altitude;
    private BufferedReader demReader;
    private int horizontalItems;
    private int longIncrements;
    private double scaleFactor;
    private ArrayList<double[]> data = new ArrayList();
    private int latIncrements;
    boolean isWindowOpen = false;

    public SurfacePluginGUI(PluginActors surfaceActors) {
        this.surfaceActors = surfaceActors;
        this.newISButton = new AddButton(this, "Add a new surface/image");
        this.remISButton = new RemoveButton(this, "Remove selected surface/image");
        this.showImageButton = new ShowButton(this, "Toggle visibility of selected image(s)");
        this.surfaceTable.setLayout(new GridLayout(1, 3));
        this.surfaceTable.setPreferredScrollableViewportSize(new Dimension(350, 70));
        this.surfaceTable.getColumnModel().getColumn(0).setMaxWidth(116);
        this.surfaceTable.getColumnModel().getColumn(1).setMaxWidth(116);
        this.surfaceTable.getColumnModel().getColumn(2).setMaxWidth(118);
        this.surfaceTable.getSelectionModel().addListSelectionListener(this);
        this.surfaceTableModel.addTableModelListener(this);
        JScrollPane scrollPane = new JScrollPane(this.surfaceTable);
        this.panesPanel.setLayout(new GridLayout(1, 2, 10, 10));
        this.panesPanel.add(scrollPane);
        this.topPanel.add((Component)this.panesPanel, "Center");
        JPanel bar = new JPanel();
        bar.setBorder(BorderFactory.createEmptyBorder(3, 0, 0, 0));
        bar.setLayout(new BoxLayout(bar, 2));
        bar.setOpaque(true);
        int buttonSpace = 3;
        bar.add(this.showImageButton);
        bar.add(Box.createHorizontalGlue());
        bar.add(this.addRemLabel);
        bar.add(this.newISButton);
        bar.add(Box.createHorizontalStrut(buttonSpace));
        bar.add(this.remISButton);
        bar.add(Box.createHorizontalStrut(buttonSpace));
        this.newISButton.setEnabled(true);
        this.bottomPanel.setLayout(new BorderLayout());
        this.bottomPanel.add((Component)this.sliderPanel, "North");
        this.bottomPanel.add((Component)bar, "South");
        this.transparencySlider.setMajorTickSpacing(10);
        this.transparencySlider.setMinorTickSpacing(5);
        this.transparencySlider.setPaintLabels(true);
        this.transparencySlider.setPaintTicks(true);
        this.transparencySlider.addChangeListener(this);
        this.transparencySlider.setEnabled(false);
        this.sliderPanel.setLayout(new BorderLayout());
        this.sliderPanel.add((Component)new JLabel("Transparency"), "North");
        this.sliderPanel.add((Component)this.transparencySlider, "Center");
        this.wm.addActionListener(this);
        this.wm.setName("wm");
        this.sc.addActionListener(this);
        this.sc.setName("sc");
        this.cm.addActionListener(this);
        this.cm.setName("cm");
        this.jm.addActionListener(this);
        this.jm.setName("jm");
        this.nz.addActionListener(this);
        this.nz.setName("nz");
        this.im.addActionListener(this);
        this.im.setName("im");
        this.hm.addActionListener(this);
        this.hm.setName("hm");
        this.mm.addActionListener(this);
        this.mm.setName("mm");
        this.sa.addActionListener(this);
        this.sa.setName("sa");
        this.cd.addActionListener(this);
        this.cd.setName("cd");
        this.cdc.addActionListener(this);
        this.cdc.setName("cdc");
        this.defaultPanel.add(this.defaultSurfaces);
        this.defaultPanel.setLayout(new BoxLayout(this.defaultPanel, 1));
        this.defaultPanel.setPreferredSize(new Dimension(300, 120));
        this.defaultScrollPane.setPreferredSize(new Dimension(300, 120));
        this.checkboxPanel.add(this.cm);
        this.checkboxPanel.add(this.sc);
        this.checkboxPanel.add(this.cd);
        this.checkboxPanel.add(this.cdc);
        this.checkboxPanel.add(this.wm);
        this.checkboxPanel.add(this.mm);
        this.checkboxPanel.add(this.sa);
        this.checkboxPanel.add(this.jm);
        this.checkboxPanel.add(this.im);
        this.checkboxPanel.add(this.nz);
        this.checkboxPanel.add(this.hm);
        this.checkboxPanel.setLayout(new GridLayout(0, 2));
        this.defaultPanel.add(this.defaultScrollPane);
        this.mainPanel.setLayout(new BorderLayout(5, 5));
        this.mainPanel.add((Component)this.topPanel, "Center");
        this.mainPanel.add((Component)this.bottomPanel, "South");
        this.mainPanel.add((Component)this.defaultPanel, "North");
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        this.mainPanel.setPreferredSize(new Dimension(Prefs.getPluginWidth(), Prefs.getPluginHeight() / 2));
        this.add(this.mainPanel);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Object src = e.getSource();
        if (src == this.transparencySlider) {
            double transparency = (double)this.transparencySlider.getValue() / 100.0;
            ListSelectionModel model = this.surfaceTable.getSelectionModel();
            for (int i = model.getMinSelectionIndex(); i <= model.getMaxSelectionIndex(); ++i) {
                int row = model.getMinSelectionIndex();
                this.setTransparency(surfaceArray.get(row), transparency);
            }
            Info.getMainGUI();
            MainGUI.updateRenderWindow();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        Object src = e.getSource();
        this.surfaceTable.getModel();
        if (e.getValueIsAdjusting()) {
            return;
        }
        if (src == this.surfaceTable.getSelectionModel()) {
            this.processTableSelectionChange();
        }
    }

    public void setScaleFactor(double newScale) {
        this.scaleFactor = newScale;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ListSelectionModel model;
        LoadedFilesProperties lfp;
        String loadedFilePath;
        String imageExt;
        String imageTemp;
        String surfaceTemp;
        double[] imageData;
        Object source = e.getSource();
        if (source == this.newISButton) {
            if (this.mscpg != null) {
                this.mscpg.dispose();
                this.mscpg = new MapSetCreatePluginGUI(this);
                this.mscpg.toFront();
            } else {
                this.mscpg = new MapSetCreatePluginGUI(this);
            }
        }
        if (source == this.cm) {
            if (this.cm.isSelected()) {
                imageData = new double[]{42.2, 32.1, -113.4, -124.5, -5.0};
                surfaceTemp = "-";
                imageTemp = "CaliforniaFull";
                imageExt = ".jpg";
                Info.getMainGUI();
                loadedFilePath = String.valueOf(MainGUI.getRootPluginDir()) + File.separator + SurfacePlugin.dataStoreDir + File.separator + "data" + File.separator + surfaceTemp + "_" + imageTemp + ".xml";
                System.out.println("Loaded File Path: " + loadedFilePath);
                Info.getMainGUI();
                lfp = new LoadedFilesProperties(String.valueOf(MainGUI.getRootPluginDir()) + File.separator + "Maps" + File.separator + imageTemp + imageExt, imageData, "-", null, null, false, loadedFilePath);
                this.mscpg = new MapSetCreatePluginGUI(imageTemp, imageData);
                this.mscpg.createImage(lfp, this);
            } else {
                this.removePresetObject(this.cm);
            }
            System.out.println("surfaceArray list is " + String.valueOf(surfaceArray));
        }
        if (source == this.wm) {
            if (this.wm.isSelected()) {
                imageData = new double[]{90.0, -90.0, 180.0, -180.0, -5.0};
                surfaceTemp = "-";
                imageTemp = "world.topo.bathy.200410.3x5400x2700";
                imageExt = ".jpg";
                Info.getMainGUI();
                loadedFilePath = String.valueOf(MainGUI.getRootPluginDir()) + File.separator + SurfacePlugin.dataStoreDir + File.separator + "data" + File.separator + surfaceTemp + "_" + imageTemp + ".xml";
                System.out.println("Loaded File Path: " + loadedFilePath);
                Info.getMainGUI();
                lfp = new LoadedFilesProperties(String.valueOf(MainGUI.getRootPluginDir()) + File.separator + "Maps" + File.separator + imageTemp + imageExt, imageData, "-", null, null, false, loadedFilePath);
                this.mscpg = new MapSetCreatePluginGUI(imageTemp, imageData);
                this.mscpg.createImage(lfp, this);
            } else {
                this.removePresetObject(this.wm);
            }
        }
        if (source == this.sc) {
            if (this.sc.isSelected()) {
                imageData = new double[]{36.0, 32.5, -114.0, -122.0, 0.0};
                surfaceTemp = "-";
                imageTemp = "largesocal";
                imageExt = ".jpg";
                Info.getMainGUI();
                loadedFilePath = String.valueOf(MainGUI.getRootPluginDir()) + File.separator + SurfacePlugin.dataStoreDir + File.separator + "data" + File.separator + surfaceTemp + "_" + imageTemp + ".xml";
                System.out.println("Loaded File Path: " + loadedFilePath);
                Info.getMainGUI();
                lfp = new LoadedFilesProperties(String.valueOf(MainGUI.getRootPluginDir()) + File.separator + "Maps" + File.separator + imageTemp + imageExt, imageData, "-", null, null, false, loadedFilePath);
                this.mscpg = new MapSetCreatePluginGUI(imageTemp, imageData);
                this.mscpg.createImage(lfp, this);
            } else {
                this.removePresetObject(this.sc);
            }
        }
        if (source == this.jm) {
            if (this.jm.isSelected()) {
                imageData = new double[]{46.9, 26.2, 147.0, 127.1, -5.0};
                surfaceTemp = "-";
                imageTemp = "Japan";
                imageExt = ".jpg";
                Info.getMainGUI();
                loadedFilePath = String.valueOf(MainGUI.getRootPluginDir()) + File.separator + SurfacePlugin.dataStoreDir + File.separator + "data" + File.separator + surfaceTemp + "_" + imageTemp + ".xml";
                System.out.println("Loaded File Path: " + loadedFilePath);
                Info.getMainGUI();
                lfp = new LoadedFilesProperties(String.valueOf(MainGUI.getRootPluginDir()) + File.separator + "Maps" + File.separator + imageTemp + imageExt, imageData, "-", null, null, false, loadedFilePath);
                this.mscpg = new MapSetCreatePluginGUI(imageTemp, imageData);
                this.mscpg.createImage(lfp, this);
            } else {
                this.removePresetObject(this.jm);
            }
        }
        if (source == this.nz) {
            if (this.nz.isSelected()) {
                imageData = new double[5];
                imageData[0] = -34.3;
                imageData[1] = -47.5;
                imageData[2] = 179.4;
                imageData[3] = 165.4;
                surfaceTemp = "-";
                imageTemp = "NewZealand";
                imageExt = ".jpg";
                Info.getMainGUI();
                loadedFilePath = String.valueOf(MainGUI.getRootPluginDir()) + File.separator + SurfacePlugin.dataStoreDir + File.separator + "data" + File.separator + surfaceTemp + "_" + imageTemp + ".xml";
                System.out.println("Loaded File Path: " + loadedFilePath);
                Info.getMainGUI();
                lfp = new LoadedFilesProperties(String.valueOf(MainGUI.getRootPluginDir()) + File.separator + "Maps" + File.separator + imageTemp + imageExt, imageData, "-", null, null, false, loadedFilePath);
                this.mscpg = new MapSetCreatePluginGUI(imageTemp, imageData);
                this.mscpg.createImage(lfp, this);
            } else {
                this.removePresetObject(this.nz);
            }
        }
        if (source == this.im) {
            if (this.im.isSelected()) {
                imageData = new double[]{9.4, -12.0, 148.4, 93.8, -5.0};
                surfaceTemp = "-";
                imageTemp = "Indonesia";
                imageExt = ".jpg";
                Info.getMainGUI();
                loadedFilePath = String.valueOf(MainGUI.getRootPluginDir()) + File.separator + SurfacePlugin.dataStoreDir + File.separator + "data" + File.separator + surfaceTemp + "_" + imageTemp + ".xml";
                System.out.println("Loaded File Path: " + loadedFilePath);
                Info.getMainGUI();
                lfp = new LoadedFilesProperties(String.valueOf(MainGUI.getRootPluginDir()) + File.separator + "Maps" + File.separator + imageTemp + imageExt, imageData, "-", null, null, false, loadedFilePath);
                this.mscpg = new MapSetCreatePluginGUI(imageTemp, imageData);
                this.mscpg.createImage(lfp, this);
            } else {
                this.removePresetObject(this.im);
            }
        }
        if (source == this.hm) {
            if (this.hm.isSelected()) {
                imageData = new double[]{20.5, 17.5, -68.5, -74.5, -5.0};
                surfaceTemp = "-";
                imageTemp = "Haiti";
                imageExt = ".jpg";
                Info.getMainGUI();
                loadedFilePath = String.valueOf(MainGUI.getRootPluginDir()) + File.separator + SurfacePlugin.dataStoreDir + File.separator + "data" + File.separator + surfaceTemp + "_" + imageTemp + ".xml";
                System.out.println("Loaded File Path: " + loadedFilePath);
                Info.getMainGUI();
                lfp = new LoadedFilesProperties(String.valueOf(MainGUI.getRootPluginDir()) + File.separator + "Maps" + File.separator + imageTemp + imageExt, imageData, "-", null, null, false, loadedFilePath);
                this.mscpg = new MapSetCreatePluginGUI(imageTemp, imageData);
                this.mscpg.createImage(lfp, this);
            } else {
                this.removePresetObject(this.hm);
            }
        }
        if (source == this.mm) {
            if (this.mm.isSelected()) {
                imageData = new double[]{35.4, 12.8, -82.9, -119.0, -8.0};
                surfaceTemp = "-";
                imageTemp = "Mexico";
                imageExt = ".jpg";
                Info.getMainGUI();
                loadedFilePath = String.valueOf(MainGUI.getRootPluginDir()) + File.separator + SurfacePlugin.dataStoreDir + File.separator + "data" + File.separator + surfaceTemp + "_" + imageTemp + ".xml";
                System.out.println("Loaded File Path: " + loadedFilePath);
                Info.getMainGUI();
                lfp = new LoadedFilesProperties(String.valueOf(MainGUI.getRootPluginDir()) + File.separator + "Maps" + File.separator + imageTemp + imageExt, imageData, "-", null, null, false, loadedFilePath);
                this.mscpg = new MapSetCreatePluginGUI(imageTemp, imageData);
                this.mscpg.createImage(lfp, this);
            } else {
                this.removePresetObject(this.mm);
            }
        }
        if (source == this.sa) {
            if (this.sa.isSelected()) {
                imageData = new double[]{14.7, -57.0, -36.0, -82.4, -5.0};
                surfaceTemp = "-";
                imageTemp = "SouthAmerica";
                imageExt = ".jpg";
                Info.getMainGUI();
                loadedFilePath = String.valueOf(MainGUI.getRootPluginDir()) + File.separator + SurfacePlugin.dataStoreDir + File.separator + "data" + File.separator + surfaceTemp + "_" + imageTemp + ".xml";
                System.out.println("Loaded File Path: " + loadedFilePath);
                Info.getMainGUI();
                lfp = new LoadedFilesProperties(String.valueOf(MainGUI.getRootPluginDir()) + File.separator + "Maps" + File.separator + imageTemp + imageExt, imageData, "-", null, null, false, loadedFilePath);
                this.mscpg = new MapSetCreatePluginGUI(imageTemp, imageData);
                this.mscpg.createImage(lfp, this);
            } else {
                this.removePresetObject(this.sa);
            }
        }
        if (source == this.cd) {
            if (this.cd.isSelected()) {
                imageData = new double[]{42.0, 32.5, -114.0, -124.5, 0.0};
                surfaceTemp = "-";
                imageTemp = "CaliforniaDEM";
                imageExt = ".png";
                Info.getMainGUI();
                loadedFilePath = String.valueOf(MainGUI.getRootPluginDir()) + File.separator + SurfacePlugin.dataStoreDir + File.separator + "data" + File.separator + surfaceTemp + "_" + imageTemp + ".xml";
                System.out.println("Loaded File Path: " + loadedFilePath);
                Info.getMainGUI();
                lfp = new LoadedFilesProperties(String.valueOf(MainGUI.getRootPluginDir()) + File.separator + "Maps" + File.separator + imageTemp + imageExt, imageData, "-", null, null, false, loadedFilePath);
                this.mscpg = new MapSetCreatePluginGUI(imageTemp, imageData);
                this.mscpg.createImage(lfp, this);
            } else {
                this.removePresetObject(this.cd);
            }
        }
        if (source == this.cdc) {
            if (this.cdc.isSelected()) {
                imageData = new double[]{42.0, 32.5, -114.131477, -124.409641, 0.0};
                surfaceTemp = "-";
                imageTemp = "CAlDEM_old";
                imageExt = ".png";
                Info.getMainGUI();
                loadedFilePath = String.valueOf(MainGUI.getRootPluginDir()) + File.separator + SurfacePlugin.dataStoreDir + File.separator + "data" + File.separator + surfaceTemp + "_" + imageTemp + ".xml";
                System.out.println("Loaded File Path: " + loadedFilePath);
                Info.getMainGUI();
                lfp = new LoadedFilesProperties(String.valueOf(MainGUI.getRootPluginDir()) + File.separator + "Maps" + File.separator + imageTemp + imageExt, imageData, "-", null, null, false, loadedFilePath);
                this.mscpg = new MapSetCreatePluginGUI(imageTemp, imageData);
                this.mscpg.createImage(lfp, this);
            } else {
                this.removePresetObject(this.cdc);
            }
        } else if (source == this.remISButton) {
            model = this.surfaceTable.getSelectionModel();
            while (model.getMinSelectionIndex() >= 0) {
                int row = model.getMinSelectionIndex();
                JCheckBox tempCheckBox = this.uncheckPreset(row);
                if (tempCheckBox != null && tempCheckBox.isSelected()) {
                    tempCheckBox.setSelected(false);
                }
                this.surfaceTableModel.removeRow(row);
                this.surfaceActors.removeActor((vtkProp)surfaceArray.get(row).getSurfaceActor());
                surfaceArray.remove(row);
            }
            Info.getMainGUI();
            MainGUI.updateRenderWindow();
        } else if (source == this.showImageButton) {
            model = this.surfaceTable.getSelectionModel();
            for (int i = model.getMinSelectionIndex(); i <= model.getMaxSelectionIndex(); ++i) {
                int row = i;
                int v = surfaceArray.get(row).getSurfaceActor().GetVisibility() == 0 ? 1 : 0;
                this.setVisibility(surfaceArray.get(row), row, v);
            }
            Info.getMainGUI();
            MainGUI.updateRenderWindow();
        }
    }

    private void removePresetObject(JCheckBox uncheckedCheckBox) {
        ListSelectionModel model = this.surfaceTable.getSelectionModel();
        for (int i = 0; i < this.surfaceTableModel.getRowCount(); ++i) {
            System.out.println("uncheck " + i);
            JCheckBox tempCheckBox = this.uncheckPreset(i);
            if (tempCheckBox == null || tempCheckBox != uncheckedCheckBox) continue;
            this.surfaceTableModel.removeRow(i);
            this.surfaceActors.removeActor((vtkProp)surfaceArray.get(i).getSurfaceActor());
            surfaceArray.remove(i);
        }
        Info.getMainGUI();
        MainGUI.updateRenderWindow();
    }

    public void removeAllMaps() {
        int numRows = this.surfaceTableModel.getRowCount();
        for (int i = 0; i < numRows; ++i) {
            JCheckBox tempCheckBox = this.uncheckPreset(0);
            this.setCheckBox(tempCheckBox.getName(), false);
            this.surfaceTableModel.removeRow(0);
            this.surfaceActors.removeActor((vtkProp)surfaceArray.get(0).getSurfaceActor());
            surfaceArray.remove(0);
        }
        Info.getMainGUI();
        MainGUI.updateRenderWindow();
    }

    private JCheckBox uncheckPreset(int row) {
        String presetImage;
        switch (presetImage = (String)this.surfaceTableModel.getValueAt(row, 1)) {
            case "CaliforniaFull": {
                return this.cm;
            }
            case "world.topo.bathy.200410.3x5400x2700": {
                return this.wm;
            }
            case "largesocal": {
                return this.sc;
            }
            case "Japan": {
                return this.jm;
            }
            case "NewZealand": {
                return this.nz;
            }
            case "Haiti": {
                return this.hm;
            }
            case "Mexico": {
                return this.mm;
            }
            case "Indonesia": {
                return this.im;
            }
            case "SouthAmerica": {
                return this.sa;
            }
            case "CaliforniaDEM": {
                return this.cd;
            }
            case "CAlDEM_new": {
                return this.cdc;
            }
        }
        return null;
    }

    public JPanel getPanel() {
        return this;
    }

    @Override
    public void tableChanged(TableModelEvent e) {
    }

    private void loadData(GeographicSurfaceInfo si) throws IOException {
        this.filename = si.getFilename();
        double[] ul = si.getUpperRight();
        this.n = ul[0];
        this.w = ul[1];
        double[] lr = si.getLowerLeft();
        this.s = lr[0];
        this.e = lr[1];
        this.altitude = lr[2];
        this.demReader = new BufferedReader(new FileReader(this.filename));
        String line = this.demReader.readLine();
        StringTokenizer dataLine = new StringTokenizer(line);
        this.horizontalItems = dataLine.countTokens();
        this.longIncrements = this.horizontalItems - 1;
        while (line != null) {
            dataLine = new StringTokenizer(line);
            double[] lineHeights = new double[this.horizontalItems];
            int j = 0;
            while (dataLine.hasMoreTokens()) {
                lineHeights[j] = this.scaleFactor * Double.parseDouble(dataLine.nextToken());
                ++j;
            }
            this.data.add(lineHeights);
            line = this.demReader.readLine();
        }
        this.demReader.close();
    }

    private vtkPolyData createSurface(GeographicSurfaceInfo si) {
        this.latIncrements = this.data.size() - 1;
        si.setVertSteps(this.latIncrements);
        si.setHorizSteps(this.longIncrements);
        int numVertices = this.latIncrements * (2 * this.longIncrements + 2);
        vtkFloatArray textureCoordinates = new vtkFloatArray();
        textureCoordinates.SetNumberOfComponents(2);
        textureCoordinates.SetNumberOfTuples((long)numVertices);
        textureCoordinates.SetName("TextureCoordinates");
        vtkPoints pts = new vtkPoints();
        double latStep = (this.n - this.s) / (double)this.latIncrements;
        double longStep = (this.e - this.w) / (double)this.longIncrements;
        double[] firstLineOfData = new double[this.horizontalItems];
        double[] secondLineOfData = new double[this.horizontalItems];
        int pointIndex = 0;
        int stripIndex = 0;
        vtkCellArray cells = new vtkCellArray();
        for (int i = 0; i < this.latIncrements; ++i) {
            vtkTriangleStrip triangleStrip = new vtkTriangleStrip();
            triangleStrip.GetPointIds().SetNumberOfIds((long)(this.longIncrements * 2));
            stripIndex = 0;
            firstLineOfData = this.data.get(this.latIncrements - i - 1);
            secondLineOfData = this.data.get(this.latIncrements - i);
            for (int j = 0; j < this.longIncrements; ++j) {
                try {
                    double[] xForm = new double[3];
                    double height = secondLineOfData[j] / 200.0 + this.altitude;
                    double lat = this.s + (double)i * latStep;
                    double lon = this.w + (double)j * longStep;
                    xForm = Transform.transformLatLonHeight(lat, lon, height);
                    float longRatio = (float)j / (float)this.longIncrements;
                    float lati = i;
                    if (j > this.longIncrements) {
                        longRatio = 1.0f;
                    }
                    if ((float)i > lati) {
                        lati = this.latIncrements;
                    }
                    textureCoordinates.InsertTuple2((long)pointIndex, (double)longRatio, (double)(lati / (float)this.latIncrements));
                    pts.InsertPoint((long)pointIndex, xForm);
                    height = firstLineOfData[j] / 200.0 + this.altitude;
                    lat = this.s + (double)(i + 1) * latStep;
                    lon = this.w + (double)j * longStep;
                    xForm = Transform.transformLatLonHeight(lat, lon, height);
                    pts.InsertPoint((long)(pointIndex + 1), xForm);
                    textureCoordinates.InsertTuple2((long)(pointIndex + 1), (double)longRatio, (double)((lati + 1.0f) / (float)this.latIncrements));
                    triangleStrip.GetPointIds().SetId((long)stripIndex, (long)pointIndex);
                    triangleStrip.GetPointIds().SetId((long)(stripIndex + 1), (long)(pointIndex + 1));
                    pointIndex += 2;
                    stripIndex += 2;
                    continue;
                }
                catch (Exception ex) {
                    System.out.println("Exception " + String.valueOf(ex));
                    System.out.println("i=" + i + " j=" + j);
                }
            }
            cells.InsertNextCell((vtkCell)triangleStrip);
        }
        vtkPolyData triangleStripPolydata = new vtkPolyData();
        triangleStripPolydata.SetPoints(pts);
        triangleStripPolydata.SetStrips(cells);
        triangleStripPolydata.GetPointData().SetTCoords((vtkDataArray)textureCoordinates);
        return triangleStripPolydata;
    }

    public void display(GeographicSurfaceInfo si, ImageInfo ii) {
        new ArrayList();
        try {
            this.loadData(si);
        }
        catch (IOException e) {
            Throwables.propagate((Throwable)e);
        }
        vtkTexture texture = new vtkTexture();
        if (ii.getFilename().contains("png")) {
            vtkPNGReader pngReader = new vtkPNGReader();
            pngReader.SetFileName(ii.getFilename());
            System.out.println(ii.getFilename());
            pngReader.Update();
            texture.SetInputConnection(pngReader.GetOutputPort());
        } else {
            vtkJPEGReader jPEGReader = new vtkJPEGReader();
            jPEGReader.SetFileName(ii.getFilename());
            System.out.println(ii.getFilename());
            jPEGReader.Update();
            texture.SetInputConnection(jPEGReader.GetOutputPort());
        }
        vtkPolyData polydata = new vtkPolyData();
        polydata = this.createSurface(si);
        vtkPolyDataMapper mapper = new vtkPolyDataMapper();
        mapper.SetInputData(polydata);
        vtkActor actor = new vtkActor();
        actor.SetMapper((vtkMapper)mapper);
        actor.SetTexture(texture);
        actor.GetProperty().SetOpacity(0.5);
        Surface surface = new Surface(ii, si, actor);
        surfaceArray.add(surface);
        Object[] tempRow = surface.createRow();
        this.surfaceTableModel.addRow(tempRow);
        this.surfaceActors.addActor((vtkProp)actor);
        Info.getMainGUI();
        MainGUI.updateRenderWindow();
    }

    public void display(ImageInfo ii) {
        System.out.println("Image added");
        vtkTexture texture = new vtkTexture();
        if (ii.getFilename().contains("png")) {
            vtkPNGReader pngReader = new vtkPNGReader();
            pngReader.SetFileName(ii.getFilename());
            System.out.println(ii.getFilename());
            pngReader.Update();
            texture.SetInputConnection(pngReader.GetOutputPort());
        } else {
            vtkJPEGReader jPEGReader = new vtkJPEGReader();
            jPEGReader.SetFileName(ii.getFilename());
            System.out.println(ii.getFilename());
            jPEGReader.Update();
            texture.SetInputConnection(jPEGReader.GetOutputPort());
        }
        double[] upperLeft = ii.getUpperLeft();
        double[] lowerRight = ii.getLowerRight();
        double height = upperLeft[2];
        double[][] tuple = new double[4][3];
        vtkPoints points = new vtkPoints();
        vtkDoubleArray textureCoordinates = new vtkDoubleArray();
        textureCoordinates.SetName("TextureCoordinates");
        textureCoordinates.SetNumberOfComponents(2);
        vtkCellArray polygons = new vtkCellArray();
        double upperLat = upperLeft[0];
        double lowerLat = lowerRight[0];
        double leftLon = upperLeft[1];
        double rightLon = lowerRight[1];
        int ptCount = 0;
        for (double i = upperLat; i > lowerLat; i -= 1.0) {
            for (double j = rightLon; j > leftLon; j -= 1.0) {
                double nextLat = Math.max(i - 1.0, lowerLat);
                double nextLon = Math.max(j - 1.0, leftLon);
                vtkPolygon polygon = new vtkPolygon();
                polygon.GetPointIds().SetNumberOfIds(4L);
                points.InsertNextPoint(Transform.transformLatLon(nextLat, j));
                double u = (leftLon - j) / (leftLon - rightLon);
                double v = (lowerLat - nextLat) / (lowerLat - upperLat);
                u = this.clampTextureCoord(u);
                v = this.clampTextureCoord(v);
                textureCoordinates.InsertNextTuple2(u, v);
                polygon.GetPointIds().SetId(0L, (long)ptCount++);
                points.InsertNextPoint(Transform.transformLatLon(i, j));
                u = (leftLon - j) / (leftLon - rightLon);
                v = (lowerLat - i) / (lowerLat - upperLat);
                u = this.clampTextureCoord(u);
                v = this.clampTextureCoord(v);
                textureCoordinates.InsertNextTuple2(u, v);
                polygon.GetPointIds().SetId(1L, (long)ptCount++);
                points.InsertNextPoint(Transform.transformLatLon(i, nextLon));
                u = (leftLon - nextLon) / (leftLon - rightLon);
                v = (lowerLat - i) / (lowerLat - upperLat);
                u = this.clampTextureCoord(u);
                v = this.clampTextureCoord(v);
                textureCoordinates.InsertNextTuple2(u, v);
                polygon.GetPointIds().SetId(2L, (long)ptCount++);
                points.InsertNextPoint(Transform.transformLatLon(nextLat, nextLon));
                u = (leftLon - nextLon) / (leftLon - rightLon);
                v = (lowerLat - nextLat) / (lowerLat - upperLat);
                u = this.clampTextureCoord(u);
                v = this.clampTextureCoord(v);
                textureCoordinates.InsertNextTuple2(u, v);
                polygon.GetPointIds().SetId(3L, (long)ptCount++);
                polygons.InsertNextCell((vtkCell)polygon);
            }
        }
        vtkPolyData polygonPolyData = new vtkPolyData();
        polygonPolyData.SetPoints(points);
        polygonPolyData.SetPolys(polygons);
        polygonPolyData.GetPointData().SetTCoords((vtkDataArray)textureCoordinates);
        vtkPolyDataMapper mapper = new vtkPolyDataMapper();
        mapper.SetInputData(polygonPolyData);
        vtkActor actor = new vtkActor();
        actor.SetMapper((vtkMapper)mapper);
        actor.SetTexture(texture);
        actor.GetProperty().SetOpacity(0.5);
        Surface surface = new Surface(ii, null, actor);
        surfaceArray.add(surface);
        Object[] tempRow = surface.createRow();
        this.surfaceTableModel.addRow(tempRow);
        this.surfaceActors.addActor((vtkProp)actor);
        Info.getMainGUI();
        MainGUI.updateRenderWindow();
    }

    private double clampTextureCoord(double t) {
        t = t < 0.0 ? 0.0 : t;
        t = t > 1.0 ? 1.0 : t;
        return t;
    }

    public void processTableSelectionChange() {
        int[] selectedRows = this.surfaceTable.getSelectedRows();
        if (selectedRows.length > 0) {
            this.remISButton.setEnabled(true);
            this.showImageButton.setEnabled(true);
            this.transparencySlider.setEnabled(true);
        } else {
            this.remISButton.setEnabled(false);
            this.showImageButton.setEnabled(false);
            this.transparencySlider.setEnabled(false);
        }
    }

    public void unloadPlugin() {
        for (int i = 0; i < surfaceArray.size(); ++i) {
            this.surfaceActors.removeActor((vtkProp)surfaceArray.get(i).getSurfaceActor());
        }
        surfaceArray.removeAllElements();
        Info.getMainGUI();
        MainGUI.updateRenderWindow();
    }

    public void setTransparency(Surface surface, double transparency) {
        surface.getSurfaceActor().GetProperty().SetOpacity(transparency);
    }

    public void setVisibility(Surface surf, int row, int visibility) {
        surf.setVisibility(visibility);
        surf.getSurfaceActor().SetVisibility(visibility);
        if (visibility == 0) {
            this.surfaceTableModel.setValueAt("false", row, 0);
        } else {
            this.surfaceTableModel.setValueAt("true", row, 0);
        }
    }

    public void setCheckBox(String nameOFButton, boolean what) {
        switch (nameOFButton) {
            case "wm": {
                this.wm.setSelected(what);
                break;
            }
            case "sc": {
                this.sc.setSelected(what);
                break;
            }
            case "cm": {
                this.cm.setSelected(what);
                break;
            }
            case "jm": {
                this.jm.setSelected(what);
                break;
            }
            case "nz": {
                this.nz.setSelected(what);
                break;
            }
            case "im": {
                this.im.setSelected(what);
                break;
            }
            case "hm": {
                this.hm.setSelected(what);
                break;
            }
            case "mm": {
                this.mm.setSelected(what);
                break;
            }
            case "sa": {
                this.sa.setSelected(what);
                break;
            }
            case "cd": {
                this.cd.setSelected(what);
                break;
            }
            case "cdc": {
                this.cdc.setSelected(what);
            }
        }
    }

    public Vector<Surface> getSurfaceArray() {
        return surfaceArray;
    }
}

