/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.plugins.SurfacePlugin;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import org.dom4j.Element;
import org.scec.vtk.main.Info;
import org.scec.vtk.main.MainGUI;
import org.scec.vtk.plugins.PluginState;
import org.scec.vtk.plugins.SurfacePlugin.Component.LoadedFilesProperties;
import org.scec.vtk.plugins.SurfacePlugin.MapSetCreatePluginGUI;
import org.scec.vtk.plugins.SurfacePlugin.Surface;
import org.scec.vtk.plugins.SurfacePlugin.SurfacePlugin;
import org.scec.vtk.plugins.SurfacePlugin.SurfacePluginGUI;

public class SurfacePluginState
implements PluginState {
    private SurfacePluginGUI parent;
    private ArrayList<Double> transparency;
    ArrayList<Integer> visibility;
    private ArrayList<String> dispName;
    private ArrayList<String> filePath;
    private ArrayList<String> filePathgeo;
    private ArrayList<Surface> surfaceArray;

    SurfacePluginState(SurfacePluginGUI parent) {
        this.parent = parent;
        this.dispName = new ArrayList();
        this.filePath = new ArrayList();
        this.surfaceArray = new ArrayList();
        this.filePathgeo = new ArrayList();
        this.transparency = new ArrayList();
        this.visibility = new ArrayList();
    }

    void copyLatestCatalogDetails() {
        this.dispName.clear();
        this.filePath.clear();
        this.surfaceArray.clear();
        this.filePathgeo.clear();
        this.transparency.clear();
        this.visibility.clear();
        for (Surface surf : SurfacePluginGUI.surfaceArray) {
            this.surfaceArray.add(surf);
            String imagename = surf.getImageInfo().getImageName();
            System.out.println(imagename);
            String file = surf.getImageInfo().getFilename();
            this.dispName.add(imagename);
            this.filePath.add(new File(file).getAbsolutePath());
            if (surf.getGeoSurfaceInfo() != null) {
                String fileGeo = surf.getGeoSurfaceInfo().getFilename();
                this.filePathgeo.add(new File(fileGeo).getAbsolutePath());
            }
            this.transparency.add(surf.getSurfaceActor().GetProperty().GetOpacity());
            this.visibility.add(surf.getVisibility());
        }
    }

    @Override
    public void load() {
        int i = 0;
        System.out.println("surfaceArray is " + String.valueOf(this.surfaceArray));
        System.out.println("transparency array is" + String.valueOf(this.transparency));
        System.out.println("visibility array is " + String.valueOf(this.visibility));
        System.out.println("disp names are " + String.valueOf(this.dispName));
        this.parent.removeAllMaps();
        this.addSurfaceToTable(this.dispName, this.filePath);
        for (Surface surf : this.parent.getSurfaceArray()) {
            this.parent.setTransparency(surf, this.transparency.get(i));
            this.parent.setVisibility(surf, i, this.visibility.get(i));
            ++i;
        }
    }

    private void createElement(Element stateEl) {
        for (int i = 0; i < this.surfaceArray.size(); ++i) {
            Element propertyEl;
            if (this.filePathgeo.size() != 0) {
                propertyEl = stateEl.addElement("Surfaces");
                propertyEl.addElement("dispName").addText(this.dispName.get(i));
                propertyEl.addElement("filePath").addText(this.filePath.get(i));
                propertyEl.addElement("GeographicSurfaceInfo").addText(this.filePathgeo.get(i));
                propertyEl.addElement("transparency").addText(this.transparency.get(i).toString());
                propertyEl.addElement("visibility").addText(this.visibility.get(i).toString());
                continue;
            }
            propertyEl = stateEl.addElement("Surfaces");
            propertyEl.addElement("dispName").addText(this.dispName.get(i));
            propertyEl.addElement("filePath").addText(this.filePath.get(i));
            propertyEl.addElement("GeographicSurfaceInfo").addText("");
            propertyEl.addElement("transparency").addText(this.transparency.get(i).toString());
            propertyEl.addElement("visibility").addText(this.visibility.get(i).toString());
        }
    }

    @Override
    public void toXML(Element stateEl) {
        this.copyLatestCatalogDetails();
        this.createElement(stateEl);
    }

    @Override
    public void fromXML(Element stateEl) {
        this.dispName.clear();
        this.filePath.clear();
        this.filePathgeo.clear();
        this.transparency.clear();
        this.visibility.clear();
        Iterator i = stateEl.elementIterator("Surfaces");
        while (i.hasNext()) {
            Element e = (Element)i.next();
            this.dispName.add(e.elementText("dispName"));
            this.filePath.add(e.elementText("filePath"));
            this.filePathgeo.add(e.elementText("GeographicSurfaceInfo"));
            this.transparency.add(Double.parseDouble(e.elementText("transparency")));
            this.visibility.add(Integer.parseInt(e.elementText("visibility")));
            System.out.println(e.elementText("filePath"));
        }
        this.addSurfaceToTable(this.dispName, this.filePath);
        for (Surface suf : this.surfaceArray) {
            System.out.println("Surface ARRAY: " + suf.getImageInfo().getImageName());
        }
    }

    @Override
    public PluginState deepCopy() {
        SurfacePluginState state = new SurfacePluginState(this.parent);
        state.copyLatestCatalogDetails();
        return state;
    }

    public void addSurfaceToTable(ArrayList<String> pictureNames, ArrayList<String> filepath) {
        for (int i = 0; i < pictureNames.size(); ++i) {
            MapSetCreatePluginGUI mscpg;
            LoadedFilesProperties lfp;
            String loadedFilePath;
            String imageExt;
            String imageTemp;
            String surfaceTemp;
            double[] imageData;
            if (pictureNames.get(i).equals("CaliforniaFull")) {
                this.parent.setCheckBox("cm", true);
                imageData = new double[]{42.2, 32.1, -113.4, -124.5, -5.0};
                surfaceTemp = "-";
                imageTemp = "CaliforniaFull";
                imageExt = ".jpg";
                Info.getMainGUI();
                loadedFilePath = String.valueOf(MainGUI.getRootPluginDir()) + File.separator + SurfacePlugin.dataStoreDir + File.separator + "data" + File.separator + surfaceTemp + "_" + imageTemp + ".xml";
                lfp = new LoadedFilesProperties(filepath.get(i), imageData, "-", null, null, false, loadedFilePath);
                mscpg = new MapSetCreatePluginGUI(imageTemp, imageData);
                mscpg.createImage(lfp, this.parent);
            } else if (pictureNames.get(i).equals("world.topo.bathy.200410.3x5400x2700")) {
                this.parent.setCheckBox("wm", true);
                imageData = new double[]{90.0, -90.0, 180.0, -180.0, -5.0};
                surfaceTemp = "-";
                imageTemp = "world.topo.bathy.200410.3x5400x2700";
                imageExt = ".jpg";
                Info.getMainGUI();
                loadedFilePath = String.valueOf(MainGUI.getRootPluginDir()) + File.separator + SurfacePlugin.dataStoreDir + File.separator + "data" + File.separator + surfaceTemp + "_" + imageTemp + ".xml";
                lfp = new LoadedFilesProperties(filepath.get(i), imageData, "-", null, null, false, loadedFilePath);
                mscpg = new MapSetCreatePluginGUI(imageTemp, imageData);
                mscpg.createImage(lfp, this.parent);
            } else if (pictureNames.get(i).equals("largesocal")) {
                this.parent.setCheckBox("sc", true);
                imageData = new double[]{36.0, 32.5, -114.0, -122.0, 0.0};
                surfaceTemp = "-";
                imageTemp = "largesocal";
                imageExt = ".jpg";
                Info.getMainGUI();
                loadedFilePath = String.valueOf(MainGUI.getRootPluginDir()) + File.separator + SurfacePlugin.dataStoreDir + File.separator + "data" + File.separator + surfaceTemp + "_" + imageTemp + ".xml";
                lfp = new LoadedFilesProperties(filepath.get(i), imageData, "-", null, null, false, loadedFilePath);
                mscpg = new MapSetCreatePluginGUI(imageTemp, imageData);
                mscpg.createImage(lfp, this.parent);
            } else if (pictureNames.get(i).equals("Japan")) {
                this.parent.setCheckBox("jm", true);
                imageData = new double[]{46.9, 26.2, 147.0, 127.1, -5.0};
                surfaceTemp = "-";
                imageTemp = "Japan";
                imageExt = ".jpg";
                Info.getMainGUI();
                loadedFilePath = String.valueOf(MainGUI.getRootPluginDir()) + File.separator + SurfacePlugin.dataStoreDir + File.separator + "data" + File.separator + surfaceTemp + "_" + imageTemp + ".xml";
                lfp = new LoadedFilesProperties(filepath.get(i), imageData, "-", null, null, false, loadedFilePath);
                mscpg = new MapSetCreatePluginGUI(imageTemp, imageData);
                mscpg.createImage(lfp, this.parent);
            } else if (pictureNames.get(i).equals("NewZealand")) {
                this.parent.setCheckBox("nz", true);
                imageData = new double[5];
                imageData[0] = -34.3;
                imageData[1] = -47.5;
                imageData[2] = 179.4;
                imageData[3] = 165.4;
                surfaceTemp = "-";
                imageTemp = "NewZealand";
                imageExt = ".jpg";
                Info.getMainGUI();
                loadedFilePath = String.valueOf(MainGUI.getRootPluginDir()) + File.separator + SurfacePlugin.dataStoreDir + File.separator + "data" + File.separator + surfaceTemp + "_" + imageTemp + ".xml";
                lfp = new LoadedFilesProperties(filepath.get(i), imageData, "-", null, null, false, loadedFilePath);
                mscpg = new MapSetCreatePluginGUI(imageTemp, imageData);
                mscpg.createImage(lfp, this.parent);
            } else if (pictureNames.get(i).equals("Indonesia")) {
                this.parent.setCheckBox("im", true);
                imageData = new double[]{9.4, -12.0, 148.4, 93.8, -5.0};
                surfaceTemp = "-";
                imageTemp = "Indonesia";
                imageExt = ".jpg";
                Info.getMainGUI();
                loadedFilePath = String.valueOf(MainGUI.getRootPluginDir()) + File.separator + SurfacePlugin.dataStoreDir + File.separator + "data" + File.separator + surfaceTemp + "_" + imageTemp + ".xml";
                lfp = new LoadedFilesProperties(filepath.get(i), imageData, "-", null, null, false, loadedFilePath);
                mscpg = new MapSetCreatePluginGUI(imageTemp, imageData);
                mscpg.createImage(lfp, this.parent);
            } else if (pictureNames.get(i).equals("Haiti")) {
                this.parent.setCheckBox("hm", true);
                imageData = new double[]{20.5, 17.5, -68.5, -74.5, -5.0};
                surfaceTemp = "-";
                imageTemp = "Haiti";
                imageExt = ".jpg";
                Info.getMainGUI();
                loadedFilePath = String.valueOf(MainGUI.getRootPluginDir()) + File.separator + SurfacePlugin.dataStoreDir + File.separator + "data" + File.separator + surfaceTemp + "_" + imageTemp + ".xml";
                lfp = new LoadedFilesProperties(filepath.get(i), imageData, "-", null, null, false, loadedFilePath);
                mscpg = new MapSetCreatePluginGUI(imageTemp, imageData);
                mscpg.createImage(lfp, this.parent);
            } else if (pictureNames.get(i).equals("Mexico")) {
                this.parent.setCheckBox("mm", true);
                imageData = new double[]{35.4, 12.8, -82.9, -119.0, -8.0};
                surfaceTemp = "-";
                imageTemp = "Mexico";
                imageExt = ".jpg";
                Info.getMainGUI();
                loadedFilePath = String.valueOf(MainGUI.getRootPluginDir()) + File.separator + SurfacePlugin.dataStoreDir + File.separator + "data" + File.separator + surfaceTemp + "_" + imageTemp + ".xml";
                lfp = new LoadedFilesProperties(filepath.get(i), imageData, "-", null, null, false, loadedFilePath);
                mscpg = new MapSetCreatePluginGUI(imageTemp, imageData);
                mscpg.createImage(lfp, this.parent);
            } else if (pictureNames.get(i).equals("SouthAmerica")) {
                this.parent.setCheckBox("sa", true);
                imageData = new double[]{14.7, -57.0, -36.0, -82.4, -5.0};
                surfaceTemp = "-";
                imageTemp = "SouthAmerica";
                imageExt = ".jpg";
                Info.getMainGUI();
                loadedFilePath = String.valueOf(MainGUI.getRootPluginDir()) + File.separator + SurfacePlugin.dataStoreDir + File.separator + "data" + File.separator + surfaceTemp + "_" + imageTemp + ".xml";
                lfp = new LoadedFilesProperties(filepath.get(i), imageData, "-", null, null, false, loadedFilePath);
                mscpg = new MapSetCreatePluginGUI(imageTemp, imageData);
                mscpg.createImage(lfp, this.parent);
            } else if (pictureNames.get(i).equals("CaliforniaDEM")) {
                this.parent.setCheckBox("cd", true);
                imageData = new double[]{42.0, 32.5, -114.0, -124.5, 0.0};
                surfaceTemp = "-";
                imageTemp = "CaliforniaDEM";
                imageExt = ".png";
                Info.getMainGUI();
                loadedFilePath = String.valueOf(MainGUI.getRootPluginDir()) + File.separator + SurfacePlugin.dataStoreDir + File.separator + "data" + File.separator + surfaceTemp + "_" + imageTemp + ".xml";
                lfp = new LoadedFilesProperties(filepath.get(i), imageData, "-", null, null, false, loadedFilePath);
                mscpg = new MapSetCreatePluginGUI(imageTemp, imageData);
                mscpg.createImage(lfp, this.parent);
            } else if (pictureNames.get(i).equals("CAlDEM_new")) {
                this.parent.setCheckBox("cdc", true);
                imageData = new double[]{42.0, 32.5, -114.131477, -124.409641, 0.0};
                surfaceTemp = "-";
                imageTemp = "CAlDEM_new";
                imageExt = ".png";
                Info.getMainGUI();
                loadedFilePath = String.valueOf(MainGUI.getRootPluginDir()) + File.separator + SurfacePlugin.dataStoreDir + File.separator + "data" + File.separator + surfaceTemp + "_" + imageTemp + ".xml";
                lfp = new LoadedFilesProperties(filepath.get(i), imageData, "-", null, null, false, loadedFilePath);
                mscpg = new MapSetCreatePluginGUI(imageTemp, imageData);
                mscpg.createImage(lfp, this.parent);
            } else if (pictureNames.get(i).equals("CAlDEM_old")) {
                this.parent.setCheckBox("cdc", true);
                imageData = new double[]{42.0, 32.5, -114.131477, -124.409641, 0.0};
                surfaceTemp = "-";
                imageTemp = "CAlDEM_old";
                imageExt = ".png";
                Info.getMainGUI();
                loadedFilePath = String.valueOf(MainGUI.getRootPluginDir()) + File.separator + SurfacePlugin.dataStoreDir + File.separator + "data" + File.separator + surfaceTemp + "_" + imageTemp + ".xml";
                lfp = new LoadedFilesProperties(filepath.get(i), imageData, "-", null, null, false, loadedFilePath);
                mscpg = new MapSetCreatePluginGUI(imageTemp, imageData);
                mscpg.createImage(lfp, this.parent);
            }
            Info.getMainGUI();
            MainGUI.updateRenderWindow();
        }
    }
}

