/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.plugins.opensha;

import java.io.IOException;
import java.util.List;
import javax.swing.JComponent;
import org.opensha.commons.util.ExceptionUtils;
import org.scec.vtk.commons.opensha.gui.anim.MultiAnimPanel;
import org.scec.vtk.commons.opensha.surfaces.FaultActorBundler;
import org.scec.vtk.commons.opensha.surfaces.GeometryGenerator;
import org.scec.vtk.plugins.ActionPlugin;
import org.scec.vtk.plugins.AnimatableChangeListener;
import org.scec.vtk.plugins.AnimatablePlugin;
import org.scec.vtk.plugins.PluginState;
import org.scec.vtk.plugins.opensha.FaultPluginGUI;
import org.scec.vtk.plugins.opensha.FaultPluginState;

public abstract class AbstractFaultPlugin
extends ActionPlugin
implements AnimatablePlugin {
    private FaultPluginGUI gui;
    private FaultPluginState state;
    private MultiAnimPanel animPanel;

    protected abstract FaultPluginGUI buildGUI() throws Exception;

    protected static void setBundlerInGeomGens(List<GeometryGenerator> geomGens, FaultActorBundler bundler) {
        for (GeometryGenerator geomGen : geomGens) {
            geomGen.setFaultActorBundler(bundler);
        }
    }

    @Override
    protected JComponent createGUI() throws IOException {
        if (this.gui == null) {
            try {
                this.gui = this.buildGUI();
                this.animPanel = this.gui.getAnimPanel();
                if (this.animPanel != null) {
                    this.animPanel.setPlugin(this);
                }
            }
            catch (Exception e) {
                ExceptionUtils.throwAsRuntimeException((Throwable)e);
            }
        }
        return this.gui.getJXLayer();
    }

    @Override
    public PluginState getState() {
        if (this.state == null) {
            this.state = new FaultPluginState(this.gui);
        }
        return this.state;
    }

    @Override
    public void animationStarted() {
        if (this.animPanel != null) {
            this.animPanel.animationStarted();
        }
    }

    @Override
    public void animationEnded() {
        if (this.animPanel != null) {
            this.animPanel.animationEnded();
        }
    }

    @Override
    public void animationTimeChanged(double fractionalTime) {
        if (this.animPanel != null) {
            this.animPanel.animationTimeChanged(fractionalTime);
        }
    }

    @Override
    public boolean isAnimatable() {
        return this.animPanel != null && this.animPanel.isAnimatable();
    }

    @Override
    public void addAnimatableChangeListener(AnimatableChangeListener l) {
        if (this.animPanel != null) {
            this.animPanel.addAnimatableChangeListener(l);
        }
    }

    @Override
    public void removeAnimatableChangeListener(AnimatableChangeListener l) {
        if (this.animPanel != null) {
            this.animPanel.removeAnimatableChangeListener(l);
        }
    }
}

