/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.plugins.opensha;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import org.jdesktop.jxlayer.JXLayer;
import org.jdesktop.jxlayer.plaf.LayerUI;
import org.jdesktop.jxlayer.plaf.ext.LockableUI;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.editor.impl.GriddedParameterListEditor;
import org.opensha.commons.param.editor.impl.ParameterListEditor;
import org.scec.vtk.commons.opensha.faults.anim.FaultAnimation;
import org.scec.vtk.commons.opensha.faults.colorers.AseismicityColorer;
import org.scec.vtk.commons.opensha.faults.colorers.CouplingCoefficientColorer;
import org.scec.vtk.commons.opensha.faults.colorers.DipColorer;
import org.scec.vtk.commons.opensha.faults.colorers.FaultColorer;
import org.scec.vtk.commons.opensha.faults.colorers.RakeColorer;
import org.scec.vtk.commons.opensha.faults.colorers.SlipRateColorer;
import org.scec.vtk.commons.opensha.faults.colorers.StrikeColorer;
import org.scec.vtk.commons.opensha.gui.ColorerPanel;
import org.scec.vtk.commons.opensha.gui.EventManager;
import org.scec.vtk.commons.opensha.gui.FaultTablePanel;
import org.scec.vtk.commons.opensha.gui.GeometryTypeSelectorPanel;
import org.scec.vtk.commons.opensha.gui.anim.MultiAnimPanel;
import org.scec.vtk.commons.opensha.surfaces.GeometryGenerator;
import org.scec.vtk.commons.opensha.surfaces.LineSurfaceGenerator;
import org.scec.vtk.commons.opensha.surfaces.PointSurfaceGenerator;
import org.scec.vtk.commons.opensha.surfaces.PolygonSurfaceGenerator;
import org.scec.vtk.commons.opensha.surfaces.pickBehavior.FaultSectionPickBehavior;
import org.scec.vtk.commons.opensha.tree.builders.FaultSectionInfoViewier;
import org.scec.vtk.commons.opensha.tree.builders.FaultTreeBuilder;
import org.scec.vtk.commons.opensha.tree.gui.FaultTreeTable;
import org.scec.vtk.plugins.opensha.AbstractFaultPlugin;
import org.scec.vtk.plugins.opensha.FaultPluginState;
import org.scec.vtk.tools.Prefs;

public class FaultPluginGUI
extends JSplitPane {
    private static final long serialVersionUID = 1L;
    private FaultTreeBuilder builder;
    private FaultTreeTable table;
    private ColorerPanel colorPanel;
    private MultiAnimPanel animPanel;
    private GeometryTypeSelectorPanel geomPanel;
    private GriddedParameterListEditor faultParamEditor;
    private FaultPluginState state;
    private JTabbedPane settingsPanel = new JTabbedPane();
    private EventManager em;
    private FaultSectionPickBehavior pickhandler;
    private JXLayer<JComponent> jxLayer;
    private LockableUI lockUI;

    public static ArrayList<GeometryGenerator> createDefaultGeomGens() {
        ArrayList<GeometryGenerator> geomGens = new ArrayList<GeometryGenerator>();
        geomGens.add(new LineSurfaceGenerator());
        geomGens.add(new PointSurfaceGenerator());
        geomGens.add(new PolygonSurfaceGenerator());
        return geomGens;
    }

    public static ArrayList<FaultColorer> createDefaultNonSlipColorers() {
        ArrayList<FaultColorer> colorers = new ArrayList<FaultColorer>();
        colorers.add(new StrikeColorer());
        colorers.add(new DipColorer());
        colorers.add(new RakeColorer());
        return colorers;
    }

    public static ArrayList<FaultColorer> createDefaultColorers() {
        ArrayList<FaultColorer> colorers = FaultPluginGUI.createDefaultNonSlipColorers();
        colorers.add(0, new SlipRateColorer());
        return colorers;
    }

    public static ArrayList<FaultColorer> createPrefDataColorers(boolean includeSlip) {
        ArrayList<FaultColorer> colorers = FaultPluginGUI.createDefaultNonSlipColorers();
        if (includeSlip) {
            colorers.add(0, new SlipRateColorer());
        }
        colorers.add(new AseismicityColorer());
        colorers.add(new CouplingCoefficientColorer());
        return colorers;
    }

    public FaultPluginGUI(AbstractFaultPlugin plugin, FaultTreeBuilder builder, ArrayList<FaultColorer> colorers, ArrayList<GeometryGenerator> geomGens, Color defaultColor) {
        this(plugin, builder, colorers, geomGens, defaultColor, null);
    }

    private static boolean hasAnimColorer(ArrayList<FaultAnimation> faultAnims) {
        for (FaultAnimation anim : faultAnims) {
            if (anim.getFaultColorer() == null) continue;
            return true;
        }
        return false;
    }

    public FaultPluginGUI(AbstractFaultPlugin plugin, FaultTreeBuilder builder, ArrayList<FaultColorer> colorers, ArrayList<GeometryGenerator> geomGens, Color defaultColor, ArrayList<FaultAnimation> faultAnims) {
        super(0);
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BoxLayout(topPanel, 1));
        this.lockUI = new LockableUI();
        this.jxLayer = new JXLayer((Component)this, (LayerUI)this.lockUI);
        FaultSectionInfoViewier infoViewer = builder instanceof FaultSectionInfoViewier ? (FaultSectionInfoViewier)((Object)builder) : null;
        this.builder = builder;
        this.table = new FaultTreeTable(builder, infoViewer);
        if (faultAnims != null && faultAnims.size() > 0 && FaultPluginGUI.hasAnimColorer(faultAnims)) {
            if (colorers == null) {
                colorers = new ArrayList();
            }
            for (FaultAnimation faultAnim : faultAnims) {
                FaultColorer animColorer = faultAnim.getFaultColorer();
                if (animColorer == null || colorers.contains(animColorer)) continue;
                colorers.add(animColorer);
            }
        }
        if (colorers != null && colorers.size() > 0) {
            this.colorPanel = new ColorerPanel(plugin, colorers, colorers.get(0));
        }
        this.geomPanel = new GeometryTypeSelectorPanel(geomGens);
        if (builder.getFaultParams() != null && builder.getFaultParams().size() > 0) {
            this.faultParamEditor = new GriddedParameterListEditor(builder.getFaultParams());
        }
        FaultTablePanel tablePanel = new FaultTablePanel((JTable)((Object)this.table));
        int tableHeight = 350;
        int minTableHeight = 100;
        int prefWidth = Prefs.getPluginWidth() - 20;
        ParameterList builderParams = builder.getBuilderParams();
        if (builderParams != null && !builderParams.isEmpty()) {
            ParameterListEditor builderEdit = new ParameterListEditor(builderParams);
            int paramHeight = Integer.min(builderParams.size() * 50, tableHeight - minTableHeight);
            tableHeight -= paramHeight;
            JScrollPane editScroll = new JScrollPane((Component)builderEdit, 20, 31);
            editScroll.setPreferredSize(new Dimension(prefWidth, paramHeight));
            editScroll.setMaximumSize(new Dimension(Integer.MAX_VALUE, paramHeight));
            topPanel.add((Component)builderEdit);
        }
        tablePanel.setPreferredSize(new Dimension(prefWidth, tableHeight));
        tablePanel.setMinimumSize(new Dimension(prefWidth, 50));
        this.table.setRowSelectionAllowed(true);
        this.table.setSelectionMode(2);
        topPanel.add(tablePanel);
        if (this.colorPanel != null) {
            this.settingsPanel.addTab("Color", null, this.wrapInScrollPane(this.colorPanel), "Fault color settings");
        }
        this.settingsPanel.addTab("Display Settings", null, this.wrapInScrollPane(this.geomPanel), "Fault display settings");
        if (this.faultParamEditor != null) {
            this.settingsPanel.addTab("Fault Settings", null, this.wrapInScrollPane((Component)this.faultParamEditor), "Fault geometry settings");
        }
        this.setTopComponent(topPanel);
        this.setBottomComponent(this.settingsPanel);
        this.pickhandler = new FaultSectionPickBehavior();
        for (GeometryGenerator geomGen : geomGens) {
            geomGen.setPickHandler(this.pickhandler);
        }
        this.em = new EventManager(plugin.getPluginActors(), this.table, this.colorPanel, this.geomPanel, builder.getFaultParams(), defaultColor, this.pickhandler, this.lockUI, this.pickhandler);
        if (faultAnims != null && faultAnims.size() > 0) {
            this.animPanel = new MultiAnimPanel(plugin, this.em, faultAnims, this.colorPanel);
            this.settingsPanel.addTab("Animation", null, this.wrapInScrollPane(this.animPanel), "Fault Animations");
        }
    }

    private JScrollPane wrapInScrollPane(Component view) {
        JScrollPane scroll = new JScrollPane(view, 20, 30);
        Dimension d = new Dimension(Prefs.getPluginWidth() - 20, 200);
        scroll.setPreferredSize(d);
        return scroll;
    }

    protected void addDistTab() {
        System.out.println("TODO: add dist tab");
    }

    protected void addTab(String title, JComponent comp) {
        if (!(comp instanceof JScrollPane)) {
            comp = this.wrapInScrollPane(comp);
        }
        this.settingsPanel.addTab(title, comp);
    }

    public EventManager getEventManager() {
        return this.em;
    }

    public JXLayer<JComponent> getJXLayer() {
        return this.jxLayer;
    }

    public GeometryTypeSelectorPanel getGeomSelect() {
        return this.geomPanel;
    }

    public FaultPluginState getState() {
        if (this.state == null) {
            this.state = new FaultPluginState(this);
        }
        return this.state;
    }

    FaultTreeBuilder getBuilder() {
        return this.builder;
    }

    FaultTreeTable getFaultTreeTable() {
        return this.table;
    }

    ColorerPanel getColorPanel() {
        return this.colorPanel;
    }

    MultiAnimPanel getAnimPanel() {
        return this.animPanel;
    }

    ParameterList getFaultParams() {
        if (this.faultParamEditor == null) {
            return null;
        }
        return this.faultParamEditor.getParameterList();
    }
}

