/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.plugins.opensha;

import com.google.common.base.Preconditions;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.dom4j.Element;
import org.opensha.commons.exceptions.ConstraintException;
import org.opensha.commons.exceptions.ParameterException;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.commons.util.XMLUtils;
import org.opensha.commons.util.cpt.CPT;
import org.scec.vtk.commons.opensha.faults.anim.FaultAnimation;
import org.scec.vtk.commons.opensha.faults.colorers.CPTBasedColorer;
import org.scec.vtk.commons.opensha.faults.colorers.FaultColorer;
import org.scec.vtk.commons.opensha.gui.anim.MultiAnimPanel;
import org.scec.vtk.commons.opensha.surfaces.GeometryGenerator;
import org.scec.vtk.commons.opensha.tree.FaultSectionNode;
import org.scec.vtk.plugins.PluginState;
import org.scec.vtk.plugins.opensha.FaultPluginGUI;

public class FaultPluginState
implements PluginState {
    private static final boolean D = false;
    private FaultPluginGUI gui;
    private ParameterList builderParams;
    private Map<Integer, Boolean> idToVisibleMap;
    private Map<Integer, Color> idToColorMap;
    private FaultColorer colorer;
    private ParameterList colorerParams;
    private CPT cpt;
    private boolean cptLog;
    private boolean legendVisibile;
    private FaultAnimation anim;
    private ParameterList animParams;
    private GeometryGenerator geomGen;
    private ParameterList geomGenParams;
    private ParameterList faultParams;
    private static final String BUILDER_PARAM_LIST_EL_NAME = "BuilderParams";
    private static final String FAULT_PARAM_LIST_EL_NAME = "FaultParams";
    private static final String GEOM_GEM_EL_NAME = "GeometryGenerator";
    private static final String GEOM_GEM_PARAM_LIST_EL_NAME = "GeometryGeneratorParams";
    private static final String ANIM_EL_NAME = "Animation";
    private static final String ANIM_PARAM_LIST_EL_NAME = "AnimationParams";
    private static final String COLORER_EL_NAME = "Colorer";
    private static final String COLORER_PARAM_LIST_EL_NAME = "ColorerParams";
    private static final String TREE_EL_NAME = "FaultTree";
    private static final String TREE_NODE_EL_NAME = "Node";

    public FaultPluginState(FaultPluginGUI gui) {
        this.gui = gui;
    }

    @Override
    public void load() {
        FaultPluginState.updateParams(this.gui.getBuilder().getBuilderParams(), this.builderParams);
        FaultPluginState.updateParams(this.gui.getFaultParams(), this.faultParams);
        if (this.geomGen != this.gui.getGeomSelect().getSelectedGeomGen()) {
            this.gui.getGeomSelect().setSelectedGeomGen(this.geomGen);
        }
        FaultPluginState.updateParams(this.gui.getGeomSelect().getSelectedGeomGen().getDisplayParams(), this.geomGenParams);
        if (this.anim != null && this.gui.getAnimPanel() != null) {
            if (this.anim != this.gui.getAnimPanel().getSelectedAnim()) {
                this.gui.getAnimPanel().setSelectedAnim(this.anim);
            }
            this.waitOnColorerChange();
            if (this.gui.getAnimPanel().getSelectedAnim() != null) {
                FaultPluginState.updateParams(this.gui.getAnimPanel().getSelectedAnim().getAnimationParameters(), this.animParams);
            }
            this.waitOnColorerChange();
        }
        if (this.gui.getColorPanel() != null) {
            if (this.colorer != this.gui.getColorPanel().getSelectedColorer()) {
                this.gui.getColorPanel().setSelectedColorer(this.colorer);
            }
            this.waitOnColorerChange();
            if (this.colorer != null) {
                CPTBasedColorer cptColor;
                FaultPluginState.updateParams(this.gui.getColorPanel().getSelectedColorer().getColorerParameters(), this.colorerParams);
                if (this.cpt != null && this.gui.getColorPanel().getSelectedColorer() instanceof CPTBasedColorer && (!this.cpt.equals((Object)(cptColor = (CPTBasedColorer)this.gui.getColorPanel().getSelectedColorer()).getCPT()) || this.cptLog != cptColor.isCPTLog())) {
                    this.waitOnColorerChange();
                    cptColor.setCPT(this.cpt, this.cptLog);
                    this.gui.getColorPanel().cptChangedExternally();
                }
                this.gui.getColorPanel().setLegendVisible(this.legendVisibile);
            }
        }
        this.waitOnColorerChange();
        if (this.updateTree(this.gui.getFaultTreeTable().getTreeRoot())) {
            this.gui.getFaultTreeTable().refreshTreeView();
        }
    }

    private void waitOnColorerChange() {
        try {
            this.gui.getEventManager().waitOnCalcThread();
        }
        catch (InterruptedException e) {
            ExceptionUtils.throwAsRuntimeException((Throwable)e);
        }
    }

    private static void updateParams(ParameterList to, ParameterList from) {
        if (to == null || from == null) {
            return;
        }
        for (Parameter fromParam : from) {
            try {
                Parameter toParam = to.getParameter(fromParam.getName());
                Object fromVal = fromParam.getValue();
                Object toVal = toParam.getValue();
                boolean equals = Objects.equals(fromVal, toVal);
                if (equals) continue;
                try {
                    toParam.setValue(fromParam.getValue());
                    toParam.getEditor().refreshParamEditor();
                }
                catch (ConstraintException e) {
                    System.err.println("WARNING: Couldn't set parameter '" + fromParam.getName() + "': " + e.getMessage());
                }
            }
            catch (ParameterException e) {
                System.err.println("WARNING: No parameter exists named " + fromParam.getName() + ", cannot fully restore state");
            }
        }
    }

    @Override
    public void toXML(Element stateEl) {
        this.captureState();
        if (this.builderParams != null && !this.builderParams.isEmpty()) {
            FaultPluginState.paramListToXML(stateEl, this.builderParams, BUILDER_PARAM_LIST_EL_NAME);
        }
        if (this.faultParams != null && !this.faultParams.isEmpty()) {
            FaultPluginState.paramListToXML(stateEl, this.faultParams, BUILDER_PARAM_LIST_EL_NAME);
        }
        Element geomGenEl = stateEl.addElement(GEOM_GEM_EL_NAME);
        geomGenEl.addAttribute("Name", this.geomGen.getName());
        if (this.geomGenParams != null) {
            FaultPluginState.paramListToXML(geomGenEl, this.geomGenParams, GEOM_GEM_PARAM_LIST_EL_NAME);
        }
        if (this.anim != null && this.gui.getAnimPanel() != null && this.gui.getAnimPanel().getSelectedAnim() != null) {
            Element animEl = stateEl.addElement(ANIM_EL_NAME);
            animEl.addAttribute("Name", this.anim.getName());
            if (this.animParams != null) {
                FaultPluginState.paramListToXML(animEl, this.animParams, ANIM_PARAM_LIST_EL_NAME);
            }
        }
        if (this.gui.getColorPanel() != null) {
            Element colorerEl = stateEl.addElement(COLORER_EL_NAME);
            if (this.colorer == null) {
                colorerEl.addAttribute("Name", "(custom)");
            } else {
                colorerEl.addAttribute("Name", this.colorer.getName());
                if (this.colorerParams != null) {
                    FaultPluginState.paramListToXML(colorerEl, this.colorerParams, COLORER_PARAM_LIST_EL_NAME);
                }
                if (this.cpt != null && this.gui.getColorPanel().getSelectedColorer() instanceof CPTBasedColorer) {
                    this.cpt.toXMLMetadata(colorerEl);
                    colorerEl.addAttribute("CPTLog", "" + this.cptLog);
                }
                colorerEl.addAttribute("LegendVisible", "" + this.legendVisibile);
            }
        }
        Element treeEl = stateEl.addElement(TREE_EL_NAME);
        for (Integer id : this.idToColorMap.keySet()) {
            Element nodeEl = treeEl.addElement(TREE_NODE_EL_NAME);
            nodeEl.addAttribute("ID", "" + id);
            Color color = this.idToColorMap.get(id);
            Boolean visible = this.idToVisibleMap.get(id);
            nodeEl.addAttribute("Color", "" + color.getRGB());
            nodeEl.addAttribute("Visible", visible.toString());
        }
    }

    private static void paramListToXML(Element rootEl, ParameterList paramList, String elName) {
        Element paramsEl = rootEl.addElement(elName);
        for (Parameter param : paramList) {
            param.toXMLMetadata(paramsEl);
        }
    }

    @Override
    public void fromXML(Element stateEl) {
        Element colorerEl;
        Element animEl;
        Element faultParamsEl;
        this.captureState();
        Element builderParamsEl = stateEl.element(BUILDER_PARAM_LIST_EL_NAME);
        if (builderParamsEl != null) {
            FaultPluginState.paramListFromXML(builderParamsEl, this.builderParams);
        }
        if ((faultParamsEl = stateEl.element(FAULT_PARAM_LIST_EL_NAME)) != null) {
            FaultPluginState.paramListFromXML(faultParamsEl, this.faultParams);
        }
        Element geomGenEl = stateEl.element(GEOM_GEM_EL_NAME);
        String geomGenName = geomGenEl.attributeValue("Name");
        for (GeometryGenerator geomGen : this.gui.getGeomSelect().getAllGeomGens()) {
            if (!geomGen.getName().equals(geomGenName)) continue;
            this.geomGen = geomGen;
            this.geomGenParams = FaultPluginState.cloneParamList(geomGen.getDisplayParams());
            Element geomGenParamsEl = geomGenEl.element(GEOM_GEM_PARAM_LIST_EL_NAME);
            if (geomGenParamsEl == null) break;
            FaultPluginState.paramListFromXML(geomGenParamsEl, this.geomGenParams);
            break;
        }
        if ((animEl = stateEl.element(ANIM_EL_NAME)) != null) {
            String animName = animEl.attributeValue("Name");
            MultiAnimPanel animPanel = this.gui.getAnimPanel();
            for (FaultAnimation anim : animPanel.getAnimations()) {
                if (!anim.getName().equals(animName)) continue;
                this.anim = anim;
                this.animParams = FaultPluginState.cloneParamList(anim.getAnimationParameters());
                Element animParamsEl = animEl.element(ANIM_PARAM_LIST_EL_NAME);
                if (animParamsEl == null) break;
                FaultPluginState.paramListFromXML(animParamsEl, this.animParams);
                break;
            }
        }
        if ((colorerEl = stateEl.element(COLORER_EL_NAME)) != null) {
            String colorerName = colorerEl.attributeValue("Name");
            if (colorerName.equals("(custom)")) {
                this.colorer = null;
            } else {
                for (FaultColorer colorer : this.gui.getColorPanel().getColorers()) {
                    Element cptEl;
                    if (!colorer.getName().equals(colorerName)) continue;
                    this.colorer = colorer;
                    this.colorerParams = FaultPluginState.cloneParamList(colorer.getColorerParameters());
                    Element colorerParamsEl = colorerEl.element(COLORER_PARAM_LIST_EL_NAME);
                    if (colorerParamsEl != null) {
                        FaultPluginState.paramListFromXML(colorerParamsEl, this.colorerParams);
                    }
                    if ((cptEl = colorerEl.element("CPT")) != null) {
                        Preconditions.checkState((boolean)(colorer instanceof CPTBasedColorer));
                        this.cpt = CPT.fromXMLMetadata((Element)cptEl);
                        this.cptLog = Boolean.parseBoolean(colorerEl.attributeValue("CPTLog"));
                    }
                    this.legendVisibile = Boolean.parseBoolean(colorerEl.attributeValue("LegendVisible"));
                    break;
                }
            }
        }
        Element treeEl = stateEl.element(TREE_EL_NAME);
        for (Element nodeEl : XMLUtils.getSubElementsList((Element)treeEl, (String)TREE_NODE_EL_NAME)) {
            Integer id = Integer.parseInt(nodeEl.attributeValue("ID"));
            int rgb = Integer.parseInt(nodeEl.attributeValue("Color"));
            Color color = new Color(rgb);
            Boolean visible = Boolean.parseBoolean(nodeEl.attributeValue("Visible"));
            this.idToColorMap.put(id, color);
            this.idToVisibleMap.put(id, visible);
        }
    }

    private static void paramListFromXML(Element paramListEl, ParameterList params) {
        boolean success = ParameterList.setParamsInListFromXML((ParameterList)params, (Element)paramListEl);
        if (!success) {
            System.err.println("Warning: failed to set one or more parameters from XML");
        }
    }

    private void clearState() {
        this.builderParams = null;
        this.idToVisibleMap = null;
        this.idToColorMap = null;
        this.colorer = null;
        this.colorerParams = null;
        this.cpt = null;
        this.anim = null;
        this.animParams = null;
        this.geomGen = null;
        this.geomGenParams = null;
        this.faultParams = null;
    }

    private void captureState() {
        this.clearState();
        this.builderParams = FaultPluginState.cloneParamList(this.gui.getBuilder().getBuilderParams());
        this.idToVisibleMap = new HashMap<Integer, Boolean>();
        this.idToColorMap = new HashMap<Integer, Color>();
        FaultPluginState.captureTree(this.gui.getFaultTreeTable().getTreeRoot(), this.idToVisibleMap, this.idToColorMap);
        if (this.gui.getColorPanel() != null) {
            this.colorer = this.gui.getColorPanel().getSelectedColorer();
            if (this.colorer != null) {
                this.colorerParams = FaultPluginState.cloneParamList(this.colorer.getColorerParameters());
                if (this.colorer instanceof CPTBasedColorer) {
                    this.cpt = ((CPTBasedColorer)this.colorer).getCPT();
                    if (this.cpt != null) {
                        this.cpt = (CPT)this.cpt.clone();
                    }
                    this.cptLog = ((CPTBasedColorer)this.colorer).isCPTLog();
                }
            }
            this.legendVisibile = this.gui.getColorPanel().isLegendVisible();
        }
        if (this.gui.getAnimPanel() != null) {
            this.anim = this.gui.getAnimPanel().getSelectedAnim();
            if (this.anim != null) {
                this.animParams = FaultPluginState.cloneParamList(this.anim.getAnimationParameters());
            }
        }
        this.geomGen = this.gui.getGeomSelect().getSelectedGeomGen();
        this.geomGenParams = FaultPluginState.cloneParamList(this.geomGen.getDisplayParams());
        this.faultParams = FaultPluginState.cloneParamList(this.gui.getFaultParams());
    }

    private static ParameterList cloneParamList(ParameterList params) {
        if (params == null) {
            return null;
        }
        return (ParameterList)params.clone();
    }

    private static void captureTree(DefaultMutableTreeNode node, Map<Integer, Boolean> visibilityMap, Map<Integer, Color> colorMap) {
        if (node instanceof FaultSectionNode) {
            FaultSectionNode faultNode = (FaultSectionNode)node;
            Integer id = faultNode.getFault().getId();
            Preconditions.checkState((!visibilityMap.containsKey(id) ? 1 : 0) != 0, (Object)("Duplicate ID entry in tree: " + id));
            visibilityMap.put(id, faultNode.isVisible());
            colorMap.put(id, faultNode.getColor());
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            TreeNode child = node.getChildAt(i);
            if (!(child instanceof DefaultMutableTreeNode)) continue;
            FaultPluginState.captureTree((DefaultMutableTreeNode)child, visibilityMap, colorMap);
        }
    }

    private boolean updateTree(DefaultMutableTreeNode node) {
        FaultSectionNode faultNode;
        Integer id;
        boolean changed = false;
        if (node instanceof FaultSectionNode && this.idToColorMap.containsKey(id = Integer.valueOf((faultNode = (FaultSectionNode)node).getFault().getId()))) {
            Color color = this.idToColorMap.get(id);
            boolean visible = this.idToVisibleMap.get(id);
            if (!Objects.equals(color, faultNode.getColor())) {
                changed = true;
                faultNode.setColor(color);
            }
            if (visible != faultNode.isVisible()) {
                changed = true;
                faultNode.setVisible(visible);
            }
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            TreeNode child = node.getChildAt(i);
            if (!(child instanceof DefaultMutableTreeNode)) continue;
            changed = this.updateTree((DefaultMutableTreeNode)child) || changed;
        }
        return changed;
    }

    @Override
    public FaultPluginState deepCopy() {
        FaultPluginState o = new FaultPluginState(this.gui);
        this.captureState();
        o.builderParams = this.builderParams;
        o.idToVisibleMap = this.idToVisibleMap;
        o.idToColorMap = this.idToColorMap;
        o.colorer = this.colorer;
        o.colorerParams = this.colorerParams;
        o.cpt = this.cpt;
        o.cptLog = this.cptLog;
        o.legendVisibile = this.legendVisibile;
        o.anim = this.anim;
        o.animParams = this.animParams;
        o.geomGen = this.geomGen;
        o.geomGenParams = this.geomGenParams;
        o.faultParams = this.faultParams;
        return o;
    }
}

