/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.plugins.opensha.faultModels;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import org.opensha.commons.data.NamedComparator;
import org.opensha.refFaultParamDb.dao.db.DB_AccessAPI;
import org.opensha.refFaultParamDb.dao.db.FaultModelDB_DAO;
import org.opensha.refFaultParamDb.dao.db.FaultModelSummaryDB_DAO;
import org.opensha.refFaultParamDb.dao.db.PrefFaultSectionDataDB_DAO;
import org.opensha.refFaultParamDb.vo.FaultModelSummary;
import org.opensha.refFaultParamDb.vo.FaultSectionPrefData;
import org.opensha.sha.faultSurface.FaultSection;
import org.scec.vtk.commons.opensha.faults.faultSectionImpl.PrefDataSection;
import org.scec.vtk.commons.opensha.tree.FaultCategoryNode;
import org.scec.vtk.commons.opensha.tree.FaultSectionNode;
import org.scec.vtk.commons.opensha.tree.builders.MultiDBBuilder;
import scratch.UCERF3.enumTreeBranches.FaultModels;

public class FaultModelBuilder
extends MultiDBBuilder {
    public FaultModelBuilder() {
    }

    public FaultModelBuilder(MultiDBBuilder.DB_Source defaultDB) {
        super(defaultDB);
    }

    @Override
    public void buildTree(DefaultMutableTreeNode root) {
        DB_AccessAPI db = this.getSelectedDB();
        if (db == null) {
            HashSet common = null;
            FaultModels[] fms = new FaultModels[]{FaultModels.FM3_1, FaultModels.FM3_2};
            ArrayList<List> sectsList = new ArrayList<List>();
            for (FaultModels fm : fms) {
                List sects = fm.getFaultSections();
                ArrayList<Integer> ids = new ArrayList<Integer>();
                for (FaultSection sect : sects) {
                    ids.add(sect.getSectionId());
                }
                if (common == null) {
                    common = new HashSet(ids);
                } else {
                    common.retainAll(ids);
                }
                sectsList.add(sects);
            }
            for (int f = 0; f < fms.length; ++f) {
                Object sect2;
                FaultModels fm = fms[f];
                List sects = (List)sectsList.get(f);
                Object addIntStr = "";
                for (char c : fm.name().toCharArray()) {
                    if (!Character.isDigit(c)) continue;
                    addIntStr = (String)addIntStr + c;
                }
                addIntStr = (String)addIntStr + "000000";
                int idAdd = Integer.parseInt((String)addIntStr);
                FaultCategoryNode fmNode = new FaultCategoryNode(fm.getName());
                ArrayList<FaultSectionNode> commonNodes = new ArrayList<FaultSectionNode>();
                ArrayList<FaultSectionNode> uniqueNodes = new ArrayList<FaultSectionNode>();
                for (Object sect2 : sects) {
                    int origID = sect2.getSectionId();
                    sect2.setSectionId(origID + idAdd);
                    PrefDataSection fault = new PrefDataSection((FaultSection)sect2);
                    FaultSectionNode faultNode = new FaultSectionNode(fault);
                    if (common.contains(origID)) {
                        commonNodes.add(faultNode);
                        continue;
                    }
                    uniqueNodes.add(faultNode);
                }
                Collections.sort(commonNodes, new NamedComparator());
                Collections.sort(uniqueNodes, new NamedComparator());
                FaultCategoryNode uniqueNode = new FaultCategoryNode("Unique to this model");
                sect2 = uniqueNodes.iterator();
                while (sect2.hasNext()) {
                    FaultSectionNode faultNode = (FaultSectionNode)sect2.next();
                    uniqueNode.add(faultNode);
                }
                FaultCategoryNode commonNode = new FaultCategoryNode("Common other models");
                for (FaultSectionNode faultNode : commonNodes) {
                    commonNode.add(faultNode);
                }
                fmNode.add(uniqueNode);
                fmNode.add(commonNode);
                root.add(fmNode);
            }
        } else {
            FaultModelSummaryDB_DAO faultModelSummaryDB_DAO = new FaultModelSummaryDB_DAO(db);
            FaultModelDB_DAO faultModelDB_DAO = new FaultModelDB_DAO(db);
            PrefFaultSectionDataDB_DAO faultSectionDB_DAO = new PrefFaultSectionDataDB_DAO(db);
            faultSectionDB_DAO.getAllFaultSectionPrefData();
            ArrayList summaries = faultModelSummaryDB_DAO.getAllFaultModels();
            ArrayList<ArrayList> sectionsList = new ArrayList<ArrayList>();
            for (FaultModelSummary fm : summaries) {
                sectionsList.add(faultModelDB_DAO.getFaultSectionIdList(fm.getFaultModelId()));
            }
            for (int i = 0; i < summaries.size(); ++i) {
                Object commonNode;
                FaultModelSummary fm;
                fm = (FaultModelSummary)summaries.get(i);
                ArrayList sections = (ArrayList)sectionsList.get(i);
                ArrayList<Integer> common = new ArrayList<Integer>();
                ArrayList unique = (ArrayList)sections.clone();
                for (int j = 0; j < summaries.size(); ++j) {
                    if (i == j) continue;
                    ArrayList otherSections = (ArrayList)sectionsList.get(j);
                    commonNode = otherSections.iterator();
                    while (commonNode.hasNext()) {
                        int otherID = (Integer)commonNode.next();
                        if (!sections.contains(otherID) || common.contains(otherID)) continue;
                        common.add(otherID);
                        unique.remove((Object)otherID);
                    }
                }
                FaultCategoryNode fmNode = new FaultCategoryNode(fm.getFaultModelName() + " (" + fm.getFaultModelId() + ")");
                FaultCategoryNode uniqueNode = new FaultCategoryNode("Unique to this model");
                FaultModelBuilder.addAll(uniqueNode, unique, faultSectionDB_DAO);
                fmNode.add(uniqueNode);
                commonNode = new FaultCategoryNode("Common other models");
                common.removeAll(unique);
                FaultModelBuilder.addAll((FaultCategoryNode)commonNode, common, faultSectionDB_DAO);
                fmNode.add((MutableTreeNode)commonNode);
                root.add(fmNode);
            }
        }
    }

    private static void addAll(FaultCategoryNode fmNode, List<Integer> secIDs, PrefFaultSectionDataDB_DAO faultSectionDB_DAO) {
        ArrayList<FaultSectionNode> faultNodes = new ArrayList<FaultSectionNode>();
        for (int secID : secIDs) {
            FaultSectionPrefData prefData = faultSectionDB_DAO.getFaultSectionPrefData(secID);
            PrefDataSection fault = new PrefDataSection((FaultSection)prefData);
            FaultSectionNode faultNode = new FaultSectionNode(fault);
            faultNodes.add(faultNode);
        }
        Collections.sort(faultNodes, new NamedComparator());
        for (FaultSectionNode faultNode : faultNodes) {
            fmNode.add(faultNode);
        }
    }
}

