/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.plugins.opensha.nshm;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.impl.FileParameter;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.GeoJSONFaultReader;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.faultSurface.GeoJSONFaultSection;
import org.scec.vtk.commons.opensha.faults.faultSectionImpl.PrefDataSection;
import org.scec.vtk.commons.opensha.tree.FaultCategoryNode;
import org.scec.vtk.commons.opensha.tree.FaultSectionNode;
import org.scec.vtk.commons.opensha.tree.builders.FaultTreeBuilder;
import org.scec.vtk.commons.opensha.tree.events.TreeChangeListener;

public class GeoJSONFaultBuilder
implements FaultTreeBuilder,
ParameterChangeListener {
    private FileParameter loadParam;
    private FileParameter slipRatesParam;
    private ParameterList params;
    private ParameterList faultParams = PrefDataSection.createPrefDataParams();
    private TreeChangeListener l;
    private List<GeoJSONFaultSection> sects;

    public GeoJSONFaultBuilder() {
        this.params = new ParameterList();
        this.loadParam = new FileParameter("Load Fault Sections GeoJSON");
        this.loadParam.addParameterChangeListener((ParameterChangeListener)this);
        this.params.addParameter((Parameter)this.loadParam);
        this.slipRatesParam = new FileParameter("Load/Map (Kludgy) Slip Rates GeoDB");
        this.slipRatesParam.addParameterChangeListener((ParameterChangeListener)this);
        this.params.addParameter((Parameter)this.slipRatesParam);
    }

    @Override
    public ParameterList getBuilderParams() {
        return this.params;
    }

    @Override
    public ParameterList getFaultParams() {
        return this.faultParams;
    }

    @Override
    public void setTreeChangeListener(TreeChangeListener l) {
        this.l = l;
    }

    @Override
    public void buildTree(DefaultMutableTreeNode root) {
        if (this.sects == null || this.sects.isEmpty()) {
            return;
        }
        boolean hasStates = false;
        for (GeoJSONFaultSection sect : this.sects) {
            if (sect.getProperty("State") == null && sect.getProperty("PrimState") == null) continue;
            hasStates = true;
            break;
        }
        if (hasStates) {
            ArrayList<String> states = new ArrayList<String>();
            String defaultState = "Other";
            HashMap statesMap = new HashMap();
            for (GeoJSONFaultSection sect : this.sects) {
                String state = (String)sect.getProperty("State", null);
                if (state == null || state.isBlank()) {
                    state = (String)sect.getProperty("PrimState", null);
                }
                if (state == null || state.isBlank()) {
                    state = defaultState;
                }
                if (statesMap.containsKey(state)) {
                    ((List)statesMap.get(state)).add(sect);
                    continue;
                }
                if (!state.equals(defaultState)) {
                    states.add(state);
                }
                ArrayList<GeoJSONFaultSection> sects = new ArrayList<GeoJSONFaultSection>();
                sects.add(sect);
                statesMap.put(state, sects);
            }
            Collections.sort(states);
            if (statesMap.containsKey(defaultState)) {
                states.add(defaultState);
            }
            for (String state : states) {
                FaultCategoryNode stateNode = new FaultCategoryNode(state);
                for (FaultSection sect : (List)statesMap.get(state)) {
                    PrefDataSection fault = new PrefDataSection(sect);
                    FaultSectionNode faultNode = new FaultSectionNode(fault);
                    stateNode.add(faultNode);
                }
                root.add(stateNode);
            }
        } else {
            for (GeoJSONFaultSection sect : this.sects) {
                PrefDataSection fault = new PrefDataSection((FaultSection)sect);
                FaultSectionNode faultNode = new FaultSectionNode(fault);
                root.add(faultNode);
            }
        }
    }

    public void parameterChange(ParameterChangeEvent e) {
        if (e.getParameter() == this.loadParam) {
            this.sects = null;
            File sectsFile = (File)this.loadParam.getValue();
            System.out.println("Loading fault sections from: " + sectsFile.getAbsolutePath());
            try {
                this.sects = GeoJSONFaultReader.readFaultSections((File)sectsFile);
            }
            catch (IOException e1) {
                throw ExceptionUtils.asRuntimeException((Throwable)e1);
            }
            if (this.slipRatesParam.getValue() != null) {
                this.slipRatesParam.removeParameterChangeListener((ParameterChangeListener)this);
                this.slipRatesParam.setValue(null);
                this.slipRatesParam.getEditor().refreshParamEditor();
                this.slipRatesParam.addParameterChangeListener((ParameterChangeListener)this);
            }
        } else if (e.getParameter() == this.slipRatesParam) {
            File slipRateFile = (File)this.slipRatesParam.getValue();
            if (this.sects != null && slipRateFile != null) {
                System.out.println("Loading slip rate data from: " + slipRateFile.getAbsolutePath());
                try {
                    Map slipRates = GeoJSONFaultReader.readGeoDB((File)slipRateFile);
                    GeoJSONFaultReader.testMapSlipRates(this.sects, (Map)slipRates, (Double)Double.NaN, null);
                }
                catch (IOException e1) {
                    throw ExceptionUtils.asRuntimeException((Throwable)e1);
                }
            }
        }
        this.l.treeChanged(null);
    }
}

