/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.plugins.opensha.obsEqkRup;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.impl.DoubleParameter;
import org.opensha.commons.param.impl.IntegerParameter;
import org.opensha.sha.earthquake.observedEarthquake.ObsEqkRupList;
import org.opensha.sha.earthquake.observedEarthquake.ObsEqkRupture;
import org.scec.vtk.commons.opensha.faults.AbstractFaultSection;
import org.scec.vtk.commons.opensha.faults.anim.TimeBasedFaultAnimation;
import org.scec.vtk.commons.opensha.faults.colorers.FaultColorer;
import org.scec.vtk.commons.opensha.faults.faultSectionImpl.ObsEqkRupSection;
import org.scec.vtk.plugins.opensha.obsEqkRup.ObsEqkRupGeometryGenerator;

public class ObsEqkRupAnim
implements TimeBasedFaultAnimation,
ParameterChangeListener {
    private ObsEqkRupGeometryGenerator geomGen;
    private ObsEqkRupList rups;
    private int step;
    private static DateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");
    private static final String MIN_YEAR_PARAM_NAME = "Min Year";
    private static final int MIN_YEAR_DEFAULT = 0;
    private IntegerParameter minYearParam;
    private static final String MAX_YEAR_PARAM_NAME = "Max Year";
    private static final int MAX_YEAR_DEFAULT = 3000;
    private IntegerParameter maxYearParam;
    private static final String MIN_MAG_PARAM_NAME = "Min Mag";
    private static final double MIN_MAG_DEFAULT = 0.0;
    private DoubleParameter minMagParam;
    private long minYearMillis;
    private long maxYearMillis;
    private int rupsBeforeMinYear = 0;
    private ParameterList animParams;
    private ArrayList<ChangeListener> listeners = new ArrayList();

    public ObsEqkRupAnim(ObsEqkRupGeometryGenerator geomGen) {
        this.geomGen = geomGen;
        this.animParams = new ParameterList();
        this.minYearParam = new IntegerParameter(MIN_YEAR_PARAM_NAME, 0, 3000);
        this.minYearParam.setDefaultValue((Object)0);
        this.minYearParam.setValueAsDefault();
        this.minYearParam.addParameterChangeListener((ParameterChangeListener)this);
        this.animParams.addParameter((Parameter)this.minYearParam);
        this.maxYearParam = new IntegerParameter(MAX_YEAR_PARAM_NAME, 0, 3000);
        this.maxYearParam.setDefaultValue((Object)3000);
        this.maxYearParam.setValueAsDefault();
        this.maxYearParam.addParameterChangeListener((ParameterChangeListener)this);
        this.animParams.addParameter((Parameter)this.maxYearParam);
        this.minMagParam = new DoubleParameter(MIN_MAG_PARAM_NAME, 0.0, 10.0);
        this.minMagParam.setDefaultValue((Object)0.0);
        this.minMagParam.setValueAsDefault();
        this.minMagParam.addParameterChangeListener((ParameterChangeListener)this);
        this.animParams.addParameter((Parameter)this.minMagParam);
        this.updateMinMaxYearMillis();
    }

    public void setRups(ObsEqkRupList rups) {
        this.rups = rups;
        this.updateMinMaxYearMillis();
        this.fireRangeChangeEvent();
    }

    @Override
    public void addRangeChangeListener(ChangeListener l) {
        this.listeners.add(l);
    }

    @Override
    public int getNumSteps() {
        if (this.geomGen == null || this.rups == null) {
            return 0;
        }
        this.rupsBeforeMinYear = 0;
        int rupsAfterMinYear = 0;
        for (int i = 0; i < this.rups.size(); ++i) {
            if (((ObsEqkRupture)this.rups.get(i)).getOriginTime() < this.minYearMillis) {
                ++this.rupsBeforeMinYear;
            }
            if (((ObsEqkRupture)this.rups.get(i)).getOriginTime() <= this.maxYearMillis) continue;
            ++rupsAfterMinYear;
        }
        int steps = this.rups.size() - this.rupsBeforeMinYear - rupsAfterMinYear;
        return steps < 0 ? 0 : steps;
    }

    @Override
    public int getPreferredInitialStep() {
        int num = this.getNumSteps();
        if (num <= 0) {
            return 0;
        }
        return num - 1;
    }

    @Override
    public void setCurrentStep(int step) {
        this.step = step;
    }

    @Override
    public boolean includeStepInLabel() {
        return true;
    }

    @Override
    public String getCurrentLabel() {
        long milis = this.getMilisForStep(this.step);
        return df.format(new Date(milis));
    }

    @Override
    public ParameterList getAnimationParameters() {
        return this.animParams;
    }

    @Override
    public Boolean getFaultVisibility(AbstractFaultSection fault) {
        if (this.step <= 0) {
            return null;
        }
        if (fault instanceof ObsEqkRupSection) {
            return this.shouldBeVisible(((ObsEqkRupSection)fault).getRup());
        }
        return null;
    }

    private boolean shouldBeVisible(ObsEqkRupture rup) {
        long milis = rup.getOriginTime();
        return milis <= this.getMilisForStep(this.step) && milis >= this.minYearMillis && milis <= this.maxYearMillis && rup.getMag() >= (Double)this.minMagParam.getValue();
    }

    @Override
    public FaultColorer getFaultColorer() {
        return null;
    }

    @Override
    public void fireRangeChangeEvent() {
        if (this.listeners.isEmpty()) {
            return;
        }
        ChangeEvent e = new ChangeEvent(this);
        for (ChangeListener l : this.listeners) {
            l.stateChanged(e);
        }
    }

    public String getName() {
        return "Animation!";
    }

    @Override
    public double getTimeForStep(int step) {
        long firstMilis = this.getMilisForStep(0);
        return (double)(this.getMilisForStep(step) - firstMilis) / 1000.0;
    }

    private ObsEqkRupture getRupForStep(int step) {
        return (ObsEqkRupture)this.rups.get(step + this.rupsBeforeMinYear);
    }

    public long getMilisForStep(int step) {
        if (this.rups == null || this.rups.isEmpty()) {
            return 0L;
        }
        return this.getRupForStep(step).getOriginTime();
    }

    public void parameterChange(ParameterChangeEvent event) {
        if (event.getParameter() == this.minYearParam || event.getParameter() == this.maxYearParam) {
            this.updateMinMaxYearMillis();
            this.fireRangeChangeEvent();
        }
    }

    private void updateMinMaxYearMillis() {
        GregorianCalendar minCal = new GregorianCalendar((Integer)this.minYearParam.getValue(), 0, 0);
        GregorianCalendar maxCal = new GregorianCalendar((Integer)this.maxYearParam.getValue(), 11, 31);
        this.minYearMillis = minCal.getTimeInMillis();
        if (this.rups != null) {
            for (int i = 0; i < this.rups.size(); ++i) {
                if (((ObsEqkRupture)this.rups.get(i)).getOriginTime() < this.minYearMillis) continue;
                this.minYearMillis = ((ObsEqkRupture)this.rups.get(i)).getOriginTime();
                break;
            }
        }
        this.maxYearMillis = maxCal.getTimeInMillis();
    }

    @Override
    public double getCurrentDuration() {
        if (this.getNumSteps() > 0) {
            return this.getTimeForStep(this.getNumSteps() - 1) - this.getTimeForStep(0);
        }
        return 0.0;
    }

    @Override
    public boolean timeChanged(double time) {
        return false;
    }
}

