/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.plugins.opensha.obsEqkRup;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EnumSet;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;
import org.dom4j.DocumentException;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.impl.BooleanParameter;
import org.opensha.commons.param.impl.EnumParameter;
import org.opensha.commons.param.impl.FileParameter;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.observedEarthquake.ObsEqkRupList;
import org.opensha.sha.earthquake.observedEarthquake.ObsEqkRupture;
import org.opensha.sha.earthquake.observedEarthquake.parsers.UCERF3_CatalogParser;
import org.opensha.sha.faultSurface.PointSurface;
import org.scec.vtk.commons.opensha.faults.faultSectionImpl.ObsEqkRupSection;
import org.scec.vtk.commons.opensha.tree.FaultCategoryNode;
import org.scec.vtk.commons.opensha.tree.FaultSectionNode;
import org.scec.vtk.commons.opensha.tree.builders.FaultTreeBuilder;
import org.scec.vtk.commons.opensha.tree.events.TreeChangeListener;
import org.scec.vtk.plugins.opensha.obsEqkRup.ObsEqkRupAnim;
import scratch.UCERF3.enumTreeBranches.FaultModels;
import scratch.UCERF3.erf.ETAS.association.FiniteFaultMappingData;
import scratch.UCERF3.inversion.InversionFaultSystemRupSet;

public class ObsEqkRupBuilder
implements FaultTreeBuilder,
ParameterChangeListener {
    private FileParameter catalogFileParam;
    private FileParameter finiteSurfsFileParam;
    private FileParameter rupSetFileParam;
    private BooleanParameter finiteOnlyParam;
    private FaultModels fm;
    private FaultSystemRupSet rupSet;
    private TreeChangeListener l;
    private ParameterList params;
    private ObsEqkRupAnim anim;
    private static SimpleDateFormat df = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss z");
    private static DecimalFormat magDF = new DecimalFormat("0.##");

    public ObsEqkRupBuilder(ObsEqkRupAnim anim) {
        this.anim = anim;
        this.params = new ParameterList();
        this.catalogFileParam = new FileParameter("Catalog File");
        this.catalogFileParam.addParameterChangeListener((ParameterChangeListener)this);
        this.params.addParameter((Parameter)this.catalogFileParam);
        this.finiteSurfsFileParam = new FileParameter("Finite Surfaces XML File");
        this.finiteSurfsFileParam.addParameterChangeListener((ParameterChangeListener)this);
        this.params.addParameter((Parameter)this.finiteSurfsFileParam);
        this.rupSetFileParam = new FileParameter("Rupture Set File");
        this.rupSetFileParam.addParameterChangeListener((ParameterChangeListener)this);
        this.params.addParameter((Parameter)this.rupSetFileParam);
        this.finiteOnlyParam = new BooleanParameter("Finite Surface Ruptures Only", Boolean.valueOf(false));
        this.finiteOnlyParam.addParameterChangeListener((ParameterChangeListener)this);
        this.params.addParameter((Parameter)this.finiteOnlyParam);
        File kevinGitDir = new File("/home/kevin/git/ucerf3-etas-launcher/inputs");
        if (kevinGitDir.exists()) {
            this.catalogFileParam.setDefaultInitialDir(kevinGitDir);
            this.finiteSurfsFileParam.setDefaultInitialDir(kevinGitDir);
            this.rupSetFileParam.setDefaultInitialDir(kevinGitDir);
        }
    }

    @Override
    public ParameterList getBuilderParams() {
        return this.params;
    }

    @Override
    public ParameterList getFaultParams() {
        return null;
    }

    @Override
    public void setTreeChangeListener(TreeChangeListener l) {
        this.l = l;
    }

    @Override
    public void buildTree(DefaultMutableTreeNode root) {
        ObsEqkRupList rups;
        File catalogFile = (File)this.catalogFileParam.getValue();
        if (catalogFile == null) {
            return;
        }
        File finiteSurfsFile = (File)this.finiteSurfsFileParam.getValue();
        try {
            rups = UCERF3_CatalogParser.loadCatalog((File)catalogFile);
        }
        catch (IOException e) {
            throw ExceptionUtils.asRuntimeException((Throwable)e);
        }
        int cnt = 0;
        FaultCategoryNode pointSourcesNode = null;
        if (!((Boolean)this.finiteOnlyParam.getValue()).booleanValue()) {
            pointSourcesNode = new FaultCategoryNode("Point Sources");
            root.add(pointSourcesNode);
        }
        FaultCategoryNode finiteSourcesNode = null;
        if (finiteSurfsFile != null && this.rupSet != null) {
            System.out.println("Loading finite sources");
            try {
                FiniteFaultMappingData.loadRuptureSurfaces((File)finiteSurfsFile, (ObsEqkRupList)rups, (FaultModels)this.fm, (FaultSystemRupSet)this.rupSet);
            }
            catch (MalformedURLException | DocumentException e) {
                throw ExceptionUtils.asRuntimeException((Throwable)e);
            }
            finiteSourcesNode = new FaultCategoryNode("Finite Sources");
            root.add(finiteSourcesNode);
        }
        ObsEqkRupList displayRups = new ObsEqkRupList();
        for (ObsEqkRupture rup : rups) {
            String name = rup.getEventId() + ": M" + magDF.format(rup.getMag()) + ", " + df.format(new Date(rup.getOriginTime()));
            if (rup.getRuptureSurface() == null || rup.getRuptureSurface() instanceof PointSurface) {
                if (pointSourcesNode == null) continue;
                pointSourcesNode.add(new FaultSectionNode(new ObsEqkRupSection(name, cnt++, rup)));
            } else {
                Preconditions.checkNotNull((Object)finiteSourcesNode);
                finiteSourcesNode.add(new FaultSectionNode(new ObsEqkRupSection(name, cnt++, rup)));
            }
            displayRups.add((Object)rup);
        }
        this.anim.setRups(displayRups);
    }

    public void parameterChange(ParameterChangeEvent e) {
        if (e.getParameter() == this.catalogFileParam) {
            this.l.treeChanged(null);
            this.rupSetFileParam.setDefaultInitialDir(((File)this.catalogFileParam.getValue()).getParentFile());
            this.finiteSurfsFileParam.setDefaultInitialDir(((File)this.catalogFileParam.getValue()).getParentFile());
        } else if (e.getParameter() == this.finiteSurfsFileParam) {
            if (this.rupSetFileParam.getValue() == null) {
                this.rupSetFileParam.setDefaultInitialDir(((File)this.finiteSurfsFileParam.getValue()).getParentFile());
                JOptionPane.showMessageDialog(null, "Must Load Rupture Set zip file before finite surfaces can be loaded", "Load RupSet File Next", 1);
            } else {
                this.l.treeChanged(null);
            }
        } else if (e.getParameter() == this.rupSetFileParam) {
            File rupSetFile = (File)this.rupSetFileParam.getValue();
            try {
                this.rupSet = FaultSystemRupSet.load((File)rupSetFile);
                if (this.rupSet instanceof InversionFaultSystemRupSet) {
                    this.fm = ((InversionFaultSystemRupSet)this.rupSet).getFaultModel();
                } else {
                    this.fm = null;
                    for (FaultModels fm : FaultModels.values()) {
                        if (!rupSetFile.getName().contains(fm.encodeChoiceString())) continue;
                        this.fm = fm;
                    }
                    if (this.fm == null) {
                        EnumParameter fmParam = new EnumParameter("Fault Model", EnumSet.allOf(FaultModels.class), (Enum)FaultModels.FM3_1, null);
                        JOptionPane.showMessageDialog(null, fmParam.getEditor(), "Select Fault Model", 3);
                        this.fm = (FaultModels)fmParam.getValue();
                    } else {
                        System.out.println("Detected Fault Model: " + this.fm.getShortName());
                    }
                }
            }
            catch (IOException e1) {
                throw ExceptionUtils.asRuntimeException((Throwable)e1);
            }
            if (this.finiteSurfsFileParam.getValue() != null) {
                this.l.treeChanged(null);
            } else {
                this.finiteSurfsFileParam.setDefaultInitialDir(rupSetFile.getParentFile());
            }
        } else if (e.getParameter() == this.finiteOnlyParam) {
            this.l.treeChanged(null);
        }
    }

    public static FaultModels detectFM(FaultSystemRupSet rupSet, File rupSetFile) {
        if (rupSet instanceof InversionFaultSystemRupSet) {
            return ((InversionFaultSystemRupSet)rupSet).getFaultModel();
        }
        if (rupSetFile != null) {
            for (FaultModels fm : FaultModels.values()) {
                if (!rupSetFile.getName().contains(fm.encodeChoiceString())) continue;
                return fm;
            }
        }
        if (rupSet.getNumRuptures() == 253706) {
            return FaultModels.FM3_1;
        }
        if (rupSet.getNumRuptures() == 305709) {
            return FaultModels.FM3_2;
        }
        EnumParameter fmParam = new EnumParameter("Fault Model", EnumSet.allOf(FaultModels.class), (Enum)FaultModels.FM3_1, null);
        JOptionPane.showMessageDialog(null, fmParam.getEditor(), "Select Fault Model", 3);
        return (FaultModels)fmParam.getValue();
    }
}

