/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.plugins.opensha.obsEqkRup;

import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.impl.StringParameter;
import org.opensha.sha.faultSurface.PointSurface;
import org.opensha.sha.faultSurface.Surface3D;
import org.scec.vtk.commons.opensha.faults.AbstractFaultSection;
import org.scec.vtk.commons.opensha.surfaces.FaultSectionActorList;
import org.scec.vtk.commons.opensha.surfaces.GeometryGenerator;
import org.scec.vtk.commons.opensha.surfaces.PointSurfaceGenerator;
import org.scec.vtk.plugins.opensha.obsEqkRup.RenamedParameterWrapper;

public class ObsEqkRupGeometryGenerator
extends GeometryGenerator
implements ParameterChangeListener {
    private StringParameter finiteFaultGeomGenSelect;
    private Map<String, GeometryGenerator> finiteGeomGens;
    private GeometryGenerator finiteGeomGen;
    private PointSurfaceGenerator pointGeomGen;
    private ParameterList paramList;

    public ObsEqkRupGeometryGenerator() {
        super("Observed EQ Geometry Gen");
        ArrayList<String> geomNames = new ArrayList<String>();
        this.finiteGeomGens = new HashMap<String, GeometryGenerator>();
        PointSurfaceGenerator pointGen = new PointSurfaceGenerator();
        geomNames.add(pointGen.getName());
        this.finiteGeomGens.put(pointGen.getName(), pointGen);
        this.finiteFaultGeomGenSelect = new StringParameter("Geometry for Finite Ruptures", geomNames);
        this.finiteFaultGeomGenSelect.setValue((Object)pointGen.getName());
        this.finiteGeomGen = pointGen;
        this.finiteFaultGeomGenSelect.addParameterChangeListener((ParameterChangeListener)this);
        this.paramList = new ParameterList();
        if (geomNames.size() > 1) {
            this.paramList.addParameter((Parameter)this.finiteFaultGeomGenSelect);
        }
        this.pointGeomGen = new PointSurfaceGenerator();
        Object pointSizeParam = this.pointGeomGen.getDisplayParams().getParameter("Point Size");
        pointSizeParam = new RenamedParameterWrapper(pointSizeParam, "Point Surf " + pointSizeParam.getName());
        this.paramList.addParameter(pointSizeParam);
        pointSizeParam.addParameterChangeListener((ParameterChangeListener)this);
        for (GeometryGenerator geomGen : this.finiteGeomGens.values()) {
            geomGen.setBundlerEneabled(false);
            ParameterList params = geomGen.getDisplayParams();
            if (params == null) continue;
            for (Object param : params) {
                param = new RenamedParameterWrapper(param, "Finite Surf " + geomGen.getName() + ": " + param.getName());
                param.addParameterChangeListener((ParameterChangeListener)this);
                this.paramList.addParameter(param);
                if (geomGen == this.finiteGeomGen) continue;
                param.getEditor().setVisible(false);
            }
        }
    }

    @Override
    public FaultSectionActorList createFaultActors(Surface3D surface, Color color, AbstractFaultSection fault) {
        if (surface instanceof PointSurface) {
            return this.pointGeomGen.createFaultActors(surface, color, fault);
        }
        return this.finiteGeomGen.createFaultActors(surface, color, fault);
    }

    @Override
    public ParameterList getDisplayParams() {
        return this.paramList;
    }

    public void parameterChange(ParameterChangeEvent e) {
        if (e.getParameter() == this.finiteFaultGeomGenSelect) {
            String name = (String)this.finiteFaultGeomGenSelect.getValue();
            this.finiteGeomGen = this.finiteGeomGens.get(name);
            for (GeometryGenerator geomGen : this.finiteGeomGens.values()) {
                if (geomGen.getDisplayParams() == null) continue;
                for (Parameter param : geomGen.getDisplayParams()) {
                    param.getEditor().setVisible(geomGen == this.finiteGeomGen);
                }
            }
        }
        this.firePlotSettingsChangeEvent();
    }
}

