/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.plugins.opensha.regions;

import java.util.ListIterator;
import javax.swing.tree.DefaultMutableTreeNode;
import org.opensha.commons.data.region.CaliforniaRegions;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.geo.Region;
import org.opensha.commons.param.ParameterList;
import org.opensha.sha.faultSurface.Surface3D;
import org.scec.vtk.commons.opensha.faults.AbstractFaultSection;
import org.scec.vtk.commons.opensha.tree.FaultSectionNode;
import org.scec.vtk.commons.opensha.tree.builders.FaultTreeBuilder;
import org.scec.vtk.commons.opensha.tree.events.TreeChangeListener;

public class RegionsBuilder
implements FaultTreeBuilder {
    @Override
    public ParameterList getBuilderParams() {
        return null;
    }

    @Override
    public ParameterList getFaultParams() {
        return null;
    }

    @Override
    public void setTreeChangeListener(TreeChangeListener l) {
    }

    @Override
    public void buildTree(DefaultMutableTreeNode root) {
        this.addNode(root, (Region)new CaliforniaRegions.RELM_TESTING());
        this.addNode(root, (Region)new CaliforniaRegions.RELM_COLLECTION());
        this.addNode(root, (Region)new CaliforniaRegions.RELM_SOCAL());
        this.addNode(root, (Region)new CaliforniaRegions.RELM_NOCAL());
        this.addNode(root, (Region)new CaliforniaRegions.LA_BOX());
        this.addNode(root, (Region)new CaliforniaRegions.SF_BOX());
        this.addNode(root, (Region)new CaliforniaRegions.NORTHRIDGE_BOX());
        this.addNode(root, (Region)new CaliforniaRegions.SAN_DIEGO_BOX());
        this.addNode(root, (Region)new CaliforniaRegions.CYBERSHAKE_MAP_REGION());
        this.addNode(root, (Region)new CaliforniaRegions.CYBERSHAKE_CCA_MAP_REGION());
    }

    private void addNode(DefaultMutableTreeNode root, Region region) {
        RegionSection sect = new RegionSection(region, root.getChildCount());
        FaultSectionNode faultNode = new FaultSectionNode(sect);
        root.add(faultNode);
    }

    private class RegionSection
    extends AbstractFaultSection {
        private Region region;

        public RegionSection(Region region, int id) {
            super(region.getName(), id);
            this.region = region;
        }

        @Override
        public Surface3D createSurface(ParameterList faultRepresentationParams) {
            return new RegionSurface(this.region.getBorder());
        }

        @Override
        public double getSlipRate() {
            return Double.NaN;
        }

        @Override
        public double getAvgRake() {
            return Double.NaN;
        }

        @Override
        public double getAvgStrike() {
            return Double.NaN;
        }

        @Override
        public double getAvgDip() {
            return Double.NaN;
        }
    }

    private class RegionSurface
    implements Surface3D {
        private LocationList perimeter;

        public RegionSurface(LocationList perimeter) {
            this.perimeter = perimeter;
        }

        public ListIterator<Location> getLocationsIterator() {
            return this.perimeter.listIterator();
        }

        public LocationList getEvenlyDiscritizedPerimeter() {
            throw new UnsupportedOperationException("Not implemented");
        }

        public LocationList getPerimeter() {
            return this.perimeter;
        }

        public boolean isPointSurface() {
            return this.perimeter.size() == 1;
        }
    }
}

