/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.plugins.opensha.simulators;

import com.google.common.base.Joiner;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Maps;
import java.awt.Color;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.impl.BooleanParameter;
import org.opensha.commons.param.impl.DoubleParameter;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.commons.util.cpt.CPT;
import org.opensha.commons.util.cpt.LinearBlender;
import org.opensha.refFaultParamDb.vo.FaultSectionPrefData;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.simulators.SimulatorElement;
import org.opensha.sha.simulators.SimulatorEvent;
import org.opensha.sha.simulators.utils.RSQSimSubSectionMapper;
import org.opensha.sha.simulators.utils.RSQSimUtils;
import org.scec.vtk.commons.opensha.faults.AbstractFaultSection;
import org.scec.vtk.commons.opensha.faults.anim.IDBasedFaultAnimation;
import org.scec.vtk.commons.opensha.faults.anim.TimeBasedFaultAnimation;
import org.scec.vtk.commons.opensha.faults.colorers.CPTBasedColorer;
import org.scec.vtk.commons.opensha.faults.colorers.FaultColorer;
import org.scec.vtk.commons.opensha.faults.faultSectionImpl.SimulatorElementFault;
import org.scec.vtk.commons.opensha.gui.EventManager;
import org.scec.vtk.main.MainGUI;
import org.scec.vtk.plugins.opensha.simulators.EQSimsEventListener;
import scratch.UCERF3.enumTreeBranches.DeformationModels;
import scratch.UCERF3.enumTreeBranches.FaultModels;

public class EQSimsAnimDroughtColorer
extends CPTBasedColorer
implements TimeBasedFaultAnimation,
IDBasedFaultAnimation,
EQSimsEventListener,
ParameterChangeListener {
    private EventManager eventManager;
    private ArrayList<ChangeListener> listeners = new ArrayList();
    private static String TITLE = "Open Interval Animation (yrs)";
    private static final String MIN_MAG_PARAM_NAME = "Min Mag";
    private static Double MIN_MAG_PARAM = 7.0;
    private static final Double MAX_MAG_PARAM = 10.0;
    private DoubleParameter minMagParam = new DoubleParameter("Min Mag", MIN_MAG_PARAM, MAX_MAG_PARAM, MIN_MAG_PARAM);
    private static final String MAX_VALUE_COLOR_WHEEL = "Drought  Period Indicator (years)";
    private static Double MIN_YEAR_PARAM = 100.0;
    private static final Double MAX_YEAR_PARAM = 1000.0;
    private static DoubleParameter droughtYearParam = new DoubleParameter("Drought  Period Indicator (years)", MIN_YEAR_PARAM, MAX_YEAR_PARAM, MIN_YEAR_PARAM);
    private ParameterList animParams = new ParameterList();
    private HashMap<Object, Object> idToUnfilteredStepMap;
    private List<Integer> filterIndexes;
    private List<? extends SimulatorEvent> unfilteredevents;
    private LoadingCache<Integer, Map<Integer, Color>> eventColorCache;
    private int currentStep = -1;
    private BooleanParameter onlyCurrentVisibleParam;
    private HashMap<Integer, Integer> faultDroughtLength;
    private HashMap<Integer, Color> faultDroughtColor;
    private Map<Integer, HashSet<Integer>> faultMappings;
    private Map<String, Integer> faultNamesMap;
    private Map<String, Integer> sectNamesMap;
    private List<SimulatorElement> elements;
    private List<? extends FaultSection> subSects;
    private RSQSimSubSectionMapper subSectMapper;
    int max = 0;
    private PreloadThread preloadThread;
    private static final DecimalFormat magDF = new DecimalFormat("0.00");
    private LinearBlender colorBlender;

    private static CPT getDefaultCPT() {
        CPT cpt = new CPT(0.0, (Double)droughtYearParam.getValue() * 2.0, new Color[]{Color.white, Color.red, Color.blue});
        cpt.setNanColor(Color.GRAY);
        cpt.setBelowMinColor(cpt.getMinColor());
        cpt.setAboveMaxColor(cpt.getMaxColor());
        return cpt;
    }

    public EQSimsAnimDroughtColorer() {
        super(EQSimsAnimDroughtColorer.getDefaultCPT(), false);
        this.animParams.addParameter((Parameter)this.minMagParam);
        this.minMagParam.addParameterChangeListener((ParameterChangeListener)this);
        this.animParams.addParameter((Parameter)droughtYearParam);
        droughtYearParam.addParameterChangeListener((ParameterChangeListener)this);
        this.onlyCurrentVisibleParam = new BooleanParameter("Hide Other Elements", Boolean.valueOf(false));
        this.animParams.addParameter((Parameter)this.onlyCurrentVisibleParam);
        this.faultDroughtLength = new HashMap();
        this.faultDroughtColor = new HashMap();
        for (int i = 0; i <= 921; ++i) {
            this.faultDroughtLength.put(i, 0);
            this.faultDroughtColor.put(i, null);
        }
        this.eventColorCache = CacheBuilder.newBuilder().maximumSize(10000L).build((CacheLoader)new CacheLoader<Integer, Map<Integer, Color>>(){

            public Map<Integer, Color> load(Integer index) throws Exception {
                SimulatorEvent event = EQSimsAnimDroughtColorer.this.unfilteredevents.get(index);
                int[] ids = event.getAllElementIDs();
                double[] slips = event.getAllElementSlips();
                HashMap<Integer, Color> slipMap = new HashMap<Integer, Color>();
                for (int j = 0; ids != null && j < ids.length; ++j) {
                    int id = ids[j];
                    double slip = slips[j];
                    Color c = EQSimsAnimDroughtColorer.this.getColorForValue(slip);
                    slipMap.put(id, c);
                }
                return slipMap;
            }
        });
    }

    public void setEventManager(EventManager eventManager) {
        this.eventManager = eventManager;
    }

    @Override
    public double getValue(AbstractFaultSection fault) {
        if (fault != null && this.faultDroughtLength.containsKey(fault.getId())) {
            return this.faultDroughtLength.get(fault.getId()).intValue();
        }
        return Double.NaN;
    }

    @Override
    public Color getColor(AbstractFaultSection fault) {
        Color c;
        if (!this.isStepValid(this.currentStep) || !(fault instanceof SimulatorElementFault)) {
            return this.getCPT().getNanColor();
        }
        this.checkInit();
        SimulatorElement elem = ((SimulatorElementFault)fault).getElement();
        FaultSection sect = this.subSectMapper.getMappedSection(elem);
        int parentID = sect.getParentSectionId();
        if (parentID > this.max) {
            this.max = parentID;
        }
        if ((c = this.faultDroughtColor != null ? this.faultDroughtColor.get(parentID) : this.getColorCacheForStep(this.currentStep).get(fault.getId())) == null) {
            return this.getCPT().getNanColor();
        }
        return c;
    }

    public String getName() {
        return "Drought Duration";
    }

    @Override
    public int getNumSteps() {
        if (this.unfilteredevents != null) {
            if (this.filterIndexes == null) {
                return this.unfilteredevents.size();
            }
            return this.filterIndexes.size();
        }
        return 0;
    }

    @Override
    public void setCurrentStep(int step) {
        this.currentStep = step;
        this.checkStartPreloadThread();
    }

    private synchronized Map<Integer, Color> getColorCacheForStep(int step) {
        if (this.unfilteredevents == null) {
            return null;
        }
        try {
            if (this.filterIndexes == null) {
                return (Map)this.eventColorCache.get((Object)step);
            }
            return (Map)this.eventColorCache.get((Object)this.filterIndexes.get(step));
        }
        catch (ExecutionException e) {
            throw ExceptionUtils.asRuntimeException((Throwable)e);
        }
    }

    private synchronized SimulatorEvent getEventForStep(int step) {
        if (this.unfilteredevents == null) {
            return null;
        }
        if (this.filterIndexes == null) {
            return this.unfilteredevents.get(step);
        }
        return this.unfilteredevents.get(this.filterIndexes.get(step));
    }

    @Override
    public void setCPT(CPT cpt) {
        super.setCPT(cpt);
        this.clearCache();
    }

    private void clearCache() {
        this.eventColorCache.invalidateAll();
    }

    private synchronized void checkStartPreloadThread() {
        if (this.preloadThread == null) {
            this.preloadThread = new PreloadThread();
            this.preloadThread.start();
        } else {
            if (this.preloadThread.isAlive()) {
                this.preloadThread.currentIteration = 0;
            }
            if (!this.preloadThread.isAlive()) {
                this.preloadThread = new PreloadThread();
                this.preloadThread.start();
            }
        }
    }

    @Override
    public void setEvents(List<? extends SimulatorEvent> events) {
        this.unfilteredevents = events;
        this.idToUnfilteredStepMap = Maps.newHashMap();
        if (events != null) {
            for (int step = 0; step < events.size(); ++step) {
                this.idToUnfilteredStepMap.put(events.get(step).getID(), step);
            }
        }
    }

    @Override
    public void addRangeChangeListener(ChangeListener l) {
        this.listeners.add(l);
    }

    @Override
    public void fireRangeChangeEvent() {
        ChangeEvent e = new ChangeEvent(this);
        for (ChangeListener l : this.listeners) {
            l.stateChanged(e);
        }
    }

    @Override
    public String getCurrentLabel() {
        if (!this.isStepValid(this.currentStep)) {
            return null;
        }
        SimulatorEvent event = this.getEventForStep(this.currentStep);
        return "Mag: " + magDF.format(event.getMagnitude());
    }

    private boolean isStepValid(int step) {
        return step >= 0 && this.unfilteredevents != null && step < this.getNumSteps();
    }

    @Override
    public double getTimeForStep(int step) {
        if (!this.isStepValid(step)) {
            return 0.0;
        }
        return this.getEventForStep(step).getTime();
    }

    @Override
    public ParameterList getAnimationParameters() {
        return this.animParams;
    }

    private void filterEvents() {
        try {
            this.eventManager.waitOnCalcThread();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.doFilterEvents();
    }

    private synchronized void doFilterEvents() {
        double minMag = (Double)this.minMagParam.getValue();
        double startTime = Double.NaN;
        double endTime = Double.NaN;
        if (minMag > MIN_MAG_PARAM || !Double.isNaN(startTime)) {
            this.filterIndexes = new ArrayList<Integer>();
            for (int i = 0; i < this.unfilteredevents.size(); ++i) {
                SimulatorEvent event = this.unfilteredevents.get(i);
                if (event.getMagnitude() < minMag) continue;
                if (!Double.isNaN(startTime)) {
                    if (event.getTime() < startTime) continue;
                    if (event.getTime() > endTime) break;
                }
                this.filterIndexes.add(i);
            }
        }
        this.fireColorerChangeEvent();
        this.checkStartPreloadThread();
        this.fireRangeChangeEvent();
        MainGUI.updateRenderWindow();
    }

    public void parameterChange(ParameterChangeEvent arg0) {
        if (arg0.getSource() == this.minMagParam) {
            MIN_MAG_PARAM = (Double)arg0.getNewValue();
            this.filterEvents();
        } else if (arg0.getSource() == droughtYearParam) {
            MIN_YEAR_PARAM = (Double)arg0.getNewValue();
            this.setCPT(EQSimsAnimDroughtColorer.getDefaultCPT());
        }
    }

    @Override
    public Boolean getFaultVisibility(AbstractFaultSection fault) {
        if (((Boolean)this.onlyCurrentVisibleParam.getValue()).booleanValue()) {
            return !this.getColor(fault).equals(this.getCPT().getNanColor());
        }
        return null;
    }

    @Override
    public FaultColorer getFaultColorer() {
        return this;
    }

    @Override
    public boolean includeStepInLabel() {
        return true;
    }

    @Override
    public int getPreferredInitialStep() {
        return 0;
    }

    @Override
    public void setGeometry(List<SimulatorElement> elements) {
        this.faultMappings = null;
        this.faultNamesMap = null;
        this.sectNamesMap = null;
        this.subSectMapper = null;
        this.elements = elements;
    }

    private void checkInit() {
        if (this.elements != null && this.subSectMapper == null) {
            if (this.subSects == null) {
                FaultModels fm = FaultModels.FM3_1;
                DeformationModels geom = DeformationModels.GEOLOGIC;
                this.subSects = RSQSimUtils.getUCERF3SubSectsForComparison((FaultModels)fm, (DeformationModels)geom);
            }
            double minSectFractForInclusion = 0.2;
            this.subSectMapper = new RSQSimSubSectionMapper(this.subSects, this.elements, minSectFractForInclusion);
            this.faultMappings = Maps.newHashMap();
            this.faultNamesMap = Maps.newHashMap();
            this.sectNamesMap = Maps.newHashMap();
            HashMap faultNames = Maps.newHashMap();
            for (SimulatorElement simulatorElement : this.elements) {
                Integer faultID;
                Integer sectID = simulatorElement.getSectionID();
                String sectName = simulatorElement.getSectionName();
                if (!this.sectNamesMap.containsKey(sectName)) {
                    this.sectNamesMap.put(sectName, sectID);
                }
                if ((faultID = Integer.valueOf(simulatorElement.getFaultID())) < 0) continue;
                HashSet<Integer> sectsForFault = this.faultMappings.get(faultID);
                if (sectsForFault == null) {
                    sectsForFault = new HashSet();
                    this.faultMappings.put(faultID, sectsForFault);
                    faultNames.put(faultID, new HashSet());
                }
                sectsForFault.add(sectID);
                ((HashSet)faultNames.get(faultID)).add(sectName);
            }
            int maxFaultID = 0;
            for (Integer faultID : this.faultMappings.keySet()) {
                if (faultID <= maxFaultID) continue;
                maxFaultID = faultID;
            }
            int n = ("" + maxFaultID).length();
            for (Integer faultID : this.faultMappings.keySet()) {
                HashSet names = (HashSet)faultNames.get(faultID);
                Object commonPrefix = "";
                block3: for (int i = 0; i < ((String)names.iterator().next()).length(); ++i) {
                    String start = null;
                    for (String name : names) {
                        if (start == null) {
                            start = "" + name.charAt(i);
                            continue;
                        }
                        if (name.charAt(i) == start.charAt(0)) continue;
                        break block3;
                    }
                    commonPrefix = (String)commonPrefix + start;
                }
                commonPrefix = ((String)commonPrefix).length() < 2 ? Joiner.on((String)",").join((Iterable)this.faultMappings.get(faultID)) : (String)commonPrefix + "*";
                String faultIDstr = "" + faultID;
                while (faultIDstr.length() < n) {
                    faultIDstr = "0" + faultIDstr;
                }
                this.faultNamesMap.put(faultIDstr + ". " + (String)commonPrefix, faultID);
            }
        }
    }

    @Override
    public double getCurrentDuration() {
        if (this.unfilteredevents != null) {
            return this.getTimeForStep(this.getNumSteps() - 1) - this.getTimeForStep(0);
        }
        return 0.0;
    }

    @Override
    public boolean timeChanged(double time) {
        double eventPrevTime = 0.0;
        Color nanColor = this.getCPT().getNanColor();
        if (this.colorBlender == null) {
            this.colorBlender = new LinearBlender();
        }
        int step = this.currentStep;
        SimulatorEvent event = this.getEventForStep(step);
        HashMap<Integer, Integer> eventParentIDS = this.getParentIDsForEvent(event);
        if (step == 1) {
            eventPrevTime = 0.0;
        } else if (step > 0) {
            SimulatorEvent eventPrevious = this.getEventForStep(step - 1);
            eventPrevTime = eventPrevious.getTimeInYears();
        } else {
            return true;
        }
        double eventTime = event.getTimeInYears();
        double timeSinceYears = eventTime - eventPrevTime;
        if (timeSinceYears < 0.0) {
            timeSinceYears = 0.0;
        }
        this.checkInit();
        for (Integer key : this.faultDroughtLength.keySet()) {
            if (!eventParentIDS.containsKey(key)) {
                Color fade;
                Color eventColor = this.faultDroughtColor.get(key);
                Integer numDroughtLength = (int)((double)this.faultDroughtLength.get(key).intValue() + timeSinceYears);
                this.faultDroughtLength.put(key, numDroughtLength);
                Color droughtColor = this.getColorForValue(numDroughtLength.intValue());
                if (this.faultDroughtColor.get(key) != null) {
                    fade = this.colorBlender.blend(droughtColor, eventColor, 0.1f);
                    this.faultDroughtColor.put(key, fade);
                    continue;
                }
                if (numDroughtLength < ((Double)droughtYearParam.getValue()).intValue()) continue;
                fade = this.colorBlender.blend(droughtColor, nanColor, 0.1f);
                this.faultDroughtColor.put(key, fade);
                continue;
            }
            this.faultDroughtLength.put(key, 0);
            this.faultDroughtColor.put(key, nanColor);
        }
        return true;
    }

    @Override
    public synchronized int getIDForStep(int step) {
        if (this.filterIndexes == null && step >= 0 && this.unfilteredevents != null && step < this.unfilteredevents.size()) {
            return this.unfilteredevents.get(step).getID();
        }
        if (this.filterIndexes != null && step >= 0 && step < this.filterIndexes.size()) {
            return this.unfilteredevents.get(this.filterIndexes.get(step)).getID();
        }
        return -1;
    }

    @Override
    public int getStepForID(int id) {
        Integer step = (Integer)this.idToUnfilteredStepMap.get(id);
        if (step == null) {
            return -1;
        }
        int filterIndex = -1;
        if (this.filterIndexes == null) {
            return step;
        }
        filterIndex = this.filterIndexes.indexOf(step);
        if (filterIndex >= 0) {
            return filterIndex;
        }
        if (id > 0 && id <= this.unfilteredevents.size()) {
            return step;
        }
        return -1;
    }

    @Override
    public Color getColorForValue(double value) {
        Color color = super.getColorForValue(value);
        return color;
    }

    public HashMap<Integer, Integer> getParentIDsForEvent(SimulatorEvent event) {
        this.checkInit();
        List mappingsBundled = this.subSectMapper.getFilteredSubSectionMappings(event);
        if (mappingsBundled == null) {
            return null;
        }
        HashMap<Integer, Integer> sects = new HashMap<Integer, Integer>();
        for (List bundle : mappingsBundled) {
            for (RSQSimSubSectionMapper.SubSectionMapping mapping : bundle) {
                sects.put(mapping.getSubSect().getParentSectionId(), 0);
            }
        }
        return sects;
    }

    public Collection<SimulatorElement> getElementsForSubSect(FaultSectionPrefData subSect) {
        this.checkInit();
        return this.subSectMapper.getElementsForSection((FaultSection)subSect);
    }

    private class PreloadThread
    extends Thread {
        final int preload_num = 100;
        final long sleep_time_millis = 500L;
        final int max_iterations = 200;
        private int currentIteration = 0;

        private PreloadThread() {
        }

        @Override
        public void run() {
            while (this.currentIteration < 200) {
                if (EQSimsAnimDroughtColorer.this.currentStep >= 0) {
                    int step;
                    if (EQSimsAnimDroughtColorer.this.unfilteredevents == null) continue;
                    for (int i = 0; i < 100 && EQSimsAnimDroughtColorer.this.isStepValid(step = EQSimsAnimDroughtColorer.this.currentStep + i); ++i) {
                        EQSimsAnimDroughtColorer.this.getColorCacheForStep(step);
                    }
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++this.currentIteration;
            }
        }
    }
}

