/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.plugins.opensha.simulators;

import java.awt.Cursor;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import org.opensha.commons.data.NamedComparator;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.impl.DoubleParameter;
import org.opensha.commons.param.impl.FileParameter;
import org.opensha.commons.param.impl.IntegerParameter;
import org.opensha.commons.param.impl.StringParameter;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.sha.gui.infoTools.CalcProgressBar;
import org.opensha.sha.simulators.SimulatorElement;
import org.opensha.sha.simulators.SimulatorEvent;
import org.opensha.sha.simulators.iden.CatalogLengthLoadIden;
import org.opensha.sha.simulators.iden.LogicalAndRupIden;
import org.opensha.sha.simulators.iden.MagRangeRuptureIdentifier;
import org.opensha.sha.simulators.iden.RuptureIdentifier;
import org.opensha.sha.simulators.parsers.EQSIMv06FileReader;
import org.opensha.sha.simulators.parsers.RSQSimFileReader;
import org.scec.vtk.commons.opensha.faults.AbstractFaultIDComparator;
import org.scec.vtk.commons.opensha.faults.anim.FaultAnimation;
import org.scec.vtk.commons.opensha.faults.colorers.DipColorer;
import org.scec.vtk.commons.opensha.faults.colorers.FaultColorer;
import org.scec.vtk.commons.opensha.faults.colorers.RakeColorer;
import org.scec.vtk.commons.opensha.faults.colorers.StrikeColorer;
import org.scec.vtk.commons.opensha.faults.faultSectionImpl.SimulatorElementFault;
import org.scec.vtk.commons.opensha.tree.FaultCategoryNode;
import org.scec.vtk.commons.opensha.tree.FaultSectionNode;
import org.scec.vtk.commons.opensha.tree.builders.FaultTreeBuilder;
import org.scec.vtk.commons.opensha.tree.events.TreeChangeListener;
import org.scec.vtk.main.Info;
import org.scec.vtk.main.MainGUI;
import org.scec.vtk.plugins.opensha.simulators.EQSimsAnimDroughtColorer;
import org.scec.vtk.plugins.opensha.simulators.EQSimsDepthColorer;
import org.scec.vtk.plugins.opensha.simulators.EQSimsDroughtColorer;
import org.scec.vtk.plugins.opensha.simulators.EQSimsEventAnimColorer;
import org.scec.vtk.plugins.opensha.simulators.EQSimsEventListener;
import org.scec.vtk.plugins.opensha.simulators.EQSimsEventSlipAnim;
import org.scec.vtk.plugins.opensha.simulators.EQSimsParticipationColorer;
import org.scec.vtk.plugins.opensha.simulators.EQSimsPatchScalarColorer;
import org.scec.vtk.plugins.opensha.simulators.EQSimsSubSectDASColorer;
import org.scec.vtk.plugins.opensha.simulators.EQSlipRateColorer;
import org.scec.vtk.tools.Prefs;

public class EQSimsBuilder
implements FaultTreeBuilder,
ParameterChangeListener {
    private static ArrayList<String> hardcodedInputs = new ArrayList();
    private static ArrayList<String> filteringOptions;
    private StringParameter filterOptions;
    String buttonchosen = "";
    List<? extends SimulatorEvent> events;
    private static final String EVENT_MIN_MAG_PARAM_NAME = "Min Event Mag To Load";
    private DoubleParameter eventMinMagParam;
    private static final String MAX_CAT_DURATION_PARAM_NAME = "Max Catalog Years To Load";
    private DoubleParameter catDurationParam;
    private static final String GEOM_PRESET_PARAM_NAME = "Geometry File Presets";
    private static final String GEOM_PRESET_NONE = "(none selected)";
    private StringParameter geomPresetParam;
    private static final String GEOM_FILE_SELECTOR_PARAM_NAME = "Geometry File";
    private FileParameter geomFileParam = new FileParameter("Geometry File");
    private static final String EVENT_SELECTOR_PARAM_NAME = "Simulator Event File";
    private FileParameter eventFileParam = new FileParameter("Simulator Event File");
    private static final String UTM_ZONE_NAME = "UTM Zone";
    private IntegerParameter utmZoneParam = new IntegerParameter("UTM Zone", 1, 60, Integer.valueOf(11));
    private static final String UTM_BAND_NAME = "UTM Band";
    private StringParameter utmBandParam = new StringParameter("UTM Band", "N");
    private ParameterList builderParams = new ParameterList();
    private TreeChangeListener l;
    private ArrayList<FaultColorer> colorers;
    private ArrayList<FaultAnimation> animations;
    private EQSimsEventSlipAnim eventSlipAnim;
    private ArrayList<EQSimsEventListener> eventListeners = new ArrayList();
    private File dataDir = new File(Prefs.getDefaultLocation() + File.separator + "data" + File.separator + "EQSims");
    private List<SimulatorElement> elements;
    private File reloadFile;

    public EQSimsBuilder() {
        if (!this.dataDir.exists()) {
            this.dataDir.mkdirs();
        }
        ArrayList<String> strings = new ArrayList<String>();
        strings.add(GEOM_PRESET_NONE);
        for (String string : hardcodedInputs) {
            strings.add(string);
        }
        ArrayList<String> strings2 = new ArrayList<String>();
        strings2.add(GEOM_PRESET_NONE);
        for (String name : filteringOptions) {
            strings2.add(name);
        }
        this.eventMinMagParam = new DoubleParameter(EVENT_MIN_MAG_PARAM_NAME, -10.0, 10.0, Double.valueOf(7.0));
        this.builderParams.addParameter((Parameter)this.eventMinMagParam);
        this.catDurationParam = new DoubleParameter(MAX_CAT_DURATION_PARAM_NAME, 0.0, Double.POSITIVE_INFINITY, Double.valueOf(0.0));
        this.builderParams.addParameter((Parameter)this.catDurationParam);
        this.geomPresetParam = new StringParameter(GEOM_PRESET_PARAM_NAME, strings, GEOM_PRESET_NONE);
        this.geomPresetParam.addParameterChangeListener((ParameterChangeListener)this);
        this.builderParams.addParameter((Parameter)this.geomPresetParam);
        this.geomFileParam.addParameterChangeListener((ParameterChangeListener)this);
        this.geomFileParam.setShowHiddenFiles(true);
        File file = new File("/home/kevin/Simulators/catalogs");
        File defaultDir = file.exists() ? file : new File(MainGUI.getCWD(), "data");
        if (defaultDir.exists()) {
            this.geomFileParam.setDefaultInitialDir(defaultDir);
        }
        this.builderParams.addParameter((Parameter)this.geomFileParam);
        this.filterOptions = new StringParameter("Filtering Tools", strings2, GEOM_PRESET_NONE);
        this.builderParams.addParameter((Parameter)this.filterOptions);
        this.filterOptions.addParameterChangeListener((ParameterChangeListener)this);
        this.builderParams.addParameter((Parameter)this.eventFileParam);
        this.eventFileParam.addParameterChangeListener((ParameterChangeListener)this);
        this.eventFileParam.setShowHiddenFiles(true);
        this.builderParams.addParameter((Parameter)this.utmZoneParam);
        this.builderParams.addParameter((Parameter)this.utmBandParam);
        this.colorers = new ArrayList();
        EQSlipRateColorer slipColorer = new EQSlipRateColorer();
        this.eventListeners.add(slipColorer);
        this.colorers.add(slipColorer);
        EQSimsParticipationColorer particColor = new EQSimsParticipationColorer();
        this.eventListeners.add(particColor);
        this.colorers.add(particColor);
        EQSimsDepthColorer depthColor = new EQSimsDepthColorer();
        this.colorers.add(depthColor);
        EQSimsPatchScalarColorer patchColorer = new EQSimsPatchScalarColorer();
        this.colorers.add(patchColorer);
        this.eventListeners.add(patchColorer);
        StrikeColorer strikeColor = new StrikeColorer();
        this.colorers.add(strikeColor);
        DipColorer dipColor = new DipColorer();
        this.colorers.add(dipColor);
        RakeColorer rakeColor = new RakeColorer();
        this.colorers.add(rakeColor);
        EQSimsSubSectDASColorer dasColorer = new EQSimsSubSectDASColorer();
        this.colorers.add(dasColorer);
        this.eventListeners.add(dasColorer);
        EQSimsDroughtColorer droughtColorer = new EQSimsDroughtColorer();
        this.colorers.add(droughtColorer);
        this.eventListeners.add(droughtColorer);
        this.animations = new ArrayList();
        EQSimsEventAnimColorer eventAnim = new EQSimsEventAnimColorer();
        this.animations.add(eventAnim);
        this.eventListeners.add(eventAnim);
        EQSimsAnimDroughtColorer eventDrought = new EQSimsAnimDroughtColorer();
        this.animations.add(eventDrought);
        this.eventListeners.add(eventDrought);
        this.eventSlipAnim = new EQSimsEventSlipAnim();
        this.animations.add(this.eventSlipAnim);
        this.eventListeners.add(this.eventSlipAnim);
    }

    @Override
    public ParameterList getBuilderParams() {
        return this.builderParams;
    }

    @Override
    public ParameterList getFaultParams() {
        return null;
    }

    private static void downloadURL(URL url, File toFile) throws IOException {
        System.out.println("downloading: " + url.toString() + "\nto: " + toFile.getAbsolutePath());
        InputStream is = url.openStream();
        DataInputStream dis = new DataInputStream(new BufferedInputStream(is));
        FileOutputStream fout = new FileOutputStream(toFile);
        int b = dis.read();
        while (b >= 0) {
            fout.write(b);
            b = dis.read();
        }
        fout.flush();
        fout.close();
        System.out.println("done.");
    }

    private File getCachePath(String fName) {
        return new File(this.dataDir.getAbsolutePath() + File.separator + fName);
    }

    private boolean isFileCached(String fName) {
        return this.getCachePath(fName).exists();
    }

    private void downloadGeomAsynchronous(final String fName) {
        final CalcProgressBar progress = new CalcProgressBar(null, "Downloading...", "Downloading selected geometry file.This requires an active internet connection.", false);
        progress.setModal(true);
        progress.setIndeterminate(true);
        progress.setVisible(true);
        final File file = this.getCachePath(fName);
        final Runnable fireRunnable = new Runnable(){

            @Override
            public void run() {
                progress.setVisible(false);
                EQSimsBuilder.this.fireTreeChangeEvent();
            }
        };
        Runnable downloadRunnable = new Runnable(){

            @Override
            public void run() {
                try {
                    URL url = new URL("http://opensha.usc.edu/data/simulators/" + fName);
                    EQSimsBuilder.downloadURL(url, file);
                    SwingUtilities.invokeLater(fireRunnable);
                }
                catch (IOException e) {
                    ExceptionUtils.throwAsRuntimeException((Throwable)e);
                }
            }
        };
        new Thread(downloadRunnable).start();
    }

    @Override
    public void buildTree(DefaultMutableTreeNode root) {
        File geomFile = (File)this.geomFileParam.getValue();
        this.elements = null;
        if (geomFile == null) {
            return;
        }
        try {
            this.elements = this.loadGeometry(geomFile);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(Info.getMainGUI(), "Incompatible File. Please Choose Another (.flt or .in recommended)");
            return;
        }
        this.eventFileParam.setValue(null);
        HashMap<Integer, FaultCategoryNode> faultNodesMap = new HashMap<Integer, FaultCategoryNode>();
        HashMap sectionsMap = new HashMap();
        ArrayList<FaultCategoryNode> faultNodes = new ArrayList<FaultCategoryNode>();
        block10: for (SimulatorElement element : this.elements) {
            SimulatorElementFault secNode;
            ArrayList secsForFault;
            FaultCategoryNode faultNode;
            FaultCategoryNode tempNode;
            int secID = element.getSectionID();
            String secName = element.getName();
            switch (this.buttonchosen) {
                case "San Andreas, San Jacinto, Elsinore, Hayward (UCERF3 catalog data)": {
                    if (!secName.contains("SanAndreas") && !secName.contains("SanJacinto") && !secName.contains("Hayward") && !secName.contains("Elsinore")) continue block10;
                    if (!faultNodesMap.containsKey(secID)) {
                        tempNode = new FaultCategoryNode(element.getSectionName());
                        faultNodesMap.put(secID, tempNode);
                        faultNodes.add(tempNode);
                    }
                    if (!sectionsMap.containsKey(faultNode = (FaultCategoryNode)faultNodesMap.get(secID))) {
                        sectionsMap.put(faultNode, new ArrayList());
                    }
                    secsForFault = (ArrayList)sectionsMap.get(faultNode);
                    secNode = new SimulatorElementFault(element);
                    secsForFault.add(secNode);
                    continue block10;
                }
                case "San Andreas, San Jacinto, Elsinore, Hayward (RSQSim catalog data (zfault))": {
                    if (!(secID >= 511 && secID <= 536 || secID >= 818 && secID <= 842 || secID >= 1772 && secID <= 1973) && (secID < 2153 || secID > 2196)) continue block10;
                    if (!faultNodesMap.containsKey(secID)) {
                        tempNode = new FaultCategoryNode(element.getSectionName());
                        faultNodesMap.put(secID, tempNode);
                        faultNodes.add(tempNode);
                    }
                    if (!sectionsMap.containsKey(faultNode = (FaultCategoryNode)faultNodesMap.get(secID))) {
                        sectionsMap.put(faultNode, new ArrayList());
                    }
                    secsForFault = (ArrayList)sectionsMap.get(faultNode);
                    secNode = new SimulatorElementFault(element);
                    secsForFault.add(secNode);
                    continue block10;
                }
            }
            if (!faultNodesMap.containsKey(secID)) {
                tempNode = new FaultCategoryNode(element.getSectionName());
                faultNodesMap.put(secID, tempNode);
                faultNodes.add(tempNode);
            }
            if (!sectionsMap.containsKey(faultNode = (FaultCategoryNode)faultNodesMap.get(secID))) {
                sectionsMap.put(faultNode, new ArrayList());
            }
            secsForFault = (ArrayList)sectionsMap.get(faultNode);
            secNode = new SimulatorElementFault(element);
            secsForFault.add(secNode);
        }
        Collections.sort(faultNodes, new NamedComparator());
        FaultCategoryNode faultRoot = new FaultCategoryNode(geomFile.getName());
        for (FaultCategoryNode faultNode : faultNodes) {
            ArrayList sections = (ArrayList)sectionsMap.get(faultNode);
            Collections.sort(sections, new AbstractFaultIDComparator());
            for (SimulatorElementFault section : sections) {
                faultNode.add(new FaultSectionNode(section));
            }
            faultRoot.add(faultNode);
        }
        root.add(faultRoot);
        this.fireNewGeometry(this.elements);
    }

    @Override
    public void setTreeChangeListener(TreeChangeListener l) {
        this.l = l;
    }

    private void fireTreeChangeEvent() {
        if (this.l != null) {
            this.l.treeChanged(null);
        }
    }

    public ArrayList<FaultColorer> getColorers() {
        return this.colorers;
    }

    public ArrayList<FaultAnimation> getAnimations() {
        return this.animations;
    }

    private void fireNewGeometry(List<SimulatorElement> elements) {
        for (EQSimsEventListener l : this.eventListeners) {
            l.setGeometry(elements);
        }
    }

    private void fireNewEvents(List<? extends SimulatorEvent> events) {
        for (EQSimsEventListener l : this.eventListeners) {
            l.setEvents(events);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void parameterChange(ParameterChangeEvent event) {
        if (event.getSource() == this.geomPresetParam) {
            String preset = (String)this.geomPresetParam.getValue();
            if (preset.equals(GEOM_PRESET_NONE)) return;
            if (this.isFileCached(preset)) {
                File file = this.getCachePath(preset);
                this.geomFileParam.setValue((Object)file);
                this.geomFileParam.getEditor().refreshParamEditor();
                this.fireTreeChangeEvent();
                return;
            }
            this.geomFileParam.setValue(null);
            this.geomFileParam.getEditor().refreshParamEditor();
            this.downloadGeomAsynchronous(preset);
            return;
        }
        if (event.getSource() == this.geomFileParam) {
            final ProgressBar progress = new ProgressBar("Loading Geometry File", "Please Wait");
            progress.runProgressBar();
            File file = (File)this.geomFileParam.getValue();
            if (file != null && this.eventFileParam.getValue() == null) {
                this.eventFileParam.setDefaultInitialDir(file.getParentFile());
            }
            this.fireNewGeometry(null);
            final Runnable fireRunnable = new Runnable(){

                @Override
                public void run() {
                    EQSimsBuilder.this.fireTreeChangeEvent();
                    progress.stopProgressBar();
                }
            };
            Runnable fileRunnable = new Runnable(){

                @Override
                public void run() {
                    SwingUtilities.invokeLater(fireRunnable);
                }
            };
            new Thread(fileRunnable).start();
            return;
        }
        if (event.getSource() == this.eventFileParam) {
            File outFile = (File)this.eventFileParam.getValue();
            if (this.reloadFile == null) {
                this.setEventFile((File)this.eventFileParam.getValue());
            }
            if (outFile != null && this.elements != null) {
                if (this.elements == null) return;
                this.loadEvents(outFile);
                return;
            }
            this.fireNewEvents(null);
            return;
        }
        if (event.getSource() != this.filterOptions) return;
        if (this.geomFileParam.getValue() == null) {
            JOptionPane.showMessageDialog(Info.getMainGUI(), "No Geometry File Detected.\n Try again after uploading it.  ");
            return;
        }
        if (this.filterOptions.getValue() == GEOM_PRESET_NONE) {
            this.buttonchosen = "";
        } else if (this.filterOptions.getValue() == "San Andreas, San Jacinto, Elsinore, Hayward (UCERF3 catalog data)") {
            this.buttonchosen = "San Andreas, San Jacinto, Elsinore, Hayward (UCERF3 catalog data)";
        } else if (this.filterOptions.getValue() == "San Andreas, San Jacinto, Elsinore, Hayward (RSQSim catalog data (zfault))") {
            this.buttonchosen = "San Andreas, San Jacinto, Elsinore, Hayward (RSQSim catalog data (zfault))";
        }
        final ProgressBar progress = new ProgressBar("Loading Filter", "Loading " + this.buttonchosen);
        progress.runProgressBar();
        final Runnable fireRunnable = new Runnable(){

            @Override
            public void run() {
                progress.stopProgressBar();
                if (EQSimsBuilder.this.reloadFile != null) {
                    EQSimsBuilder.this.loadEvents(EQSimsBuilder.this.reloadFile);
                }
            }
        };
        Runnable filteringRunnable = new Runnable(){

            @Override
            public void run() {
                EQSimsBuilder.this.fireTreeChangeEvent();
                SwingUtilities.invokeLater(fireRunnable);
            }
        };
        new Thread(filteringRunnable).start();
    }

    private void setEventFile(File outFile) {
        this.reloadFile = outFile;
    }

    private void loadEvents(final File outFile) {
        final ProgressBar progress = new ProgressBar("Reading Events File", "Loading events...");
        try {
            this.eventSlipAnim.setInitialDir(outFile.getParentFile());
            final ArrayList<MagRangeRuptureIdentifier> rupIdens = new ArrayList<MagRangeRuptureIdentifier>();
            MagRangeRuptureIdentifier loadIden = new MagRangeRuptureIdentifier(((Double)this.eventMinMagParam.getValue()).doubleValue(), Double.POSITIVE_INFINITY);
            if ((Double)this.catDurationParam.getValue() > 0.0) {
                loadIden = new LogicalAndRupIden(new RuptureIdentifier[]{loadIden, new CatalogLengthLoadIden(((Double)this.catDurationParam.getValue()).doubleValue())});
            }
            rupIdens.add(loadIden);
            progress.runProgressBar();
            final Runnable eventRunnable = new Runnable(){

                @Override
                public void run() {
                    EQSimsBuilder.this.fireNewEvents(EQSimsBuilder.this.events);
                    progress.stopProgressBar();
                }
            };
            Runnable simulatorRunnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        if (outFile.isDirectory() || outFile.getName().endsWith("List")) {
                            System.out.println("Detected RSQSim output file/dir");
                            progress.changeLoadingMessage("Detected RSQSim output file/dir");
                            EQSimsBuilder.this.events = RSQSimFileReader.readEventsFile((File)outFile, EQSimsBuilder.this.elements, (Collection)rupIdens);
                        } else {
                            EQSimsBuilder.this.events = EQSIMv06FileReader.readEventsFile((File)outFile, EQSimsBuilder.this.elements, (Collection)rupIdens);
                        }
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog(Info.getMainGUI(), "Incompatible File. Please Choose Another (Files Ending With \"List\" Preferred)");
                        progress.stopProgressBar();
                        EQSimsBuilder.this.eventFileParam.setValue(null);
                        return;
                    }
                    System.out.println("Done reading events file!");
                    progress.changeLoadingMessage("Done reading events file!");
                    SwingUtilities.invokeLater(eventRunnable);
                }
            };
            new Thread(simulatorRunnable).start();
            System.out.println("Done loadEvents()");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private List<SimulatorElement> loadGeometry(File file) throws IOException {
        String name = file.getName().toLowerCase();
        if (name.endsWith(".flt") || name.endsWith(".in")) {
            int zone = (Integer)this.utmZoneParam.getValue();
            char band = ((String)this.utmBandParam.getValue()).charAt(0);
            return RSQSimFileReader.readGeometryFile((File)file, (int)zone, (char)band);
        }
        return EQSIMv06FileReader.readGeometryFile((File)file);
    }

    static {
        hardcodedInputs.add("ALLCAL2_1-7-11_Geometry.dat");
        hardcodedInputs.add("ALLCAL_Ward_Geometry.dat");
        hardcodedInputs.add("NCAL2a_Ward_Geometry.dat");
        hardcodedInputs.add("NCAL3a_Ward_Geometry.dat");
        hardcodedInputs.add("NCAL4a_Ward_Geometry.dat");
        hardcodedInputs.add("UCERF3.D3.1.1km.tri.2.flt");
        hardcodedInputs.add("zfault_Deepen.in");
        filteringOptions = new ArrayList();
        filteringOptions.add("San Andreas, San Jacinto, Elsinore, Hayward (UCERF3 catalog data)");
        filteringOptions.add("San Andreas, San Jacinto, Elsinore, Hayward (RSQSim catalog data (zfault))");
    }

    public class ProgressBar {
        CalcProgressBar progress;
        private Cursor waitCursor = new Cursor(3);

        public ProgressBar(String titleString, String loadingString) {
            this.progress = new CalcProgressBar(titleString, loadingString);
        }

        public void runProgressBar() {
            this.progress.setCursor(this.waitCursor);
            this.progress.setVisible(true);
            this.progress.setIndeterminate(true);
        }

        public void stopProgressBar() {
            this.progress.toFront();
            this.progress.setVisible(false);
            this.progress.dispose();
        }

        public void changeLoadingMessage(String loadingString) {
            this.progress.setProgressMessage(loadingString);
        }
    }
}

