/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.plugins.opensha.simulators;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.scec.vtk.plugins.utils.components.CheckAllTable;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class EQSimsCatalogQuery
extends JFrame {
    JButton downloadButton;
    private JTextField locationTextField;
    private JEditorPane displayEditorPane;
    private String defaultCatalogURL = "http://rsqsim.usc.edu/catalogs/";
    private CheckAllTable tablePanel;

    public EQSimsCatalogQuery() {
        super("Catalog Downloads");
        this.setSize(640, 480);
        this.setVisible(true);
        this.setDefaultCloseOperation(1);
        JPanel buttonPanel = new JPanel(new BorderLayout());
        buttonPanel.setBorder(new EmptyBorder(5, 10, 0, 10));
        this.locationTextField = new JTextField(this.defaultCatalogURL);
        this.locationTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    try {
                        EQSimsCatalogQuery.this.actionGo();
                    }
                    catch (SAXException e1) {
                        e1.printStackTrace();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                    catch (ParserConfigurationException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
        buttonPanel.add((Component)this.locationTextField, "Center");
        JButton goButton = new JButton("GO");
        goButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    EQSimsCatalogQuery.this.actionGo();
                }
                catch (SAXException e1) {
                    System.out.println("Parsing error");
                    e1.printStackTrace();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                catch (ParserConfigurationException e1) {
                    e1.printStackTrace();
                }
            }
        });
        buttonPanel.add((Component)goButton, "After");
        JPanel southButtonPanel = new JPanel();
        southButtonPanel.setLayout(new FlowLayout(4));
        this.downloadButton = new JButton("Download");
        southButtonPanel.add(this.downloadButton);
        ArrayList<String> empty = new ArrayList<String>();
        empty.add("");
        this.tablePanel = new CheckAllTable(empty, "title");
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)buttonPanel, "North");
        this.getContentPane().add((Component)southButtonPanel, "South");
    }

    protected ArrayList<Date> getDate() {
        ArrayList<Date> dates = new ArrayList<Date>();
        for (int i = 0; i < this.tablePanel.getTable().getRowCount(); ++i) {
            if (!((Boolean)this.tablePanel.getTable().getValueAt(i, 0)).booleanValue()) continue;
            String dateStr = (String)this.tablePanel.getTable().getValueAt(i, 3);
            Date date = new Date();
        }
        return dates;
    }

    protected HashMap<String, ArrayList<URL>> getDownloadURLs() {
        HashMap<String, ArrayList<URL>> downloads = new HashMap<String, ArrayList<URL>>();
        ArrayList<URL> URLList = new ArrayList<URL>();
        String[] fileTypes = new String[]{".flt", ".eList", ".pList", ".dList", ".tList"};
        for (int i = 0; i < this.tablePanel.getTable().getRowCount(); ++i) {
            if (!((Boolean)this.tablePanel.getTable().getValueAt(i, 0)).booleanValue()) continue;
            try {
                String title = (String)this.tablePanel.getTable().getValueAt(i, 1);
                for (int j = 0; j < fileTypes.length; ++j) {
                    URL url = new URL(this.defaultCatalogURL + title + "/" + title + fileTypes[j]);
                    URLList.add(url);
                }
                downloads.put(title, URLList);
                continue;
            }
            catch (MalformedURLException e) {
                System.out.println("URL Invalid");
            }
        }
        return downloads;
    }

    private ArrayList<String> convertNodeList(NodeList nodeList) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            arrayList.add(nodeList.item(i).getTextContent());
        }
        return arrayList;
    }

    private void actionGo() throws SAXException, IOException, ParserConfigurationException {
        URL verifiedUrl = this.verifyUrl(this.locationTextField.getText() + "index.xml");
        this.defaultCatalogURL = this.locationTextField.getText();
        if (verifiedUrl != null) {
            String[] tags = new String[]{"Title", "Authors", "Date", "Description", "Region"};
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            InputStream stream = verifiedUrl.openStream();
            Document document = documentBuilder.parse(stream);
            NodeList titles = document.getElementsByTagName(tags[0]);
            ArrayList<String> titleList = this.convertNodeList(titles);
            this.getContentPane().remove(this.tablePanel);
            this.tablePanel = new CheckAllTable(titleList, tags[0]);
            for (int i = 1; i < tags.length; ++i) {
                NodeList nodeList = document.getElementsByTagName(tags[i]);
                ArrayList<String> arrayList = this.convertNodeList(nodeList);
                this.tablePanel.addColumn(arrayList, tags[i]);
            }
            this.getContentPane().add((Component)this.tablePanel, "Center");
            this.revalidate();
        } else {
            System.out.println("Invalid URL");
        }
    }

    private URL verifyUrl(String url) {
        if (!url.toLowerCase().startsWith("http://")) {
            return null;
        }
        URL verifiedUrl = null;
        try {
            verifiedUrl = new URL(url);
        }
        catch (Exception e) {
            return null;
        }
        return verifiedUrl;
    }
}

