/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.plugins.opensha.simulators;

import com.google.common.base.Preconditions;
import java.awt.Color;
import java.io.IOException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import org.opensha.commons.mapping.gmt.elements.GMT_CPT_Files;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.impl.DoubleParameter;
import org.opensha.commons.param.impl.EnumParameter;
import org.opensha.commons.param.impl.ParameterListParameter;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.commons.util.cpt.CPT;
import org.opensha.sha.gui.infoTools.CalcProgressBar;
import org.opensha.sha.simulators.SimulatorElement;
import org.opensha.sha.simulators.SimulatorEvent;
import org.scec.useit.forecasting.droughts.CatalogMinMagDroughtType;
import org.scec.useit.forecasting.droughts.DroughtCalculator;
import org.scec.useit.forecasting.droughts.DroughtType;
import org.scec.vtk.commons.opensha.faults.AbstractFaultSection;
import org.scec.vtk.commons.opensha.faults.colorers.CPTBasedColorer;
import org.scec.vtk.commons.opensha.faults.faultSectionImpl.SimulatorElementFault;
import org.scec.vtk.plugins.opensha.simulators.EQSimsEventListener;

public class EQSimsDroughtColorer
extends CPTBasedColorer
implements EQSimsEventListener,
ParameterChangeListener {
    private List<SimulatorElement> elements;
    private List<? extends SimulatorEvent> events;
    JOptionPane hey = new JOptionPane();
    private ParameterList params = new ParameterList();
    private EnumParameter<DroughtTypes> droughtTypeParam = new EnumParameter("Drought Type", EnumSet.allOf(DroughtTypes.class), (Enum)DroughtTypes.STATEWIDE, null);
    private DoubleParameter droughtDurationParam;
    private ParameterListParameter droughtParamsParam;
    private EnumParameter<PlotType> plotTypeParam;
    private DoubleParameter forecastMinMagParam;
    private DoubleParameter forecastDurationParam;
    private Map<SimulatorElement, Double> tiProbs;
    private Map<SimulatorElement, Double> droughtProbs;
    private Map<SimulatorElement, Double> afterProbs;
    private Map<SimulatorElement, Double> droughtGain;

    static CPT getDefaultCPT() {
        try {
            CPT cpt = GMT_CPT_Files.MAX_SPECTRUM.instance().rescale(-5.0, 0.0);
            cpt.setNanColor(Color.GRAY);
            return cpt;
        }
        catch (IOException e) {
            throw ExceptionUtils.asRuntimeException((Throwable)e);
        }
    }

    static CPT getGainCPT() {
        try {
            CPT cpt = GMT_CPT_Files.GMT_POLAR.instance().rescale(-1.0, 1.0);
            cpt.setNanColor(Color.GRAY);
            return cpt;
        }
        catch (IOException e) {
            throw ExceptionUtils.asRuntimeException((Throwable)e);
        }
    }

    public EQSimsDroughtColorer() {
        super(EQSimsDroughtColorer.getDefaultCPT(), true);
        this.droughtTypeParam.addParameterChangeListener((ParameterChangeListener)this);
        this.params.addParameter(this.droughtTypeParam);
        this.droughtDurationParam = new DoubleParameter("Drought Duration", 0.0, 1000.0);
        this.droughtDurationParam.setUnits("Years");
        this.droughtDurationParam.setValue(50.0);
        this.droughtDurationParam.addParameterChangeListener((ParameterChangeListener)this);
        this.params.addParameter((Parameter)this.droughtDurationParam);
        this.droughtParamsParam = new ParameterListParameter("Dought Parameters", ((DroughtTypes)((Object)this.droughtTypeParam.getValue())).type.getParameters());
        this.droughtParamsParam.addParameterChangeListener((ParameterChangeListener)this);
        this.params.addParameter((Parameter)this.droughtParamsParam);
        this.plotTypeParam = new EnumParameter("Plot Type", EnumSet.allOf(PlotType.class), (Enum)PlotType.TIME_INDEPENDENT, null);
        this.plotTypeParam.addParameterChangeListener((ParameterChangeListener)this);
        this.params.addParameter(this.plotTypeParam);
        this.forecastMinMagParam = new DoubleParameter("Forecast Min Mag", 0.0, 10.0);
        this.forecastMinMagParam.setValue(7.0);
        this.forecastMinMagParam.addParameterChangeListener((ParameterChangeListener)this);
        this.params.addParameter((Parameter)this.forecastMinMagParam);
        this.forecastDurationParam = new DoubleParameter("Forecast Duration", 0.0, 1000.0);
        this.forecastDurationParam.setUnits("Years");
        this.forecastDurationParam.setValue(30.0);
        this.forecastDurationParam.addParameterChangeListener((ParameterChangeListener)this);
        this.params.addParameter((Parameter)this.forecastDurationParam);
    }

    public String getName() {
        return "Drought Probabilities";
    }

    @Override
    public ParameterList getColorerParameters() {
        return this.params;
    }

    @Override
    public synchronized double getValue(AbstractFaultSection fault) {
        Double ret;
        Preconditions.checkState((boolean)(fault instanceof SimulatorElementFault));
        SimulatorElementFault simFault = (SimulatorElementFault)fault;
        SimulatorElement elem = simFault.getElement();
        if (this.tiProbs == null) {
            this.calculateProbs();
            if (this.tiProbs == null) {
                return Double.NaN;
            }
        }
        switch (((PlotType)((Object)this.plotTypeParam.getValue())).ordinal()) {
            case 0: {
                ret = this.tiProbs.get(elem);
                break;
            }
            case 1: {
                ret = this.droughtProbs.get(elem);
                break;
            }
            case 2: {
                ret = this.afterProbs.get(elem);
                break;
            }
            case 3: {
                ret = this.droughtGain.get(elem);
                break;
            }
            default: {
                ret = Double.NaN;
            }
        }
        if (ret == null) {
            ret = Double.NaN;
        }
        return ret;
    }

    @Override
    public synchronized void setEvents(List<? extends SimulatorEvent> events) {
        this.events = events;
        this.clear();
    }

    @Override
    public synchronized void setGeometry(List<SimulatorElement> elements) {
        this.elements = elements;
        this.clear();
    }

    private void clear() {
        this.tiProbs = null;
        this.droughtProbs = null;
        this.afterProbs = null;
        this.droughtGain = null;
    }

    private synchronized void calculateProbs() {
        if (this.events == null || this.elements == null || this.events.size() < 2) {
            return;
        }
        System.out.println("Computing drought rates");
        CalcProgressBar progress = new CalcProgressBar("Loading Events", "Please Wait");
        progress.getMousePosition();
        progress.setVisible(true);
        progress.setIndeterminate(true);
        DroughtCalculator calc = new DroughtCalculator(this.elements, this.events, ((DroughtTypes)((Object)this.droughtTypeParam.getValue())).type);
        double droughtDuration = (Double)this.droughtDurationParam.getValue();
        double forecastMinMag = (Double)this.forecastMinMagParam.getValue();
        double forecastDuration = (Double)this.forecastDurationParam.getValue();
        this.tiProbs = calc.getElementTimeIndependentProbs(forecastMinMag, forecastDuration);
        this.droughtProbs = calc.getElementProbsDuringDrought(forecastMinMag, droughtDuration);
        this.afterProbs = calc.getElementProbAfterDroughtYears(forecastMinMag, droughtDuration, forecastDuration);
        this.droughtGain = new HashMap<SimulatorElement, Double>();
        for (SimulatorElement event : this.tiProbs.keySet()) {
            if (event == null || !this.afterProbs.containsKey(event)) continue;
            double difference = (this.afterProbs.get(event) - this.tiProbs.get(event)) / this.tiProbs.get(event);
            this.droughtGain.put(event, difference);
        }
        System.out.println("Done computing drought rates");
        progress.toFront();
        progress.setVisible(false);
        progress.dispose();
    }

    public void parameterChange(ParameterChangeEvent e) {
        if (e.getParameter() != this.plotTypeParam) {
            this.clear();
        }
        if (e.getNewValue().equals((Object)PlotType.DROUGHT_GAIN)) {
            this.setCPT(EQSimsDroughtColorer.getGainCPT(), true);
            this.droughtParamsParam.setValue(((DroughtTypes)((Object)this.droughtTypeParam.getValue())).type.getParameters());
        } else {
            this.setCPT(EQSimsDroughtColorer.getDefaultCPT(), true);
            this.droughtParamsParam.setValue(((DroughtTypes)((Object)this.droughtTypeParam.getValue())).type.getParameters());
        }
        this.fireColorerChangeEvent();
    }

    private static enum DroughtTypes {
        STATEWIDE((DroughtType)new CatalogMinMagDroughtType(7.5));

        private DroughtType type;

        private DroughtTypes(DroughtType type) {
            this.type = type;
        }

        public String toString() {
            return this.type.getName();
        }
    }

    private static enum PlotType {
        TIME_INDEPENDENT("Time-Independent"),
        DURING_DROUGHT("During Drought"),
        AFTER_DROUGHT("After Drought"),
        DROUGHT_GAIN("Drought Gain");

        private String name;

        private PlotType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

