/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.plugins.opensha.simulators;

import com.google.common.base.Joiner;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.primitives.Ints;
import java.awt.Color;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.constraint.impl.StringConstraint;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.impl.BooleanParameter;
import org.opensha.commons.param.impl.ButtonParameter;
import org.opensha.commons.param.impl.DoubleParameter;
import org.opensha.commons.param.impl.IntegerParameter;
import org.opensha.commons.param.impl.StringParameter;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.commons.util.cpt.CPT;
import org.opensha.commons.util.cpt.CPTVal;
import org.opensha.commons.util.cpt.LinearBlender;
import org.opensha.sha.simulators.SimulatorElement;
import org.opensha.sha.simulators.SimulatorEvent;
import org.opensha.sha.simulators.utils.General_EQSIM_Tools;
import org.scec.vtk.commons.opensha.faults.AbstractFaultSection;
import org.scec.vtk.commons.opensha.faults.anim.IDBasedFaultAnimation;
import org.scec.vtk.commons.opensha.faults.anim.TimeBasedFaultAnimation;
import org.scec.vtk.commons.opensha.faults.colorers.CPTBasedColorer;
import org.scec.vtk.commons.opensha.faults.colorers.FaultColorer;
import org.scec.vtk.commons.opensha.faults.faultSectionImpl.SimulatorElementFault;
import org.scec.vtk.commons.opensha.gui.EventManager;
import org.scec.vtk.main.MainGUI;
import org.scec.vtk.plugins.opensha.simulators.EQSimsEventListener;
import org.scec.vtk.tools.picking.PickEnabledActor;
import org.scec.vtk.tools.picking.PickHandler;
import vtk.vtkCellPicker;

public class EQSimsEventAnimColorer
extends CPTBasedColorer
implements TimeBasedFaultAnimation,
IDBasedFaultAnimation,
ParameterChangeListener,
EQSimsEventListener,
PickHandler<AbstractFaultSection> {
    private static final long serialVersionUID = 1L;
    private static String NAME = "Simulator Output Animation: slip (m) per event";
    private ArrayList<ChangeListener> listeners = new ArrayList();
    private EventManager eventManager;
    private List<? extends SimulatorEvent> unfilteredevents;
    private Map<Integer, Integer> idToUnfilteredStepMap;
    private List<Integer> filterIndexes;
    private LoadingCache<Integer, Map<Integer, Color>> eventColorCache;
    private int currentStep = -1;
    private static final String MAG_MIN_PARAM_NAME = "Min Mag";
    private static final Double MAG_PARAM_MIN = 0.0;
    private static final Double MAG_PARAM_MAX = 10.0;
    private static final Double MAG_MIN_PARAM_DEFAULT = MAG_PARAM_MIN;
    private DoubleParameter magMinParam = new DoubleParameter("Min Mag", MAG_PARAM_MIN, MAG_PARAM_MAX, MAG_MIN_PARAM_DEFAULT);
    private static final String MAG_MAX_PARAM_NAME = "Max Mag";
    private static final Double MAG_MAX_PARAM_DEFAULT = MAG_PARAM_MAX;
    private DoubleParameter magMaxParam = new DoubleParameter("Max Mag", MAG_PARAM_MIN, MAG_PARAM_MAX, MAG_MAX_PARAM_DEFAULT);
    private static final String SECT_FILTER_PARAM_NAME = "Only Events Involing";
    private static final String SECT_FILTER_PARAM_DEFAULT = "(all sections)";
    private StringParameter sectFilterParam;
    private static final String FAULT_FILTER_PARAM_NAME = "Filter By Fault";
    private static final String FAULT_FILTER_PARAM_DEFAULT = "(all faults)";
    private StringParameter faultFilterParam;
    private static final String CONTROL_CLICK_FILTER_PARAM_NAME = "Filter By Control+Clicking Elements";
    private ButtonParameter controlClickClearParam;
    private static final String SUPRA_SEISMOGENIC_FILTER_PARAM_NAME = "Only Supra-Seismogenic";
    private BooleanParameter supraSeismogenicFilterParam;
    private static final String START_ID_PARAM_NAME = "Start Event ID";
    private IntegerParameter startIDParam;
    private static final String DURATION_YEARS_PARAM_NAME = "Cat Duration To Animate (years)";
    private DoubleParameter durationYearsParam;
    private static final String FADE_YEARS_PARAM_NAME = "Fade Out Time (years)";
    private DoubleParameter fadeYearsParam;
    private Map<Integer, Color> fadeColors;
    private BooleanParameter onlyCurrentVisibleParam;
    private Map<Integer, HashSet<Integer>> faultMappings;
    private Map<String, Integer> faultNamesMap;
    private Map<String, Integer> sectNamesMap;
    private List<SimulatorElement> elements;
    private General_EQSIM_Tools tools;
    private List<SimulatorElement> controlClickedElements;
    private ParameterList animParams = new ParameterList();
    private PreloadThread preloadThread;
    private static final DecimalFormat magDF = new DecimalFormat("0.00");
    private LinearBlender colorBlender;

    private static CPT getDefaultCPT() {
        CPT cpt = new CPT();
        float delta = 1.6666666f;
        cpt.add((Object)new CPTVal(0.0f, new Color(0, 0, 255), delta * 1.0f, new Color(0, 255, 255)));
        cpt.add((Object)new CPTVal(delta * 1.0f, new Color(0, 255, 255), delta * 2.0f, new Color(0, 255, 0)));
        cpt.add((Object)new CPTVal(delta * 2.0f, new Color(0, 255, 0), delta * 3.0f, new Color(255, 255, 0)));
        cpt.add((Object)new CPTVal(delta * 3.0f, new Color(255, 255, 0), delta * 4.0f, new Color(255, 127, 0)));
        cpt.add((Object)new CPTVal(delta * 4.0f, new Color(255, 127, 0), delta * 5.0f, new Color(255, 0, 0)));
        cpt.add((Object)new CPTVal(delta * 5.0f, new Color(255, 0, 0), delta * 6.0f, new Color(255, 0, 255)));
        cpt.setBelowMinColor(new Color(0, 0, 255));
        cpt.setAboveMaxColor(new Color(255, 0, 255));
        cpt.setNanColor(new Color(127, 127, 127));
        return cpt;
    }

    public EQSimsEventAnimColorer() {
        super(EQSimsEventAnimColorer.getDefaultCPT(), false);
        this.animParams.addParameter((Parameter)this.magMinParam);
        this.magMinParam.addParameterChangeListener((ParameterChangeListener)this);
        this.animParams.addParameter((Parameter)this.magMaxParam);
        this.magMaxParam.addParameterChangeListener((ParameterChangeListener)this);
        ArrayList<String> strings = new ArrayList<String>();
        strings.add(SECT_FILTER_PARAM_DEFAULT);
        this.sectFilterParam = new StringParameter(SECT_FILTER_PARAM_NAME, strings, SECT_FILTER_PARAM_DEFAULT);
        this.animParams.addParameter((Parameter)this.sectFilterParam);
        this.sectFilterParam.addParameterChangeListener((ParameterChangeListener)this);
        strings = new ArrayList();
        strings.add(FAULT_FILTER_PARAM_DEFAULT);
        this.faultFilterParam = new StringParameter(FAULT_FILTER_PARAM_NAME, strings, FAULT_FILTER_PARAM_DEFAULT);
        this.animParams.addParameter((Parameter)this.faultFilterParam);
        this.faultFilterParam.addParameterChangeListener((ParameterChangeListener)this);
        this.controlClickClearParam = new ButtonParameter(CONTROL_CLICK_FILTER_PARAM_NAME, "temp");
        this.animParams.addParameter((Parameter)this.controlClickClearParam);
        this.controlClickClearParam.addParameterChangeListener((ParameterChangeListener)this);
        this.controlClickedElements = new ArrayList<SimulatorElement>();
        this.updateControlClickButtonText();
        this.supraSeismogenicFilterParam = new BooleanParameter(SUPRA_SEISMOGENIC_FILTER_PARAM_NAME, Boolean.valueOf(false));
        this.animParams.addParameter((Parameter)this.supraSeismogenicFilterParam);
        this.supraSeismogenicFilterParam.addParameterChangeListener((ParameterChangeListener)this);
        this.startIDParam = new IntegerParameter(START_ID_PARAM_NAME, Integer.valueOf(-1));
        this.animParams.addParameter((Parameter)this.startIDParam);
        this.startIDParam.addParameterChangeListener((ParameterChangeListener)this);
        this.durationYearsParam = new DoubleParameter(DURATION_YEARS_PARAM_NAME, 0.0, Double.POSITIVE_INFINITY, Double.valueOf(0.0));
        this.animParams.addParameter((Parameter)this.durationYearsParam);
        this.durationYearsParam.addParameterChangeListener((ParameterChangeListener)this);
        this.fadeYearsParam = new DoubleParameter(FADE_YEARS_PARAM_NAME, 0.0, Double.POSITIVE_INFINITY, Double.valueOf(0.0));
        this.animParams.addParameter((Parameter)this.fadeYearsParam);
        this.fadeYearsParam.addParameterChangeListener((ParameterChangeListener)this);
        this.onlyCurrentVisibleParam = new BooleanParameter("Hide Other Elements", Boolean.valueOf(false));
        this.animParams.addParameter((Parameter)this.onlyCurrentVisibleParam);
        this.onlyCurrentVisibleParam.addParameterChangeListener((ParameterChangeListener)this);
        this.eventColorCache = CacheBuilder.newBuilder().maximumSize(10000L).build((CacheLoader)new CacheLoader<Integer, Map<Integer, Color>>(){

            public Map<Integer, Color> load(Integer index) throws Exception {
                SimulatorEvent event = EQSimsEventAnimColorer.this.unfilteredevents.get(index);
                int[] ids = event.getAllElementIDs();
                double[] slips = event.getAllElementSlips();
                HashMap<Integer, Color> slipMap = new HashMap<Integer, Color>();
                for (int j = 0; ids != null && j < ids.length; ++j) {
                    int id = ids[j];
                    double slip = slips[j];
                    Color c = EQSimsEventAnimColorer.this.getColorForValue(slip);
                    slipMap.put(id, c);
                }
                return slipMap;
            }
        });
    }

    public void setEventManager(EventManager eventManager) {
        this.eventManager = eventManager;
    }

    @Override
    public double getValue(AbstractFaultSection fault) {
        return Double.NaN;
    }

    @Override
    public Color getColor(AbstractFaultSection fault) {
        if (!this.isStepValid(this.currentStep)) {
            return this.getCPT().getNanColor();
        }
        Color c = this.fadeColors != null ? this.fadeColors.get(fault.getId()) : this.getColorCacheForStep(this.currentStep).get(fault.getId());
        if (c == null) {
            return this.getCPT().getNanColor();
        }
        return c;
    }

    public String getName() {
        return NAME;
    }

    @Override
    public synchronized int getNumSteps() {
        if (this.unfilteredevents != null) {
            if (this.filterIndexes == null) {
                return this.unfilteredevents.size();
            }
            return this.filterIndexes.size();
        }
        return 0;
    }

    @Override
    public void setCurrentStep(int step) {
        this.currentStep = step;
        this.checkStartPreloadThread();
    }

    private synchronized Map<Integer, Color> getColorCacheForStep(int step) {
        if (this.unfilteredevents == null) {
            return null;
        }
        try {
            if (this.filterIndexes == null) {
                return (Map)this.eventColorCache.get((Object)step);
            }
            return (Map)this.eventColorCache.get((Object)this.filterIndexes.get(step));
        }
        catch (ExecutionException e) {
            throw ExceptionUtils.asRuntimeException((Throwable)e);
        }
    }

    private synchronized SimulatorEvent getEventForStep(int step) {
        if (this.unfilteredevents == null) {
            return null;
        }
        if (this.filterIndexes == null) {
            return this.unfilteredevents.get(step);
        }
        return this.unfilteredevents.get(this.filterIndexes.get(step));
    }

    @Override
    public void setCPT(CPT cpt) {
        super.setCPT(cpt);
        this.clearCache();
    }

    @Override
    public void setCPT(CPT cpt, boolean isLog) {
        super.setCPT(cpt, isLog);
        this.clearCache();
    }

    private void clearCache() {
        this.eventColorCache.invalidateAll();
    }

    private synchronized void checkStartPreloadThread() {
        if (this.preloadThread == null) {
            this.preloadThread = new PreloadThread();
            this.preloadThread.start();
        } else {
            if (this.preloadThread.isAlive()) {
                this.preloadThread.currentIteration = 0;
            }
            if (!this.preloadThread.isAlive()) {
                this.preloadThread = new PreloadThread();
                this.preloadThread.start();
            }
        }
    }

    @Override
    public void setCPTLog(boolean cptLog) {
        super.setCPTLog(cptLog);
        this.clearCache();
    }

    @Override
    public void setEvents(List<? extends SimulatorEvent> events) {
        this.unfilteredevents = events;
        this.idToUnfilteredStepMap = Maps.newHashMap();
        if (events != null) {
            for (int step = 0; step < events.size(); ++step) {
                this.idToUnfilteredStepMap.put(events.get(step).getID(), step);
            }
        }
        this.clearCache();
        this.filterEvents();
    }

    @Override
    public void addRangeChangeListener(ChangeListener l) {
        this.listeners.add(l);
    }

    @Override
    public void fireRangeChangeEvent() {
        ChangeEvent e = new ChangeEvent(this);
        for (ChangeListener l : this.listeners) {
            l.stateChanged(e);
        }
    }

    @Override
    public String getCurrentLabel() {
        if (!this.isStepValid(this.currentStep)) {
            return null;
        }
        SimulatorEvent event = this.getEventForStep(this.currentStep);
        return "Mag: " + magDF.format(event.getMagnitude());
    }

    private boolean isStepValid(int step) {
        return step >= 0 && this.unfilteredevents != null && step < this.getNumSteps();
    }

    @Override
    public double getTimeForStep(int step) {
        if (!this.isStepValid(step)) {
            return 0.0;
        }
        return this.getEventForStep(step).getTime();
    }

    @Override
    public ParameterList getAnimationParameters() {
        return this.animParams;
    }

    private void filterEvents() {
        try {
            this.eventManager.waitOnCalcThread();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.doFilterEvents();
    }

    private synchronized void doFilterEvents() {
        String faultFilterName;
        double minMag = (Double)this.magMinParam.getValue();
        double maxMag = (Double)this.magMaxParam.getValue();
        String sectFilterName = (String)this.sectFilterParam.getValue();
        int filterSectionID = !sectFilterName.equals(SECT_FILTER_PARAM_DEFAULT) ? this.sectNamesMap.get(sectFilterName) : -1;
        if (filterSectionID >= 0) {
            System.out.println("Filtering on sect id=" + filterSectionID);
        }
        HashSet<Integer> filterFault = !(faultFilterName = (String)this.faultFilterParam.getValue()).equals(FAULT_FILTER_PARAM_DEFAULT) ? this.faultMappings.get(this.faultNamesMap.get(faultFilterName)) : null;
        boolean supraSeis = (Boolean)this.supraSeismogenicFilterParam.getValue();
        double startTime = Double.NaN;
        double endTime = Double.NaN;
        if (this.startIDParam.getValue() != null && (Integer)this.startIDParam.getValue() >= 0) {
            Integer startStep = this.idToUnfilteredStepMap.get(this.startIDParam.getValue());
            if (startStep == null) {
                System.out.println("Warning: no event found with ID=" + String.valueOf(this.startIDParam.getValue()));
            } else {
                double duration = this.getCurrentDuration();
                startTime = this.unfilteredevents.get(startStep).getTime();
                endTime = startTime + duration;
            }
        }
        if (minMag > MAG_PARAM_MIN || maxMag < MAG_PARAM_MAX || filterSectionID >= 0 || filterFault != null || supraSeis || !Double.isNaN(startTime) || !this.controlClickedElements.isEmpty()) {
            this.filterIndexes = new ArrayList<Integer>();
            for (int i = 0; i < this.unfilteredevents.size(); ++i) {
                SimulatorEvent event = this.unfilteredevents.get(i);
                if (event.getMagnitude() < minMag || event.getMagnitude() > maxMag || filterSectionID >= 0 && !event.doesEventIncludeSection(filterSectionID) || filterFault != null && !event.doesEventIncludeFault(filterFault)) continue;
                if (!this.controlClickedElements.isEmpty()) {
                    boolean match = true;
                    HashSet rupElems = new HashSet(Ints.asList((int[])event.getAllElementIDs()));
                    for (SimulatorElement elem : this.controlClickedElements) {
                        if (rupElems.contains(elem.getID())) continue;
                        match = false;
                        break;
                    }
                    if (!match) continue;
                }
                if (supraSeis) {
                    if (this.tools == null) {
                        this.tools = new General_EQSIM_Tools(this.elements);
                    }
                    if (!this.tools.isEventSupraSeismogenic(event, Double.NaN)) continue;
                }
                if (!Double.isNaN(startTime)) {
                    if (event.getTime() < startTime) continue;
                    if (event.getTime() > endTime) break;
                }
                this.filterIndexes.add(i);
            }
            System.out.println("Filtered out " + (this.unfilteredevents.size() - this.filterIndexes.size()) + "/" + this.unfilteredevents.size());
            if (this.filterIndexes != null && this.filterIndexes.size() > 600000) {
                System.out.println("Only animating first 600000 events!");
                this.filterIndexes = this.filterIndexes.subList(0, 600000);
            }
        } else {
            this.filterIndexes = null;
        }
        this.fireColorerChangeEvent();
        this.checkStartPreloadThread();
        this.fireRangeChangeEvent();
        MainGUI.updateRenderWindow();
    }

    public void parameterChange(ParameterChangeEvent event) {
        if (event.getSource() == this.magMinParam) {
            this.filterEvents();
        } else if (event.getSource() == this.magMaxParam) {
            this.filterEvents();
        } else if (event.getSource() == this.sectFilterParam) {
            this.filterEvents();
        } else if (event.getSource() == this.faultFilterParam) {
            this.filterEvents();
        } else if (event.getSource() == this.supraSeismogenicFilterParam) {
            this.filterEvents();
        } else if (event.getSource() == this.startIDParam || event.getSource() == this.durationYearsParam) {
            this.filterEvents();
        } else if (event.getSource() == this.fadeYearsParam) {
            this.fadeColors = null;
            this.fireRangeChangeEvent();
        } else if (event.getSource() == this.onlyCurrentVisibleParam) {
            this.fireColorerChangeEvent();
        } else if (event.getSource() == this.controlClickClearParam) {
            this.controlClickedElements.clear();
            this.filterEvents();
        }
    }

    @Override
    public synchronized int getStepForID(int id) {
        Integer step = this.idToUnfilteredStepMap.get(id);
        if (step == null) {
            return -1;
        }
        int filterIndex = -1;
        if (this.filterIndexes == null) {
            return step;
        }
        filterIndex = this.filterIndexes.indexOf(step);
        if (filterIndex >= 0) {
            return filterIndex;
        }
        if (id > 0 && id <= this.unfilteredevents.size()) {
            this.magMinParam.setValue((Object)MAG_PARAM_MIN);
            this.magMinParam.getEditor().setParameter((Parameter)this.magMinParam);
            this.magMaxParam.setValue((Object)MAG_PARAM_MAX);
            this.magMaxParam.getEditor().setParameter((Parameter)this.magMaxParam);
            return step;
        }
        return -1;
    }

    @Override
    public synchronized int getIDForStep(int step) {
        if (this.filterIndexes == null && step >= 0 && this.unfilteredevents != null && step < this.unfilteredevents.size()) {
            return this.unfilteredevents.get(step).getID();
        }
        if (this.filterIndexes != null && step >= 0 && step < this.filterIndexes.size()) {
            return this.unfilteredevents.get(this.filterIndexes.get(step)).getID();
        }
        return -1;
    }

    @Override
    public Boolean getFaultVisibility(AbstractFaultSection fault) {
        if (((Boolean)this.onlyCurrentVisibleParam.getValue()).booleanValue()) {
            return !this.getColor(fault).equals(this.getCPT().getNanColor());
        }
        return null;
    }

    @Override
    public FaultColorer getFaultColorer() {
        return this;
    }

    private void updateSectionNames() {
        ArrayList strings = Lists.newArrayList();
        strings.add(SECT_FILTER_PARAM_DEFAULT);
        if (this.sectNamesMap != null && !this.sectNamesMap.isEmpty()) {
            ArrayList names = Lists.newArrayList(this.sectNamesMap.keySet());
            Collections.sort(names);
            strings.addAll(names);
        }
        StringConstraint sconst = (StringConstraint)this.sectFilterParam.getConstraint();
        this.sectFilterParam.setValue((Object)SECT_FILTER_PARAM_DEFAULT);
        sconst.setStrings(strings);
        this.sectFilterParam.getEditor().setParameter((Parameter)this.sectFilterParam);
    }

    private void updateFaultNames() {
        ArrayList strings = Lists.newArrayList();
        strings.add(FAULT_FILTER_PARAM_DEFAULT);
        if (this.faultNamesMap != null && !this.faultNamesMap.isEmpty()) {
            ArrayList names = Lists.newArrayList(this.faultNamesMap.keySet());
            Collections.sort(names);
            strings.addAll(names);
        }
        StringConstraint sconst = (StringConstraint)this.faultFilterParam.getConstraint();
        this.faultFilterParam.setValue((Object)FAULT_FILTER_PARAM_DEFAULT);
        sconst.setStrings(strings);
        this.faultFilterParam.getEditor().setParameter((Parameter)this.faultFilterParam);
    }

    @Override
    public boolean includeStepInLabel() {
        return true;
    }

    @Override
    public int getPreferredInitialStep() {
        return 0;
    }

    @Override
    public void setGeometry(List<SimulatorElement> elements) {
        this.faultMappings = null;
        this.faultNamesMap = null;
        this.sectNamesMap = null;
        this.tools = null;
        this.elements = elements;
        if (elements != null) {
            this.faultMappings = Maps.newHashMap();
            this.faultNamesMap = Maps.newHashMap();
            this.sectNamesMap = Maps.newHashMap();
            HashMap faultNames = Maps.newHashMap();
            for (SimulatorElement simulatorElement : elements) {
                Integer faultID;
                Integer sectID = simulatorElement.getSectionID();
                String sectName = simulatorElement.getSectionName();
                if (!this.sectNamesMap.containsKey(sectName)) {
                    this.sectNamesMap.put(sectName, sectID);
                }
                if ((faultID = Integer.valueOf(simulatorElement.getFaultID())) < 0) continue;
                HashSet<Integer> sectsForFault = this.faultMappings.get(faultID);
                if (sectsForFault == null) {
                    sectsForFault = new HashSet();
                    this.faultMappings.put(faultID, sectsForFault);
                    faultNames.put(faultID, new HashSet());
                }
                sectsForFault.add(sectID);
                ((HashSet)faultNames.get(faultID)).add(sectName);
            }
            int maxFaultID = 0;
            for (Integer faultID : this.faultMappings.keySet()) {
                if (faultID <= maxFaultID) continue;
                maxFaultID = faultID;
            }
            int n = ("" + maxFaultID).length();
            for (Integer faultID : this.faultMappings.keySet()) {
                HashSet names = (HashSet)faultNames.get(faultID);
                Object commonPrefix = "";
                block3: for (int i = 0; i < ((String)names.iterator().next()).length(); ++i) {
                    String start = null;
                    for (String name : names) {
                        if (start == null) {
                            start = "" + name.charAt(i);
                            continue;
                        }
                        if (name.charAt(i) == start.charAt(0)) continue;
                        break block3;
                    }
                    commonPrefix = (String)commonPrefix + start;
                }
                commonPrefix = ((String)commonPrefix).length() < 2 ? Joiner.on((String)",").join((Iterable)this.faultMappings.get(faultID)) : (String)commonPrefix + "*";
                String faultIDstr = "" + faultID;
                while (faultIDstr.length() < n) {
                    faultIDstr = "0" + faultIDstr;
                }
                this.faultNamesMap.put(faultIDstr + ". " + (String)commonPrefix, faultID);
            }
        }
        this.updateSectionNames();
        this.updateFaultNames();
    }

    @Override
    public double getCurrentDuration() {
        if (this.startIDParam.getValue() != null && (Integer)this.startIDParam.getValue() >= 0) {
            if ((Double)this.durationYearsParam.getValue() > 0.0) {
                return (Double)this.durationYearsParam.getValue() * 3.1536E7;
            }
            Integer startStep = this.idToUnfilteredStepMap.get(this.startIDParam.getValue());
            if (startStep != null) {
                return this.getTimeForStep(this.getNumSteps() - 1) - this.unfilteredevents.get(startStep).getTime();
            }
        }
        if (this.unfilteredevents != null) {
            return this.getTimeForStep(this.getNumSteps() - 1) - this.getTimeForStep(0);
        }
        return 0.0;
    }

    @Override
    public boolean timeChanged(double time) {
        Double fadeYears = (Double)this.fadeYearsParam.getValue();
        if (fadeYears == null || fadeYears == 0.0 || this.unfilteredevents == null) {
            return false;
        }
        if (this.colorBlender == null) {
            this.colorBlender = new LinearBlender();
        }
        Color nanColor = this.getCPT().getNanColor();
        HashMap fadeColors = Maps.newHashMap();
        for (int step = this.currentStep; step >= 0; --step) {
            SimulatorEvent event = this.getEventForStep(step);
            double stepTime = event.getTime();
            Map<Integer, Color> eventColors = this.getColorCacheForStep(step);
            double timeSinceYears = (time - stepTime) / 3.1536E7;
            if (timeSinceYears < 0.0) {
                timeSinceYears = 0.0;
            }
            if (timeSinceYears > fadeYears) break;
            double fade = timeSinceYears / fadeYears;
            for (Integer patchID : eventColors.keySet()) {
                if (fadeColors.containsKey(patchID)) continue;
                Color eventColor = eventColors.get(patchID);
                Color faded = this.colorBlender.blend(eventColor, nanColor, (float)fade);
                fadeColors.put(patchID, faded);
            }
        }
        this.fadeColors = fadeColors;
        return true;
    }

    private void updateControlClickButtonText() {
        if (this.controlClickedElements == null || this.controlClickedElements.isEmpty()) {
            this.controlClickClearParam.setButtonText("(control+click a fault to begin)");
            this.controlClickClearParam.getEditor().setEnabled(false);
        } else {
            this.controlClickClearParam.setButtonText(this.controlClickedElements.size() + " selected, click to clear");
            this.controlClickClearParam.getEditor().setEnabled(true);
        }
        this.controlClickClearParam.getEditor().refreshParamEditor();
    }

    @Override
    public void actorPicked(PickEnabledActor<AbstractFaultSection> actor, AbstractFaultSection reference, vtkCellPicker picker, MouseEvent e) {
        if (reference instanceof SimulatorElementFault) {
            SimulatorElementFault fault = (SimulatorElementFault)reference;
            if (e.getButton() == 1 && e.isControlDown()) {
                System.out.println("shift down, adding " + fault.getId());
                this.controlClickedElements.add(fault.getElement());
                this.updateControlClickButtonText();
                this.filterEvents();
            }
        }
    }

    private class PreloadThread
    extends Thread {
        final int preload_num = 100;
        final long sleep_time_millis = 500L;
        final int max_iterations = 200;
        private int currentIteration = 0;

        private PreloadThread() {
        }

        @Override
        public void run() {
            while (this.currentIteration < 200) {
                if (EQSimsEventAnimColorer.this.currentStep >= 0) {
                    int step;
                    if (EQSimsEventAnimColorer.this.unfilteredevents == null) continue;
                    for (int i = 0; i < 100 && EQSimsEventAnimColorer.this.isStepValid(step = EQSimsEventAnimColorer.this.currentStep + i); ++i) {
                        EQSimsEventAnimColorer.this.getColorCacheForStep(step);
                    }
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++this.currentIteration;
            }
        }
    }
}

