/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.plugins.opensha.simulators;

import com.google.common.base.Preconditions;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.opensha.commons.mapping.gmt.elements.GMT_CPT_Files;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.impl.DoubleParameter;
import org.opensha.commons.param.impl.EnumParameter;
import org.opensha.commons.param.impl.FileParameter;
import org.opensha.commons.param.impl.IntegerParameter;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.commons.util.cpt.CPT;
import org.opensha.sha.simulators.RSQSimEvent;
import org.opensha.sha.simulators.SimulatorElement;
import org.opensha.sha.simulators.SimulatorEvent;
import org.opensha.sha.simulators.srf.RSQSimEventSlipTimeFunc;
import org.opensha.sha.simulators.srf.RSQSimStateTransitionFileReader;
import org.scec.vtk.commons.opensha.faults.AbstractFaultSection;
import org.scec.vtk.commons.opensha.faults.anim.TimeBasedFaultAnimation;
import org.scec.vtk.commons.opensha.faults.colorers.CPTBasedColorer;
import org.scec.vtk.commons.opensha.faults.colorers.FaultColorer;
import org.scec.vtk.plugins.opensha.simulators.EQSimsEventListener;

public class EQSimsEventSlipAnim
extends CPTBasedColorer
implements TimeBasedFaultAnimation,
EQSimsEventListener,
ParameterChangeListener {
    private static DisplayType DISPLAY_TYPE_DEFAULT = DisplayType.CUMULATIVE_SLIP;
    private EnumParameter<DisplayType> displayParam;
    private IntegerParameter eventIDParam;
    private FileParameter transFileParam;
    private DoubleParameter slipVelParam;
    private ParameterList paramList;
    private List<SimulatorElement> elements;
    private List<? extends SimulatorEvent> events;
    private RSQSimEvent curEvent;
    private RSQSimEventSlipTimeFunc curSlipTimeFunc;
    private RSQSimStateTransitionFileReader transReader;
    private double curTime;
    private CPT slipCPT = null;
    private boolean slipCPTlog = false;
    private CPT velCPT = null;
    private boolean velCPTlog = false;
    private ArrayList<ChangeListener> listeners = new ArrayList();

    private static CPT getDefaultSlipCPT() {
        try {
            CPT cpt = GMT_CPT_Files.MAX_SPECTRUM.instance().rescale(0.0, 10.0);
            cpt.setNanColor(Color.GRAY);
            return cpt;
        }
        catch (IOException e) {
            throw ExceptionUtils.asRuntimeException((Throwable)e);
        }
    }

    private static CPT getDefaultVelocityCPT() {
        try {
            CPT cpt = GMT_CPT_Files.MAX_SPECTRUM.instance().rescale(0.0, 1.0);
            cpt.setNanColor(Color.GRAY);
            return cpt;
        }
        catch (IOException e) {
            throw ExceptionUtils.asRuntimeException((Throwable)e);
        }
    }

    private static CPT getDefaultCPT() {
        switch (DISPLAY_TYPE_DEFAULT.ordinal()) {
            case 0: {
                return EQSimsEventSlipAnim.getDefaultSlipCPT();
            }
            case 1: {
                return EQSimsEventSlipAnim.getDefaultVelocityCPT();
            }
        }
        throw new IllegalStateException("Unknown display type: " + String.valueOf((Object)DISPLAY_TYPE_DEFAULT));
    }

    public EQSimsEventSlipAnim() {
        super(EQSimsEventSlipAnim.getDefaultCPT(), false);
        this.paramList = new ParameterList();
        this.transFileParam = new FileParameter("Trans. File");
        this.transFileParam.addParameterChangeListener((ParameterChangeListener)this);
        this.paramList.addParameter((Parameter)this.transFileParam);
        this.displayParam = new EnumParameter("Display Type", EnumSet.allOf(DisplayType.class), (Enum)DISPLAY_TYPE_DEFAULT, null);
        this.displayParam.addParameterChangeListener((ParameterChangeListener)this);
        this.paramList.addParameter(this.displayParam);
        this.eventIDParam = new IntegerParameter("Event ID");
        this.eventIDParam.setValue((Object)-1);
        this.eventIDParam.addParameterChangeListener((ParameterChangeListener)this);
        this.paramList.addParameter((Parameter)this.eventIDParam);
        this.slipVelParam = new DoubleParameter("Slip Velocity", 0.0, Double.POSITIVE_INFINITY);
        this.slipVelParam.setValue(1.0);
        this.slipVelParam.setUnits("m/s");
        this.slipVelParam.addParameterChangeListener((ParameterChangeListener)this);
        this.paramList.addParameter((Parameter)this.slipVelParam);
    }

    public void setInitialDir(File dir) {
        this.transFileParam.setDefaultInitialDir(dir);
    }

    @Override
    public void addRangeChangeListener(ChangeListener l) {
        this.listeners.add(l);
    }

    @Override
    public int getNumSteps() {
        if (this.curSlipTimeFunc == null) {
            return 0;
        }
        return 2;
    }

    @Override
    public void setCurrentStep(int step) {
    }

    @Override
    public int getPreferredInitialStep() {
        return 0;
    }

    @Override
    public boolean includeStepInLabel() {
        return false;
    }

    @Override
    public String getCurrentLabel() {
        return null;
    }

    @Override
    public ParameterList getAnimationParameters() {
        return this.paramList;
    }

    @Override
    public Boolean getFaultVisibility(AbstractFaultSection fault) {
        return null;
    }

    @Override
    public FaultColorer getFaultColorer() {
        return this;
    }

    @Override
    public void fireRangeChangeEvent() {
        ChangeEvent e = new ChangeEvent(this);
        for (ChangeListener l : this.listeners) {
            l.stateChanged(e);
        }
    }

    public String getName() {
        return "RSQSim Rup Slip/Time Animation";
    }

    @Override
    public void setEvents(List<? extends SimulatorEvent> events) {
        this.events = events;
        this.eventChanged();
    }

    @Override
    public void setGeometry(List<SimulatorElement> elements) {
        this.elements = elements;
    }

    @Override
    public double getTimeForStep(int step) {
        this.checkCalcSlipFunc();
        if (step < 0 || this.curSlipTimeFunc == null) {
            return 0.0;
        }
        Preconditions.checkState((step <= 1 ? 1 : 0) != 0, (Object)"Should either be -1, 0, or 1");
        if (step == 0) {
            return 0.0;
        }
        return this.curSlipTimeFunc.getEndTime() - this.curSlipTimeFunc.getStartTime();
    }

    @Override
    public double getCurrentDuration() {
        this.checkCalcSlipFunc();
        if (this.curSlipTimeFunc != null) {
            return this.curSlipTimeFunc.getEndTime() - this.curSlipTimeFunc.getStartTime();
        }
        return 0.0;
    }

    @Override
    public boolean timeChanged(double time) {
        this.curTime = time;
        return true;
    }

    @Override
    public double getValue(AbstractFaultSection fault) {
        this.checkCalcSlipFunc();
        if (this.curSlipTimeFunc == null) {
            return Double.NaN;
        }
        switch (((DisplayType)((Object)this.displayParam.getValue())).ordinal()) {
            case 0: {
                return this.curSlipTimeFunc.getCumulativeEventSlip(fault.getId(), this.curSlipTimeFunc.getStartTime() + this.curTime);
            }
            case 1: {
                return this.curSlipTimeFunc.getVelocity(fault.getId(), this.curSlipTimeFunc.getStartTime() + this.curTime);
            }
        }
        throw new IllegalStateException();
    }

    private synchronized void checkCalcSlipFunc() {
        if (this.curSlipTimeFunc != null || this.curEvent == null || this.transReader == null) {
            return;
        }
        try {
            Map trans = this.transReader.getTransitions(this.curEvent);
            System.out.println("Loaded " + trans.size() + " transitions for event " + this.curEvent.getID());
            int numActualTrans = 0;
            for (List list : trans.values()) {
                numActualTrans += list.size();
            }
            System.out.println("Loaded " + numActualTrans + " actual values");
            this.curSlipTimeFunc = new RSQSimEventSlipTimeFunc(trans);
            System.out.println("Time range: " + this.curSlipTimeFunc.getStartTime() + " " + this.curSlipTimeFunc.getEndTime());
            this.curSlipTimeFunc = this.curSlipTimeFunc.asRelativeTimeFunc();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Error calculating/loading slip time function", e.getMessage(), 0);
        }
    }

    public void parameterChange(ParameterChangeEvent event) {
        if (event.getParameter() == this.transFileParam) {
            this.transFileChanged();
        } else if (event.getParameter() == this.eventIDParam) {
            this.eventChanged();
        } else if (event.getParameter() == this.slipVelParam) {
            this.curSlipTimeFunc = null;
            this.fireColorerChangeEvent();
        } else if (event.getParameter() == this.displayParam) {
            if (this.displayParam.getValue() == DisplayType.CUMULATIVE_SLIP) {
                this.velCPT = this.getCPT();
                this.velCPTlog = this.isCPTLog();
                if (this.slipCPT == null) {
                    this.slipCPT = EQSimsEventSlipAnim.getDefaultSlipCPT();
                    this.slipCPTlog = false;
                }
                this.setCPT(this.slipCPT, this.slipCPTlog);
            } else if (this.displayParam.getValue() == DisplayType.VELOCITY) {
                this.slipCPT = this.getCPT();
                this.slipCPTlog = this.isCPTLog();
                if (this.velCPT == null) {
                    this.velCPT = EQSimsEventSlipAnim.getDefaultVelocityCPT();
                    this.velCPTlog = false;
                }
                this.setCPT(this.velCPT, this.velCPTlog);
            } else {
                throw new IllegalStateException();
            }
            this.fireColorerChangeEvent();
        }
    }

    private void eventChanged() {
        this.curEvent = null;
        this.curSlipTimeFunc = null;
        int eventID = (Integer)this.eventIDParam.getValue();
        if (eventID >= 0 && this.events != null) {
            for (SimulatorEvent simulatorEvent : this.events) {
                if (simulatorEvent.getID() != eventID) continue;
                System.out.println("Found a match: M" + (float)simulatorEvent.getMagnitude() + " at " + (float)simulatorEvent.getTimeInYears());
                Preconditions.checkState((boolean)(simulatorEvent instanceof RSQSimEvent), (Object)"Must be an RSQSim event");
                this.curEvent = (RSQSimEvent)simulatorEvent;
                break;
            }
        }
        this.fireRangeChangeEvent();
    }

    private void transFileChanged() {
        this.transReader = null;
        this.curSlipTimeFunc = null;
        File file = (File)this.transFileParam.getValue();
        if (file != null) {
            try {
                this.transReader = new RSQSimStateTransitionFileReader(file, this.elements);
                if (this.transReader.getVersion() == RSQSimStateTransitionFileReader.TransVersion.ORIGINAL) {
                    HashMap<Integer, Double> slipVels = new HashMap<Integer, Double>();
                    for (SimulatorElement elem : this.elements) {
                        slipVels.put(elem.getID(), (Double)this.slipVelParam.getValue());
                    }
                    this.transReader.setPatchFixedVelocities(slipVels);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.fireRangeChangeEvent();
    }

    private static enum DisplayType {
        CUMULATIVE_SLIP("Cumulative Slip (m)"),
        VELOCITY("Slip Velocity (m/s)");

        private String name;

        private DisplayType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

