/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.plugins.opensha.simulators;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.awt.Color;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.JOptionPane;
import org.apache.commons.math3.stat.StatUtils;
import org.opensha.commons.data.CSVFile;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.DefaultXY_DataSet;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.data.function.HistogramFunction;
import org.opensha.commons.gui.plot.GraphWindow;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.commons.gui.plot.PlotSpec;
import org.opensha.commons.mapping.gmt.elements.GMT_CPT_Files;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.impl.BooleanParameter;
import org.opensha.commons.param.impl.DoubleParameter;
import org.opensha.commons.param.impl.EnumParameter;
import org.opensha.commons.param.impl.FileParameter;
import org.opensha.commons.util.cpt.CPT;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import org.opensha.sha.simulators.SimulatorElement;
import org.opensha.sha.simulators.SimulatorEvent;
import org.opensha.sha.simulators.iden.ElementIden;
import org.opensha.sha.simulators.iden.FaultIDIden;
import org.opensha.sha.simulators.iden.MagRangeRuptureIdentifier;
import org.opensha.sha.simulators.iden.SectionIDIden;
import org.opensha.sha.simulators.utils.SimulatorUtils;
import org.scec.vtk.commons.opensha.faults.AbstractFaultSection;
import org.scec.vtk.commons.opensha.faults.colorers.CPTBasedColorer;
import org.scec.vtk.commons.opensha.faults.faultSectionImpl.SimulatorElementFault;
import org.scec.vtk.plugins.opensha.simulators.EQSimsEventListener;
import org.scec.vtk.tools.picking.PickEnabledActor;
import org.scec.vtk.tools.picking.PickHandler;
import vtk.vtkCellPicker;

public class EQSimsParticipationColorer
extends CPTBasedColorer
implements EQSimsEventListener,
ParameterChangeListener,
PickHandler<AbstractFaultSection> {
    private DoubleParameter magMinParam;
    private static final double MIN_MAG_DEFAULT = 6.5;
    private static final double MAX_MAG_DEFAULT = 10.0;
    private DoubleParameter magMaxParam;
    private double minMag = 6.5;
    private double maxMag = 10.0;
    private double minEventMag;
    private double maxEventMag;
    private BooleanParameter probabilityParam;
    private DoubleParameter probDurationParam;
    private FileParameter csvComparisonParam;
    private List<DiscretizedFunc> comparisonCumMFDs;
    private HashMap<Integer, Double> comparisonRates;
    private static final String PLOT_TYPE_PARAM_NAME = "Plot Type";
    private static final PlotType PLOT_TYPE_DEFAULT = PlotType.CATALOG;
    private EnumParameter<PlotType> plotTypeParam;
    private ParameterList params;
    private List<? extends SimulatorEvent> events;
    private HashMap<Integer, SimulatorEvent> eventsMap;
    protected HashMap<Integer, Double> rates;
    private List<SimulatorElement> elements;
    private int minElemIndex = Integer.MAX_VALUE;
    private int maxElemIndex = -1;
    private int minSectIndex = Integer.MAX_VALUE;
    private int maxSectIndex = -1;
    private int myNumSects = -1;
    private CPT rateCPT;
    private boolean rateCPTLog;
    private CPT ratioCPT = EQSimsParticipationColorer.getDefaultRatioCPT();
    private boolean ratioCPTLog = true;

    private static CPT getDefaultRateCPT() {
        try {
            CPT cpt = GMT_CPT_Files.MAX_SPECTRUM.instance();
            cpt = cpt.rescale(-6.0, -2.0);
            cpt.setNanColor(Color.GRAY);
            return cpt;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static CPT getDefaultRatioCPT() {
        try {
            CPT cpt = GMT_CPT_Files.UCERF3_RATIOS.instance();
            cpt = cpt.rescale(-3.0, 3.0);
            cpt.setNanColor(Color.GRAY);
            return cpt;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public EQSimsParticipationColorer() {
        super(EQSimsParticipationColorer.getDefaultRateCPT(), true);
        this.rateCPT = this.getCPT();
        this.rateCPTLog = this.isCPTLog();
        this.params = new ParameterList();
        this.magMinParam = new DoubleParameter("Min Mag", 0.0, 10.0);
        this.magMinParam.setValue(6.5);
        this.magMinParam.addParameterChangeListener((ParameterChangeListener)this);
        this.params.addParameter((Parameter)this.magMinParam);
        this.magMaxParam = new DoubleParameter("Max Mag", 0.0, 10.0);
        this.magMaxParam.setValue(10.0);
        this.magMaxParam.addParameterChangeListener((ParameterChangeListener)this);
        this.params.addParameter((Parameter)this.magMaxParam);
        this.probabilityParam = new BooleanParameter("Probabilities", Boolean.valueOf(false));
        this.probabilityParam.addParameterChangeListener((ParameterChangeListener)this);
        this.probabilityParam.setInfo("If selected, Poisson probabilities with the given duration. Otherwise annualized rates");
        this.params.addParameter((Parameter)this.probabilityParam);
        this.probDurationParam = new DoubleParameter("Duration", 0.0027378507871321013, 100000.0, "Years");
        this.probDurationParam.setValue(50.0);
        this.probDurationParam.addParameterChangeListener((ParameterChangeListener)this);
        this.params.addParameter((Parameter)this.probDurationParam);
        this.csvComparisonParam = new FileParameter("U3 CSV For Comparison");
        this.csvComparisonParam.addParameterChangeListener((ParameterChangeListener)this);
        this.params.addParameter((Parameter)this.csvComparisonParam);
        this.plotTypeParam = new EnumParameter(PLOT_TYPE_PARAM_NAME, EnumSet.allOf(PlotType.class), (Enum)PLOT_TYPE_DEFAULT, null);
        this.plotTypeParam.addParameterChangeListener((ParameterChangeListener)this);
        this.plotTypeParam.getEditor().setEnabled(false);
        this.params.addParameter(this.plotTypeParam);
    }

    public String getName() {
        return "Simulator Participation Rates";
    }

    @Override
    public double getValue(AbstractFaultSection fault) {
        return this.getValue(fault.getId());
    }

    public double getValue(int id) {
        switch (((PlotType)((Object)this.plotTypeParam.getValue())).ordinal()) {
            case 0: {
                double simRate = this.getSimulator(id);
                return this.getProbIfApplicable(simRate);
            }
            case 1: {
                double u3Rate = this.getUCER3(id);
                return this.getProbIfApplicable(u3Rate);
            }
            case 2: {
                double simRate = this.getSimulator(id);
                double u3Rate = this.getUCER3(id);
                return simRate / u3Rate;
            }
        }
        throw new IllegalStateException("Unknown plot type!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double getSimulator(int id) {
        Double rate;
        if (this.events == null) {
            return Double.NaN;
        }
        if (this.rates == null) {
            EQSimsParticipationColorer eQSimsParticipationColorer = this;
            synchronized (eQSimsParticipationColorer) {
                if (this.rates == null) {
                    this.updateCache();
                }
            }
        }
        if ((rate = this.rates.get(id)) == null) {
            return 0.0;
        }
        return rate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double getUCER3(int id) {
        if (this.comparisonCumMFDs == null) {
            return Double.NaN;
        }
        if (this.comparisonRates == null) {
            EQSimsParticipationColorer eQSimsParticipationColorer = this;
            synchronized (eQSimsParticipationColorer) {
                if (this.comparisonRates == null) {
                    this.updateComparisonCache();
                }
            }
        }
        if (this.comparisonRates == null) {
            return Double.NaN;
        }
        return this.comparisonRates.get(id);
    }

    private double getProbIfApplicable(double rate) {
        if (((Boolean)this.probabilityParam.getValue()).booleanValue()) {
            double duration = (Double)this.probDurationParam.getValue();
            double prob = 1.0 - Math.exp(-rate * duration);
            return prob;
        }
        return rate;
    }

    @Override
    public void setEvents(List<? extends SimulatorEvent> events) {
        this.events = events;
        this.eventsMap = Maps.newHashMap();
        if (events == null || events.isEmpty()) {
            this.minEventMag = 0.0;
            this.maxEventMag = 0.0;
        } else {
            this.minEventMag = Double.MAX_VALUE;
            this.maxEventMag = 0.0;
            for (SimulatorEvent simulatorEvent : events) {
                double mag = simulatorEvent.getMagnitude();
                if (mag < this.minEventMag) {
                    this.minEventMag = mag;
                }
                if (mag > this.maxEventMag) {
                    this.maxEventMag = mag;
                }
                this.eventsMap.put(simulatorEvent.getID(), simulatorEvent);
            }
        }
        this.rates = null;
    }

    double getMinEventMag() {
        return this.minEventMag;
    }

    double getMaxEventMag() {
        return this.maxEventMag;
    }

    void clearCache() {
        this.rates = null;
        this.comparisonRates = null;
    }

    synchronized void updateCache() {
        if (this.events == null) {
            return;
        }
        this.rates = new HashMap();
        if (this.events.isEmpty()) {
            return;
        }
        double years = SimulatorUtils.getSimulationDurationYears(this.events);
        double rate = 1.0 / years;
        System.out.println("Updating participation rates! Time span: " + years + " years. Rate/event: " + rate);
        System.out.println("Num events: " + this.events.size());
        int eventCount = 0;
        for (SimulatorEvent simulatorEvent : this.events) {
            double mag = simulatorEvent.getMagnitude();
            if (!this.isWithinMagRange(mag)) continue;
            int[] nArray = simulatorEvent.getAllElementIDs();
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                Integer elementID = nArray[i];
                Double val = this.rates.get(elementID);
                val = val == null ? Double.valueOf(rate) : Double.valueOf(val + rate);
                this.rates.put(elementID, val);
            }
            ++eventCount;
        }
        System.out.println("Found " + eventCount + " events in the given range");
    }

    synchronized void updateComparisonCache() {
        if (this.comparisonCumMFDs == null || this.elements == null) {
            return;
        }
        if (!this.validateComparisonCSV()) {
            return;
        }
        this.comparisonRates = Maps.newHashMap();
        for (SimulatorElement elem : this.elements) {
            int sectID = elem.getSectionID() - this.minSectIndex;
            DiscretizedFunc mfd = this.comparisonCumMFDs.get(sectID);
            double val = mfd.getInterpolatedY_inLogYDomain(this.minMag);
            this.comparisonRates.put(elem.getID(), val);
        }
    }

    boolean isWithinMagRange(double mag) {
        return mag >= this.minMag && mag < this.maxMag;
    }

    private void safeDisablePlotType() {
        this.plotTypeParam.getEditor().setEnabled(false);
        if (this.plotTypeParam.getValue() != PlotType.CATALOG) {
            this.plotTypeParam.setValue((Object)PlotType.CATALOG);
        }
    }

    public void parameterChange(ParameterChangeEvent event) {
        if (event.getParameter() == this.magMinParam || event.getParameter() == this.magMaxParam) {
            this.minMag = (Double)this.magMinParam.getValue();
            this.maxMag = (Double)this.magMaxParam.getValue();
            this.clearCache();
            this.fireColorerChangeEvent();
        } else if (event.getParameter() == this.probabilityParam || event.getParameter() == this.probDurationParam) {
            this.probDurationParam.getEditor().setEnabled(((Boolean)this.probabilityParam.getValue()).booleanValue());
            this.fireColorerChangeEvent();
        } else if (event.getParameter() == this.csvComparisonParam) {
            CSVFile csv;
            this.comparisonCumMFDs = null;
            File csvFile = (File)this.csvComparisonParam.getValue();
            if (csvFile == null) {
                this.safeDisablePlotType();
                return;
            }
            try {
                csv = CSVFile.readFile((File)csvFile, (boolean)true);
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(null, e.getMessage(), "Error opening CSV", 0);
                this.safeDisablePlotType();
                return;
            }
            int startCol = 3;
            ArrayList<Double> mags = new ArrayList<Double>();
            this.comparisonCumMFDs = new ArrayList<DiscretizedFunc>();
            for (int col = 3; col < csv.getNumCols(); ++col) {
                mags.add(Double.parseDouble((String)csv.get(0, col)));
            }
            for (int row = 1; row < csv.getNumRows(); ++row) {
                int index = Integer.parseInt((String)csv.get(row, 0));
                Preconditions.checkState((index == this.comparisonCumMFDs.size() ? 1 : 0) != 0, (Object)"File out of order!");
                ArbitrarilyDiscretizedFunc func = new ArbitrarilyDiscretizedFunc();
                for (int i = 0; i < mags.size(); ++i) {
                    func.set(((Double)mags.get(i)).doubleValue(), Double.parseDouble((String)csv.get(row, 3 + i)));
                }
                this.comparisonCumMFDs.add((DiscretizedFunc)func);
            }
            this.plotTypeParam.getEditor().setEnabled(true);
        } else if (event.getParameter() == this.plotTypeParam) {
            if (this.plotTypeParam.getValue() == PlotType.CATALOG || this.plotTypeParam.getValue() == PlotType.UCERF3) {
                if (event.getOldValue().equals((Object)PlotType.RATIO)) {
                    this.ratioCPT = this.getCPT();
                    this.ratioCPTLog = this.isCPTLog();
                    this.setCPT(this.rateCPT, this.rateCPTLog);
                }
            } else {
                this.rateCPT = this.getCPT();
                this.rateCPTLog = this.isCPTLog();
                this.setCPT(this.ratioCPT, this.ratioCPTLog);
            }
            this.fireColorerChangeEvent();
        }
    }

    protected List<? extends SimulatorEvent> getEvents() {
        return this.events;
    }

    protected SimulatorEvent getEvent(int id) {
        return this.eventsMap.get(id);
    }

    @Override
    public ParameterList getColorerParameters() {
        return this.params;
    }

    @Override
    public void setGeometry(List<SimulatorElement> elements) {
        this.elements = elements;
        this.minElemIndex = Integer.MAX_VALUE;
        this.maxElemIndex = -1;
        this.minSectIndex = Integer.MAX_VALUE;
        this.maxSectIndex = -1;
        if (elements != null) {
            for (SimulatorElement elem : elements) {
                int s;
                int e = elem.getID();
                if (e < this.minElemIndex) {
                    this.minElemIndex = e;
                }
                if (e > this.maxElemIndex) {
                    this.maxElemIndex = e;
                }
                if ((s = elem.getSectionID()) < 0) continue;
                if (s < this.minSectIndex) {
                    this.minSectIndex = s;
                }
                if (s <= this.maxSectIndex) continue;
                this.maxSectIndex = s;
            }
            this.myNumSects = this.maxSectIndex - this.minSectIndex + 1;
        } else {
            this.myNumSects = -1;
        }
    }

    private boolean validateComparisonCSV() {
        if (this.myNumSects != this.comparisonCumMFDs.size()) {
            JOptionPane.showMessageDialog(null, "Section count mismatch. CSV has " + this.comparisonCumMFDs.size() + ", geom file has " + this.myNumSects, "Can't use comparison CSV", 0);
            this.csvComparisonParam.setValue(null);
            this.csvComparisonParam.getEditor().refreshParamEditor();
            return false;
        }
        return true;
    }

    @Override
    public void actorPicked(PickEnabledActor<AbstractFaultSection> actor, AbstractFaultSection reference, vtkCellPicker picker, MouseEvent e) {
        double deltaMag;
        int numMag;
        int faultID;
        int sectID;
        int clickCount = e.getClickCount();
        if (this.events == null || this.events.isEmpty() || clickCount < 2 || e.getButton() != 1 || !(reference instanceof SimulatorElementFault)) {
            return;
        }
        ArrayList recurrenceMags = Lists.newArrayList((Object[])new Double[]{6.0, 6.5, 7.0, 7.5});
        if (!recurrenceMags.contains(this.magMinParam.getValue())) {
            recurrenceMags.add((Double)this.magMinParam.getValue());
        }
        Collections.sort(recurrenceMags);
        SimulatorElementFault elementFault = (SimulatorElementFault)reference;
        SimulatorElement element = elementFault.getElement();
        ArrayList names = Lists.newArrayList();
        ArrayList eventLists = Lists.newArrayList();
        ArrayList comparisonMFDs = Lists.newArrayList();
        int elemID = element.getID();
        List matches = new ElementIden("" + elemID, elemID).getMatches(this.events);
        if (!matches.isEmpty()) {
            names.add("Elem " + elemID);
            eventLists.add(matches);
            comparisonMFDs.add(null);
        }
        if ((sectID = element.getSectionID()) >= 0 && !(matches = new SectionIDIden("" + sectID, this.elements, sectID).getMatches(this.events)).isEmpty()) {
            names.add("Sect " + sectID + ": " + element.getSectionName());
            eventLists.add(matches);
            if (this.comparisonCumMFDs != null) {
                System.out.println("Min: " + this.minSectIndex);
                System.out.println("Max: " + this.maxSectIndex);
                System.out.println("File: " + this.comparisonCumMFDs.size());
                if (this.validateComparisonCSV()) {
                    comparisonMFDs.add(this.comparisonCumMFDs.get(sectID - this.minSectIndex));
                } else {
                    comparisonMFDs.add(null);
                }
            } else {
                comparisonMFDs.add(null);
            }
        }
        if ((faultID = element.getFaultID()) >= 0 && !(matches = new FaultIDIden("" + sectID, this.elements, faultID).getMatches(this.events)).isEmpty()) {
            names.add("Parent " + faultID);
            eventLists.add(matches);
            comparisonMFDs.add(null);
        }
        if (names.isEmpty()) {
            return;
        }
        GraphWindow graph = null;
        double duration = this.events.get(this.events.size() - 1).getTimeInYears() - this.events.get(0).getTimeInYears();
        double eventMinMag = Double.POSITIVE_INFINITY;
        for (SimulatorEvent simulatorEvent : this.events) {
            if (!(simulatorEvent.getMagnitude() < eventMinMag)) continue;
            eventMinMag = simulatorEvent.getMagnitude();
        }
        double minMag = Math.floor(eventMinMag);
        if (minMag > 5.0) {
            minMag = 5.0;
        }
        Preconditions.checkState(((numMag = (int)((9.0 - minMag) / (deltaMag = 0.1) + 0.5)) > 1 ? 1 : 0) != 0, (Object)("Bad numMag=" + numMag + ", minMag=" + minMag));
        minMag += 0.5 * deltaMag;
        for (int i = 0; i < names.size(); ++i) {
            String name = (String)names.get(i);
            List events = (List)eventLists.get(i);
            IncrementalMagFreqDist mfd = EQSimsParticipationColorer.calcMFD(events, duration, minMag, numMag, deltaMag);
            mfd.setName("Incremental MFD");
            mfd.setInfo(" ");
            EvenlyDiscretizedFunc cumMFD = mfd.getCumRateDistWithOffset();
            cumMFD.setName("Cumulative MFD");
            cumMFD.setInfo(" ");
            ArrayList<Object> funcs = new ArrayList<Object>();
            ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
            funcs.add(mfd);
            chars.add(new PlotCurveCharacterstics(PlotLineType.HISTOGRAM, 1.0f, Color.BLUE));
            funcs.add(cumMFD);
            chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLACK));
            DiscretizedFunc compMFD = (DiscretizedFunc)comparisonMFDs.get(i);
            if (compMFD != null) {
                funcs.add(compMFD);
                compMFD.setName("U3 Comparison");
                chars.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 2.0f, Color.RED));
            }
            PlotSpec spec = new PlotSpec(funcs, chars, name + " MFD", "Magnitude", "Participation Rate (1/yr)");
            spec.setLegendVisible(true);
            if (graph == null) {
                graph = new GraphWindow(spec, false);
            } else {
                graph.addTab(spec);
            }
            graph.setYLog(true);
            graph.setAxisRange(6.0, 9.0, 1.0E-10, 0.1);
            Iterator iterator = recurrenceMags.iterator();
            while (iterator.hasNext()) {
                double riMag = (Double)iterator.next();
                List riEvents = new MagRangeRuptureIdentifier(riMag, 10.0).getMatches(events);
                if (riEvents.size() < 3) continue;
                double[] ris = new double[riEvents.size() - 1];
                for (int r = 0; r < riEvents.size() - 1; ++r) {
                    ris[r] = ((SimulatorEvent)riEvents.get(r + 1)).getTimeInYears() - ((SimulatorEvent)riEvents.get(r)).getTimeInYears();
                }
                double meanRI = StatUtils.mean((double[])ris);
                double riDelta = 5.0;
                if (meanRI > 300.0) {
                    riDelta = 10.0;
                }
                if (meanRI > 1000.0) {
                    riDelta = 50.0;
                }
                HistogramFunction hist = HistogramFunction.getEncompassingHistogram((double)StatUtils.min((double[])ris), (double)StatUtils.max((double[])ris), (double)riDelta);
                for (double ri : ris) {
                    hist.add(ri, 1.0);
                }
                funcs = new ArrayList();
                chars = new ArrayList();
                funcs.add(hist);
                hist.setName("M\u2265" + (float)riMag + " RI Dist");
                chars.add(new PlotCurveCharacterstics(PlotLineType.HISTOGRAM, 1.0f, Color.BLUE));
                DefaultXY_DataSet meanLine = new DefaultXY_DataSet();
                meanLine.set(meanRI, 0.0);
                meanLine.set(meanRI, hist.getMaxY());
                meanLine.set(meanRI, hist.getMaxY() * 1.25);
                meanLine.setName("Mean RI: " + (float)meanRI);
                funcs.add(meanLine);
                chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLACK));
                if (compMFD != null && riMag >= compMFD.getMinX() && riMag <= compMFD.getMaxX()) {
                    double rate = compMFD.getInterpolatedY(riMag);
                    double compRI = 1.0 / rate;
                    DefaultXY_DataSet compLine = new DefaultXY_DataSet();
                    compLine.set(compRI, 0.0);
                    compLine.set(compRI, hist.getMaxY());
                    compLine.set(compRI, hist.getMaxY() * 1.25);
                    compLine.setName("U3 Comparison RI: " + (float)compRI);
                    funcs.add(compLine);
                    chars.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 2.0f, Color.RED));
                }
                spec = new PlotSpec(funcs, chars, "M\u2265" + (float)riMag + " RI", "Time (years)", "Number");
                spec.setLegendVisible(true);
                graph.addTab(spec);
            }
        }
        graph.setSelectedTab(0);
        graph.setVisible(true);
    }

    public static IncrementalMagFreqDist calcMFD(List<? extends SimulatorEvent> events, double duration, double minMag, int num, double delta) {
        IncrementalMagFreqDist mfd = new IncrementalMagFreqDist(minMag, num, delta);
        double myMin = minMag - 0.5 * delta;
        double myMax = mfd.getMaxX() + 0.5 * delta;
        for (SimulatorEvent simulatorEvent : events) {
            double mag = simulatorEvent.getMagnitude();
            if (mag < myMin || mag > myMax) continue;
            int ind = mfd.getClosestXIndex(mag);
            double eventRate = 1.0;
            mfd.set(ind, mfd.getY(ind) + eventRate);
        }
        if (duration > 0.0) {
            for (int i = 0; i < mfd.size(); ++i) {
                mfd.set(i, mfd.getY(i) / duration);
            }
        }
        return mfd;
    }

    private static enum PlotType {
        CATALOG("Catalog Rate"),
        UCERF3("UCERF3 Rate"),
        RATIO("Ratio");

        private String name;

        private PlotType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

