/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.plugins.opensha.simulators;

import com.google.common.base.Preconditions;
import com.google.common.io.Files;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import javax.swing.JOptionPane;
import org.opensha.commons.mapping.gmt.elements.GMT_CPT_Files;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.impl.ButtonParameter;
import org.opensha.commons.param.impl.EnumParameter;
import org.opensha.commons.param.impl.FileParameter;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.commons.util.cpt.CPT;
import org.opensha.sha.simulators.SimulatorElement;
import org.opensha.sha.simulators.SimulatorEvent;
import org.scec.vtk.commons.opensha.faults.AbstractFaultSection;
import org.scec.vtk.commons.opensha.faults.colorers.CPTBasedColorer;
import org.scec.vtk.commons.opensha.faults.faultSectionImpl.SimulatorElementFault;
import org.scec.vtk.plugins.opensha.simulators.EQSimsEventListener;

public class EQSimsPatchScalarColorer
extends CPTBasedColorer
implements ParameterChangeListener,
EQSimsEventListener {
    private EnumParameter<CPTPreset> cptParam;
    private static final CPTPreset CPT_PRESET_DEFAULT = CPTPreset.SPECTRUM;
    private FileParameter fileParam;
    private ButtonParameter scaleToDataParam;
    private ParameterList params = new ParameterList();
    private int minPatchIndex = -1;
    private int numPatches = -1;
    private List<Double> data;

    public EQSimsPatchScalarColorer() {
        super(CPT_PRESET_DEFAULT.get(), CPT_PRESET_DEFAULT.isLog10());
        this.fileParam = new FileParameter("Input File");
        this.fileParam.setInfo("Load a text file where every line contains one scalar value, indexed by patch index.");
        this.fileParam.addParameterChangeListener((ParameterChangeListener)this);
        this.fileParam.getEditor().setEnabled(false);
        this.params.addParameter((Parameter)this.fileParam);
        this.cptParam = new EnumParameter("CPT Preset", EnumSet.allOf(CPTPreset.class), (Enum)CPT_PRESET_DEFAULT, null);
        this.cptParam.addParameterChangeListener((ParameterChangeListener)this);
        this.params.addParameter(this.cptParam);
        this.scaleToDataParam = new ButtonParameter("CPT Range", "Scale to Data");
        this.scaleToDataParam.addParameterChangeListener((ParameterChangeListener)this);
        this.scaleToDataParam.getEditor().setEnabled(false);
        this.params.addParameter((Parameter)this.scaleToDataParam);
    }

    public String getName() {
        return "Patch Scalar File Loader";
    }

    @Override
    public double getValue(AbstractFaultSection fault) {
        if (this.data == null || !(fault instanceof SimulatorElementFault)) {
            return Double.NaN;
        }
        int index = ((SimulatorElementFault)fault).getElement().getID() - this.minPatchIndex;
        if (index >= this.data.size()) {
            System.out.println("Bad patch index! Have " + this.data.size() + ", index=" + index);
            return Double.NaN;
        }
        return this.data.get(index);
    }

    @Override
    public ParameterList getColorerParameters() {
        return this.params;
    }

    public void parameterChange(ParameterChangeEvent event) {
        if (event.getParameter() == this.fileParam) {
            this.data = null;
            File file = (File)this.fileParam.getValue();
            if (file != null) {
                try {
                    for (String line : Files.readLines((File)file, (Charset)Charset.defaultCharset())) {
                        if (this.data == null) {
                            this.data = new ArrayList<Double>();
                        }
                        if ((line = line.trim()).isEmpty()) continue;
                        double val = Double.parseDouble(line);
                        this.data.add(val);
                    }
                    if (this.data.size() != this.numPatches) {
                        JOptionPane.showMessageDialog(null, "Each line should contain one scalar value, one for each patch.\n\nExpected " + this.numPatches + ", file has " + this.data.size(), "Malformed data file", 0);
                        this.data = null;
                    }
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(null, e.getMessage(), "I/O Exception", 0);
                    this.data = null;
                }
                catch (NumberFormatException e) {
                    JOptionPane.showMessageDialog(null, "Each line should contain one scalar value.\n\n" + e.getMessage(), "Malformed data file", 0);
                    this.data = null;
                }
                if (this.data == null) {
                    this.fileParam.setValue(null);
                }
            }
            this.scaleToDataParam.getEditor().setEnabled(this.data != null);
            this.fireColorerChangeEvent();
        } else if (event.getParameter() == this.cptParam) {
            CPTPreset preset = (CPTPreset)((Object)this.cptParam.getValue());
            this.setCPT(preset.get(), preset.isLog10());
            this.fireColorerChangeEvent();
        } else if (event.getParameter() == this.scaleToDataParam) {
            Preconditions.checkNotNull(this.data);
            double min = Double.POSITIVE_INFINITY;
            double max = Double.NEGATIVE_INFINITY;
            for (double val : this.data) {
                min = Math.min(min, val);
                max = Math.max(max, val);
            }
            if (this.isCPTLog()) {
                min = Math.log10(min);
                max = Math.log10(max);
            }
            CPT cpt = this.getCPT().rescale(min, max);
            this.setCPT(cpt, this.isCPTLog());
            this.fireColorerChangeEvent();
        }
    }

    @Override
    public void setEvents(List<? extends SimulatorEvent> events) {
    }

    @Override
    public void setGeometry(List<SimulatorElement> elements) {
        this.minPatchIndex = -1;
        this.numPatches = -1;
        if (elements != null && !elements.isEmpty()) {
            this.minPatchIndex = Integer.MAX_VALUE;
            this.numPatches = elements.size();
            for (SimulatorElement elem : elements) {
                if (elem.getID() >= this.minPatchIndex) continue;
                this.minPatchIndex = elem.getID();
            }
        }
        this.fileParam.getEditor().setEnabled(this.numPatches > 0);
    }

    private static enum CPTPreset {
        RATIO("Ratio", false){

            @Override
            CPT build() {
                CPT cpt;
                try {
                    cpt = GMT_CPT_Files.GMT_POLAR.instance();
                }
                catch (IOException e) {
                    throw ExceptionUtils.asRuntimeException((Throwable)e);
                }
                cpt.setNanColor(Color.GRAY);
                cpt = cpt.rescale(0.0, 2.0);
                return cpt;
            }
        }
        ,
        SPECTRUM("Max Spectrum", false){

            @Override
            CPT build() {
                CPT cpt;
                try {
                    cpt = GMT_CPT_Files.MAX_SPECTRUM.instance();
                }
                catch (IOException e) {
                    throw ExceptionUtils.asRuntimeException((Throwable)e);
                }
                cpt.setNanColor(Color.GRAY);
                cpt = cpt.rescale(0.0, 2.0);
                return cpt;
            }
        }
        ,
        LOG_SPECTRUM("Log10 Spectrum", true){

            @Override
            CPT build() {
                CPT cpt;
                try {
                    cpt = GMT_CPT_Files.MAX_SPECTRUM.instance();
                }
                catch (IOException e) {
                    throw ExceptionUtils.asRuntimeException((Throwable)e);
                }
                cpt.setNanColor(Color.GRAY);
                cpt = cpt.rescale(-1.0, 1.0);
                return cpt;
            }
        };

        private String name;
        private CPT cpt;
        private boolean isLog10;

        private CPTPreset(String name, boolean isLog10) {
            this.name = name;
            this.isLog10 = isLog10;
        }

        abstract CPT build();

        CPT get() {
            if (this.cpt == null) {
                this.cpt = this.build();
            }
            return this.cpt;
        }

        boolean isLog10() {
            return this.isLog10;
        }

        public String toString() {
            return this.name;
        }
    }
}

