/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.plugins.opensha.simulators;

import java.awt.Color;
import java.util.ArrayList;
import org.opensha.commons.util.ListUtils;
import org.scec.vtk.commons.opensha.faults.anim.FaultAnimation;
import org.scec.vtk.commons.opensha.faults.colorers.FaultColorer;
import org.scec.vtk.commons.opensha.surfaces.GeometryGenerator;
import org.scec.vtk.plugins.opensha.AbstractFaultPlugin;
import org.scec.vtk.plugins.opensha.FaultPluginGUI;
import org.scec.vtk.plugins.opensha.simulators.EQSimsAnimDroughtColorer;
import org.scec.vtk.plugins.opensha.simulators.EQSimsBuilder;
import org.scec.vtk.plugins.opensha.simulators.EQSimsEventAnimColorer;
import org.scec.vtk.plugins.opensha.simulators.EQSimsFaultSectionBundler;

public class EQSimsPlugin
extends AbstractFaultPlugin {
    @Override
    protected FaultPluginGUI buildGUI() {
        EQSimsBuilder builder = new EQSimsBuilder();
        ArrayList<FaultColorer> colorers = builder.getColorers();
        ArrayList<GeometryGenerator> geomGens = FaultPluginGUI.createDefaultGeomGens();
        EQSimsPlugin.setBundlerInGeomGens(geomGens, new EQSimsFaultSectionBundler());
        int lineIndex = ListUtils.getIndexByName(geomGens, (String)"Lines");
        if (lineIndex > 0) {
            GeometryGenerator lines = geomGens.remove(lineIndex);
            geomGens.add(0, lines);
        }
        ArrayList<FaultAnimation> faultAnims = builder.getAnimations();
        FaultPluginGUI gui = new FaultPluginGUI(this, builder, colorers, geomGens, Color.GRAY, faultAnims);
        for (FaultAnimation anim : faultAnims) {
            if (anim instanceof EQSimsEventAnimColorer) {
                ((EQSimsEventAnimColorer)anim).setEventManager(gui.getEventManager());
            }
            if (!(anim instanceof EQSimsAnimDroughtColorer)) continue;
            ((EQSimsAnimDroughtColorer)anim).setEventManager(gui.getEventManager());
        }
        return gui;
    }
}

