/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.plugins.opensha.simulators;

import java.io.IOException;
import java.util.EnumSet;
import java.util.List;
import org.opensha.commons.mapping.gmt.elements.GMT_CPT_Files;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.impl.EnumParameter;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.commons.util.cpt.CPT;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.simulators.SimulatorElement;
import org.opensha.sha.simulators.SimulatorEvent;
import org.opensha.sha.simulators.utils.RSQSimSubSectionMapper;
import org.opensha.sha.simulators.utils.RSQSimUtils;
import org.scec.vtk.commons.opensha.faults.AbstractFaultSection;
import org.scec.vtk.commons.opensha.faults.colorers.CPTBasedColorer;
import org.scec.vtk.commons.opensha.faults.faultSectionImpl.SimulatorElementFault;
import org.scec.vtk.plugins.opensha.simulators.EQSimsEventListener;
import scratch.UCERF3.enumTreeBranches.DeformationModels;
import scratch.UCERF3.enumTreeBranches.FaultModels;

public class EQSimsSubSectDASColorer
extends CPTBasedColorer
implements EQSimsEventListener,
ParameterChangeListener {
    private List<SimulatorElement> elements;
    private RSQSimSubSectionMapper mapper;
    private boolean mapperFail = false;
    private EnumParameter<FaultModels> fmParam = new EnumParameter("Fault Model", EnumSet.allOf(FaultModels.class), (Enum)FaultModels.FM3_1, null);

    private static CPT buildCPT() {
        try {
            return GMT_CPT_Files.MAX_SPECTRUM.instance().rescale(0.0, 1.0);
        }
        catch (IOException e) {
            throw ExceptionUtils.asRuntimeException((Throwable)e);
        }
    }

    public EQSimsSubSectDASColorer() {
        super(EQSimsSubSectDASColorer.buildCPT(), false);
        this.fmParam.addParameterChangeListener((ParameterChangeListener)this);
    }

    public String getName() {
        return "Sub Section DAS Colorer";
    }

    @Override
    public double getValue(AbstractFaultSection fault) {
        if (this.elements != null && this.mapper == null && !this.mapperFail) {
            try {
                List subSects = RSQSimUtils.getUCERF3SubSectsForComparison((FaultModels)((FaultModels)this.fmParam.getValue()), (DeformationModels)DeformationModels.GEOLOGIC);
                this.mapper = new RSQSimSubSectionMapper(subSects, this.elements, 0.2);
            }
            catch (Exception e) {
                System.err.println("Error building mapper:");
                e.printStackTrace();
                this.mapperFail = true;
            }
        }
        if (this.mapper == null || !(fault instanceof SimulatorElementFault)) {
            return Double.NaN;
        }
        SimulatorElement elem = ((SimulatorElementFault)fault).getElement();
        double das = this.mapper.getElemSubSectDAS((SimulatorElement)elem).midDAS;
        FaultSection sect = this.mapper.getMappedSection(elem);
        double len = sect.getFaultTrace().getTraceLength();
        return das / len;
    }

    @Override
    public void setEvents(List<? extends SimulatorEvent> events) {
    }

    @Override
    public void setGeometry(List<SimulatorElement> elements) {
        this.elements = elements;
        this.mapperFail = false;
        this.fireColorerChangeEvent();
    }

    public void parameterChange(ParameterChangeEvent arg0) {
        this.mapper = null;
        this.mapperFail = false;
        if (this.elements != null) {
            this.fireColorerChangeEvent();
        }
    }
}

