/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.plugins.opensha.simulators;

import java.awt.Color;
import java.io.IOException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import org.opensha.commons.mapping.gmt.elements.GMT_CPT_Files;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.impl.EnumParameter;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.commons.util.cpt.CPT;
import org.opensha.commons.util.cpt.CPTVal;
import org.opensha.sha.simulators.SimulatorElement;
import org.opensha.sha.simulators.SimulatorEvent;
import org.opensha.sha.simulators.utils.SimulatorUtils;
import org.scec.vtk.commons.opensha.faults.AbstractFaultSection;
import org.scec.vtk.commons.opensha.faults.colorers.CPTBasedColorer;
import org.scec.vtk.plugins.opensha.simulators.EQSimsEventListener;

public class EQSlipRateColorer
extends CPTBasedColorer
implements EQSimsEventListener,
ParameterChangeListener {
    private static final String PLOT_TYPE_PARAM_NAME = "Plot Type";
    private static final PlotType PLOT_TYPE_DEFAULT = PlotType.FAULT_SLIP;
    private EnumParameter<PlotType> plotTypeParam;
    private ParameterList params;
    private CPT slipCPT;
    private CPT ratioCPT;
    private HashMap<Integer, Double> solutionSlips = new HashMap();

    private static CPT createEQSimsCPT() {
        CPT cpt = new CPT();
        float delta = 6.6666665f;
        cpt.add((Object)new CPTVal(0.0f, new Color(0, 0, 255), delta * 1.0f, new Color(0, 255, 255)));
        cpt.add((Object)new CPTVal(delta * 1.0f, new Color(0, 255, 255), delta * 2.0f, new Color(0, 255, 0)));
        cpt.add((Object)new CPTVal(delta * 2.0f, new Color(0, 255, 0), delta * 3.0f, new Color(255, 255, 0)));
        cpt.add((Object)new CPTVal(delta * 3.0f, new Color(255, 255, 0), delta * 4.0f, new Color(255, 127, 0)));
        cpt.add((Object)new CPTVal(delta * 4.0f, new Color(255, 127, 0), delta * 5.0f, new Color(255, 0, 0)));
        cpt.add((Object)new CPTVal(delta * 5.0f, new Color(255, 0, 0), delta * 6.0f, new Color(255, 0, 255)));
        cpt.setBelowMinColor(new Color(0, 0, 255));
        cpt.setAboveMaxColor(new Color(255, 0, 255));
        cpt.setNanColor(new Color(127, 127, 127));
        return cpt;
    }

    public EQSlipRateColorer() {
        super(EQSlipRateColorer.createEQSimsCPT(), false);
        this.slipCPT = (CPT)this.getCPT().clone();
        try {
            this.ratioCPT = GMT_CPT_Files.UCERF3_RATIOS.instance();
        }
        catch (IOException e) {
            ExceptionUtils.throwAsRuntimeException((Throwable)e);
        }
        this.ratioCPT = this.ratioCPT.rescale(-3.0, 3.0);
        this.params = new ParameterList();
        this.plotTypeParam = new EnumParameter(PLOT_TYPE_PARAM_NAME, EnumSet.allOf(PlotType.class), (Enum)PLOT_TYPE_DEFAULT, null);
        this.plotTypeParam.addParameterChangeListener((ParameterChangeListener)this);
        this.params.addParameter(this.plotTypeParam);
    }

    public String getName() {
        return "Slip Rate (mm/yr)";
    }

    @Override
    public ParameterList getColorerParameters() {
        return this.params;
    }

    public void parameterChange(ParameterChangeEvent event) {
        if (event.getParameter() == this.plotTypeParam) {
            switch (((PlotType)((Object)this.plotTypeParam.getValue())).ordinal()) {
                case 0: {
                    this.setCPT(this.slipCPT, false);
                    break;
                }
                case 1: {
                    this.setCPT(this.slipCPT, false);
                    break;
                }
                case 2: {
                    this.setCPT(this.ratioCPT, true);
                    break;
                }
            }
            this.fireColorerChangeEvent();
        }
    }

    @Override
    public void setEvents(List<? extends SimulatorEvent> events) {
        this.solutionSlips.clear();
        if (events == null) {
            return;
        }
        double rate = 1.0 / SimulatorUtils.getSimulationDurationYears(events);
        for (SimulatorEvent simulatorEvent : events) {
            int[] ids = simulatorEvent.getAllElementIDs();
            if (ids == null) continue;
            double[] slips = simulatorEvent.getAllElementSlips();
            for (int i = 0; i < ids.length; ++i) {
                int id = ids[i];
                double slip = slips[i];
                Double prevSlip = this.solutionSlips.get(id);
                if (prevSlip == null) {
                    prevSlip = 0.0;
                }
                prevSlip = prevSlip + slip * rate;
                this.solutionSlips.put(id, prevSlip);
            }
        }
        this.fireColorerChangeEvent();
    }

    @Override
    public double getValue(AbstractFaultSection fault) {
        PlotType plt = (PlotType)((Object)this.plotTypeParam.getValue());
        if (plt == PlotType.FAULT_SLIP) {
            return fault.getSlipRate();
        }
        if (this.solutionSlips.isEmpty()) {
            return Double.NaN;
        }
        Double solSlip = this.solutionSlips.get(fault.getId());
        if (solSlip == null) {
            solSlip = 0.0;
        }
        solSlip = solSlip * 1000.0;
        if (plt == PlotType.SOLUTION_SLIP) {
            return solSlip;
        }
        return solSlip / fault.getSlipRate();
    }

    @Override
    public void setGeometry(List<SimulatorElement> elements) {
    }

    private static enum PlotType {
        FAULT_SLIP("Fault Slip Rate"),
        SOLUTION_SLIP("Solution Slip Rate"),
        RATIO("Ratio");

        private String name;

        private PlotType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

