/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.plugins.opensha.ucerf3Disagg;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.awt.Color;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.tree.DefaultMutableTreeNode;
import org.opensha.commons.data.Site;
import org.opensha.commons.geo.Location;
import org.opensha.commons.mapping.gmt.elements.GMT_CPT_Files;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.WarningParameter;
import org.opensha.commons.param.editor.impl.ParameterListParameterEditor;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.impl.ButtonParameter;
import org.opensha.commons.param.impl.DoubleParameter;
import org.opensha.commons.param.impl.EnumParameter;
import org.opensha.commons.param.impl.ParameterListParameter;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.commons.util.ServerPrefUtils;
import org.opensha.commons.util.ServerPrefs;
import org.opensha.commons.util.cpt.CPT;
import org.opensha.sha.earthquake.ERF;
import org.opensha.sha.earthquake.EqkRupture;
import org.opensha.sha.earthquake.ProbEqkRupture;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.faultSurface.PointSurface;
import org.opensha.sha.faultSurface.utils.PtSrcDistCorr;
import org.opensha.sha.gui.beans.IMR_MultiGuiBean;
import org.opensha.sha.gui.beans.IMT_NewGuiBean;
import org.opensha.sha.gui.beans.Site_GuiBean;
import org.opensha.sha.gui.beans.TimeSpanGuiBean;
import org.opensha.sha.gui.beans.event.IMTChangeListener;
import org.opensha.sha.gui.controls.SiteDataControlPanel;
import org.opensha.sha.imr.AttenRelRef;
import org.opensha.sha.imr.ScalarIMR;
import org.opensha.sha.imr.event.ScalarIMRChangeEvent;
import org.opensha.sha.imr.event.ScalarIMRChangeListener;
import org.opensha.sha.util.TRTUtils;
import org.opensha.sha.util.TectonicRegionType;
import org.scec.vtk.commons.opensha.faults.AbstractFaultSection;
import org.scec.vtk.commons.opensha.faults.colorers.CPTBasedColorer;
import org.scec.vtk.commons.opensha.faults.colorers.FaultColorer;
import org.scec.vtk.commons.opensha.faults.faultSectionImpl.PrefDataSection;
import org.scec.vtk.commons.opensha.tree.FaultCategoryNode;
import org.scec.vtk.commons.opensha.tree.FaultSectionNode;
import org.scec.vtk.commons.opensha.tree.builders.FaultTreeBuilder;
import org.scec.vtk.commons.opensha.tree.events.TreeChangeListener;
import org.scec.vtk.main.MainGUI;
import org.scec.vtk.plugins.PluginActors;
import org.scec.vtk.tools.Transform;
import scratch.UCERF3.erf.FaultSystemSolutionERF;
import scratch.UCERF3.erf.mean.MeanUCERF3;
import vtk.vtkAbstractArray;
import vtk.vtkActor;
import vtk.vtkConeSource;
import vtk.vtkDataObject;
import vtk.vtkDoubleArray;
import vtk.vtkGlyph3D;
import vtk.vtkMapper;
import vtk.vtkPoints;
import vtk.vtkPolyData;
import vtk.vtkPolyDataMapper;
import vtk.vtkProp;
import vtk.vtkSphereSource;
import vtk.vtkUnsignedCharArray;

public class UCERF3DisaggBuilder
implements FaultTreeBuilder,
ParameterChangeListener,
ScalarIMRChangeListener {
    private ERF erf;
    private FaultSystemRupSet rupSet;
    private EnumParameter<ERF_CHOICES> erfParam;
    private ParameterListParameter erfParamsParam = new ParameterListParameter("ERF Params");
    private ButtonParameter timeSpanButton = new ButtonParameter("Time Span", "Set Time Span");
    private ButtonParameter imrParamsButton = new ButtonParameter("IMR", "Set IMR Params");
    private ButtonParameter imtParamsButton = new ButtonParameter("IMT", "Set IMT");
    private ButtonParameter siteParamsButton = new ButtonParameter("Site", "Set Site");
    private ButtonParameter siteDataParamsButton = new ButtonParameter("Site Data", "Set Site Data From Web");
    private DoubleParameter imlParam;
    private ButtonParameter computeButton = new ButtonParameter("Hazard Calculation", "Compute");
    private DoubleParameter magMinParam;
    private DoubleParameter magMaxParam;
    private ParameterListParameter subParamsParam;
    private TimeSpanGuiBean timeSpanBean;
    private IMR_MultiGuiBean imrBean;
    private IMT_NewGuiBean imtBean;
    private Site_GuiBean siteBean;
    private SiteDataControlPanel siteControl;
    private ParameterList faultParams = PrefDataSection.createPrefDataParams();
    private ParameterList builderParams = new ParameterList();
    private TreeChangeListener l;
    private CPT defaultCPT;
    private DisaggColorer colorer;
    private JFileChooser choose;
    private PluginActors actors;
    private Map<Location, Double> ptSourceVals;
    private Map<Integer, Double> sectVals;
    private vtkActor sphereActor;
    private vtkPoints spherePoints;
    private vtkDoubleArray sphereRadius;
    private vtkUnsignedCharArray sphereColors;
    private vtkActor coneActor;
    private vtkPoints conePoints;
    private vtkDoubleArray coneRadius;
    private vtkUnsignedCharArray coneColors;

    public UCERF3DisaggBuilder(PluginActors actors) {
        this.actors = actors;
        ParameterList subParams = new ParameterList();
        this.erfParam = new EnumParameter("ERF Select", EnumSet.allOf(ERF_CHOICES.class), (Enum)ERF_CHOICES.MEAN_UCERF3, null);
        this.erfParam.addParameterChangeListener((ParameterChangeListener)this);
        this.builderParams.addParameter(this.erfParam);
        this.erfParamsParam.setValue(new ParameterList());
        this.erfParamsParam.addParameterChangeListener((ParameterChangeListener)this);
        subParams.addParameter((Parameter)this.erfParamsParam);
        this.timeSpanButton.addParameterChangeListener((ParameterChangeListener)this);
        subParams.addParameter((Parameter)this.timeSpanButton);
        this.imrParamsButton.addParameterChangeListener((ParameterChangeListener)this);
        subParams.addParameter((Parameter)this.imrParamsButton);
        this.imtParamsButton.addParameterChangeListener((ParameterChangeListener)this);
        subParams.addParameter((Parameter)this.imtParamsButton);
        this.siteParamsButton.addParameterChangeListener((ParameterChangeListener)this);
        subParams.addParameter((Parameter)this.siteParamsButton);
        this.siteDataParamsButton.addParameterChangeListener((ParameterChangeListener)this);
        subParams.addParameter((Parameter)this.siteDataParamsButton);
        this.magMinParam = new DoubleParameter("Min Max", 0.0, 10.0, Double.valueOf(0.0));
        subParams.addParameter((Parameter)this.magMinParam);
        this.magMaxParam = new DoubleParameter("Max Max", 0.0, 10.0, Double.valueOf(10.0));
        subParams.addParameter((Parameter)this.magMaxParam);
        this.subParamsParam = new ParameterListParameter("ERF/IMR/IMT/Site Params", subParams);
        ((ParameterListParameterEditor)this.subParamsParam.getEditor()).setModal(false);
        this.builderParams.addParameter((Parameter)this.subParamsParam);
        this.imlParam = new DoubleParameter("IML", 0.0, 100.0, Double.valueOf(0.2));
        this.imlParam.addParameterChangeListener((ParameterChangeListener)this);
        this.builderParams.addParameter((Parameter)this.imlParam);
        this.computeButton.addParameterChangeListener((ParameterChangeListener)this);
        this.builderParams.addParameter((Parameter)this.computeButton);
        try {
            this.defaultCPT = GMT_CPT_Files.MAX_SPECTRUM.instance().rescale(-8.0, -1.0);
            this.defaultCPT.setBelowMinColor(Color.GRAY);
            this.defaultCPT.setNanColor(Color.GRAY);
        }
        catch (IOException e) {
            ExceptionUtils.throwAsRuntimeException((Throwable)e);
        }
        this.colorer = new DisaggColorer();
        List imrs = AttenRelRef.instanceList(null, (boolean)true, (ServerPrefs)ServerPrefUtils.SERVER_PREFS);
        for (ScalarIMR imr : imrs) {
            imr.setParamDefaults();
        }
        this.imrBean = new IMR_MultiGuiBean(imrs);
        this.imrBean.setSelectedSingleIMR(AttenRelRef.CB_2008.toString());
        this.imrBean.setMaxChooserChars(30);
        this.imrBean.rebuildGUI();
        this.imrBean.addIMRChangeListener((ScalarIMRChangeListener)this);
        this.imtBean = new IMT_NewGuiBean(imrs);
        this.imtBean.addIMTChangeListener((IMTChangeListener)this.imrBean);
        this.imtBean.setSelectedIMT("SA");
        this.imtBean.setMinimumSize(new Dimension(200, 90));
        this.imtBean.setPreferredSize(new Dimension(290, 220));
        this.siteBean = new Site_GuiBean();
        this.siteBean.addSiteParams(this.imrBean.getMultiIMRSiteParamIterator());
        this.loadERF();
    }

    public ArrayList<FaultColorer> getColorers() {
        ArrayList colorers = Lists.newArrayList();
        colorers.add(this.colorer);
        return colorers;
    }

    @Override
    public ParameterList getBuilderParams() {
        return this.builderParams;
    }

    @Override
    public ParameterList getFaultParams() {
        return this.faultParams;
    }

    @Override
    public void setTreeChangeListener(TreeChangeListener l) {
        this.l = l;
    }

    @Override
    public void buildTree(DefaultMutableTreeNode root) {
        if (this.rupSet == null) {
            return;
        }
        FaultCategoryNode catNode = new FaultCategoryNode("Fault Based Sources", "");
        List sectionData = this.rupSet.getFaultSectionDataList();
        for (FaultSection data : sectionData) {
            String name = data.getSectionId() + ". " + data.getName();
            PrefDataSection fault = new PrefDataSection(name, data);
            FaultSectionNode faultNode = new FaultSectionNode(fault);
            catNode.add(faultNode);
        }
        catNode.setVisible(true);
        root.add(catNode);
    }

    private void loadERF() {
        this.erf = null;
        this.rupSet = null;
        switch (((ERF_CHOICES)((Object)this.erfParam.getValue())).ordinal()) {
            case 0: {
                MeanUCERF3 erf = new MeanUCERF3();
                erf.setMeanParams(0.0, false, 0.1, "Do Not Combine");
                this.erf = erf;
                break;
            }
            case 1: {
                int ret;
                File defaultDir;
                if (this.choose == null) {
                    this.choose = new JFileChooser();
                }
                if ((defaultDir = new File(MainGUI.getCWD(), "data")).exists()) {
                    this.choose.setCurrentDirectory(defaultDir);
                }
                if ((ret = this.choose.showOpenDialog(null)) == 0) {
                    this.erf = new FaultSystemSolutionERF(this.choose.getSelectedFile().getAbsolutePath());
                    break;
                }
                this.erf = new FaultSystemSolutionERF();
                break;
            }
            default: {
                throw new IllegalStateException("Unknown ERF: " + String.valueOf(this.erfParam.getValue()));
            }
        }
        this.erfParamsParam.removeParameterChangeListener((ParameterChangeListener)this);
        this.erfParamsParam.setValue(this.erf.getAdjustableParameterList());
        this.erfParamsParam.getEditor().setParameter((Parameter)this.erfParamsParam);
        this.erfParamsParam.addParameterChangeListener((ParameterChangeListener)this);
    }

    private void loadRupSet() {
        this.rupSet = null;
        switch (((ERF_CHOICES)((Object)this.erfParam.getValue())).ordinal()) {
            case 0: {
                this.rupSet = ((MeanUCERF3)this.erf).getSolution().getRupSet();
                break;
            }
            case 1: {
                this.rupSet = ((FaultSystemSolutionERF)this.erf).getSolution().getRupSet();
                break;
            }
            default: {
                throw new IllegalStateException("Unknown ERF: " + String.valueOf(this.erfParam.getValue()));
            }
        }
    }

    private void compute() {
        if (this.erf == null) {
            this.loadERF();
        }
        this.erf.updateForecast();
        this.clearActors();
        this.ptSourceVals = Maps.newHashMap();
        this.sectVals = Maps.newHashMap();
        if (this.rupSet == null) {
            this.loadRupSet();
            this.fireTreeChangeEvent();
        }
        Map imrMap = this.imrBean.getIMRMap();
        Site site = this.siteBean.getSite();
        double maxDist = 200.0;
        int numSources = this.erf.getNumSources();
        double iml = (Double)this.imlParam.getValue();
        for (ScalarIMR imr : imrMap.values()) {
            this.imtBean.setIMTinIMR(imr);
            Parameter im = imr.getIntensityMeasure();
            System.out.println("IMT: " + im.getName());
            if (im instanceof WarningParameter) {
                WarningParameter warnIM = (WarningParameter)im;
                warnIM.setValueIgnoreWarning((Object)iml);
            } else {
                im.setValue((Object)iml);
            }
            imr.setSite(site);
        }
        int rupCount = 0;
        double minMag = (Double)this.magMinParam.getValue();
        double maxMag = (Double)this.magMaxParam.getValue();
        for (int i = 0; i < numSources; ++i) {
            ProbEqkSource source = this.erf.getSource(i);
            String sourceName = source.getName();
            int numRuptures = this.erf.getNumRuptures(i);
            double distance = source.getMinDistance(site);
            if (distance > maxDist) {
                rupCount += numRuptures;
                continue;
            }
            TectonicRegionType trt = source.getTectonicRegionType();
            ScalarIMR imr = TRTUtils.getIMRforTRT((Map)imrMap, (TectonicRegionType)trt);
            for (int n = 0; n < numRuptures; ++n) {
                ProbEqkRupture rupture = source.getRupture(n);
                double mag = rupture.getMag();
                if (mag < minMag || mag > maxMag) {
                    ++rupCount;
                    continue;
                }
                if (rupture.getRuptureSurface() instanceof PointSurface) {
                    ((PointSurface)rupture.getRuptureSurface()).setDistCorrMagAndType(rupture.getMag(), PtSrcDistCorr.Type.NSHMP08);
                }
                double qkProb = rupture.getProbability();
                imr.setEqkRupture((EqkRupture)rupture);
                double condProb = imr.getExceedProbability(iml);
                if (condProb <= 0.0) {
                    ++rupCount;
                    continue;
                }
                double rate = -condProb * Math.log(1.0 - qkProb);
                if (rate > 0.0) {
                    this.registerRate(i, source, n, rupCount, rupture, rate);
                }
                ++rupCount;
            }
        }
        this.colorer.fireColorerChangeEvent();
    }

    private void registerRate(int sourceID, ProbEqkSource source, int rupID, int rupCount, ProbEqkRupture rup, double rate) {
        if (rup.getRuptureSurface() instanceof PointSurface) {
            Location ptLoc = rup.getRuptureSurface().getFirstLocOnUpperEdge();
            Double prevVal = this.ptSourceVals.get(ptLoc);
            if (prevVal == null) {
                this.ptSourceVals.put(ptLoc, rate);
            } else {
                this.ptSourceVals.put(ptLoc, prevVal + rate);
            }
        } else {
            String name = source.getName();
            Preconditions.checkState((boolean)name.startsWith("Inversion Src #"));
            name = name.substring(name.indexOf(35) + 1, name.indexOf(59));
            int fssIndex = Integer.parseInt(name.trim());
            Iterator iterator = this.rupSet.getSectionsIndicesForRup(fssIndex).iterator();
            while (iterator.hasNext()) {
                int sect = (Integer)iterator.next();
                Double prevVal = this.sectVals.get(sect);
                if (prevVal == null) {
                    this.sectVals.put(sect, rate);
                    continue;
                }
                this.sectVals.put(sect, prevVal + rate);
            }
        }
    }

    private void clearActors() {
        this.actors.clearActors();
        this.sphereActor = null;
        this.spherePoints = null;
        this.sphereRadius = null;
        this.sphereColors = null;
    }

    private void displayGridded() {
        this.clearActors();
        if (this.ptSourceVals == null) {
            return;
        }
        for (Location loc : this.ptSourceVals.keySet()) {
            double val = this.ptSourceVals.get(loc);
            if (this.colorer.isCPTLog() ? Math.log10(val) < (double)this.colorer.getCPT().getMinValue() : val < (double)this.colorer.getCPT().getMinValue()) continue;
            Color color = this.colorer.getColorForValue(val);
            this.displayLoc(color, false, loc);
        }
        this.displayLoc(Color.PINK, true, this.siteBean.getSite().getLocation());
    }

    private void displayLoc(Color color, boolean cone, Location loc) {
        vtkUnsignedCharArray colorArray;
        vtkDoubleArray radiusArray;
        vtkPoints points;
        vtkActor actor;
        vtkPolyData inputData;
        vtkPolyDataMapper mapper;
        if (cone) {
            if (this.coneActor == null) {
                this.conePoints = new vtkPoints();
                this.coneRadius = new vtkDoubleArray();
                this.coneRadius.SetName("radius");
                this.coneColors = new vtkUnsignedCharArray();
                this.coneColors.SetName("colors");
                this.coneColors.SetNumberOfComponents(4);
                mapper = new vtkPolyDataMapper();
                inputData = new vtkPolyData();
                inputData.SetPoints(this.conePoints);
                inputData.GetPointData().AddArray((vtkAbstractArray)this.coneRadius);
                inputData.GetPointData().AddArray((vtkAbstractArray)this.coneColors);
                inputData.GetPointData().SetActiveScalars("radius");
                vtkConeSource balls = new vtkConeSource();
                balls.SetRadius(1.0);
                balls.SetResolution(7);
                vtkGlyph3D glyphPoints = new vtkGlyph3D();
                glyphPoints.SetInputData((vtkDataObject)inputData);
                glyphPoints.SetSourceConnection(balls.GetOutputPort());
                mapper.SetInputConnection(glyphPoints.GetOutputPort());
                mapper.ScalarVisibilityOn();
                mapper.SetScalarModeToUsePointFieldData();
                mapper.SelectColorArray("colors");
                this.coneActor = new vtkActor();
                this.coneActor.SetMapper((vtkMapper)mapper);
                this.coneActor.SetVisibility(1);
                this.coneActor.GetProperty().SetOpacity(1.0);
                this.actors.addActor((vtkProp)this.coneActor);
            }
            actor = this.coneActor;
            points = this.conePoints;
            radiusArray = this.coneRadius;
            colorArray = this.coneColors;
        } else {
            if (this.sphereActor == null) {
                this.spherePoints = new vtkPoints();
                this.sphereRadius = new vtkDoubleArray();
                this.sphereRadius.SetName("radius");
                this.sphereColors = new vtkUnsignedCharArray();
                this.sphereColors.SetName("colors");
                this.sphereColors.SetNumberOfComponents(4);
                mapper = new vtkPolyDataMapper();
                inputData = new vtkPolyData();
                inputData.SetPoints(this.spherePoints);
                inputData.GetPointData().AddArray((vtkAbstractArray)this.sphereRadius);
                inputData.GetPointData().AddArray((vtkAbstractArray)this.sphereColors);
                inputData.GetPointData().SetActiveScalars("radius");
                vtkSphereSource balls = new vtkSphereSource();
                balls.SetRadius(1.0);
                balls.SetPhiResolution(7);
                balls.SetThetaResolution(7);
                vtkGlyph3D glyphPoints = new vtkGlyph3D();
                glyphPoints.SetInputData((vtkDataObject)inputData);
                glyphPoints.SetSourceConnection(balls.GetOutputPort());
                mapper.SetInputConnection(glyphPoints.GetOutputPort());
                mapper.ScalarVisibilityOn();
                mapper.SetScalarModeToUsePointFieldData();
                mapper.SelectColorArray("colors");
                this.sphereActor = new vtkActor();
                this.sphereActor.SetMapper((vtkMapper)mapper);
                this.sphereActor.SetVisibility(1);
                this.sphereActor.GetProperty().SetOpacity(1.0);
                this.actors.addActor((vtkProp)this.sphereActor);
            }
            actor = this.sphereActor;
            points = this.spherePoints;
            radiusArray = this.sphereRadius;
            colorArray = this.sphereColors;
        }
        double[] pt = Transform.transformLatLonHeight(loc.getLatitude(), loc.getLongitude(), -loc.getDepth());
        double size = 2.0;
        points.InsertNextPoint(pt);
        radiusArray.InsertNextTuple1(size);
        colorArray.InsertNextTuple4((double)color.getRed(), (double)color.getGreen(), (double)color.getBlue(), 255.0);
        points.Modified();
        radiusArray.Modified();
        colorArray.Modified();
        actor.Modified();
    }

    public void parameterChange(ParameterChangeEvent event) {
        if (event.getSource() == this.computeButton) {
            this.compute();
        } else if (event.getSource() == this.erfParam) {
            this.erf = null;
            this.rupSet = null;
            this.loadERF();
            this.clearActors();
            this.fireTreeChangeEvent();
        } else if (event.getSource() == this.erfParamsParam) {
            if (this.erf == null) {
                this.loadERF();
            }
            this.rupSet = null;
            this.clearActors();
            this.fireTreeChangeEvent();
        } else if (event.getSource() == this.timeSpanButton) {
            if (this.erf == null) {
                this.loadERF();
            }
            if (this.timeSpanBean == null) {
                this.timeSpanBean = new TimeSpanGuiBean(this.erf.getTimeSpan());
            } else {
                this.timeSpanBean.setTimeSpan(this.erf.getTimeSpan());
            }
            this.showDialog((JComponent)this.timeSpanBean);
        } else if (event.getSource() == this.imrParamsButton) {
            this.showDialog((JComponent)this.imrBean);
        } else if (event.getSource() == this.imtParamsButton) {
            this.showDialog((JComponent)this.imtBean);
        } else if (event.getSource() == this.siteParamsButton) {
            this.showDialog((JComponent)this.siteBean);
        } else if (event.getSource() == this.siteDataParamsButton) {
            this.siteControl = new SiteDataControlPanel(null, this.imrBean, this.siteBean);
            this.siteControl.showControlPanel();
        }
    }

    private void showDialog(JComponent comp) {
        JFrame frame = new JFrame();
        frame.setContentPane(comp);
        frame.pack();
        frame.setVisible(true);
    }

    private void fireTreeChangeEvent() {
        if (this.l != null) {
            this.l.treeChanged(null);
        }
    }

    public void imrChange(ScalarIMRChangeEvent event) {
        this.siteBean.replaceSiteParams(this.imrBean.getMultiIMRSiteParamIterator());
        this.siteBean.validate();
        this.siteBean.repaint();
    }

    private static enum ERF_CHOICES {
        MEAN_UCERF3("Mean UCERF3"),
        FSS("Fault System Solution");

        private String name;

        private ERF_CHOICES(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    private class DisaggColorer
    extends CPTBasedColorer {
        public DisaggColorer() {
            super(UCERF3DisaggBuilder.this.defaultCPT, true);
        }

        public String getName() {
            return "Disaggregation Colorer";
        }

        @Override
        public double getValue(AbstractFaultSection fault) {
            if (UCERF3DisaggBuilder.this.sectVals == null || !(fault instanceof PrefDataSection)) {
                return Double.NaN;
            }
            FaultSection sect = ((PrefDataSection)fault).getFaultSection();
            Double val = UCERF3DisaggBuilder.this.sectVals.get(sect.getSectionId());
            if (val == null || val == 0.0) {
                return Double.NaN;
            }
            return val;
        }

        @Override
        public void setCPT(CPT cpt) {
            UCERF3DisaggBuilder.this.displayGridded();
            super.setCPT(cpt);
        }

        @Override
        public void setCPT(CPT cpt, boolean isLog) {
            UCERF3DisaggBuilder.this.displayGridded();
            super.setCPT(cpt, isLog);
        }

        @Override
        public void setCPTLog(boolean newCPTLog) {
            UCERF3DisaggBuilder.this.displayGridded();
            super.setCPTLog(newCPTLog);
        }

        @Override
        public void fireColorerChangeEvent() {
            UCERF3DisaggBuilder.this.displayGridded();
            super.fireColorerChangeEvent();
        }
    }
}

