/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.plugins.opensha.ucerf3Rups;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.EnumSet;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.dom4j.Document;
import org.dom4j.Element;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.editor.impl.GriddedParameterListEditor;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.impl.ButtonParameter;
import org.opensha.commons.param.impl.EnumParameter;
import org.opensha.commons.util.XMLUtils;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import scratch.UCERF3.utils.FaultSectionDataWriter;
import scratch.UCERF3.utils.U3FaultSystemIO;

public class RuptureInfoViewSave
extends JFrame
implements ParameterChangeListener {
    private FaultSystemRupSet rupSet;
    private FaultSystemSolution sol;
    private static final String CHOOSE_PARAM_NAME = "View Type";
    private EnumParameter<Choice> chooseParameter;
    private static final String SAVE_PARAM_NAME = "Data Files";
    private static final String SAVE_PARAM_BUTTON_TEXT = "Save";
    private ButtonParameter saveParam;
    private ParameterList params = new ParameterList();
    private JTextArea area;
    private JFileChooser fileChoose;

    public RuptureInfoViewSave(FaultSystemRupSet rupSet, FaultSystemSolution sol) {
        JPanel panel = new JPanel(new BorderLayout());
        this.rupSet = rupSet;
        this.sol = sol;
        this.chooseParameter = new EnumParameter(CHOOSE_PARAM_NAME, EnumSet.allOf(Choice.class), (Enum)Choice.SECTIONS_ASCII, null);
        this.params.addParameter(this.chooseParameter);
        this.chooseParameter.addParameterChangeListener((ParameterChangeListener)this);
        this.saveParam = new ButtonParameter(SAVE_PARAM_NAME, SAVE_PARAM_BUTTON_TEXT);
        this.params.addParameter((Parameter)this.saveParam);
        this.saveParam.addParameterChangeListener((ParameterChangeListener)this);
        GriddedParameterListEditor paramEdit = new GriddedParameterListEditor(this.params);
        panel.add((Component)paramEdit, "North");
        this.area = new JTextArea();
        this.area.setEditable(false);
        panel.add((Component)new JScrollPane(this.area), "Center");
        this.updateTextArea();
        this.setContentPane(panel);
        this.setSize(1000, 800);
        this.setDefaultCloseOperation(2);
        this.setVisible(true);
    }

    private void updateTextArea() {
        Choice choice = (Choice)((Object)this.chooseParameter.getValue());
        switch (choice.ordinal()) {
            case 0: {
                StringBuffer ascii = FaultSectionDataWriter.getSectionsASCII((List)this.rupSet.getFaultSectionDataList(), null, (boolean)false);
                this.area.setText(ascii.toString());
                break;
            }
            case 2: {
                StringBuffer rups = FaultSectionDataWriter.getRupsASCII((FaultSystemRupSet)this.rupSet);
                this.area.setText(rups.toString());
                break;
            }
            case 3: {
                if (this.sol != null) {
                    StringBuffer rupsAndRates = FaultSectionDataWriter.getRupsASCII((FaultSystemRupSet)this.rupSet, (FaultSystemSolution)this.sol);
                    this.area.setText(rupsAndRates.toString());
                    break;
                }
                JOptionPane.showMessageDialog(null, "A solution must be loaded to view rupture rates!", "No Solution Loaded!", 0);
                break;
            }
            case 1: {
                Document doc = XMLUtils.createDocumentWithRoot();
                U3FaultSystemIO.fsDataToXML((Element)doc.getRootElement(), (String)"FaultSectionPrefDataList", (FaultSystemRupSet)this.rupSet);
                String text = "";
                try {
                    text = XMLUtils.getDocumentAsString((Document)doc);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(this, "Error: " + String.valueOf(e), "Error Creating XML!", 0);
                }
                this.area.setText(text);
                break;
            }
        }
        this.area.setCaretPosition(0);
    }

    public void parameterChange(ParameterChangeEvent event) {
        if (event.getParameter() == this.chooseParameter) {
            this.updateTextArea();
        } else if (event.getParameter() == this.saveParam) {
            int ret;
            if (this.fileChoose == null) {
                this.fileChoose = new JFileChooser();
            }
            if ((ret = this.fileChoose.showSaveDialog(this)) == 0) {
                File file = this.fileChoose.getSelectedFile();
                try {
                    FileWriter fw = new FileWriter(file);
                    fw.write(this.area.getText());
                    fw.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(this, "Error: " + String.valueOf(e), "Error Saving File!", 0);
                }
            }
        }
    }

    private static enum Choice {
        SECTIONS_ASCII("Fault Section Data (ASCII)"),
        SECTIONS_XML("Fault Section Data (XML)"),
        RUPTURES("Rupture Information"),
        RUPTURES_AND_RATES("Rupture/Rates Information");

        private String name;

        private Choice(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

