/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.plugins.opensha.ucerf3Rups;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.awt.Color;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipFile;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import org.apache.commons.lang3.text.WordUtils;
import org.opensha.commons.calc.FaultMomentCalc;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.eq.MagUtils;
import org.opensha.commons.gui.plot.GraphWindow;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.constraint.impl.StringConstraint;
import org.opensha.commons.param.editor.impl.FileParameterEditor;
import org.opensha.commons.param.editor.impl.GriddedParameterListEditor;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.impl.ButtonParameter;
import org.opensha.commons.param.impl.EnumParameter;
import org.opensha.commons.param.impl.FileParameter;
import org.opensha.commons.param.impl.StringParameter;
import org.opensha.commons.util.ClassUtils;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.faultSurface.FaultSection;
import org.scec.vtk.commons.opensha.faults.anim.FaultAnimation;
import org.scec.vtk.commons.opensha.faults.colorers.AseismicityColorer;
import org.scec.vtk.commons.opensha.faults.colorers.CouplingCoefficientColorer;
import org.scec.vtk.commons.opensha.faults.colorers.DipColorer;
import org.scec.vtk.commons.opensha.faults.colorers.FaultColorer;
import org.scec.vtk.commons.opensha.faults.colorers.RakeColorer;
import org.scec.vtk.commons.opensha.faults.faultSectionImpl.PrefDataSection;
import org.scec.vtk.commons.opensha.gui.EventManager;
import org.scec.vtk.commons.opensha.gui.FaultHighlighter;
import org.scec.vtk.commons.opensha.gui.GeometryTypeSelectorPanel;
import org.scec.vtk.commons.opensha.tree.FaultCategoryNode;
import org.scec.vtk.commons.opensha.tree.FaultSectionNode;
import org.scec.vtk.commons.opensha.tree.builders.FaultTreeBuilder;
import org.scec.vtk.commons.opensha.tree.events.TreeChangeListener;
import org.scec.vtk.main.MainGUI;
import org.scec.vtk.plugins.Plugin;
import org.scec.vtk.plugins.opensha.ucerf3Rups.RuptureComparisonViewer;
import org.scec.vtk.plugins.opensha.ucerf3Rups.RuptureInfoViewSave;
import org.scec.vtk.plugins.opensha.ucerf3Rups.UCERF3RupSetChangeListener;
import org.scec.vtk.plugins.opensha.ucerf3Rups.anims.ETASCatalogAnim;
import org.scec.vtk.plugins.opensha.ucerf3Rups.anims.GridSourceAnim;
import org.scec.vtk.plugins.opensha.ucerf3Rups.anims.RupturesAnim;
import org.scec.vtk.plugins.opensha.ucerf3Rups.anims.SectionResetAnim;
import org.scec.vtk.plugins.opensha.ucerf3Rups.colorers.ComparisonColorer;
import org.scec.vtk.plugins.opensha.ucerf3Rups.colorers.DateLastEventColorer;
import org.scec.vtk.plugins.opensha.ucerf3Rups.colorers.ETASMultiCatalogColorer;
import org.scec.vtk.plugins.opensha.ucerf3Rups.colorers.EternalDatasetColorer;
import org.scec.vtk.plugins.opensha.ucerf3Rups.colorers.InversionSlipRateColorer;
import org.scec.vtk.plugins.opensha.ucerf3Rups.colorers.MaxMagColorer;
import org.scec.vtk.plugins.opensha.ucerf3Rups.colorers.MultiFaultRupColorer;
import org.scec.vtk.plugins.opensha.ucerf3Rups.colorers.NucleationRateColorer;
import org.scec.vtk.plugins.opensha.ucerf3Rups.colorers.ParentSectColorer;
import org.scec.vtk.plugins.opensha.ucerf3Rups.colorers.ParticipationRateColorer;
import org.scec.vtk.plugins.opensha.ucerf3Rups.colorers.RSQSimRuptureMappingColorer;
import org.scec.vtk.plugins.opensha.ucerf3Rups.colorers.StiffnessColorer;
import scratch.UCERF3.U3CompoundFaultSystemSolution;
import scratch.UCERF3.U3SlipEnabledSolution;
import scratch.UCERF3.analysis.FaultSpecificSegmentationPlotGen;
import scratch.UCERF3.enumTreeBranches.FaultModels;
import scratch.UCERF3.inversion.BatchPlotGen;
import scratch.UCERF3.inversion.CommandLineInversionRunner;
import scratch.UCERF3.inversion.InversionFaultSystemRupSet;
import scratch.UCERF3.inversion.InversionFaultSystemSolution;
import scratch.UCERF3.logicTree.U3LogicTreeBranch;
import scratch.UCERF3.utils.aveSlip.U3AveSlipConstraint;
import scratch.UCERF3.utils.paleoRateConstraints.PaleoFitPlotter;
import scratch.UCERF3.utils.paleoRateConstraints.PaleoSiteCorrelationData;
import scratch.UCERF3.utils.paleoRateConstraints.UCERF3_PaleoRateConstraintFetcher;

public class UCERF3FaultSystemRupturesBuilder
implements FaultTreeBuilder,
ParameterChangeListener {
    private FaultSystemRupSet rupSet;
    private FaultSystemSolution sol;
    private ArrayList<FaultAnimation> anims;
    private ArrayList<FaultColorer> colorers;
    private ArrayList<UCERF3RupSetChangeListener> rupSetChangeListeners;
    private ParameterList faultParams = PrefDataSection.createPrefDataParams();
    private static final String RUP_SET_FILE_PARAM_NAME = "Load Rupture Set/Solution File";
    private FileParameter rupSetFileParam;
    private static final String FIGURE_PARAM_NAME = "Display Figure...";
    private static final String FIGURE_PARAM_DEFAULT = "(select)";
    private EnumParameter<Figures> figureParam;
    private RuptureComparisonViewer rupComp;
    private ComparisonColorer compColor;
    private ETASCatalogAnim etasAnim;
    private ParameterList builderParams;
    private TreeChangeListener l;
    private static final String DEFAULT_NAME = "All Fault Sections";
    private String name;
    private StiffnessColorer stiffnessColorer;
    private EventManager em;
    private FaultHighlighter highlight;
    private File defaultLoadDir;
    private static String compoundName;

    public UCERF3FaultSystemRupturesBuilder(Plugin plugin) {
        this.faultParams.getParameter(Boolean.class, "Fit Grid Spacing Exactly").setValue((Object)false);
        this.faultParams.getParameter(Boolean.class, "Aseis Reduces Area").setValue((Object)false);
        File defaultLoadDir = new File("/home/kevin/OpenSHA/UCERF4/rup_sets");
        if (!defaultLoadDir.exists()) {
            defaultLoadDir = new File(MainGUI.getCWD().getParentFile(), "OpenSHA" + File.separator + "dev" + File.separator + "scratch" + File.separator + "UCERF3" + File.separator + "data" + File.separator + "scratch");
        }
        if (!defaultLoadDir.exists()) {
            defaultLoadDir = new File(MainGUI.getCWD(), "data");
        }
        System.out.println(defaultLoadDir.getAbsolutePath() + " ? " + defaultLoadDir.exists());
        if (!defaultLoadDir.exists()) {
            defaultLoadDir = null;
        }
        this.rupSetFileParam = new FileParameter(RUP_SET_FILE_PARAM_NAME);
        this.setDefaultDir(defaultLoadDir);
        this.rupSetFileParam.addParameterChangeListener((ParameterChangeListener)this);
        this.figureParam = new EnumParameter(FIGURE_PARAM_NAME, EnumSet.allOf(Figures.class), null, FIGURE_PARAM_DEFAULT);
        this.figureParam.setValue(null);
        this.figureParam.addParameterChangeListener((ParameterChangeListener)this);
        this.figureParam.getEditor().setEnabled(false);
        this.builderParams = new ParameterList();
        this.builderParams.addParameter((Parameter)this.rupSetFileParam);
        this.builderParams.addParameter(this.figureParam);
        this.rupSetChangeListeners = new ArrayList();
        this.anims = new ArrayList();
        this.colorers = new ArrayList();
        this.colorers.add(new AseismicityColorer());
        this.colorers.add(new CouplingCoefficientColorer());
        InversionSlipRateColorer invSlipRate = new InversionSlipRateColorer();
        this.colorers.add(0, invSlipRate);
        this.rupSetChangeListeners.add(invSlipRate);
        this.etasAnim = new ETASCatalogAnim(plugin.getPluginActors());
        this.anims.add(this.etasAnim);
        this.rupSetChangeListeners.add(this.etasAnim);
        SectionResetAnim sectResetAnim = new SectionResetAnim(plugin.getPluginActors());
        this.anims.add(sectResetAnim);
        this.rupSetChangeListeners.add(sectResetAnim);
        GridSourceAnim gridSourceAnim = new GridSourceAnim(plugin.getPluginActors());
        this.anims.add(gridSourceAnim);
        this.rupSetChangeListeners.add(gridSourceAnim);
        RupturesAnim rupturesAnim = new RupturesAnim();
        this.anims.add(rupturesAnim);
        this.rupSetChangeListeners.add(rupturesAnim);
        ParticipationRateColorer partRateColor = new ParticipationRateColorer(plugin.getPluginActors());
        this.colorers.add(partRateColor);
        this.rupSetChangeListeners.add(partRateColor);
        NucleationRateColorer nucleationColor = new NucleationRateColorer();
        this.colorers.add(nucleationColor);
        this.rupSetChangeListeners.add(nucleationColor);
        this.compColor = new ComparisonColorer(this);
        this.colorers.add(this.compColor);
        this.rupSetChangeListeners.add(this.compColor);
        MultiFaultRupColorer stackedRupColorer = new MultiFaultRupColorer();
        this.colorers.add(stackedRupColorer);
        this.rupSetChangeListeners.add(stackedRupColorer);
        this.stiffnessColorer = new StiffnessColorer(plugin.getPluginActors());
        this.colorers.add(this.stiffnessColorer);
        this.rupSetChangeListeners.add(this.stiffnessColorer);
        this.colorers.add(new EternalDatasetColorer());
        MaxMagColorer maxMagColorer = new MaxMagColorer();
        this.colorers.add(maxMagColorer);
        this.rupSetChangeListeners.add(maxMagColorer);
        this.colorers.add(new DipColorer());
        this.colorers.add(new RakeColorer());
        DateLastEventColorer dateColorer = new DateLastEventColorer();
        this.colorers.add(dateColorer);
        this.rupSetChangeListeners.add(dateColorer);
        this.colorers.add(new ParentSectColorer());
        ETASMultiCatalogColorer etasMulti = new ETASMultiCatalogColorer(plugin.getPluginActors());
        this.colorers.add(etasMulti);
        this.rupSetChangeListeners.add(etasMulti);
        RSQSimRuptureMappingColorer rsqsimMapping = new RSQSimRuptureMappingColorer();
        this.rupSetChangeListeners.add(rsqsimMapping);
        this.colorers.add(rsqsimMapping);
    }

    public void setGeometryTypeSelector(GeometryTypeSelectorPanel geomSelect) {
    }

    @Override
    public ParameterList getBuilderParams() {
        return this.builderParams;
    }

    @Override
    public ParameterList getFaultParams() {
        return this.faultParams;
    }

    @Override
    public void setTreeChangeListener(TreeChangeListener l) {
        this.l = l;
    }

    @Override
    public void buildTree(DefaultMutableTreeNode root) {
        String infoStr;
        if (this.rupSet == null) {
            return;
        }
        String catName = this.name == null ? DEFAULT_NAME : this.name;
        String info = ClassUtils.getClassNameWithoutPackage(this.rupSet.getClass()) + "\nFile Name: " + this.name + "\nNum Ruptures: " + this.rupSet.getNumRuptures();
        if (this.sol != null) {
            try {
                int numNonZeros = 0;
                for (double rate : this.sol.getRateForAllRups()) {
                    if (rate == 0.0) continue;
                    ++numNonZeros;
                }
                float percent = (float)numNonZeros / (float)this.rupSet.getNumRuptures() * 100.0f;
                info = info + "\nNum Non-Zero Rups: " + numNonZeros + "/" + this.rupSet.getNumRuptures() + " (" + percent + " %)";
            }
            catch (RuntimeException numNonZeros) {
                // empty catch block
            }
        }
        if ((infoStr = this.rupSet.getInfoString()) != null && !infoStr.isEmpty()) {
            info = info + "\n\n****Metadata****";
            for (String line : Splitter.on((char)'\n').split((CharSequence)infoStr)) {
                info = info + "\n" + WordUtils.wrap((String)line, (int)100);
            }
        }
        info = "<html>" + info.replaceAll("\n", "<br>") + "</html>";
        FaultCategoryNode catNode = new FaultCategoryNode(catName, info);
        List sectionData = this.rupSet.getFaultSectionDataList();
        for (FaultSection data : sectionData) {
            String name = data.getSectionId() + ". " + data.getName();
            PrefDataSection fault = new PrefDataSection(name, data);
            FaultSectionNode faultNode = new FaultSectionNode(fault);
            catNode.add(faultNode);
        }
        root.add(catNode);
    }

    public ArrayList<FaultAnimation> getFaultAnimations() {
        return this.anims;
    }

    public ArrayList<FaultColorer> getFaultColorers() {
        return this.colorers;
    }

    public static void showErrorMessage(Throwable t) {
        JOptionPane.showMessageDialog(null, "Error: " + t.getMessage(), "Error reading file!", 0);
    }

    private void hideRupComp() {
        if (this.rupComp != null) {
            this.rupComp.setVisible(false);
            this.rupComp.dispose();
            this.rupComp = null;
        }
    }

    public void parameterChange(ParameterChangeEvent event) {
        Figures fig;
        this.name = null;
        if (event.getParameterName().equals(RUP_SET_FILE_PARAM_NAME)) {
            this.hideRupComp();
            File file = (File)this.rupSetFileParam.getValue();
            FaultSystemRupSet prevRupSet = this.rupSet;
            if (this.rupSet != null) {
                this.rupSet = null;
                this.fireRupSetNullEvent();
            }
            System.gc();
            if (file != null) {
                this.sol = null;
                try {
                    ZipFile zip = new ZipFile(file);
                    compoundName = null;
                    if (FaultSystemSolution.isSolution((ZipFile)zip)) {
                        this.sol = FaultSystemSolution.load((ZipFile)zip);
                        this.sol.setShowProgress(true);
                        this.rupSet = this.sol.getRupSet();
                    } else {
                        this.rupSet = UCERF3FaultSystemRupturesBuilder.loadRupSetFromFile(zip);
                    }
                    if (compoundName != null) {
                        this.name = compoundName;
                        this.rupSetFileParam.removeParameterChangeListener((ParameterChangeListener)this);
                        this.rupSetFileParam.setValue(null);
                        this.rupSetFileParam.addParameterChangeListener((ParameterChangeListener)this);
                    } else {
                        this.name = file.getName();
                    }
                    this.defaultLoadDir = file.getParentFile();
                    this.compColor.setLoadDir(this.defaultLoadDir);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    UCERF3FaultSystemRupturesBuilder.showErrorMessage(e);
                    this.rupSetFileParam.setValue(null);
                    return;
                }
            }
            System.gc();
            if (this.l != null) {
                this.l.treeChanged(null);
            }
            this.fireRupSetChangedEvent();
        } else if (event.getParameter() == this.figureParam && (fig = (Figures)((Object)this.figureParam.getValue())) != null) {
            switch (fig.ordinal()) {
                case 0: {
                    if (this.sol != null && this.sol instanceof InversionFaultSystemSolution) {
                        try {
                            ArrayList segRateConstraints = UCERF3_PaleoRateConstraintFetcher.getConstraints((List)this.rupSet.getFaultSectionDataList());
                            List aveSlipConstraints = U3AveSlipConstraint.load((List)this.rupSet.getFaultSectionDataList());
                            PaleoFitPlotter.showSegRateComparison((List)segRateConstraints, (List)aveSlipConstraints, (InversionFaultSystemSolution)((InversionFaultSystemSolution)this.sol));
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            JOptionPane.showMessageDialog(null, e.getMessage(), "Error loading paleo data", 0);
                        }
                        break;
                    }
                    JOptionPane.showMessageDialog(null, "At least one solution must be loaded\nfor this plot.", "Error creating figure", 0);
                    break;
                }
                case 1: {
                    if (this.sol != null && this.compColor != null && this.compColor.getCompFaultSystemSolution() != null) {
                        this.hideRupComp();
                        FaultSystemSolution sol1 = this.sol;
                        FaultSystemSolution sol2 = this.compColor.getCompFaultSystemSolution();
                        this.rupComp = new RuptureComparisonViewer(sol1, sol2, this.highlight);
                        break;
                    }
                    JOptionPane.showMessageDialog(null, "Two solutions must be loaded for this view...both above and in the 'Comparison Colorer' section below.", "Error creating figure", 0);
                    break;
                }
                case 2: {
                    if (this.rupSet != null) {
                        new RuptureInfoViewSave(this.rupSet, this.sol);
                        break;
                    }
                    JOptionPane.showMessageDialog(null, "No ruptures are loaded!", "Error creating figure", 0);
                    break;
                }
                case 3: {
                    if (this.sol == null || !(this.sol instanceof InversionFaultSystemSolution)) break;
                    ((InversionFaultSystemSolution)this.sol).plotMFDs();
                    break;
                }
                case 4: {
                    if (this.sol == null) break;
                    EvenlyDiscretizedFunc func = new EvenlyDiscretizedFunc(0.0, this.rupSet.getNumRuptures(), 1.0);
                    double[] rates = Arrays.copyOf(this.sol.getRateForAllRups(), this.rupSet.getNumRuptures());
                    Arrays.sort(rates);
                    int cnt = 0;
                    int zeros = 0;
                    int i = rates.length;
                    while (--i >= 0) {
                        func.set(cnt++, rates[i]);
                        if (rates[i] != 0.0) continue;
                        ++zeros;
                    }
                    System.out.println("Min rate: " + rates[0]);
                    System.out.println("Zero rates: " + zeros);
                    ArrayList<EvenlyDiscretizedFunc> funcs = new ArrayList<EvenlyDiscretizedFunc>();
                    funcs.add(func);
                    ArrayList chars = Lists.newArrayList((Object[])new PlotCurveCharacterstics[]{new PlotCurveCharacterstics(PlotLineType.SOLID, 1.0f, Color.BLACK)});
                    GraphWindow graph = new GraphWindow(funcs, "Rupture Rate Distribution", (List)chars);
                    graph.setX_AxisLabel("Rank");
                    graph.setY_AxisLabel("Rate");
                    graph.setYLog(true);
                    break;
                }
                case 5: {
                    if (this.sol == null) break;
                    EvenlyDiscretizedFunc func = new EvenlyDiscretizedFunc(0.0, this.rupSet.getNumRuptures(), 1.0);
                    double[] rates = Arrays.copyOf(this.sol.getRateForAllRups(), this.rupSet.getNumRuptures());
                    if (this.rupSet instanceof InversionFaultSystemRupSet) {
                        InversionFaultSystemRupSet invRupSet = (InversionFaultSystemRupSet)this.rupSet;
                        for (int r = 0; r < rates.length; ++r) {
                            rates[r] = rates[r] * FaultMomentCalc.getMoment((double)this.rupSet.getAreaForRup(r), (double)invRupSet.getAveSlipForRup(r));
                        }
                    } else {
                        for (int r = 0; r < rates.length; ++r) {
                            rates[r] = rates[r] * MagUtils.magToMoment((double)this.rupSet.getMagForRup(r));
                        }
                    }
                    Arrays.sort(rates);
                    int cnt = 0;
                    int zeros = 0;
                    EvenlyDiscretizedFunc cmlFunc = new EvenlyDiscretizedFunc(0.0, rates.length, 1.0);
                    cmlFunc.setName("Cumulative Moment Rate");
                    double cml = 0.0;
                    int i = rates.length;
                    while (--i >= 0) {
                        cmlFunc.set(cnt, cml += rates[i]);
                        func.set(cnt++, rates[i]);
                        if (rates[i] != 0.0) continue;
                        ++zeros;
                    }
                    System.out.println("Min rate: " + rates[0]);
                    System.out.println("Zero rates: " + zeros);
                    ArrayList<EvenlyDiscretizedFunc> funcs = new ArrayList<EvenlyDiscretizedFunc>();
                    funcs.add(func);
                    ArrayList chars = Lists.newArrayList((Object[])new PlotCurveCharacterstics[]{new PlotCurveCharacterstics(PlotLineType.SOLID, 1.0f, Color.BLACK)});
                    funcs.add(cmlFunc);
                    chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 1.0f, Color.BLUE));
                    GraphWindow graph = new GraphWindow(funcs, "Rupture Moment Rate Distribution", (List)chars);
                    graph.setX_AxisLabel("Rank");
                    graph.setY_AxisLabel("Moment RateRate");
                    graph.setYLog(true);
                    break;
                }
                case 6: {
                    if (this.sol == null || !(this.sol instanceof InversionFaultSystemSolution)) break;
                    List parentSects = FaultSpecificSegmentationPlotGen.getSAFParents((FaultModels)((InversionFaultSystemRupSet)this.rupSet).getFaultModel());
                    FaultSpecificSegmentationPlotGen.plotSegmentation((List)parentSects, (InversionFaultSystemSolution)((InversionFaultSystemSolution)this.sol), (double)7.0, (boolean)false);
                    break;
                }
                case 7: {
                    int ret;
                    if (this.sol == null || !(this.sol instanceof InversionFaultSystemSolution)) break;
                    JFileChooser choose = new JFileChooser();
                    File defaultDir = new File(MainGUI.getCWD(), "data");
                    if (defaultDir.exists()) {
                        choose.setCurrentDirectory(defaultDir);
                    }
                    if ((ret = choose.showSaveDialog(null)) != 0) break;
                    File outFile = choose.getSelectedFile();
                    if (!outFile.getName().toLowerCase().endsWith(".xls")) {
                        outFile = new File(outFile.getParentFile(), outFile.getName() + ".xls");
                    }
                    try {
                        PaleoSiteCorrelationData.loadPaleoCorrelationData((InversionFaultSystemSolution)((InversionFaultSystemSolution)this.sol), (File)outFile);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        JOptionPane.showMessageDialog(null, "Error: " + e.getMessage(), "Error writing paleo correlation file!", 0);
                    }
                    break;
                }
                case 8: {
                    if (this.sol == null || !(this.sol instanceof InversionFaultSystemSolution)) break;
                    InversionFaultSystemSolution invSol = (InversionFaultSystemSolution)this.sol;
                    JFileChooser choose = new JFileChooser();
                    choose.setFileSelectionMode(1);
                    int ret = choose.showSaveDialog(null);
                    if (ret != 0) break;
                    File outDir = choose.getSelectedFile();
                    if (!outDir.exists()) {
                        outDir.mkdir();
                    }
                    try {
                        ArrayList paleoRateConstraints = CommandLineInversionRunner.getPaleoConstraints((FaultModels)invSol.getRupSet().getFaultModel(), (FaultSystemRupSet)invSol.getRupSet());
                        List aveSlipConstraints = U3AveSlipConstraint.load((List)this.sol.getRupSet().getFaultSectionDataList());
                        Map namedFaultsMap = invSol.getRupSet().getFaultModel().getNamedFaultsMapAlt();
                        CommandLineInversionRunner.writePaleoFaultPlots((List)paleoRateConstraints, (List)aveSlipConstraints, (Map)namedFaultsMap, (U3SlipEnabledSolution)invSol, (File)outDir);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        JOptionPane.showMessageDialog(null, "Error: " + e.getMessage(), "Error writing plots!", 0);
                    }
                    break;
                }
                case 9: {
                    int ret;
                    if (this.sol == null || !(this.sol instanceof InversionFaultSystemSolution)) break;
                    JFileChooser choose = new JFileChooser();
                    choose.setFileSelectionMode(1);
                    String s = File.separator;
                    File defaultDir = new File(MainGUI.getCWD(), "data" + s + "ShakeMapPlugin");
                    if (defaultDir.exists()) {
                        choose.setCurrentDirectory(defaultDir);
                    }
                    if ((ret = choose.showSaveDialog(null)) != 0) break;
                    final File outDir = choose.getSelectedFile();
                    if (!outDir.exists()) {
                        outDir.mkdir();
                    }
                    final InversionFaultSystemSolution theSol = (InversionFaultSystemSolution)this.sol;
                    JOptionPane.showMessageDialog(null, "All plots will be written to:\n" + outDir.getName() + "\nYou can continue to use SCEC-VDO\nwhile plots are generated (it can\ntake some time), a dialog will pop\nup when complete.", "All plots will be writting", 1);
                    new Thread(){

                        @Override
                        public void run() {
                            try {
                                File file = new File(outDir, outDir.getName() + "_sol.zip");
                                theSol.write(file);
                                BatchPlotGen.handleSolutionFile((File)file, (String)outDir.getName(), (InversionFaultSystemSolution)theSol, null);
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        JOptionPane.showMessageDialog(null, "All plots were written to:\n" + outDir.getName(), "Plots Written Successfully", 1);
                                    }
                                });
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        JOptionPane.showMessageDialog(null, "Error: " + e.getMessage(), "Error writing plots!", 0);
                                    }
                                });
                            }
                        }
                    }.start();
                    break;
                }
                default: {
                    System.out.println("Unknown figure type: " + String.valueOf((Object)fig));
                }
            }
            this.figureParam.setValue(null);
        }
    }

    private static FaultSystemRupSet loadRupSetFromFile(ZipFile zip) throws Exception {
        FaultSystemRupSet rupSet = FaultSystemRupSet.load((ZipFile)zip);
        rupSet.setShowProgress(true);
        return rupSet;
    }

    private static FaultSystemSolution tryLoadFromCompoundSol(File file) {
        try {
            CompoundSelectionGUI gui;
            int selection;
            U3CompoundFaultSystemSolution sol = U3CompoundFaultSystemSolution.fromZipFile((File)file);
            if (!sol.getBranches().isEmpty() && (selection = JOptionPane.showConfirmDialog(null, (gui = new CompoundSelectionGUI(sol)).getEditor(), "Select Branch", 2)) == 0) {
                return gui.getSelectedSolution();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public void setEventManager(EventManager em) {
        this.em = em;
        this.highlight = new FaultHighlighter(em, em);
        this.stiffnessColorer.setEventManager(em);
    }

    private void fireRupSetNullEvent() {
        for (UCERF3RupSetChangeListener l : this.rupSetChangeListeners) {
            l.setRupSet(null, null);
        }
    }

    private void fireRupSetChangedEvent() {
        this.figureParam.getEditor().setEnabled(this.rupSet != null);
        if (this.em != null) {
            try {
                this.em.waitOnCalcThread();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        for (UCERF3RupSetChangeListener l : this.rupSetChangeListeners) {
            l.setRupSet(this.rupSet, this.sol);
        }
    }

    public void addRupSetChangeListener(UCERF3RupSetChangeListener l) {
        this.rupSetChangeListeners.add(l);
    }

    public File getDefaultDir() {
        return this.defaultLoadDir;
    }

    public void setDefaultDir(File defaultLoadDir) {
        this.defaultLoadDir = defaultLoadDir;
        ((FileParameterEditor)this.rupSetFileParam.getEditor()).setDefaultDir(defaultLoadDir);
    }

    private static enum Figures {
        PALEO_CONSTRAINT("Paleosiesmic Constraint Fit"),
        RATE_COMPARISON("Rupture Rates Comparison"),
        SECTION_DATA("View/Save Rupture Info"),
        REGIONAL_MFDS("Regional MFDs"),
        RUPTURE_RATE_VS_RANK("Rupture Rate Vs Rank"),
        RUP_MOM_RATE_VS_RANK("Rupture MoRate Vs Rank"),
        SAF_SEGMENTATION("SAF Segmentation"),
        PALEO_CORRELATION_GEN("Paleo Correlation Table"),
        PALEO_FAULT_BASED("Paleo Fault Based"),
        ALL_FILE_PLOTS("All File Based Plots");

        private String name;

        private Figures(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    private static class CompoundSelectionGUI
    implements ParameterChangeListener {
        private U3CompoundFaultSystemSolution sol;
        private List<U3LogicTreeBranch> branches;
        private ArrayList<String> strings;
        private GriddedParameterListEditor editor;
        private StringParameter filterParam;
        private ButtonParameter applyFilterParam;
        private StringParameter listParam;
        private static final String NONE_STRING = "(none)";

        public CompoundSelectionGUI(U3CompoundFaultSystemSolution sol) {
            this.sol = sol;
            this.branches = Lists.newArrayList((Iterable)sol.getBranches());
            Collections.sort(this.branches, new Comparator<U3LogicTreeBranch>(){

                @Override
                public int compare(U3LogicTreeBranch o1, U3LogicTreeBranch o2) {
                    return o1.buildFileName().compareTo(o2.buildFileName());
                }
            });
            this.strings = Lists.newArrayList();
            for (U3LogicTreeBranch branch : this.branches) {
                this.strings.add(branch.buildFileName());
            }
            ParameterList params = new ParameterList();
            this.filterParam = new StringParameter("Filter (multiple can be comma separated)", "");
            params.addParameter((Parameter)this.filterParam);
            this.applyFilterParam = new ButtonParameter("Update Filter", "Apply");
            this.applyFilterParam.addParameterChangeListener((ParameterChangeListener)this);
            params.addParameter((Parameter)this.applyFilterParam);
            this.listParam = new StringParameter("Available Branches", this.strings, this.strings.get(0));
            params.addParameter((Parameter)this.listParam);
            this.editor = new GriddedParameterListEditor(params, 0, 1);
            this.editor.setPreferredSize(new Dimension(700, 200));
        }

        public void parameterChange(ParameterChangeEvent event) {
            String filterStr;
            if (event.getParameter() == this.applyFilterParam && !(filterStr = ((String)this.filterParam.getValue()).trim()).isEmpty()) {
                ArrayList filters = Lists.newArrayList();
                if (filterStr.contains(",")) {
                    for (String filter : Splitter.on((String)",").split((CharSequence)filterStr)) {
                        filters.add(filter.trim());
                    }
                } else {
                    filters.add(filterStr);
                }
                this.updateFilter(filters);
            }
        }

        private void updateFilter(List<String> filters) {
            String selection;
            ArrayList filteredStrings;
            if (filters == null || filters.isEmpty()) {
                filteredStrings = this.strings;
            } else {
                filteredStrings = Lists.newArrayList();
                block0: for (String name : this.strings) {
                    for (String filter : filters) {
                        if (name.contains(filter)) continue;
                        continue block0;
                    }
                    filteredStrings.add(name);
                }
            }
            if (filteredStrings.isEmpty()) {
                filteredStrings.add(NONE_STRING);
            }
            if (!filteredStrings.contains(selection = (String)this.listParam.getValue())) {
                selection = (String)filteredStrings.get(0);
            }
            StringConstraint sconst = (StringConstraint)this.listParam.getConstraint();
            sconst.setStrings(filteredStrings);
            this.listParam.setValue((Object)selection);
            this.listParam.getEditor().refreshParamEditor();
        }

        public FaultSystemSolution getSelectedSolution() {
            String name = (String)this.listParam.getValue();
            int index = this.strings.indexOf(name);
            if (index < 0) {
                return null;
            }
            InversionFaultSystemSolution fss = this.sol.getSolution(this.branches.get(index));
            compoundName = name;
            return fss;
        }

        public GriddedParameterListEditor getEditor() {
            return this.editor;
        }
    }
}

