/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.plugins.opensha.ucerf3Rups.anims;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import java.awt.Color;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.constraint.impl.StringConstraint;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.impl.BooleanParameter;
import org.opensha.commons.param.impl.DoubleParameter;
import org.opensha.commons.param.impl.FileParameter;
import org.opensha.commons.param.impl.StringParameter;
import org.opensha.commons.util.cpt.CPT;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.faultSurface.FaultSection;
import org.scec.vtk.commons.opensha.faults.AbstractFaultSection;
import org.scec.vtk.commons.opensha.faults.anim.IDBasedFaultAnimation;
import org.scec.vtk.commons.opensha.faults.anim.TimeBasedFaultAnimation;
import org.scec.vtk.commons.opensha.faults.colorers.CPTBasedColorer;
import org.scec.vtk.commons.opensha.faults.colorers.ColorerChangeListener;
import org.scec.vtk.commons.opensha.faults.colorers.FaultColorer;
import org.scec.vtk.main.MainGUI;
import org.scec.vtk.plugins.PluginActors;
import org.scec.vtk.plugins.opensha.ucerf3Rups.UCERF3RupSetChangeListener;
import org.scec.vtk.tools.Transform;
import org.scec.vtk.tools.picking.PickEnabledActor;
import org.scec.vtk.tools.picking.PickHandler;
import org.scec.vtk.tools.picking.PointPickEnabledActor;
import scratch.UCERF3.erf.ETAS.ETAS_CatalogIO;
import scratch.UCERF3.erf.ETAS.ETAS_EqkRupture;
import scratch.UCERF3.erf.ETAS.ETAS_SimAnalysisTools;
import scratch.UCERF3.erf.ETAS.launcher.ETAS_Launcher;
import scratch.UCERF3.erf.FaultSystemSolutionERF;
import vtk.vtkAbstractArray;
import vtk.vtkCellPicker;
import vtk.vtkDataObject;
import vtk.vtkDoubleArray;
import vtk.vtkGlyph3D;
import vtk.vtkMapper;
import vtk.vtkPoints;
import vtk.vtkPolyData;
import vtk.vtkPolyDataMapper;
import vtk.vtkProp;
import vtk.vtkSphereSource;
import vtk.vtkUnsignedCharArray;
import vtk.vtkVertexGlyphFilter;

public class ETASCatalogAnim
extends CPTBasedColorer
implements TimeBasedFaultAnimation,
IDBasedFaultAnimation,
UCERF3RupSetChangeListener,
ParameterChangeListener,
PickHandler<AbstractFaultSection> {
    private FileParameter catalogFileParam;
    private BooleanParameter hideFaultsParam;
    protected DoubleParameter minMagParam;
    protected DoubleParameter opacityParam;
    private StringParameter subSectParam;
    private static final String ALL_SUB_SECTS = "(all)";
    private BooleanParameter onlyCurrentParam;
    private DoubleParameter catDurationParam;
    private ParameterList animParams;
    private List<ETAS_EqkRupture> catalog;
    private List<ETAS_EqkRupture> displayCatalog;
    private Map<Integer, ETAS_EqkRupture> catalogMap;
    private Map<Integer, Integer> parentsMap;
    private Map<Integer, List<Integer>> childrenMap;
    private FaultSystemSolutionERF erf;
    protected FaultSystemSolution sol;
    private ArrayList<ChangeListener> listeners = new ArrayList();
    private int curStep = -1;
    protected HashSet<Integer> sectsRuptured;
    protected Map<Integer, Integer> mostRecentSectRups;
    protected Map<Integer, Double> mostRecentSectMag;
    private PickHandler<ETAS_EqkRupture> spherePicker;
    private PluginActors actors;
    private static final boolean point_display = false;
    private vtkVertexGlyphFilter vertexGlyphFilter;
    private static final double[] sphere_mag_bins = new double[]{3.5, 4.0, 5.0, 6.0, 100.0};
    private static final int[] sphere_resolutions = new int[]{5, 7, 12, 20, 40};
    private PointPickEnabledActor<ETAS_EqkRupture>[] sphereActor;
    private vtkPoints[] spherePoints;
    private vtkDoubleArray[] sphereRadius;
    private vtkUnsignedCharArray[] sphereColors;

    private static CPT getDefaultCPT() {
        CPT cpt = new CPT(2.5, 8.0, new Color[]{Color.RED, Color.ORANGE, Color.YELLOW, Color.GREEN});
        return cpt;
    }

    public ETASCatalogAnim(PluginActors actors) {
        super(ETASCatalogAnim.getDefaultCPT(), false);
        this.actors = actors;
        this.animParams = new ParameterList();
        this.catalogFileParam = new FileParameter("Catalog File");
        this.catalogFileParam.addParameterChangeListener((ParameterChangeListener)this);
        this.animParams.addParameter((Parameter)this.catalogFileParam);
        File defaultInitialDir = new File("/home/kevin/OpenSHA/UCERF3/etas/simulations");
        if (defaultInitialDir.exists()) {
            this.catalogFileParam.setDefaultInitialDir(defaultInitialDir);
        }
        this.hideFaultsParam = new BooleanParameter("Hide Faults", Boolean.valueOf(true));
        this.hideFaultsParam.setValueAsDefault();
        this.hideFaultsParam.addParameterChangeListener((ParameterChangeListener)this);
        this.animParams.addParameter((Parameter)this.hideFaultsParam);
        this.minMagParam = new DoubleParameter("Min Mag", 0.0, 10.0, Double.valueOf(0.0));
        this.minMagParam.addParameterChangeListener((ParameterChangeListener)this);
        this.animParams.addParameter((Parameter)this.minMagParam);
        this.opacityParam = new DoubleParameter("Opacity", 0.0, 1.0, Double.valueOf(0.5));
        this.opacityParam.addParameterChangeListener((ParameterChangeListener)this);
        this.animParams.addParameter((Parameter)this.opacityParam);
        this.subSectParam = new StringParameter("Events Involving Sect", Lists.newArrayList((Object[])new String[]{ALL_SUB_SECTS}), ALL_SUB_SECTS);
        this.subSectParam.addParameterChangeListener((ParameterChangeListener)this);
        this.animParams.addParameter((Parameter)this.subSectParam);
        this.onlyCurrentParam = new BooleanParameter("Only Show Current", Boolean.valueOf(false));
        this.onlyCurrentParam.setValueAsDefault();
        this.onlyCurrentParam.addParameterChangeListener((ParameterChangeListener)this);
        this.animParams.addParameter((Parameter)this.onlyCurrentParam);
        this.catDurationParam = new DoubleParameter("Duration To Animate", 0.0, 100000.0, Double.valueOf(0.0));
        this.catDurationParam.setUnits("Years");
        this.catDurationParam.addParameterChangeListener((ParameterChangeListener)this);
        this.animParams.addParameter((Parameter)this.catDurationParam);
        this.spherePicker = new PickHandler<ETAS_EqkRupture>(){

            @Override
            public void actorPicked(PickEnabledActor<ETAS_EqkRupture> actor, ETAS_EqkRupture reference, vtkCellPicker picker, MouseEvent e) {
                ETASCatalogAnim.this.etasSphereActorPicked(actor, reference, picker, e);
            }
        };
    }

    private synchronized void initSphereActor() {
        this.sphereActor = new PointPickEnabledActor[sphere_mag_bins.length];
        this.spherePoints = new vtkPoints[sphere_mag_bins.length];
        this.sphereRadius = new vtkDoubleArray[sphere_mag_bins.length];
        this.sphereColors = new vtkUnsignedCharArray[sphere_mag_bins.length];
        for (int i = 0; i < sphere_mag_bins.length; ++i) {
            this.spherePoints[i] = new vtkPoints();
            this.sphereRadius[i] = new vtkDoubleArray();
            this.sphereRadius[i].SetName("radius");
            this.sphereColors[i] = new vtkUnsignedCharArray();
            this.sphereColors[i].SetName("colors");
            this.sphereColors[i].SetNumberOfComponents(4);
            vtkPolyDataMapper mapper = new vtkPolyDataMapper();
            vtkPolyData inputData = new vtkPolyData();
            inputData.SetPoints(this.spherePoints[i]);
            inputData.GetPointData().AddArray((vtkAbstractArray)this.sphereRadius[i]);
            inputData.GetPointData().AddArray((vtkAbstractArray)this.sphereColors[i]);
            inputData.GetPointData().SetActiveScalars("radius");
            vtkSphereSource balls = new vtkSphereSource();
            balls.SetRadius(1.0);
            balls.SetPhiResolution(sphere_resolutions[i]);
            balls.SetThetaResolution(sphere_resolutions[i]);
            vtkGlyph3D glyphPoints = new vtkGlyph3D();
            glyphPoints.SetInputData((vtkDataObject)inputData);
            glyphPoints.SetSourceConnection(balls.GetOutputPort());
            mapper.SetInputConnection(glyphPoints.GetOutputPort());
            mapper.ScalarVisibilityOn();
            mapper.SetScalarModeToUsePointFieldData();
            mapper.SelectColorArray("colors");
            this.sphereActor[i] = new PointPickEnabledActor<ETAS_EqkRupture>(this.spherePicker);
            this.sphereActor[i].SetMapper((vtkMapper)mapper);
            this.sphereActor[i].SetVisibility(1);
            this.sphereActor[i].GetProperty().SetOpacity(((Double)this.opacityParam.getValue()).doubleValue());
            this.actors.addActor((vtkProp)this.sphereActor[i]);
        }
    }

    protected synchronized void displayEvent(ETAS_EqkRupture rup) {
        int fssIndex;
        if (rup.getMag() < (Double)this.minMagParam.getValue()) {
            return;
        }
        if (((Boolean)this.onlyCurrentParam.getValue()).booleanValue()) {
            this.clearEvents();
        }
        if ((fssIndex = rup.getFSSIndex()) >= 0) {
            System.out.println("Fault based rupture, M=" + rup.getMag());
            List sects = this.sol.getRupSet().getSectionsIndicesForRup(fssIndex);
            this.sectsRuptured.addAll(sects);
            Iterator iterator = sects.iterator();
            while (iterator.hasNext()) {
                int sect = (Integer)iterator.next();
                this.mostRecentSectMag.put(sect, rup.getMag());
                this.mostRecentSectRups.put(sect, rup.getID());
            }
        } else {
            int i;
            if (this.sphereActor == null) {
                this.initSphereActor();
            }
            Location loc = rup.getHypocenterLocation();
            double[] pt = Transform.transformLatLonHeight(loc.getLatitude(), loc.getLongitude(), -loc.getDepth());
            double size = this.getSize(rup);
            for (i = 0; i < sphere_mag_bins.length && !(rup.getMag() < sphere_mag_bins[i]); ++i) {
            }
            Preconditions.checkState((i < sphere_mag_bins.length ? 1 : 0) != 0);
            Color color = this.getColorForValue(rup.getMag());
            int index = (int)this.spherePoints[i].GetNumberOfPoints();
            this.spherePoints[i].InsertNextPoint(pt);
            this.sphereRadius[i].InsertNextTuple1(size);
            this.sphereColors[i].InsertNextTuple4((double)color.getRed(), (double)color.getGreen(), (double)color.getBlue(), 255.0);
            this.spherePoints[i].Modified();
            this.sphereRadius[i].Modified();
            this.sphereColors[i].Modified();
            this.sphereActor[i].registerPointID(index, rup);
            this.sphereActor[i].Modified();
        }
    }

    protected double getSize(ETAS_EqkRupture rup) {
        double mag = rup.getMag();
        return mag - 2.5;
    }

    private synchronized void clearEvents() {
        this.sectsRuptured = new HashSet();
        this.mostRecentSectMag = Maps.newHashMap();
        this.mostRecentSectRups = Maps.newHashMap();
        if (this.sphereActor != null) {
            for (int i = 0; i < this.sphereActor.length; ++i) {
                this.actors.removeActor((vtkProp)this.sphereActor[i]);
            }
            this.spherePoints = null;
            this.sphereRadius = null;
            this.sphereColors = null;
            this.sphereActor = null;
        }
    }

    private void loadCatalog(File catalogFile) throws IOException {
        this.curStep = -1;
        this.clearEvents();
        this.catalog = ETAS_CatalogIO.loadCatalog((File)catalogFile);
        if (this.sol == null) {
            return;
        }
        this.updateFSSIndexesInCatalog(this.catalog);
        File infoFile = new File(catalogFile.getParentFile(), "infoString.txt");
        if (infoFile.exists()) {
            System.out.println("Parsing info file");
            long ot = ETASCatalogAnim.detectScenarioOT(this.catalog);
            ArrayList triggerEvents = Lists.newArrayList();
            for (String line : Files.readLines((File)infoFile, (Charset)Charset.defaultCharset())) {
                if ((line = line.trim()).startsWith("FSS simulation. ")) {
                    line = line.substring(line.indexOf("M=") + 2);
                    double mag = Double.parseDouble(line.substring(0, line.indexOf(",")));
                    line = line.substring(line.indexOf("ID=") + 3);
                    int fssIndex = Integer.parseInt(line);
                    ETAS_EqkRupture rup = new ETAS_EqkRupture();
                    rup.setOriginTime(ot);
                    rup.setRuptureSurface(this.sol.getRupSet().getSurfaceForRupture(fssIndex, 1.0));
                    rup.setMag(mag);
                    rup.setFSSIndex(fssIndex);
                    rup.setID(0);
                    triggerEvents.add(rup);
                    System.out.println("Found fault based trigger");
                    continue;
                }
                if (!line.startsWith("Pt Source. ")) continue;
                line = line.substring(line.indexOf("M=") + 2);
                String[] lineSplit = (line = line.replaceAll(",", "")).split(" ");
                Preconditions.checkState((lineSplit.length == 4 ? 1 : 0) != 0);
                double mag = Double.parseDouble(lineSplit[0]);
                double lat = Double.parseDouble(lineSplit[1]);
                double lon = Double.parseDouble(lineSplit[2]);
                double dep = Double.parseDouble(lineSplit[3]);
                Location loc = new Location(lat, lon, dep);
                ETAS_EqkRupture rup = new ETAS_EqkRupture();
                rup.setPointSurface(loc);
                rup.setHypocenterLocation(loc);
                rup.setMag(mag);
                rup.setOriginTime(ot);
                rup.setID(0);
                triggerEvents.add(rup);
                System.out.println("Found point source trigger");
            }
            this.catalog.addAll(0, triggerEvents);
        }
        this.catalogMap = Maps.newHashMap();
        this.parentsMap = Maps.newHashMap();
        this.childrenMap = Maps.newHashMap();
        for (ETAS_EqkRupture rup : this.catalog) {
            int fssIndex;
            this.catalogMap.put(rup.getID(), rup);
            Integer parentID = rup.getParentID();
            if (parentID >= 0) {
                this.parentsMap.put(rup.getID(), parentID);
                ArrayList children = this.childrenMap.get(parentID);
                if (children == null) {
                    children = Lists.newArrayList();
                    this.childrenMap.put(parentID, children);
                }
                children.add(rup.getID());
            }
            if ((fssIndex = rup.getFSSIndex()) < 0) continue;
            rup.setRuptureSurface(this.sol.getRupSet().getSurfaceForRupture(fssIndex, 1.0));
        }
        this.filterCatalog();
        this.fireRangeChangeEvent();
    }

    public static long detectScenarioOT(List<ETAS_EqkRupture> catalog) {
        return Math.round(((double)ETASCatalogAnim.detectScenarioYear(catalog) - 1970.0) * 3.15576E10);
    }

    public static int detectScenarioYear(List<ETAS_EqkRupture> catalog) {
        int detectedYear = 2014;
        if (catalog.size() > 0) {
            long catStart = catalog.get(0).getOriginTime();
            long minDiff = Long.MAX_VALUE;
            for (int year = 2000; year < 2050; ++year) {
                long myOT = Math.round(((double)year - 1970.0) * 3.15576E10);
                long diff = myOT - catStart;
                if (diff < 0L) {
                    diff = -diff;
                }
                if (diff >= minDiff) continue;
                minDiff = diff;
                detectedYear = year;
            }
            System.out.println("Detected " + detectedYear);
        }
        return detectedYear;
    }

    private void filterCatalog() {
        if (this.catalog == null) {
            return;
        }
        double minMag = (Double)this.minMagParam.getValue();
        int subSectIndex = this.subSectParam.getAllowedStrings().indexOf(this.subSectParam.getValue()) - 1;
        double duration = (Double)this.catDurationParam.getValue();
        if (minMag == 0.0 && subSectIndex < 0 && duration == 0.0) {
            this.displayCatalog = this.catalog;
            return;
        }
        System.out.println("Filtering for " + (String)this.subSectParam.getValue() + " at index " + subSectIndex);
        HashSet fssIndexes = null;
        if (subSectIndex >= 0) {
            fssIndexes = new HashSet(this.sol.getRupSet().getRupturesForSection(subSectIndex));
        }
        long maxTime = Long.MAX_VALUE;
        if (duration > 0.0 && !this.catalog.isEmpty()) {
            maxTime = this.catalog.get(0).getOriginTime() + (long)(duration * 3.15576E10);
        }
        this.displayCatalog = Lists.newArrayList();
        for (ETAS_EqkRupture rup : this.catalog) {
            if (fssIndexes != null && !fssIndexes.contains(rup.getFSSIndex())) continue;
            if (rup.getOriginTime() > maxTime) break;
            if (!(rup.getMag() >= minMag)) continue;
            this.displayCatalog.add(rup);
        }
    }

    private void updateFSSIndexesInCatalog(List<ETAS_EqkRupture> catalog) {
        if (this.sol == null) {
            return;
        }
        for (ETAS_EqkRupture rup : catalog) {
            if (rup.getFSSIndex() < 0 && rup.getGridNodeIndex() < 0) continue;
            return;
        }
        if (this.erf == null) {
            System.out.println("Have to build ERF...");
            this.erf = ETAS_Launcher.buildERF((FaultSystemSolution)this.sol, (boolean)false, (double)1.0, (int)2012);
            this.erf.updateForecast();
            System.out.println("Done building ERF.");
        } else if (this.sol != this.erf.getSolution()) {
            this.erf.setSolution(this.sol);
            this.erf.updateForecast();
        }
        ETAS_SimAnalysisTools.loadFSSIndexesFromNth(catalog, (FaultSystemSolutionERF)this.erf);
    }

    @Override
    public void addRangeChangeListener(ChangeListener l) {
        this.listeners.add(l);
    }

    @Override
    public int getNumSteps() {
        if (this.displayCatalog == null || this.sol == null) {
            return 0;
        }
        return this.displayCatalog.size();
    }

    @Override
    public synchronized void setCurrentStep(int step) {
        System.out.println("setCurrentStep(" + step + "), cur=" + this.curStep);
        if (step < this.curStep || step < 0) {
            this.clearEvents();
            this.curStep = -1;
            if (step < 0) {
                return;
            }
        }
        if (step == this.curStep) {
            return;
        }
        if (this.displayCatalog != null) {
            ++this.curStep;
            while (this.curStep <= step) {
                this.displayEvent(this.displayCatalog.get(this.curStep));
                ++this.curStep;
            }
            MainGUI.updateRenderWindow();
        }
        this.curStep = step;
    }

    @Override
    public int getPreferredInitialStep() {
        if (this.displayCatalog == null) {
            return 0;
        }
        return this.displayCatalog.size() - 1;
    }

    @Override
    public boolean includeStepInLabel() {
        return false;
    }

    @Override
    public String getCurrentLabel() {
        return null;
    }

    @Override
    public ParameterList getAnimationParameters() {
        return this.animParams;
    }

    @Override
    public Boolean getFaultVisibility(AbstractFaultSection fault) {
        boolean contains = this.sectsRuptured.contains(fault.getId());
        if (contains) {
            return true;
        }
        if (((Boolean)this.hideFaultsParam.getValue()).booleanValue()) {
            return false;
        }
        return null;
    }

    @Override
    public FaultColorer getFaultColorer() {
        return this;
    }

    @Override
    public void fireRangeChangeEvent() {
        ChangeEvent e = new ChangeEvent(this);
        for (ChangeListener l : this.listeners) {
            l.stateChanged(e);
        }
    }

    public String getName() {
        return "ETAS Catalog Animation";
    }

    @Override
    public void actorPicked(PickEnabledActor<AbstractFaultSection> actor, AbstractFaultSection fault, vtkCellPicker picker, MouseEvent e) {
        Integer sectID = this.mostRecentSectRups.get(fault.getId());
        if (sectID == null) {
            return;
        }
        ETAS_EqkRupture rup = this.catalogMap.get(sectID);
        if (rup == null) {
            return;
        }
        Object s = fault.getInfo();
        s = ((String)s).replaceAll("\n", ", ");
        String addition = rup.getParentID() >= 0 && this.catalogMap.get(rup.getParentID()) != null ? "Mag: " + (float)rup.getMag() + ", Parent=" + rup.getParentID() + " (Mag=" + (float)this.catalogMap.get(rup.getParentID()).getMag() + ")" : "Mag: " + (float)rup.getMag() + ", Spontaneous";
        int numChildren = 0;
        if (this.childrenMap.get(rup.getID()) != null) {
            numChildren = this.childrenMap.get(rup.getID()).size();
        }
        addition = addition + ", " + numChildren + " children";
        s = addition + ", " + (String)s;
        System.out.println((String)s);
        if (e.isShiftDown()) {
            if (e.isControlDown()) {
                Integer parentID = this.parentsMap.get(rup.getID());
                if (parentID == null) {
                    System.out.println("Parent ID not found, spontaneous");
                    this.clearChildren();
                    return;
                }
                rup = this.catalogMap.get(parentID);
                if (rup == null) {
                    System.out.println("Parent rup not found for ID?");
                    this.clearChildren();
                    return;
                }
            }
            this.displayChildren(rup);
        }
    }

    private void etasSphereActorPicked(PickEnabledActor<ETAS_EqkRupture> actor, ETAS_EqkRupture rup, vtkCellPicker picker, MouseEvent e) {
        Preconditions.checkNotNull((Object)rup, (String)"Picked but no rup registered for PointID=%s", (long)picker.GetPointId());
        String s = rup.getParentID() >= 0 && this.catalogMap.get(rup.getParentID()) != null ? "Mag: " + (float)rup.getMag() + ", Parent=" + rup.getParentID() + " (Mag=" + (float)this.catalogMap.get(rup.getParentID()).getMag() + ")" : "Mag: " + (float)rup.getMag() + ", Spontaneous";
        int numChildren = 0;
        if (this.childrenMap.get(rup.getID()) != null) {
            numChildren = this.childrenMap.get(rup.getID()).size();
        }
        s = s + ", " + numChildren + " children";
        System.out.println(s);
        if (e.isShiftDown()) {
            if (e.isControlDown()) {
                Integer parentID = this.parentsMap.get(rup.getID());
                if (parentID == null) {
                    System.out.println("Parent ID not found, spontaneous");
                    this.clearChildren();
                    return;
                }
                rup = this.catalogMap.get(parentID);
                if (rup == null) {
                    System.out.println("Parent rup not found for ID?");
                    this.clearChildren();
                    return;
                }
            }
            this.displayChildren(rup);
        }
    }

    private List<Location> getSurfaceLocs(ETAS_EqkRupture rup) {
        if (rup.getRuptureSurface() == null) {
            return Lists.newArrayList((Object[])new Location[]{rup.getHypocenterLocation()});
        }
        return rup.getRuptureSurface().getEvenlyDiscritizedListOfLocsOnSurface();
    }

    private Location[] getConnectionLocations(ETAS_EqkRupture rup1, ETAS_EqkRupture rup2) {
        Location[] closestPts = null;
        double closestDist = Double.POSITIVE_INFINITY;
        for (Location pt1 : this.getSurfaceLocs(rup1)) {
            for (Location pt2 : this.getSurfaceLocs(rup2)) {
                double dist = LocationUtils.linearDistanceFast((Location)pt1, (Location)pt2);
                if (!(dist < closestDist)) continue;
                closestDist = dist;
                closestPts = new Location[]{pt1, pt2};
            }
        }
        return closestPts;
    }

    private void clearChildren() {
    }

    private void displayChildren(ETAS_EqkRupture rup) {
    }

    public void parameterChange(ParameterChangeEvent event) {
        if (event.getParameter() == this.catalogFileParam) {
            try {
                this.loadCatalog((File)this.catalogFileParam.getValue());
            }
            catch (IOException e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(null, e.getMessage(), "Error Loading Catalog", 0);
                this.clearEvents();
                this.catalog = null;
            }
        } else if (event.getParameter() != this.hideFaultsParam) {
            if (event.getParameter() == this.minMagParam || event.getParameter() == this.subSectParam || event.getParameter() == this.catDurationParam) {
                this.filterCatalog();
                this.fireRangeChangeEvent();
                this.setCurrentStep(this.getNumSteps() - 1);
            } else if (event.getParameter() == this.opacityParam || event.getParameter() == this.onlyCurrentParam) {
                this.forceRedraw();
            }
        }
    }

    private void forceRedraw() {
        int origCurStep = this.curStep++;
        this.setCurrentStep(origCurStep);
    }

    @Override
    public void setRupSet(FaultSystemRupSet rupSet, FaultSystemSolution sol) {
        this.clearEvents();
        this.sol = sol;
        ArrayList subSectNames = Lists.newArrayList((Object[])new String[]{ALL_SUB_SECTS});
        if (sol != null) {
            for (FaultSection sect : sol.getRupSet().getFaultSectionDataList()) {
                subSectNames.add(sect.getSectionId() + ". " + sect.getName());
            }
        }
        ((StringConstraint)this.subSectParam.getConstraint()).setStrings(subSectNames);
        this.subSectParam.setValue((Object)ALL_SUB_SECTS);
        this.subSectParam.getEditor().refreshParamEditor();
    }

    @Override
    public double getTimeForStep(int step) {
        if (step >= 0 && this.displayCatalog != null && step < this.displayCatalog.size()) {
            long catStart = this.catalog.get(0).getOriginTime();
            long curTime = this.displayCatalog.get(step).getOriginTime();
            long diff = curTime - catStart;
            Preconditions.checkState((diff >= 0L ? 1 : 0) != 0, (String)"Bad time? diff=%s, start=%s, cur=%s, step=%s", (Object)diff, (Object)catStart, (Object)curTime, (Object)step);
            double secs = (double)diff / 1000.0;
            return secs;
        }
        return 0.0;
    }

    @Override
    public ParameterList getColorerParameters() {
        return null;
    }

    @Override
    public void setColorerChangeListener(ColorerChangeListener l) {
    }

    @Override
    public int getStepForID(int id) {
        for (int i = 0; i < this.displayCatalog.size(); ++i) {
            ETAS_EqkRupture rup = this.displayCatalog.get(i);
            if (rup.getID() != id) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int getIDForStep(int step) {
        if (this.displayCatalog == null || step >= this.displayCatalog.size()) {
            return -1;
        }
        return this.displayCatalog.get(step).getID();
    }

    @Override
    public double getValue(AbstractFaultSection fault) {
        if (this.sectsRuptured != null && this.sectsRuptured.contains(fault.getId())) {
            return this.mostRecentSectMag.get(fault.getId());
        }
        return Double.NaN;
    }

    @Override
    public double getCurrentDuration() {
        if (this.displayCatalog != null) {
            return this.getTimeForStep(this.displayCatalog.size() - 1) - this.getTimeForStep(0);
        }
        return 0.0;
    }

    @Override
    public boolean timeChanged(double time) {
        return false;
    }

    public static void main(String[] args) throws IOException {
        ETASCatalogAnim anim = new ETASCatalogAnim(null);
        FaultSystemSolution sol = FaultSystemSolution.load((File)new File("/home/kevin/workspace/OpenSHA/dev/scratch/UCERF3/data/scratch/InversionSolutions/2013_05_10-ucerf3p3-production-10runs_COMPOUND_SOL_FM3_1_SpatSeisU3_MEAN_BRANCH_AVG_SOL.zip"));
        anim.setRupSet(sol.getRupSet(), sol);
        anim.catalogFileParam.setValue((Object)new File("/home/kevin/OpenSHA/UCERF3/etas/simulations/2016_02_19-mojave_m7-10yr-full_td-subSeisSupraNucl-gridSeisCorr-scale1.14/selected_catalogs/fract_1.0_cat1/simulatedEvents.txt"));
        System.out.println("Num events: " + anim.displayCatalog.size());
        for (int i = 0; i < 100; ++i) {
            System.out.println("Time " + i + ": " + anim.getTimeForStep(i));
        }
    }
}

