/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.plugins.opensha.ucerf3Rups.anims;

import com.google.common.base.Preconditions;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.sha.earthquake.ProbEqkRupture;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.faultSysSolution.modules.GridSourceList;
import org.opensha.sha.earthquake.faultSysSolution.modules.GridSourceProvider;
import org.opensha.sha.earthquake.param.BackgroundRupParam;
import org.opensha.sha.earthquake.param.BackgroundRupType;
import org.opensha.sha.faultSurface.PointSurface;
import org.opensha.sha.faultSurface.RuptureSurface;
import org.opensha.sha.faultSurface.Surface3D;
import org.scec.vtk.commons.opensha.faults.AbstractFaultSection;
import org.scec.vtk.commons.opensha.faults.anim.IDBasedFaultAnimation;
import org.scec.vtk.commons.opensha.faults.colorers.ColorerChangeListener;
import org.scec.vtk.commons.opensha.faults.colorers.FaultColorer;
import org.scec.vtk.commons.opensha.surfaces.FaultSectionActorList;
import org.scec.vtk.commons.opensha.surfaces.GeometryGenerator;
import org.scec.vtk.commons.opensha.surfaces.LineSurfaceGenerator;
import org.scec.vtk.main.MainGUI;
import org.scec.vtk.plugins.PluginActors;
import org.scec.vtk.plugins.opensha.ucerf3Rups.UCERF3RupSetChangeListener;
import vtk.vtkActor;
import vtk.vtkDataObject;
import vtk.vtkDataSetMapper;
import vtk.vtkMapper;
import vtk.vtkPoints;
import vtk.vtkPolyData;
import vtk.vtkProp;
import vtk.vtkVertexGlyphFilter;

public class GridSourceAnim
implements IDBasedFaultAnimation,
UCERF3RupSetChangeListener,
ParameterChangeListener {
    private ArrayList<ChangeListener> listeners = new ArrayList();
    private FaultSystemSolution sol;
    private boolean initialized = false;
    private GridSourceProvider gridProv;
    private int totNumRups;
    private int[] sourceRupIndexes;
    private ProbEqkSource[] gridSources;
    private int curStep = -1;
    private int curSourceIndex = -1;
    private vtkActor locActor;
    private vtkActor surfActor;
    private ProbEqkSource curSource;
    private ProbEqkRupture curRupture;
    private BackgroundRupType bgType = BackgroundRupType.POINT;
    private BackgroundRupParam bgTypeParam;
    private ParameterList params;
    private PluginActors actors;
    private GeometryGenerator geomGen;

    public GridSourceAnim(PluginActors actors) {
        this.actors = actors;
        this.params = new ParameterList();
        this.bgTypeParam = new BackgroundRupParam();
        this.bgTypeParam.setValue((Object)this.bgType);
        this.bgTypeParam.addParameterChangeListener((ParameterChangeListener)this);
        this.params.addParameter((Parameter)this.bgTypeParam);
    }

    public String getName() {
        return "Grid Sources";
    }

    @Override
    public synchronized void setRupSet(FaultSystemRupSet rupSet, FaultSystemSolution sol) {
        this.sol = sol;
        this.initialized = false;
        this.fireRangeChangeEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkInit() {
        if (this.initialized) {
            return;
        }
        GridSourceAnim gridSourceAnim = this;
        synchronized (gridSourceAnim) {
            if (this.initialized) {
                return;
            }
            GridSourceProvider gridSourceProvider = this.gridProv = this.sol == null ? null : this.sol.getGridSourceProvider();
            if (this.gridProv == null) {
                this.totNumRups = 0;
                this.sourceRupIndexes = null;
            } else {
                int numSources = this.gridProv.getNumSources();
                this.sourceRupIndexes = new int[numSources];
                this.gridSources = new ProbEqkSource[numSources];
                this.totNumRups = 0;
                for (int sourceIndex = 0; sourceIndex < numSources; ++sourceIndex) {
                    this.sourceRupIndexes[sourceIndex] = this.totNumRups;
                    this.gridSources[sourceIndex] = this.gridProv.getSource(sourceIndex, 1.0, null, this.bgType);
                    this.totNumRups += this.gridSources[sourceIndex].getNumRuptures();
                }
            }
        }
    }

    @Override
    public void addRangeChangeListener(ChangeListener l) {
        this.listeners.add(l);
    }

    @Override
    public int getNumSteps() {
        this.checkInit();
        if (this.gridProv instanceof GridSourceList) {
            return this.totNumRups + 2;
        }
        return this.totNumRups + 1;
    }

    @Override
    public synchronized void setCurrentStep(int step) {
        int index;
        if (step <= 0 || this.sol == null) {
            if (this.locActor != null || this.surfActor != null) {
                if (this.locActor != null) {
                    this.actors.removeActor((vtkProp)this.locActor);
                    this.locActor = null;
                }
                if (this.surfActor != null) {
                    this.actors.removeActor((vtkProp)this.surfActor);
                    this.surfActor = null;
                }
                MainGUI.updateRenderWindow();
            }
            this.curRupture = null;
            return;
        }
        this.checkInit();
        if (step == this.curStep) {
            return;
        }
        this.curStep = step;
        if (this.locActor != null) {
            this.actors.removeActor((vtkProp)this.locActor);
            this.locActor = null;
        }
        if (this.surfActor != null) {
            this.actors.removeActor((vtkProp)this.surfActor);
            this.surfActor = null;
        }
        if ((index = this.getIDForStep(step)) == this.totNumRups) {
            LocationList uniqueLocs = new LocationList();
            Preconditions.checkState((boolean)(this.gridProv instanceof GridSourceList));
            GridSourceList gridSources = (GridSourceList)this.gridProv;
            for (int gridIndex = 0; gridIndex < gridSources.getNumLocations(); ++gridIndex) {
                Location loc = gridSources.getLocation(gridIndex);
                HashSet<Float> uniqueDepths = new HashSet<Float>();
                for (GridSourceList.GriddedRupture rup : gridSources.getRuptures(null, gridIndex)) {
                    double depth = Double.isFinite(rup.properties.hypocentralDepth) ? rup.properties.hypocentralDepth : rup.properties.upperDepth + 0.5 * (rup.properties.lowerDepth - rup.properties.upperDepth);
                    if (uniqueDepths.contains(Float.valueOf((float)depth))) continue;
                    uniqueDepths.add(Float.valueOf((float)depth));
                    uniqueLocs.add((Object)new Location(loc.lat, loc.lon, depth));
                }
            }
            System.out.println("Displaying " + uniqueLocs.size() + " unique locations (gridProv.getNumLocations()=" + this.gridProv.getNumLocations() + ")");
            vtkPoints pts = new vtkPoints();
            for (Location loc : uniqueLocs) {
                pts.InsertNextPoint(GeometryGenerator.getPointForLoc(loc));
            }
            vtkDataSetMapper mapper = new vtkDataSetMapper();
            vtkPolyData polydata = new vtkPolyData();
            polydata.SetPoints(pts);
            vtkVertexGlyphFilter vertexGlyphFilter = new vtkVertexGlyphFilter();
            vertexGlyphFilter.AddInputData((vtkDataObject)polydata);
            vertexGlyphFilter.Update();
            mapper.SetInputConnection(vertexGlyphFilter.GetOutputPort());
            this.locActor = new vtkActor();
            this.locActor.SetMapper((vtkMapper)mapper);
            this.locActor.GetProperty().SetPointSize(3.0f);
            this.locActor.GetProperty().SetColor(GeometryGenerator.getColorDoubleArray(Color.GREEN.darker()));
            this.locActor.GetProperty().SetOpacity(1.0);
            this.locActor.Modified();
            this.actors.addActor((vtkProp)this.locActor);
        } else {
            Preconditions.checkState((index < this.totNumRups ? 1 : 0) != 0, (String)"Bad index=%s for step=%s, totNumRups=%s", (Object)index, (Object)step, (Object)this.totNumRups);
            ProbEqkRupture rupture = null;
            if (this.curSourceIndex >= 0 && index >= this.sourceRupIndexes[this.curSourceIndex]) {
                int delta = index - this.sourceRupIndexes[this.curSourceIndex];
                int myNum = this.gridSources[this.curSourceIndex].getNumRuptures();
                if (delta < myNum) {
                    rupture = this.gridSources[this.curSourceIndex].getRupture(delta);
                } else if (delta == myNum) {
                    rupture = this.gridSources[this.curSourceIndex + 1].getRupture(0);
                    ++this.curSourceIndex;
                }
            }
            if (rupture == null) {
                int rupIndex;
                this.curSourceIndex = Arrays.binarySearch(this.sourceRupIndexes, index);
                if (this.curSourceIndex < 0) {
                    this.curSourceIndex = -(this.curSourceIndex + 1);
                    --this.curSourceIndex;
                }
                Preconditions.checkState(((rupIndex = index - this.sourceRupIndexes[this.curSourceIndex]) >= 0 ? 1 : 0) != 0, (String)"rupIndex=%s, curStep=%s, sourceRupIndexes[%s] = %s", (Object)rupIndex, (Object)index, (Object)this.curSourceIndex, (Object)this.sourceRupIndexes[this.curSourceIndex]);
                rupture = this.gridSources[this.curSourceIndex].getRupture(rupIndex);
            }
            this.curSource = this.gridSources[this.curSourceIndex];
            this.curRupture = rupture;
            RuptureSurface surf = rupture.getRuptureSurface();
            System.out.println("Displaying M" + rupture.getMag() + " with surf type: " + surf.getClass().getName());
            Location pointLoc = null;
            if (surf instanceof PointSurface) {
                pointLoc = ((PointSurface)surf).getLocation();
            } else {
                FaultSectionActorList list;
                pointLoc = rupture.getHypocenterLocation();
                if (this.geomGen == null) {
                    this.geomGen = new LineSurfaceGenerator();
                }
                Preconditions.checkState(((list = this.geomGen.createFaultActors((Surface3D)surf, Color.RED, null)).size() == 1 ? 1 : 0) != 0, (Object)"Expected a single actor");
                this.surfActor = (vtkActor)list.get(0);
                this.surfActor.Modified();
                this.actors.addActor((vtkProp)this.surfActor);
                System.out.println("\tDisplaying finite surface with upperDepth=" + surf.getAveRupTopDepth() + ", width=" + surf.getAveWidth() + ", length=" + surf.getAveLength() + ", area=" + surf.getArea());
            }
            if (pointLoc != null) {
                System.out.println("Displaying loc at");
                if (this.gridProv.getGriddedRegion() != null) {
                    System.out.println("\tDisplaying location (" + String.valueOf(pointLoc) + ") at gridIndex=" + this.gridProv.getGriddedRegion().indexForLocation(pointLoc));
                } else {
                    System.out.println("\tDisplaying location: " + String.valueOf(pointLoc));
                }
                double[] point = GeometryGenerator.getPointForLoc(pointLoc);
                vtkPoints pts = new vtkPoints();
                pts.InsertNextPoint(point);
                vtkDataSetMapper mapper = new vtkDataSetMapper();
                vtkPolyData polydata = new vtkPolyData();
                polydata.SetPoints(pts);
                vtkVertexGlyphFilter vertexGlyphFilter = new vtkVertexGlyphFilter();
                vertexGlyphFilter.AddInputData((vtkDataObject)polydata);
                vertexGlyphFilter.Update();
                mapper.SetInputConnection(vertexGlyphFilter.GetOutputPort());
                this.locActor = new vtkActor();
                this.locActor.SetMapper((vtkMapper)mapper);
                this.locActor.GetProperty().SetPointSize(5.0f);
                this.locActor.GetProperty().SetColor(GeometryGenerator.getColorDoubleArray(this.surfActor == null ? Color.RED : Color.BLUE));
                this.locActor.GetProperty().SetOpacity(1.0);
                this.locActor.Modified();
                this.actors.addActor((vtkProp)this.locActor);
            }
        }
        MainGUI.updateRenderWindow();
    }

    @Override
    public int getPreferredInitialStep() {
        return 0;
    }

    @Override
    public boolean includeStepInLabel() {
        return false;
    }

    @Override
    public String getCurrentLabel() {
        if (this.curRupture == null) {
            return "";
        }
        String str = "M" + (float)this.curRupture.getMag() + ", rake=" + (float)this.curRupture.getAveRake() + ", trt=" + this.curSource.getTectonicRegionType().name();
        if (!Double.isNaN(this.curRupture.getRuptureSurface().getAveStrike())) {
            str = str + ", strike=" + (int)(this.curRupture.getRuptureSurface().getAveStrike() + 0.5);
        }
        if (this.curRupture.getHypocenterLocation() != null) {
            str = str + ", hypo=" + String.valueOf(this.curRupture.getHypocenterLocation());
        }
        return str;
    }

    @Override
    public ParameterList getAnimationParameters() {
        return this.params;
    }

    @Override
    public Boolean getFaultVisibility(AbstractFaultSection fault) {
        return null;
    }

    @Override
    public FaultColorer getFaultColorer() {
        return new FaultColorer(){

            public String getName() {
                return GridSourceAnim.this.getName();
            }

            @Override
            public void setColorerChangeListener(ColorerChangeListener l) {
            }

            @Override
            public String getLegendLabel() {
                return null;
            }

            @Override
            public ParameterList getColorerParameters() {
                return null;
            }

            @Override
            public Color getColor(AbstractFaultSection fault) {
                return Color.GRAY;
            }
        };
    }

    @Override
    public void fireRangeChangeEvent() {
        ChangeEvent e = new ChangeEvent(this);
        for (ChangeListener l : this.listeners) {
            l.stateChanged(e);
        }
    }

    public void parameterChange(ParameterChangeEvent event) {
        this.fireRangeChangeEvent();
    }

    @Override
    public int getStepForID(int id) {
        return id + 1;
    }

    @Override
    public int getIDForStep(int step) {
        return step - 1;
    }
}

