/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.plugins.opensha.ucerf3Rups.anims;

import java.awt.Color;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.NoSuchElementException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.opensha.commons.calc.FaultMomentCalc;
import org.opensha.commons.calc.WeightedSampler;
import org.opensha.commons.mapping.gmt.elements.GMT_CPT_Files;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.constraint.impl.StringConstraint;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.impl.BooleanParameter;
import org.opensha.commons.param.impl.DoubleParameter;
import org.opensha.commons.param.impl.EnumParameter;
import org.opensha.commons.param.impl.IntegerParameter;
import org.opensha.commons.param.impl.StringParameter;
import org.opensha.commons.util.cpt.CPT;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.faultSysSolution.modules.AveSlipModule;
import org.opensha.sha.earthquake.faultSysSolution.modules.SlipAlongRuptureModel;
import org.opensha.sha.faultSurface.FaultSection;
import org.scec.vtk.commons.opensha.faults.AbstractFaultSection;
import org.scec.vtk.commons.opensha.faults.anim.AnimMultiColorerPickHandlerWrapper;
import org.scec.vtk.commons.opensha.faults.anim.AnimMultiColorerWrapper;
import org.scec.vtk.commons.opensha.faults.anim.IDBasedFaultAnimation;
import org.scec.vtk.commons.opensha.faults.colorers.CPTBasedColorer;
import org.scec.vtk.commons.opensha.faults.colorers.ColorerChangeListener;
import org.scec.vtk.commons.opensha.faults.colorers.FaultColorer;
import org.scec.vtk.commons.opensha.faults.colorers.RakeColorer;
import org.scec.vtk.commons.opensha.faults.colorers.SlipRateColorer;
import org.scec.vtk.commons.opensha.faults.colorers.StrikeColorer;
import org.scec.vtk.plugins.opensha.ucerf3Rups.UCERF3RupSetChangeListener;
import org.scec.vtk.tools.picking.PickEnabledActor;
import org.scec.vtk.tools.picking.PickHandler;
import vtk.vtkCellPicker;

public class RupturesAnim
implements IDBasedFaultAnimation,
UCERF3RupSetChangeListener,
ParameterChangeListener,
PickHandler<AbstractFaultSection> {
    private static final String SECTION_SELECT_PARAM_NAME = "Ruptures for Section";
    private static final String SECTION_SELECT_PARAM_INFO = "Filters the rupture list to only include\nruptures involving the given section.\n\nYou can also shift+click on a secion\nin the 3D view to set this.";
    private static final String SECTION_SELECT_PARAM_DEFAULT = "(all sections)";
    private StringParameter sectionSelect;
    private ArrayList<String> sectionNames;
    private int selectedSectionID = -1;
    private static final String MIN_MAG_PARAM_NAME = "Min Mag.";
    private static final double MIN_MAG_PARAM_DEFAULT = 0.0;
    private DoubleParameter minMagParam;
    private static final String MAX_MAG_PARAM_NAME = "Max Mag.";
    private static final double MAX_MAG_PARAM_DEFAULT = 10.0;
    private DoubleParameter maxMagParam;
    private static final String MIN_RATE_PARAM_NAME = "Min Rate.";
    private static final double MIN_RATE_PARAM_DEFAULT = 0.0;
    private DoubleParameter minRateParam;
    private static final String MAX_RATE_PARAM_NAME = "Max Rate.";
    private static final double MAX_RATE_PARAM_DEFAULT = 100.0;
    private DoubleParameter maxRateParam;
    private static final String SORT_PARAM_NAME = "Sort By";
    private static final String SORT_PARAM_DEFAULT = SortType.ID.toString();
    private StringParameter sortParam;
    private SortType sortType;
    private Comparator<Integer> rupComparator;
    private static final String POISSON_SAMPLES_PARAM_NAME = "# Samples";
    private static final int POISSON_SAMPLES_DEFAULT = 1000;
    private static final int POISSON_SAMPLES_MIN = 1;
    private static final int POISSON_SAMPLES_MAX = 1000000;
    private IntegerParameter poissonSamplesParam;
    private static final String SURFS_VISIBLE_PARAM_NAME = "Only Ruptures Visible";
    private BooleanParameter surfsVisibleParam;
    private static final String DISPLAY_PARAM_NAME = "Display Type";
    private static final DisplayType DISPLAY_DEFAULT = DisplayType.SOLID;
    private EnumParameter<DisplayType> displayParam;
    private SlipRateColorer sectionSlipColorer = new SlipRateColorer(){

        @Override
        public double getValue(AbstractFaultSection fault) {
            if (RupturesAnim.this.isSectionAnimated(fault.getId())) {
                return super.getValue(fault);
            }
            return Double.NaN;
        }
    };
    private RakeColorer rakeColorer = new RakeColorer(){

        @Override
        public double getValue(AbstractFaultSection fault) {
            if (RupturesAnim.this.isSectionAnimated(fault.getId())) {
                return super.getValue(fault);
            }
            return Double.NaN;
        }
    };
    private StrikeColorer strikeColorer = new StrikeColorer(){

        @Override
        public double getValue(AbstractFaultSection fault) {
            if (RupturesAnim.this.isSectionAnimated(fault.getId())) {
                return super.getValue(fault);
            }
            return Double.NaN;
        }
    };
    private CPTBasedColorer magColorer = new CPTBasedColorer(SlipRateColorer.getDefaultCPT().rescale(6.0, 8.5), false){

        public String getName() {
            return DisplayType.MAG.toString();
        }

        @Override
        public double getValue(AbstractFaultSection fault) {
            if (RupturesAnim.this.isSectionAnimated(fault.getId())) {
                int rupID = RupturesAnim.this.ruptureIDs.get(RupturesAnim.this.curStep);
                return RupturesAnim.this.rupSet.getMagForRup(rupID);
            }
            return Double.NaN;
        }
    };
    private CPTBasedColorer rateColorer = new CPTBasedColorer(SlipRateColorer.getDefaultCPT().rescale(1.0E-7, 0.05), false){

        public String getName() {
            return DisplayType.RATE.toString();
        }

        @Override
        public double getValue(AbstractFaultSection fault) {
            if (RupturesAnim.this.sol != null && RupturesAnim.this.isSectionAnimated(fault.getId())) {
                int rupID = RupturesAnim.this.ruptureIDs.get(RupturesAnim.this.curStep);
                return RupturesAnim.this.sol.getRateForRup(rupID);
            }
            return Double.NaN;
        }
    };
    private CPTBasedColorer orderColorer = new CPTBasedColorer(SlipRateColorer.getDefaultCPT().rescale(0.0, 1.0), false){

        public String getName() {
            return DisplayType.RATE.toString();
        }

        @Override
        public double getValue(AbstractFaultSection fault) {
            if (RupturesAnim.this.rupSet == null) {
                return Double.NaN;
            }
            if (RupturesAnim.this.curStep < 0) {
                return Double.NaN;
            }
            int rupID = RupturesAnim.this.ruptureIDs.get(RupturesAnim.this.curStep);
            List list = RupturesAnim.this.rupSet.getSectionsIndicesForRup(rupID);
            int ind = list.indexOf(fault.getId());
            if (ind >= 0) {
                if (list.size() == 1) {
                    return 0.0;
                }
                return (double)ind / (double)(list.size() - 1);
            }
            return Double.NaN;
        }
    };
    private int last_parent_color_rupture_id = -1;
    private List<Integer> last_parents = null;
    private CPTBasedColorer parentColorer = new CPTBasedColorer(SlipRateColorer.getDefaultCPT().rescale(0.0, 1.0), false){

        public String getName() {
            return DisplayType.RATE.toString();
        }

        @Override
        public double getValue(AbstractFaultSection fault) {
            if (RupturesAnim.this.isSectionAnimated(fault.getId())) {
                List parents;
                int rupID = RupturesAnim.this.ruptureIDs.get(RupturesAnim.this.curStep);
                if (rupID == RupturesAnim.this.last_parent_color_rupture_id) {
                    parents = RupturesAnim.this.last_parents;
                } else {
                    parents = RupturesAnim.this.rupSet.getParentSectionsForRup(rupID);
                    RupturesAnim.this.last_parent_color_rupture_id = rupID;
                    RupturesAnim.this.last_parents = parents;
                }
                if (parents.size() == 1) {
                    return 0.0;
                }
                int ind = parents.indexOf(RupturesAnim.this.rupSet.getFaultSectionData(fault.getId()).getParentSectionId());
                if (ind >= 0) {
                    return (double)ind / (double)(parents.size() - 1);
                }
            }
            return Double.NaN;
        }
    };
    private CPTBasedColorer slipColorer = new CPTBasedColorer(SlipRateColorer.getDefaultCPT().rescale(0.01, 10.0), false){
        private double[] slips;
        private int rupID;
        private List<Integer> sections;

        public String getName() {
            return DisplayType.SLIP.toString();
        }

        @Override
        public double getValue(AbstractFaultSection fault) {
            int index;
            if (RupturesAnim.this.rupSet == null || !RupturesAnim.this.rupSet.hasModule(SlipAlongRuptureModel.class) || !RupturesAnim.this.rupSet.hasModule(AveSlipModule.class)) {
                return Double.NaN;
            }
            if (RupturesAnim.this.curStep < 0) {
                return Double.NaN;
            }
            int rupID = RupturesAnim.this.ruptureIDs.get(RupturesAnim.this.curStep);
            if (this.slips == null || rupID != this.rupID) {
                try {
                    this.slips = ((SlipAlongRuptureModel)RupturesAnim.this.rupSet.getModule(SlipAlongRuptureModel.class)).calcSlipOnSectionsForRup(RupturesAnim.this.rupSet, (AveSlipModule)RupturesAnim.this.rupSet.requireModule(AveSlipModule.class), rupID);
                }
                catch (NullPointerException e) {
                    return Double.NaN;
                }
                this.sections = RupturesAnim.this.rupSet.getSectionsIndicesForRup(rupID);
                this.rupID = rupID;
            }
            if ((index = this.sections.indexOf(fault.getId())) >= 0) {
                return this.slips[index];
            }
            return Double.NaN;
        }
    };
    private FaultColorer simpleFaultColorer = new FaultColorer(){

        public String getName() {
            return "Selected Rupture";
        }

        @Override
        public void setColorerChangeListener(ColorerChangeListener l) {
        }

        @Override
        public ParameterList getColorerParameters() {
            return null;
        }

        @Override
        public Color getColor(AbstractFaultSection fault) {
            if (RupturesAnim.this.rupSet == null) {
                return Color.LIGHT_GRAY;
            }
            int secID = fault.getId();
            if (RupturesAnim.this.isSectionAnimated(secID)) {
                return Color.RED;
            }
            return Color.GREEN;
        }

        @Override
        public String getLegendLabel() {
            return this.getName();
        }
    };
    private AnimMultiColorerWrapper multiColorerWrapper;
    private ParameterList params;
    private ArrayList<ChangeListener> listeners = new ArrayList();
    private FaultSystemSolution sol;
    private FaultSystemRupSet rupSet;
    private List<Integer> ruptureIDs;
    private int curStep = -1;

    public RupturesAnim() {
        this.sectionNames = new ArrayList();
        this.sectionNames.add(SECTION_SELECT_PARAM_DEFAULT);
        this.sectionSelect = new StringParameter(SECTION_SELECT_PARAM_NAME, this.sectionNames, SECTION_SELECT_PARAM_DEFAULT);
        this.sectionSelect.addParameterChangeListener((ParameterChangeListener)this);
        this.sectionSelect.setInfo(SECTION_SELECT_PARAM_INFO);
        this.minMagParam = new DoubleParameter(MIN_MAG_PARAM_NAME, 0.0, 10.0);
        this.minMagParam.setValue(0.0);
        this.minMagParam.addParameterChangeListener((ParameterChangeListener)this);
        this.maxMagParam = new DoubleParameter(MAX_MAG_PARAM_NAME, 0.0, 10.0);
        this.maxMagParam.setValue(10.0);
        this.maxMagParam.addParameterChangeListener((ParameterChangeListener)this);
        this.minRateParam = new DoubleParameter(MIN_RATE_PARAM_NAME, 0.0, 10.0);
        this.minRateParam.setValue(0.0);
        this.minRateParam.addParameterChangeListener((ParameterChangeListener)this);
        this.maxRateParam = new DoubleParameter(MAX_RATE_PARAM_NAME, 0.0, 100.0);
        this.maxRateParam.setValue(100.0);
        this.maxRateParam.addParameterChangeListener((ParameterChangeListener)this);
        ArrayList<String> sortStrings = new ArrayList<String>();
        for (SortType t : SortType.values()) {
            sortStrings.add(t.toString());
        }
        this.sortParam = new StringParameter(SORT_PARAM_NAME, sortStrings, SORT_PARAM_DEFAULT);
        this.sortType = SortType.fromString((String)this.sortParam.getValue());
        this.sortParam.addParameterChangeListener((ParameterChangeListener)this);
        this.poissonSamplesParam = new IntegerParameter(POISSON_SAMPLES_PARAM_NAME, 1, 1000000);
        this.poissonSamplesParam.setDefaultValue((Object)1000);
        this.poissonSamplesParam.setValueAsDefault();
        this.poissonSamplesParam.getEditor().getComponent();
        this.poissonSamplesParam.getEditor().setEnabled(this.sortType == SortType.POISSON_SAMPLING);
        this.poissonSamplesParam.addParameterChangeListener((ParameterChangeListener)this);
        this.surfsVisibleParam = new BooleanParameter(SURFS_VISIBLE_PARAM_NAME, Boolean.valueOf(false));
        this.surfsVisibleParam.addParameterChangeListener((ParameterChangeListener)this);
        this.rupComparator = new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                if (RupturesAnim.this.rupSet == null) {
                    return 0;
                }
                switch (RupturesAnim.this.sortType.ordinal()) {
                    case 0: {
                        return o1.compareTo(o2);
                    }
                    case 1: {
                        return Integer.valueOf(RupturesAnim.this.rupSet.getSectionsIndicesForRup(o2.intValue()).size()).compareTo(RupturesAnim.this.rupSet.getSectionsIndicesForRup(o1.intValue()).size());
                    }
                    case 2: {
                        return Double.valueOf(RupturesAnim.this.rupSet.getMagForRup(o2.intValue())).compareTo(RupturesAnim.this.rupSet.getMagForRup(o1.intValue()));
                    }
                    case 3: {
                        return Double.valueOf(RupturesAnim.this.rupSet.getMagForRup(o1.intValue())).compareTo(RupturesAnim.this.rupSet.getMagForRup(o2.intValue()));
                    }
                    case 4: {
                        if (RupturesAnim.this.sol == null) {
                            return 0;
                        }
                        return Double.valueOf(RupturesAnim.this.sol.getRateForRup(o2.intValue())).compareTo(RupturesAnim.this.sol.getRateForRup(o1.intValue()));
                    }
                    case 7: {
                        if (RupturesAnim.this.sol == null) {
                            return 0;
                        }
                        Double mr1 = RupturesAnim.this.getMomentRate(o1);
                        Double mr2 = RupturesAnim.this.getMomentRate(o2);
                        return mr2.compareTo(mr1);
                    }
                }
                return 0;
            }
        };
        this.displayParam = new EnumParameter(DISPLAY_PARAM_NAME, EnumSet.allOf(DisplayType.class), (Enum)DISPLAY_DEFAULT, null);
        this.displayParam.setValue((Object)DISPLAY_DEFAULT);
        this.displayParam.addParameterChangeListener((ParameterChangeListener)this);
        this.rateColorer.setCPTLog(true);
        this.rateColorer.getCPT().setBelowMinColor(this.rateColorer.getCPT().getMinColor());
        try {
            CPT max01 = GMT_CPT_Files.MAX_SPECTRUM.instance().rescale(0.0, 1.0);
            max01.setNanColor(Color.GRAY);
            this.orderColorer.setCPT(max01);
            this.parentColorer.setCPT((CPT)max01.clone());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.multiColorerWrapper = new AnimMultiColorerPickHandlerWrapper(this.getName(), this.getColorerForDisplayParam(), this);
        this.params = new ParameterList();
        this.params.addParameter((Parameter)this.sectionSelect);
        this.params.addParameter((Parameter)this.sortParam);
        this.params.addParameter((Parameter)this.minMagParam);
        this.params.addParameter((Parameter)this.maxMagParam);
        this.params.addParameter((Parameter)this.minRateParam);
        this.params.addParameter((Parameter)this.maxRateParam);
        this.params.addParameter(this.displayParam);
        this.params.addParameter((Parameter)this.poissonSamplesParam);
        this.params.addParameter((Parameter)this.surfsVisibleParam);
    }

    private double getMomentRate(int rupIndex) {
        if (!this.rupSet.hasModule(AveSlipModule.class)) {
            return Double.NaN;
        }
        return this.sol.getRateForRup(rupIndex) * FaultMomentCalc.getMoment((double)this.rupSet.getAreaForRup(rupIndex), (double)this.getAveSlip(rupIndex));
    }

    private double getAveSlip(int rupIndex) {
        if (this.rupSet == null || !this.rupSet.hasModule(AveSlipModule.class)) {
            return Double.NaN;
        }
        return ((AveSlipModule)this.rupSet.getModule(AveSlipModule.class)).getAveSlip(rupIndex);
    }

    @Override
    public void addRangeChangeListener(ChangeListener l) {
        this.listeners.add(l);
    }

    @Override
    public int getNumSteps() {
        if (this.rupSet == null) {
            return 0;
        }
        return this.ruptureIDs.size();
    }

    @Override
    public void setCurrentStep(int step) {
        this.curStep = step;
    }

    @Override
    public boolean includeStepInLabel() {
        return false;
    }

    @Override
    public String getCurrentLabel() {
        if (this.curStep < 0 || this.rupSet == null || this.ruptureIDs.isEmpty()) {
            return null;
        }
        int rupID = this.ruptureIDs.get(this.curStep);
        String str = "Rupture " + rupID;
        str = str + " (" + this.rupSet.getSectionsIndicesForRup(rupID).size() + " sects).";
        str = str + " Mag: " + (float)this.rupSet.getMagForRup(rupID);
        try {
            str = str + " Area: " + (float)this.rupSet.getAreaForRup(rupID) + " m^2";
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            str = str + " Len: " + (float)this.rupSet.getLengthForRup(rupID) + " m";
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.sol != null) {
            str = str + " Rate: " + (float)this.sol.getRateForRup(rupID);
            double moRate = this.getMomentRate(rupID);
            if (!Double.isNaN(moRate)) {
                str = str + " MoRate: " + (float)moRate;
            }
            try {
                double aveSlip = this.getAveSlip(rupID);
                if (!Double.isNaN(aveSlip)) {
                    str = str + " aveSlip: " + (float)aveSlip + " m";
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return str;
    }

    @Override
    public ParameterList getAnimationParameters() {
        return this.params;
    }

    @Override
    public Boolean getFaultVisibility(AbstractFaultSection fault) {
        if (((Boolean)this.surfsVisibleParam.getValue()).booleanValue()) {
            return this.isSectionAnimated(fault.getId());
        }
        return null;
    }

    @Override
    public FaultColorer getFaultColorer() {
        return this.multiColorerWrapper;
    }

    @Override
    public void fireRangeChangeEvent() {
        ChangeEvent e = new ChangeEvent(this);
        for (ChangeListener l : this.listeners) {
            l.stateChanged(e);
        }
    }

    public String getName() {
        return "Ruptures Animation";
    }

    private boolean isSectionAnimated(int secID) {
        if (this.rupSet == null) {
            return false;
        }
        if (this.curStep < 0) {
            return false;
        }
        int rupID = this.ruptureIDs.get(this.curStep);
        return this.rupSet.getSectionsIndicesForRup(rupID).contains(secID);
    }

    @Override
    public void setRupSet(FaultSystemRupSet rupSet, FaultSystemSolution sol) {
        this.rupSet = rupSet;
        this.sol = sol;
        this.sectionSelect.removeParameterChangeListener((ParameterChangeListener)this);
        StringConstraint sconst = (StringConstraint)this.sectionSelect.getConstraint();
        this.sectionNames = new ArrayList();
        this.sectionNames.add(SECTION_SELECT_PARAM_DEFAULT);
        if (rupSet != null) {
            for (FaultSection data : rupSet.getFaultSectionDataList()) {
                Object name = data.getSectionId() + ". " + data.getSectionName();
                name = ((String)name).replaceAll("Subsection", "#");
                this.sectionNames.add((String)name);
            }
        }
        this.sectionSelect.setValue((Object)SECTION_SELECT_PARAM_DEFAULT);
        sconst.setStrings(this.sectionNames);
        this.sectionSelect.getEditor().refreshParamEditor();
        this.sectionSelect.addParameterChangeListener((ParameterChangeListener)this);
        this.updateRuptures();
    }

    @Override
    public int getStepForID(int id) {
        if (this.ruptureIDs == null || this.ruptureIDs.isEmpty()) {
            return -1;
        }
        return this.ruptureIDs.indexOf(id);
    }

    @Override
    public int getIDForStep(int step) {
        if (this.ruptureIDs == null || this.ruptureIDs.isEmpty()) {
            return -1;
        }
        return this.ruptureIDs.get(step);
    }

    private void updateRuptures() {
        this.ruptureIDs = new ArrayList<Integer>();
        if (this.rupSet != null) {
            double minMag = (Double)this.minMagParam.getValue();
            double maxMag = (Double)this.maxMagParam.getValue();
            double minRate = (Double)this.minRateParam.getValue();
            double maxRate = (Double)this.maxRateParam.getValue();
            for (int rupID = 0; rupID < this.rupSet.getNumRuptures(); ++rupID) {
                double rate;
                double mag;
                if (this.selectedSectionID >= 0 && !this.rupSet.getSectionsIndicesForRup(rupID).contains(this.selectedSectionID) || (mag = this.rupSet.getMagForRup(rupID)) < minMag || mag > maxMag || this.sol != null && ((rate = this.sol.getRateForRup(rupID)) < minRate || rate > maxRate)) continue;
                this.ruptureIDs.add(rupID);
            }
        }
        if (this.sortType == SortType.RANDOM) {
            Collections.shuffle(this.ruptureIDs);
        } else if (this.sortType == SortType.POISSON_SAMPLING) {
            this.ruptureIDs = this.generatePoissonSequence(this.ruptureIDs);
        } else {
            Collections.sort(this.ruptureIDs, this.rupComparator);
        }
        this.fireRangeChangeEvent();
    }

    private List<Integer> generatePoissonSequence(List<Integer> rupIDs) {
        if (this.sol == null) {
            return new ArrayList<Integer>();
        }
        ArrayList<Integer> nonZeros = new ArrayList<Integer>();
        ArrayList<Double> rates = new ArrayList<Double>();
        for (int rupID : rupIDs) {
            double rate = this.sol.getRateForRup(rupID);
            if (!(rate > 0.0)) continue;
            nonZeros.add(rupID);
            rates.add(rate);
        }
        WeightedSampler s = new WeightedSampler(nonZeros, rates);
        int numSamples = (Integer)this.poissonSamplesParam.getValue();
        return s.generateSeries(numSamples);
    }

    public void parameterChange(ParameterChangeEvent event) {
        if (event.getParameter() == this.sectionSelect) {
            int sectionIndex = this.sectionNames.indexOf(this.sectionSelect.getValue()) - 1;
            this.selectedSectionID = this.rupSet == null || sectionIndex < 0 ? -1 : this.rupSet.getFaultSectionData(sectionIndex).getSectionId();
            this.updateRuptures();
        } else if (event.getParameter() == this.minMagParam || event.getParameter() == this.maxMagParam) {
            this.updateRuptures();
        } else if (event.getParameter() == this.minRateParam || event.getParameter() == this.maxRateParam) {
            this.updateRuptures();
        } else if (event.getParameter() == this.sortParam) {
            this.sortType = SortType.fromString((String)this.sortParam.getValue());
            this.poissonSamplesParam.getEditor().setEnabled(this.sortType == SortType.POISSON_SAMPLING);
            this.updateRuptures();
        } else if (event.getParameter() == this.displayParam) {
            this.multiColorerWrapper.setAnimColorer(this.getColorerForDisplayParam());
        } else if (event.getParameter() == this.poissonSamplesParam) {
            this.updateRuptures();
        } else if (event.getParameter() == this.surfsVisibleParam) {
            this.updateRuptures();
        }
    }

    private FaultColorer getColorerForDisplayParam() {
        switch (((DisplayType)((Object)this.displayParam.getValue())).ordinal()) {
            case 1: {
                return this.rateColorer;
            }
            case 5: {
                return this.rakeColorer;
            }
            case 2: {
                return this.magColorer;
            }
            case 3: {
                return this.slipColorer;
            }
            case 4: {
                return this.sectionSlipColorer;
            }
            case 6: {
                return this.strikeColorer;
            }
            case 7: {
                return this.orderColorer;
            }
            case 8: {
                return this.parentColorer;
            }
        }
        return this.simpleFaultColorer;
    }

    @Override
    public int getPreferredInitialStep() {
        return 0;
    }

    @Override
    public void actorPicked(PickEnabledActor<AbstractFaultSection> actor, AbstractFaultSection fault, vtkCellPicker picker, MouseEvent e) {
        int pickedID;
        int nameIndex;
        if (e.getButton() == 1 && e.isShiftDown() && (nameIndex = (pickedID = fault.getId()) + 1) < this.sectionNames.size() && nameIndex >= 0) {
            this.sectionSelect.setValue((Object)this.sectionNames.get(nameIndex));
            this.sectionSelect.getEditor().refreshParamEditor();
        }
    }

    static enum SortType {
        ID("Rupture ID"),
        NUM_SECTIONS("Num Sections (Decreasing)"),
        MAGNITUDE_DECREASING("Mag (Decreasing)"),
        MAGNITUDE_INCREASING("Mag (Increasing)"),
        RATE("Rate (Decreasing)"),
        RANDOM("Random"),
        POISSON_SAMPLING("Rate-Weighted Sample"),
        MOMENT_RATE("Moment*Rate (Decreasing)");

        private String name;

        private SortType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public static SortType fromString(String str) {
            for (SortType t : SortType.values()) {
                if (!t.toString().equals(str)) continue;
                return t;
            }
            throw new NoSuchElementException("Unknown Sort Type: " + str);
        }
    }

    private static enum DisplayType {
        SOLID("Solid Colors"),
        RATE("Color By Rate"),
        MAG("Color By Mag"),
        SLIP("Color By Rupture Slip"),
        SECTION_SLIP("Color By Section Slip Rate"),
        RAKE("Color By Rake"),
        STRIKE("Color By Strike"),
        ORDER("Color By Section Order"),
        PARENT("Color By Parent Section");

        private String name;

        private DisplayType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

