/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.plugins.opensha.ucerf3Rups.anims;

import com.google.common.base.Preconditions;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.dom4j.DocumentException;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.impl.BooleanParameter;
import org.opensha.commons.param.impl.DoubleParameter;
import org.opensha.commons.param.impl.FileParameter;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.faultSysSolution.modules.PolygonFaultGridAssociations;
import org.opensha.sha.earthquake.observedEarthquake.ObsEqkRupList;
import org.opensha.sha.earthquake.observedEarthquake.ObsEqkRupture;
import org.opensha.sha.earthquake.observedEarthquake.parsers.UCERF3_CatalogParser;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.faultSurface.PointSurface;
import org.opensha.sha.faultSurface.RuptureSurface;
import org.opensha.sha.faultSurface.Surface3D;
import org.scec.vtk.commons.opensha.faults.AbstractFaultSection;
import org.scec.vtk.commons.opensha.faults.anim.FaultAnimation;
import org.scec.vtk.commons.opensha.faults.colorers.ColorerChangeListener;
import org.scec.vtk.commons.opensha.faults.colorers.FaultColorer;
import org.scec.vtk.commons.opensha.faults.faultSectionImpl.ObsEqkRupSection;
import org.scec.vtk.commons.opensha.surfaces.FaultSectionActorList;
import org.scec.vtk.commons.opensha.surfaces.PointSurfaceGenerator;
import org.scec.vtk.commons.opensha.surfaces.PolygonSurfaceGenerator;
import org.scec.vtk.plugins.PluginActors;
import org.scec.vtk.plugins.opensha.obsEqkRup.ObsEqkRupBuilder;
import org.scec.vtk.plugins.opensha.obsEqkRup.RenamedParameterWrapper;
import org.scec.vtk.plugins.opensha.ucerf3Rups.UCERF3RupSetChangeListener;
import scratch.UCERF3.enumTreeBranches.FaultModels;
import scratch.UCERF3.erf.ETAS.ETAS_EqkRupture;
import scratch.UCERF3.erf.ETAS.association.FiniteFaultMappingData;
import scratch.UCERF3.erf.ETAS.association.FiniteFaultSectionResetCalc;
import vtk.vtkActor;
import vtk.vtkProp;

public class SectionResetAnim
implements FaultAnimation,
ParameterChangeListener,
UCERF3RupSetChangeListener,
FaultColorer {
    private FileParameter catalogFileParam;
    private FileParameter finiteSurfsFileParam;
    private DoubleParameter fractAreaParam;
    private BooleanParameter removeOverlapsParam;
    private BooleanParameter polygonsParam;
    private List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private ColorerChangeListener colorListener;
    private ParameterList params;
    private PluginActors pluginActors;
    private PointSurfaceGenerator pointGen;
    private Parameter<?> pointSizeParam;
    private PolygonSurfaceGenerator polyGen;
    private Parameter<Double> opacityParam;
    private List<vtkProp> curActors;
    private FaultSystemRupSet rupSet;
    private FaultModels fm;
    private ObsEqkRupList obsRups;
    private FiniteFaultSectionResetCalc sectCalc;
    private int step = -1;
    private HashSet<Integer> curAreaInsideSects;
    private HashSet<Integer> curMappedSects;
    private HashSet<Integer> curResetSects;
    private static SimpleDateFormat df = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss z");
    private static DecimalFormat twoDigit = new DecimalFormat("0.##");
    private static final Color MAPPED_AND_RESET = Color.GREEN.darker();
    private static final Color MAPPED_NOT_RESET = Color.RED.darker();
    private static final Color RESET_NOT_MAPPED = Color.BLUE.darker();
    private static final Color AREA_ONLY = Color.LIGHT_GRAY.darker();
    private static final Color UNMAPPED_SURF = Color.ORANGE.darker();

    public SectionResetAnim(PluginActors pluginActors) {
        this.pluginActors = pluginActors;
        this.params = new ParameterList();
        this.catalogFileParam = new FileParameter("Catalog File");
        this.catalogFileParam.addParameterChangeListener((ParameterChangeListener)this);
        this.params.addParameter((Parameter)this.catalogFileParam);
        this.finiteSurfsFileParam = new FileParameter("Finite Surfaces XML File");
        this.finiteSurfsFileParam.addParameterChangeListener((ParameterChangeListener)this);
        this.params.addParameter((Parameter)this.finiteSurfsFileParam);
        File kevinGitDir = new File("/home/kevin/git/ucerf3-etas-launcher/inputs");
        if (kevinGitDir.exists()) {
            this.catalogFileParam.setDefaultInitialDir(kevinGitDir);
            this.finiteSurfsFileParam.setDefaultInitialDir(kevinGitDir);
        }
        this.fractAreaParam = new DoubleParameter("Fract Sect Area", 0.01, 1.0);
        this.fractAreaParam.setValue(0.5);
        this.fractAreaParam.addParameterChangeListener((ParameterChangeListener)this);
        this.params.addParameter((Parameter)this.fractAreaParam);
        this.removeOverlapsParam = new BooleanParameter("Remove Overlaps (dist-weighted)");
        this.removeOverlapsParam.setValue((Object)true);
        this.removeOverlapsParam.addParameterChangeListener((ParameterChangeListener)this);
        this.params.addParameter((Parameter)this.removeOverlapsParam);
        this.polygonsParam = new BooleanParameter("Show Sect Polygons", Boolean.valueOf(true));
        this.polygonsParam.addParameterChangeListener((ParameterChangeListener)this);
        this.params.addParameter((Parameter)this.polygonsParam);
        this.pointGen = new PointSurfaceGenerator();
        this.pointGen.setBundlerEneabled(false);
        this.pointSizeParam = this.pointGen.getDisplayParams().getParameter(Double.class, "Point Size");
        this.params.addParameter(new RenamedParameterWrapper(this.pointSizeParam, "Unmapped Surf " + this.pointSizeParam.getName()));
        this.pointSizeParam.addParameterChangeListener((ParameterChangeListener)this);
        this.polyGen = new PolygonSurfaceGenerator();
        this.polyGen.setBundlerEneabled(false);
        this.opacityParam = this.polyGen.getDisplayParams().getParameter(Double.class, "Surface Opacity");
        this.opacityParam.setValue((Object)0.3);
        this.params.addParameter(new RenamedParameterWrapper<Double>(this.opacityParam, "Polygon " + this.opacityParam.getName()));
        this.opacityParam.addParameterChangeListener((ParameterChangeListener)this);
    }

    public String getName() {
        return "Obs Rup Finite Section Reset Anim";
    }

    @Override
    public void addRangeChangeListener(ChangeListener l) {
        this.listeners.add(l);
    }

    @Override
    public int getNumSteps() {
        if (this.obsRups == null) {
            return 0;
        }
        return this.obsRups.size();
    }

    private void clearCurrent() {
        this.curAreaInsideSects = null;
        this.curMappedSects = null;
        this.curResetSects = null;
        if (this.curActors != null) {
            for (vtkProp prop : this.curActors) {
                this.pluginActors.removeActor(prop);
            }
            this.curActors = null;
        }
    }

    @Override
    public void setCurrentStep(int step) {
        this.step = step;
        this.clearCurrent();
        if (step >= 0 && this.sectCalc != null) {
            int rupIndex;
            Preconditions.checkNotNull((Object)this.obsRups);
            Preconditions.checkState((step < this.obsRups.size() ? 1 : 0) != 0);
            ObsEqkRupture rup = (ObsEqkRupture)this.obsRups.get(step);
            RuptureSurface surf = rup.getRuptureSurface();
            double[] areas = this.sectCalc.getAreaInSectionPolygons(surf);
            if (areas != null) {
                this.curAreaInsideSects = new HashSet();
                for (int s = 0; s < areas.length; ++s) {
                    if (!(areas[s] > 0.0)) continue;
                    this.curAreaInsideSects.add(s);
                }
                FiniteFaultSectionResetCalc.SectRupDistances[] dists = (Boolean)this.removeOverlapsParam.getValue() != false ? this.sectCalc.getSectRupDistances(surf, areas) : null;
                List sects = this.sectCalc.getMatchingSections(surf, areas, dists);
                if (sects != null) {
                    System.out.println("Found " + sects.size() + " sections to reset");
                    this.curResetSects = new HashSet();
                    for (FaultSection sect : sects) {
                        this.curResetSects.add(sect.getSectionId());
                    }
                } else {
                    System.out.println("Found no sections to reset");
                }
            }
            if ((rupIndex = this.getRupIndex(rup)) >= 0) {
                this.curMappedSects = new HashSet(this.rupSet.getSectionsIndicesForRup(rupIndex));
            } else {
                Preconditions.checkNotNull((Object)rup.getRuptureSurface());
                FaultSectionActorList actors = this.pointGen.createFaultActors((Surface3D)rup.getRuptureSurface(), UNMAPPED_SURF, (AbstractFaultSection)new ObsEqkRupSection(this.getRupName(rup), -1, rup));
                this.curActors = new ArrayList<vtkProp>();
                for (vtkActor actor : actors) {
                    this.pluginActors.addActor((vtkProp)actor);
                    this.curActors.add((vtkProp)actor);
                }
            }
            System.out.println("=== " + this.getRupName(rup) + " ===");
            for (FaultSection sect : this.rupSet.getFaultSectionDataList()) {
                Object areaFractStr;
                int index = sect.getSectionId();
                boolean hasArea = this.contained(this.curAreaInsideSects, index);
                boolean isMapped = this.contained(this.curMappedSects, index);
                boolean isReset = this.contained(this.curResetSects, index);
                if (hasArea) {
                    double sectArea = this.rupSet.getAreaForSection(index) * 1.0E-6;
                    double fract = areas[index] / sectArea;
                    areaFractStr = "\t\t(area fract =" + twoDigit.format(areas[index]) + " / " + twoDigit.format(sectArea) + " = " + twoDigit.format(fract);
                    double thresh = (Double)this.fractAreaParam.getValue();
                    areaFractStr = fract >= thresh ? (String)areaFractStr + " > " : (String)areaFractStr + " < ";
                    areaFractStr = (String)areaFractStr + twoDigit.format(thresh) + ")";
                } else {
                    areaFractStr = "\t\t(no area)";
                }
                if (isMapped) {
                    if (isReset) {
                        System.out.println(sect.getName() + ": MAPPED and RESET" + (String)areaFractStr);
                    } else {
                        System.out.println(sect.getName() + ": MAPPED and NOT RESET" + (String)areaFractStr);
                    }
                } else if (isReset) {
                    System.out.println(sect.getName() + ": RESET and NOT MAPPED" + (String)areaFractStr);
                } else if (hasArea) {
                    System.out.println(sect.getName() + ": NEITHER MAPPED and NOR RESET, HAS AREA" + (String)areaFractStr);
                }
                if (!hasArea || !((Boolean)this.polygonsParam.getValue()).booleanValue()) continue;
                if (this.curActors == null) {
                    this.curActors = new ArrayList<vtkProp>();
                }
                vtkActor actor = this.polyGen.buildSimplePolygon(this.sectCalc.getPolygon(index).getBorder(), this.getColor(index));
                this.pluginActors.addActor((vtkProp)actor);
                this.curActors.add((vtkProp)actor);
            }
            System.out.println("=============================");
        }
        if (this.colorListener != null) {
            this.colorListener.colorerChanged(this);
        }
    }

    @Override
    public int getPreferredInitialStep() {
        if (this.obsRups != null && this.step < this.obsRups.size()) {
            return this.step;
        }
        return 0;
    }

    @Override
    public boolean includeStepInLabel() {
        return false;
    }

    private String getRupName(ObsEqkRupture rup) {
        String name = "M" + twoDigit.format(rup.getMag()) + ", " + df.format(new Date(rup.getOriginTime()));
        int rupIndex = this.getRupIndex(rup);
        name = rupIndex >= 0 ? name + ", Mapped U3 Rup # " + rupIndex : name + ", Unmapped";
        return name;
    }

    @Override
    public String getCurrentLabel() {
        if (this.obsRups == null || this.step < 0) {
            return null;
        }
        ObsEqkRupture rup = (ObsEqkRupture)this.obsRups.get(this.step);
        return this.getRupName(rup);
    }

    private int getRupIndex(ObsEqkRupture rup) {
        if (rup instanceof ETAS_EqkRupture) {
            return ((ETAS_EqkRupture)rup).getFSSIndex();
        }
        return -1;
    }

    @Override
    public ParameterList getAnimationParameters() {
        return this.params;
    }

    @Override
    public Boolean getFaultVisibility(AbstractFaultSection fault) {
        int index = fault.getId();
        boolean hasArea = this.contained(this.curAreaInsideSects, index);
        boolean isMapped = this.contained(this.curMappedSects, index);
        boolean isReset = this.contained(this.curResetSects, index);
        return hasArea || isMapped || isReset;
    }

    @Override
    public Color getColor(AbstractFaultSection fault) {
        int index = fault.getId();
        return this.getColor(index);
    }

    private Color getColor(int index) {
        boolean hasArea = this.contained(this.curAreaInsideSects, index);
        boolean isMapped = this.contained(this.curMappedSects, index);
        boolean isReset = this.contained(this.curResetSects, index);
        if (isMapped) {
            if (isReset) {
                return MAPPED_AND_RESET;
            }
            return MAPPED_NOT_RESET;
        }
        if (isReset) {
            return RESET_NOT_MAPPED;
        }
        if (hasArea) {
            return AREA_ONLY;
        }
        return Color.GRAY;
    }

    private boolean contained(HashSet<Integer> indexes, int index) {
        return indexes != null && indexes.contains(index);
    }

    @Override
    public FaultColorer getFaultColorer() {
        return this;
    }

    @Override
    public void fireRangeChangeEvent() {
        ChangeEvent e = new ChangeEvent(this);
        for (ChangeListener l : this.listeners) {
            l.stateChanged(e);
        }
    }

    private void checkLoadCatalog() {
        File catalogFile = (File)this.catalogFileParam.getValue();
        File finiteSurfsFile = (File)this.finiteSurfsFileParam.getValue();
        this.clearCurrent();
        if (catalogFile != null && finiteSurfsFile != null && this.rupSet != null) {
            if (this.fm == null) {
                this.fm = ObsEqkRupBuilder.detectFM(this.rupSet, null);
            }
            try {
                ObsEqkRupList rups = UCERF3_CatalogParser.loadCatalog((File)catalogFile);
                FiniteFaultMappingData.loadRuptureSurfaces((File)finiteSurfsFile, (ObsEqkRupList)rups, (FaultModels)this.fm, (FaultSystemRupSet)this.rupSet);
                ObsEqkRupList finiteRups = new ObsEqkRupList();
                for (ObsEqkRupture rup : rups) {
                    RuptureSurface surf = rup.getRuptureSurface();
                    if (surf == null || surf instanceof PointSurface || surf.isPointSurface()) continue;
                    finiteRups.add((Object)rup);
                }
                System.out.println("Loaded " + finiteRups.size() + " finite ruptures");
                this.obsRups = finiteRups;
                this.sectCalc = new FiniteFaultSectionResetCalc(this.rupSet, (PolygonFaultGridAssociations)this.rupSet.requireModule(PolygonFaultGridAssociations.class), ((Double)this.fractAreaParam.getValue()).doubleValue(), ((Boolean)this.removeOverlapsParam.getValue()).booleanValue());
                this.fireRangeChangeEvent();
                this.colorListener.colorerChanged(this);
                this.setCurrentStep(0);
            }
            catch (IOException | DocumentException e) {
                throw ExceptionUtils.asRuntimeException((Throwable)e);
            }
        } else if (this.obsRups != null) {
            this.obsRups = null;
            this.fireRangeChangeEvent();
        }
    }

    public void parameterChange(ParameterChangeEvent e) {
        if (e.getParameter() == this.catalogFileParam) {
            if (this.finiteSurfsFileParam.getValue() == null) {
                this.finiteSurfsFileParam.setDefaultInitialDir(((File)this.catalogFileParam.getValue()).getParentFile());
            }
            this.checkLoadCatalog();
        } else if (e.getParameter() == this.finiteSurfsFileParam) {
            if (this.catalogFileParam.getValue() == null) {
                this.catalogFileParam.setDefaultInitialDir(((File)this.finiteSurfsFileParam.getValue()).getParentFile());
            }
            this.checkLoadCatalog();
        } else if (e.getParameter() == this.fractAreaParam) {
            if (this.sectCalc != null) {
                this.sectCalc.setMinFractionalAreaInPolygon(((Double)this.fractAreaParam.getValue()).doubleValue());
                this.fireRangeChangeEvent();
            }
        } else if (e.getParameter() == this.removeOverlapsParam) {
            if (this.sectCalc != null) {
                this.sectCalc.setRemoveOverlapsWithDist(((Boolean)this.removeOverlapsParam.getValue()).booleanValue());
                this.fireRangeChangeEvent();
            }
        } else if (e.getParameter() == this.pointSizeParam || e.getParameter() == this.opacityParam) {
            this.colorListener.colorerChanged(this);
            this.setCurrentStep(this.step);
        }
    }

    @Override
    public void setRupSet(FaultSystemRupSet rupSet, FaultSystemSolution sol) {
        this.rupSet = rupSet;
        this.fm = null;
    }

    @Override
    public ParameterList getColorerParameters() {
        return null;
    }

    @Override
    public void setColorerChangeListener(ColorerChangeListener l) {
        this.colorListener = l;
    }

    @Override
    public String getLegendLabel() {
        return null;
    }
}

