/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.plugins.opensha.ucerf3Rups.colorers;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.NoSuchElementException;
import org.opensha.commons.mapping.gmt.elements.GMT_CPT_Files;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.constraint.impl.StringConstraint;
import org.opensha.commons.param.editor.impl.FileParameterEditor;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.impl.DoubleParameter;
import org.opensha.commons.param.impl.FileParameter;
import org.opensha.commons.param.impl.StringParameter;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.commons.util.cpt.CPT;
import org.opensha.commons.util.cpt.CPTVal;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.faultSysSolution.modules.AveSlipModule;
import org.opensha.sha.earthquake.faultSysSolution.modules.SlipAlongRuptureModel;
import org.scec.vtk.commons.opensha.faults.AbstractFaultSection;
import org.scec.vtk.commons.opensha.faults.colorers.CPTBasedColorer;
import org.scec.vtk.commons.opensha.faults.colorers.ColorerChangeListener;
import org.scec.vtk.plugins.opensha.ucerf3Rups.UCERF3FaultSystemRupturesBuilder;
import org.scec.vtk.plugins.opensha.ucerf3Rups.UCERF3RupSetChangeListener;
import scratch.UCERF3.inversion.UCERF3InversionInputGenerator;

public class ComparisonColorer
extends CPTBasedColorer
implements UCERF3RupSetChangeListener,
ParameterChangeListener {
    private FaultSystemSolution sol;
    private static final String COMPARISON_FILE_PARAM_NAME = "Load Solution Comparison File";
    private FileParameter comparisonFileParam;
    private FaultSystemSolution comparisonSol;
    private ColorerChangeListener l;
    private CPT polar;
    private static final String COMPARE_TYPE_PARAM_NAME = "Comparison Type";
    private StringParameter compareTypeParam;
    private CompareType comp;
    private static final String COMPARE_PLOT_TYPE_PARAM_NAME = "Plot";
    private StringParameter plotTypeParam;
    private ComparePlotType plot;
    private DoubleParameter magMinParam;
    private double min_patic_mag = 0.0;
    private double max_patic_mag = 10.0;
    private DoubleParameter magMaxParam;
    private ParameterList params;
    private HashMap<Integer, double[]> valCache;
    private UCERF3FaultSystemRupturesBuilder builder;

    public ComparisonColorer(UCERF3FaultSystemRupturesBuilder builder) {
        super(null, false);
        this.builder = builder;
        try {
            this.polar = GMT_CPT_Files.GMT_POLAR.instance();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.comparisonFileParam = new FileParameter(COMPARISON_FILE_PARAM_NAME);
        this.comparisonFileParam.addParameterChangeListener((ParameterChangeListener)this);
        this.comparisonFileParam.getEditor().setEnabled(false);
        this.params = new ParameterList();
        ArrayList<String> compStrings = new ArrayList<String>();
        for (CompareType t : CompareType.values()) {
            if (t.external) continue;
            compStrings.add(t.toString());
        }
        this.compareTypeParam = new StringParameter(COMPARE_TYPE_PARAM_NAME, compStrings, (String)compStrings.get(0));
        this.compareTypeParam.addParameterChangeListener((ParameterChangeListener)this);
        this.comp = CompareType.forString((String)this.compareTypeParam.getValue());
        ArrayList<String> plotStrings = new ArrayList<String>();
        for (ComparePlotType t : ComparePlotType.values()) {
            plotStrings.add(t.toString());
        }
        this.plotTypeParam = new StringParameter(COMPARE_PLOT_TYPE_PARAM_NAME, plotStrings, (String)plotStrings.get(0));
        this.plotTypeParam.addParameterChangeListener((ParameterChangeListener)this);
        this.plot = ComparePlotType.forString((String)this.plotTypeParam.getValue());
        this.params.addParameter((Parameter)this.compareTypeParam);
        this.params.addParameter((Parameter)this.plotTypeParam);
        this.params.addParameter((Parameter)this.comparisonFileParam);
        this.magMinParam = new DoubleParameter("Min Mag (Part. Rates)", this.min_patic_mag, this.max_patic_mag);
        this.magMinParam.setValue(this.min_patic_mag);
        this.magMinParam.addParameterChangeListener((ParameterChangeListener)this);
        this.params.addParameter((Parameter)this.magMinParam);
        this.magMaxParam = new DoubleParameter("Max Mag (Part. Rates)", this.min_patic_mag, this.max_patic_mag);
        this.magMaxParam.setValue(this.max_patic_mag);
        this.magMaxParam.addParameterChangeListener((ParameterChangeListener)this);
        this.params.addParameter((Parameter)this.magMaxParam);
        this.enableMinMax();
        this.valCache = new HashMap();
        this.setCPT(null);
    }

    private void enableMinMax() {
        boolean enabled = this.comp == CompareType.SOLUTION_PARTICIPATION_RATES_COMPARISON;
        this.magMinParam.getEditor().setEnabled(enabled);
        this.magMinParam.getEditor().refreshParamEditor();
        this.magMaxParam.getEditor().setEnabled(enabled);
        this.magMaxParam.getEditor().refreshParamEditor();
    }

    private void updateCompTypeStrings() {
        boolean allowExternal = this.comparisonSol != null;
        ArrayList<String> compStrings = new ArrayList<String>();
        for (CompareType t : CompareType.values()) {
            if (t.external && !allowExternal) continue;
            compStrings.add(t.toString());
        }
        if (this.comp.external && !allowExternal) {
            for (CompareType t : CompareType.values()) {
                if (t.external) continue;
                this.compareTypeParam.setValue((Object)t.toString());
                break;
            }
        }
        StringConstraint sconst = (StringConstraint)this.compareTypeParam.getConstraint();
        sconst.setStrings(compStrings);
        this.compareTypeParam.getEditor().refreshParamEditor();
    }

    public String getName() {
        return "Solution Comparisons";
    }

    @Override
    public void setRupSet(FaultSystemRupSet rupSet, FaultSystemSolution sol) {
        this.sol = sol;
        if (sol != null && this.comparisonSol != null && this.comparisonSol.getRupSet().getNumRuptures() != sol.getRupSet().getNumRuptures()) {
            this.comparisonFileParam.setValue(null);
        }
        this.comparisonFileParam.getEditor().setEnabled(rupSet != null);
        this.valCache.clear();
    }

    public void setComparisonSolution(FaultSystemSolution comparisonSol) {
        System.out.println("Got new comparison!");
        this.valCache.clear();
        this.comparisonSol = comparisonSol;
        this.updateCompTypeStrings();
    }

    @Override
    public double getValue(AbstractFaultSection fault) {
        double val2;
        double val1;
        int secID = fault.getId();
        if (this.sol == null) {
            return Double.NaN;
        }
        if (this.valCache.containsKey(secID)) {
            double[] cached = this.valCache.get(secID);
            val1 = cached[0];
            val2 = cached[1];
        } else {
            FaultSystemRupSet rupSet = this.sol.getRupSet();
            switch (this.comp.ordinal()) {
                case 0: {
                    val1 = rupSet.hasModule(SlipAlongRuptureModel.class) && rupSet.hasModule(AveSlipModule.class) ? ((SlipAlongRuptureModel)rupSet.getModule(SlipAlongRuptureModel.class)).calcSlipRateForSect(this.sol, (AveSlipModule)rupSet.getModule(AveSlipModule.class), secID) : Double.NaN;
                    val2 = this.sol.getRupSet().getSlipRateForSection(secID);
                    break;
                }
                case 1: {
                    try {
                        val1 = this.sol.calcTotPaleoVisibleRateForSect(secID, UCERF3InversionInputGenerator.loadDefaultPaleoProbabilityModel());
                    }
                    catch (IOException e) {
                        throw ExceptionUtils.asRuntimeException((Throwable)e);
                    }
                    val2 = this.sol.calcTotParticRateForSect(secID);
                    break;
                }
                case 2: {
                    val1 = this.sol.calcParticRateForSect(secID, this.min_patic_mag, this.max_patic_mag);
                    val2 = this.comparisonSol.calcParticRateForSect(secID, this.min_patic_mag, this.max_patic_mag);
                    break;
                }
                case 3: {
                    val1 = rupSet.hasModule(SlipAlongRuptureModel.class) && rupSet.hasModule(AveSlipModule.class) ? ((SlipAlongRuptureModel)rupSet.getModule(SlipAlongRuptureModel.class)).calcSlipRateForSect(this.sol, (AveSlipModule)rupSet.getModule(AveSlipModule.class), secID) : Double.NaN;
                    FaultSystemRupSet compRupSet = this.comparisonSol.getRupSet();
                    if (compRupSet.hasModule(SlipAlongRuptureModel.class) && compRupSet.hasModule(AveSlipModule.class)) {
                        val2 = ((SlipAlongRuptureModel)compRupSet.getModule(SlipAlongRuptureModel.class)).calcSlipRateForSect(this.comparisonSol, (AveSlipModule)compRupSet.getModule(AveSlipModule.class), secID);
                        break;
                    }
                    val2 = Double.NaN;
                    break;
                }
                default: {
                    return Double.NaN;
                }
            }
            double[] cached = new double[]{val1, val2};
            this.valCache.put(secID, cached);
        }
        double comp = this.getComparison(val1, val2);
        if (Double.isInfinite(comp)) {
            return Double.NaN;
        }
        return comp;
    }

    private double getComparison(double val1, double val2) {
        return ComparisonColorer.getComparison(this.plot, val1, val2);
    }

    public static double getComparison(ComparePlotType plot, double val1, double val2) {
        switch (plot.ordinal()) {
            case 0: {
                if (val1 == 0.0 && val2 == 0.0) {
                    return 1.0;
                }
                return val1 / val2;
            }
            case 1: {
                return val1 - val2;
            }
            case 2: {
                return Math.abs(val1 - val2);
            }
            case 3: {
                return (val1 - val2) / val2;
            }
        }
        throw new IllegalStateException("Unknown plot type: " + String.valueOf((Object)plot));
    }

    @Override
    public ParameterList getColorerParameters() {
        return this.params;
    }

    @Override
    public void setCPT(CPT origCPT) {
        if (this.polar == null) {
            super.setCPT(null);
            return;
        }
        if (origCPT != null) {
            double min = origCPT.getMinValue();
            double max = origCPT.getMaxValue();
            switch (this.plot.ordinal()) {
                case 0: {
                    if (min < 1.0) {
                        this.comp.ratioMin = min;
                    }
                    if (!(max > 1.0)) break;
                    this.comp.ratioMax = max;
                    break;
                }
                case 1: {
                    if (min < 0.0) {
                        this.comp.diffMin = min;
                    }
                    if (!(max > 0.0)) break;
                    this.comp.diffMax = max;
                    break;
                }
                case 2: {
                    if (!(max > 0.0)) break;
                    this.comp.absDiffMax = max;
                    if (min < 0.0) {
                        min = 0.0;
                    }
                    if (!(min < max)) break;
                    this.comp.absDiffMin = min;
                    break;
                }
                case 3: {
                    if (min < 0.0) {
                        this.comp.fractDiffMin = min;
                    }
                    if (!(max > 0.0)) break;
                    this.comp.fractDiffMax = max;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown plot type: " + String.valueOf((Object)this.plot));
                }
            }
        }
        CPT cpt = (CPT)this.polar.clone();
        switch (this.plot.ordinal()) {
            case 0: {
                ((CPTVal)cpt.get((int)0)).start = (float)this.comp.ratioMin;
                ((CPTVal)cpt.get((int)0)).end = 1.0f;
                ((CPTVal)cpt.get((int)1)).start = 1.0f;
                ((CPTVal)cpt.get((int)1)).end = (float)this.comp.ratioMax;
                break;
            }
            case 1: {
                ((CPTVal)cpt.get((int)0)).start = (float)this.comp.diffMin;
                ((CPTVal)cpt.get((int)1)).end = (float)this.comp.diffMax;
                break;
            }
            case 2: {
                cpt.remove(0);
                ((CPTVal)cpt.get((int)0)).start = (float)this.comp.absDiffMin;
                ((CPTVal)cpt.get((int)0)).end = (float)this.comp.absDiffMax;
                break;
            }
            case 3: {
                ((CPTVal)cpt.get((int)0)).start = (float)this.comp.fractDiffMin;
                ((CPTVal)cpt.get((int)0)).end = 0.0f;
                ((CPTVal)cpt.get((int)1)).start = 0.0f;
                ((CPTVal)cpt.get((int)1)).end = (float)this.comp.fractDiffMax;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown plot type: " + String.valueOf((Object)this.plot));
            }
        }
        this.setCPTLog(false);
        super.setCPT(cpt);
        this.fireColorerChangeEvent();
    }

    public void parameterChange(ParameterChangeEvent event) {
        if (event.getSource() == this.compareTypeParam) {
            this.comp = CompareType.forString((String)this.compareTypeParam.getValue());
            this.enableMinMax();
            this.valCache.clear();
        } else if (event.getSource() == this.plotTypeParam) {
            this.plot = ComparePlotType.forString((String)this.plotTypeParam.getValue());
        } else if (event.getSource() == this.comparisonFileParam) {
            FaultSystemSolution comp;
            this.setComparisonSolution(null);
            System.gc();
            try {
                File file = (File)this.comparisonFileParam.getValue();
                if (file != null) {
                    FaultSystemSolution newSol;
                    comp = newSol = FaultSystemSolution.load((File)file);
                    Preconditions.checkState((this.sol.getRupSet().getNumRuptures() == comp.getRupSet().getNumRuptures() ? 1 : 0) != 0, (Object)"Comparison has a different number of ruptures!");
                    this.builder.setDefaultDir(file.getParentFile());
                } else {
                    comp = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                UCERF3FaultSystemRupturesBuilder.showErrorMessage(e);
                this.comparisonFileParam.setValue(null);
                return;
            }
            this.setComparisonSolution(comp);
        } else if (event.getSource() == this.magMinParam) {
            this.min_patic_mag = (Double)this.magMinParam.getValue();
            this.valCache.clear();
        } else if (event.getSource() == this.magMaxParam) {
            this.max_patic_mag = (Double)this.magMaxParam.getValue();
            this.valCache.clear();
        }
        this.setCPT(null);
    }

    public FaultSystemSolution getCompFaultSystemSolution() {
        return this.comparisonSol;
    }

    public void setLoadDir(File defaultLoadDir) {
        ((FileParameterEditor)this.comparisonFileParam.getEditor()).setDefaultDir(defaultLoadDir);
    }

    public static enum CompareType {
        SOLUTION_SLIP_MISFIT("Sol. Slip vs Def Model Slip", 3.0, 0.005, false),
        SOLUTION_RATES_VS_PALEO_VISIBLE("Paleo Visible vs. Sol. Part. Rates", 3.0, 0.001, false),
        SOLUTION_PARTICIPATION_RATES_COMPARISON("Sol. Part. Rates vs Comparison Sol.", 3.0, 0.001, true),
        SOLUTION_SLIP_RATES_COMPARISON("Sol. Slip Rates vs Comparison Sol.", 3.0, 0.001, true);

        private String name;
        private double ratioMin;
        private double ratioMax;
        private double diffMin;
        private double diffMax;
        private double absDiffMin;
        private double absDiffMax;
        private double fractDiffMin;
        private double fractDiffMax;
        private boolean external;

        private CompareType(String name, double ratioMult, double diffDelta, boolean external) {
            this.name = name;
            this.ratioMin = 1.0 / ratioMult;
            this.ratioMax = 1.0 * ratioMult;
            this.diffMin = -diffDelta;
            this.diffMax = diffDelta;
            this.absDiffMin = 0.0;
            this.absDiffMax = diffDelta;
            this.fractDiffMin = -1.0;
            this.fractDiffMax = 1.0;
            this.external = external;
        }

        public String toString() {
            return this.name;
        }

        public static CompareType forString(String str) {
            for (CompareType type : CompareType.values()) {
                if (!type.toString().equals(str)) continue;
                return type;
            }
            throw new NoSuchElementException("Unknown CompareType: " + str);
        }
    }

    public static enum ComparePlotType {
        RATIOS("Ratio"),
        DIFFERENCE("Difference"),
        ABSOLUTE_DIFFERENCE("Abs. Difference"),
        FRACTIONAL_DIFFERENCE("Fractional Difference");

        private String name;

        private ComparePlotType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public static ComparePlotType forString(String str) {
            for (ComparePlotType type : ComparePlotType.values()) {
                if (!type.toString().equals(str)) continue;
                return type;
            }
            throw new NoSuchElementException("Unknown CompareType: " + str);
        }
    }
}

