/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.plugins.opensha.ucerf3Rups.colorers;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.constraint.impl.StringConstraint;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.impl.BooleanParameter;
import org.opensha.commons.param.impl.FileParameter;
import org.opensha.commons.param.impl.StringParameter;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.faultSurface.FaultTrace;
import org.scec.vtk.commons.opensha.faults.AbstractFaultSection;
import org.scec.vtk.commons.opensha.faults.colorers.CPTBasedColorer;
import org.scec.vtk.commons.opensha.faults.colorers.SlipRateColorer;
import org.scec.vtk.commons.opensha.faults.faultSectionImpl.PrefDataSection;
import scratch.UCERF3.analysis.CompoundFSSPlots;

public class CompoundMapPlotColorer
extends CPTBasedColorer
implements ParameterChangeListener {
    private FileParameter fileParam;
    private static final String PLOT_PARAM_DEFAULT = "(none)";
    private StringParameter plotParam;
    private BooleanParameter holdCPTParam;
    private ParameterList params = new ParameterList();
    private List<CompoundFSSPlots.MapPlotData> datas;
    private Map<Integer, List<LocationList>> faultsByTraceSize;
    private Map<LocationList, Double> valuesMap;

    public CompoundMapPlotColorer() {
        super(SlipRateColorer.getDefaultCPT(), false);
        this.fileParam = new FileParameter("Map Plot XML File");
        this.fileParam.addParameterChangeListener((ParameterChangeListener)this);
        this.params.addParameter((Parameter)this.fileParam);
        this.plotParam = new StringParameter("Plot", Lists.newArrayList((Object[])new String[]{PLOT_PARAM_DEFAULT}));
        this.plotParam.setValue((Object)PLOT_PARAM_DEFAULT);
        this.plotParam.addParameterChangeListener((ParameterChangeListener)this);
        this.params.addParameter((Parameter)this.plotParam);
        this.holdCPTParam = new BooleanParameter("Keep CPT on Load", Boolean.valueOf(false));
        this.params.addParameter((Parameter)this.holdCPTParam);
    }

    public String getName() {
        return "Compound Sol Map Plot Loader";
    }

    @Override
    public double getValue(AbstractFaultSection fault) {
        if (fault instanceof PrefDataSection && this.faultsByTraceSize != null) {
            FaultSection subSect = ((PrefDataSection)fault).getFaultSection();
            FaultTrace trace = subSect.getFaultTrace();
            List<LocationList> traces = this.faultsByTraceSize.get(trace.size());
            block0: for (LocationList oTrace : traces) {
                for (int i = 0; i < trace.size(); ++i) {
                    if (!((Location)oTrace.get(i)).equals(trace.get(i))) continue block0;
                }
                return this.valuesMap.get(oTrace);
            }
        }
        return Double.NaN;
    }

    @Override
    public ParameterList getColorerParameters() {
        return this.params;
    }

    public void parameterChange(ParameterChangeEvent event) {
        if (event.getParameter() == this.fileParam) {
            this.loadFile((File)this.fileParam.getValue());
        } else if (event.getParameter() == this.plotParam) {
            for (CompoundFSSPlots.MapPlotData data : this.datas) {
                if (!data.getFileName().equals(this.plotParam.getValue())) continue;
                this.setCurData(data);
                break;
            }
            this.fireColorerChangeEvent();
        }
    }

    private void loadFile(File file) {
        try {
            this.datas = CompoundFSSPlots.MapBasedPlot.loadPlotData((File)file);
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, e.getMessage(), "Error Loading File", 0);
            this.datas = null;
        }
        ArrayList strings = Lists.newArrayList();
        if (this.datas == null) {
            strings.add(PLOT_PARAM_DEFAULT);
            this.setCurData(null);
        } else {
            for (CompoundFSSPlots.MapPlotData data : this.datas) {
                strings.add(data.getFileName());
            }
            this.setCurData(this.datas.get(0));
        }
        this.plotParam.removeParameterChangeListener((ParameterChangeListener)this);
        ((StringConstraint)this.plotParam.getConstraint()).setStrings(strings);
        this.plotParam.setValue((Object)((String)strings.get(0)));
        this.plotParam.getEditor().refreshParamEditor();
        this.plotParam.addParameterChangeListener((ParameterChangeListener)this);
        this.fireColorerChangeEvent();
    }

    private void setCurData(CompoundFSSPlots.MapPlotData data) {
        this.faultsByTraceSize = Maps.newHashMap();
        this.valuesMap = Maps.newHashMap();
        if (data == null) {
            return;
        }
        if (data.getFaults() == null) {
            return;
        }
        for (int i = 0; i < data.getFaults().size(); ++i) {
            LocationList trace = (LocationList)data.getFaults().get(i);
            double value = data.getFaultValues()[i];
            Integer numLocs = trace.size();
            ArrayList tracesForSize = this.faultsByTraceSize.get(numLocs);
            if (tracesForSize == null) {
                tracesForSize = Lists.newArrayList();
                this.faultsByTraceSize.put(numLocs, tracesForSize);
            }
            tracesForSize.add(trace);
            this.valuesMap.put(trace, value);
        }
        if (!((Boolean)this.holdCPTParam.getValue()).booleanValue()) {
            this.setCPT(data.getCPT());
        }
    }
}

