/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.plugins.opensha.ucerf3Rups.colorers;

import java.awt.Color;
import java.io.IOException;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.opensha.commons.mapping.gmt.elements.GMT_CPT_Files;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.impl.EnumParameter;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.commons.util.cpt.CPT;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.impl.PaleoProbabilityModel;
import org.opensha.sha.faultSurface.FaultSection;
import org.scec.vtk.commons.opensha.faults.AbstractFaultSection;
import org.scec.vtk.commons.opensha.faults.colorers.CPTBasedColorer;
import org.scec.vtk.commons.opensha.faults.faultSectionImpl.PrefDataSection;
import org.scec.vtk.plugins.opensha.ucerf3Rups.UCERF3RupSetChangeListener;
import scratch.UCERF3.utils.LastEventData;
import scratch.UCERF3.utils.paleoRateConstraints.UCERF3_PaleoProbabilityModel;

public class DateLastEventColorer
extends CPTBasedColorer
implements UCERF3RupSetChangeListener,
ParameterChangeListener {
    private FaultSystemRupSet rupSet;
    private FaultSystemSolution sol;
    private Map<Integer, List<LastEventData>> data;
    private boolean populated = false;
    private PaleoProbabilityModel paleoProbModel;
    private static final double YEARS_PER_MILLI = 3.168878188728042E-11;
    private CPT intervalCPT = this.getCPT();
    private CPT ratioCPT = DateLastEventColorer.createRatioCPT();
    private EnumParameter<PlotType> plotTypeParam = new EnumParameter("Plot Type", EnumSet.allOf(PlotType.class), (Enum)PlotType.INTERVAL, null);
    private ParameterList params;

    private static CPT createIntervalCPT() {
        try {
            CPT cpt = GMT_CPT_Files.MAX_SPECTRUM.instance();
            cpt = cpt.rescale(0.0, Math.log10(15000.0));
            cpt.setNanColor(Color.GRAY);
            return cpt;
        }
        catch (IOException e) {
            throw ExceptionUtils.asRuntimeException((Throwable)e);
        }
    }

    private static CPT createRatioCPT() {
        try {
            CPT cpt = GMT_CPT_Files.GMT_POLAR.instance();
            cpt = cpt.rescale(-1.0, 1.0);
            cpt.setNanColor(Color.GRAY);
            return cpt;
        }
        catch (IOException e) {
            throw ExceptionUtils.asRuntimeException((Throwable)e);
        }
    }

    public DateLastEventColorer() {
        super(DateLastEventColorer.createIntervalCPT(), true);
        this.plotTypeParam.addParameterChangeListener((ParameterChangeListener)this);
        this.params = new ParameterList();
        this.params.addParameter(this.plotTypeParam);
    }

    public String getName() {
        return "Open Interval (years)";
    }

    @Override
    public synchronized double getValue(AbstractFaultSection fault) {
        if (this.rupSet == null || !(fault instanceof PrefDataSection)) {
            return Double.NaN;
        }
        if (!this.populated) {
            if (this.data == null) {
                try {
                    System.out.println("Loading data...");
                    this.data = LastEventData.load();
                }
                catch (IOException e) {
                    ExceptionUtils.throwAsRuntimeException((Throwable)e);
                }
            }
            System.out.println("Populating subsects with data...");
            LastEventData.populateSubSects((List)this.rupSet.getFaultSectionDataList(), this.data);
            this.populated = true;
        }
        FaultSection sect = ((PrefDataSection)fault).getFaultSection();
        long curTime = System.currentTimeMillis();
        long eventTime = sect.getDateOfLastEvent();
        if (eventTime == Long.MIN_VALUE) {
            return Double.NaN;
        }
        long timeDiffMillis = curTime - eventTime;
        double diffYears = 3.168878188728042E-11 * (double)timeDiffMillis;
        switch (((PlotType)((Object)this.plotTypeParam.getValue())).ordinal()) {
            case 0: {
                return diffYears;
            }
            case 1: {
                if (this.sol == null) {
                    return Double.NaN;
                }
                if (this.paleoProbModel == null) {
                    try {
                        this.paleoProbModel = UCERF3_PaleoProbabilityModel.load();
                    }
                    catch (IOException e) {
                        ExceptionUtils.throwAsRuntimeException((Throwable)e);
                    }
                }
                double paleoRate = this.sol.calcTotPaleoVisibleRateForSect(sect.getSectionId(), this.paleoProbModel);
                double paleoRI = 1.0 / paleoRate;
                return diffYears / paleoRI;
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public void setRupSet(FaultSystemRupSet rupSet, FaultSystemSolution sol) {
        this.rupSet = rupSet;
        this.sol = sol;
        this.populated = false;
    }

    public void parameterChange(ParameterChangeEvent event) {
        if (event.getParameter() == this.plotTypeParam) {
            switch (((PlotType)((Object)this.plotTypeParam.getValue())).ordinal()) {
                case 0: {
                    this.setCPT(this.intervalCPT, true);
                    break;
                }
                case 1: {
                    this.setCPT(this.ratioCPT, true);
                    break;
                }
            }
            this.fireColorerChangeEvent();
        }
    }

    @Override
    public ParameterList getColorerParameters() {
        return this.params;
    }

    static enum PlotType {
        INTERVAL("Open Interval (years)"),
        RATIO("Open Interval/Paleo Obs Recurr");

        private String name;

        private PlotType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

