/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.plugins.opensha.ucerf3Rups.colorers;

import com.google.common.base.Preconditions;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.opensha.commons.data.region.CaliforniaRegions;
import org.opensha.commons.data.xyz.GriddedGeoDataSet;
import org.opensha.commons.geo.GriddedRegion;
import org.opensha.commons.geo.Location;
import org.opensha.commons.mapping.gmt.elements.GMT_CPT_Files;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.impl.BooleanParameter;
import org.opensha.commons.param.impl.DoubleParameter;
import org.opensha.commons.param.impl.EnumParameter;
import org.opensha.commons.param.impl.FileParameter;
import org.opensha.commons.param.impl.IntegerParameter;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.commons.util.cpt.CPT;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.param.BPTAveragingTypeOptions;
import org.opensha.sha.earthquake.param.IncludeBackgroundOption;
import org.opensha.sha.earthquake.param.ProbabilityModelOptions;
import org.opensha.sha.faultSurface.FaultSection;
import org.scec.vtk.commons.opensha.faults.AbstractFaultSection;
import org.scec.vtk.commons.opensha.faults.colorers.CPTBasedColorer;
import org.scec.vtk.main.MainGUI;
import org.scec.vtk.plugins.PluginActors;
import org.scec.vtk.plugins.opensha.ucerf3Rups.UCERF3RupSetChangeListener;
import org.scec.vtk.plugins.opensha.ucerf3Rups.anims.ETASCatalogAnim;
import org.scec.vtk.plugins.opensha.ucerf3Rups.colorers.ParticipationRateColorer;
import scratch.UCERF3.analysis.FaultSysSolutionERF_Calc;
import scratch.UCERF3.erf.ETAS.ETAS_CatalogIO;
import scratch.UCERF3.erf.ETAS.ETAS_EqkRupture;
import scratch.UCERF3.erf.ETAS.ETAS_SimAnalysisTools;
import scratch.UCERF3.erf.FaultSystemSolutionERF;
import scratch.UCERF3.utils.LastEventData;
import vtk.vtkActor;
import vtk.vtkProp;

public class ETASMultiCatalogColorer
extends CPTBasedColorer
implements ParameterChangeListener,
UCERF3RupSetChangeListener {
    private FileParameter catalogFileParam;
    private EnumParameter<DisplayType> displayTypeParam;
    private DoubleParameter minMagParam;
    private DoubleParameter maxDaysParam;
    private IntegerParameter descendantsOfParam;
    private IntegerParameter scenIndexParam;
    private BooleanParameter displayBoxesParam;
    private BooleanParameter hideNansParam;
    private DoubleParameter opacityParam;
    private ParameterList params;
    private List<ETAS_CatalogIO.ETAS_Catalog> catalogs;
    private FaultSystemRupSet rupSet;
    private FaultSystemSolution sol;
    private Map<Integer, List<LastEventData>> lastEventData;
    private FaultSystemSolutionERF erf;
    private Map<Integer, Double> etasFaultRatesMap;
    private double[] timeIndepFaultRates;
    private double[] timeDepFaultRates;
    private HashSet<ETAS_EqkRupture> faultRups;
    private vtkActor boxActor;
    private PluginActors actors;
    private CPT rateCPT;
    private boolean rateCPTLog = true;
    private CPT gainCPT;
    private boolean gainCPTLog = true;

    private static CPT getDefaultCPT() {
        CPT cpt;
        try {
            cpt = GMT_CPT_Files.MAX_SPECTRUM.instance();
        }
        catch (IOException e) {
            throw ExceptionUtils.asRuntimeException((Throwable)e);
        }
        cpt = cpt.rescale(-3.0, 2.0);
        return cpt;
    }

    private static CPT getDefaultGainCPT() {
        CPT cpt;
        try {
            cpt = GMT_CPT_Files.GMT_POLAR.instance();
        }
        catch (IOException e) {
            throw ExceptionUtils.asRuntimeException((Throwable)e);
        }
        cpt = cpt.rescale(-1.0, 1.0);
        return cpt;
    }

    public ETASMultiCatalogColorer(PluginActors actors) {
        super(ETASMultiCatalogColorer.getDefaultCPT(), true);
        this.actors = actors;
        this.params = new ParameterList();
        this.catalogFileParam = new FileParameter("Catalogs Binary/Zip File");
        this.catalogFileParam.addParameterChangeListener((ParameterChangeListener)this);
        this.params.addParameter((Parameter)this.catalogFileParam);
        File defaultInitialDir = new File("/home/kevin/OpenSHA/UCERF3/etas/simulations");
        if (defaultInitialDir.exists()) {
            this.catalogFileParam.setDefaultInitialDir(defaultInitialDir);
        }
        this.displayTypeParam = new EnumParameter("Display Type", EnumSet.allOf(DisplayType.class), (Enum)DisplayType.ETAS_ALL, null);
        this.displayTypeParam.addParameterChangeListener((ParameterChangeListener)this);
        this.params.addParameter(this.displayTypeParam);
        this.minMagParam = new DoubleParameter("Min Mag", 0.0, 10.0, Double.valueOf(0.0));
        this.minMagParam.addParameterChangeListener((ParameterChangeListener)this);
        this.params.addParameter((Parameter)this.minMagParam);
        this.maxDaysParam = new DoubleParameter("Max Days After", 0.0, 36525.0, Double.valueOf(365.25));
        this.maxDaysParam.addParameterChangeListener((ParameterChangeListener)this);
        this.params.addParameter((Parameter)this.maxDaysParam);
        this.descendantsOfParam = new IntegerParameter("Only Descendants Of", -1, Integer.MAX_VALUE, Integer.valueOf(-1));
        this.descendantsOfParam.addParameterChangeListener((ParameterChangeListener)this);
        this.params.addParameter((Parameter)this.descendantsOfParam);
        this.scenIndexParam = new IntegerParameter("Scenario FSS Index", -1, Integer.MAX_VALUE, Integer.valueOf(-1));
        this.scenIndexParam.addParameterChangeListener((ParameterChangeListener)this);
        this.params.addParameter((Parameter)this.scenIndexParam);
        this.displayBoxesParam = new BooleanParameter("Display Boxes");
        this.displayBoxesParam.addParameterChangeListener((ParameterChangeListener)this);
        this.params.addParameter((Parameter)this.displayBoxesParam);
        this.hideNansParam = new BooleanParameter("Hide NaNs");
        this.hideNansParam.setValue((Object)true);
        this.hideNansParam.addParameterChangeListener((ParameterChangeListener)this);
        this.params.addParameter((Parameter)this.hideNansParam);
        this.opacityParam = new DoubleParameter("Gridded Data Opacity", 0.0, 1.0);
        this.opacityParam.setDefaultValue((Object)0.7);
        this.opacityParam.setValue((Object)((Double)this.opacityParam.getDefaultValue()));
        this.opacityParam.addParameterChangeListener((ParameterChangeListener)this);
        this.params.addParameter((Parameter)this.opacityParam);
    }

    public String getName() {
        return "ETAS Multi-Catalog Density";
    }

    @Override
    public double getValue(AbstractFaultSection fault) {
        if (this.etasFaultRatesMap != null) {
            Double val;
            switch (((DisplayType)((Object)this.displayTypeParam.getValue())).ordinal()) {
                case 0: {
                    val = this.etasFaultRatesMap.get(fault.getId());
                    break;
                }
                case 1: {
                    if (this.timeIndepFaultRates == null) {
                        val = Double.NaN;
                        break;
                    }
                    val = this.timeIndepFaultRates[fault.getId()];
                    break;
                }
                case 2: {
                    if (this.timeDepFaultRates == null) {
                        val = Double.NaN;
                        break;
                    }
                    val = this.timeDepFaultRates[fault.getId()];
                    break;
                }
                case 3: {
                    if (this.timeIndepFaultRates == null || this.timeDepFaultRates == null) {
                        val = Double.NaN;
                        break;
                    }
                    val = this.timeDepFaultRates[fault.getId()] / this.timeIndepFaultRates[fault.getId()];
                    break;
                }
                case 4: {
                    Double etasVal = this.etasFaultRatesMap.get(fault.getId());
                    if (this.timeDepFaultRates == null || etasVal == null) {
                        val = Double.NaN;
                        break;
                    }
                    val = (this.timeDepFaultRates[fault.getId()] + etasVal) / this.timeDepFaultRates[fault.getId()];
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown display type: " + String.valueOf(this.displayTypeParam.getValue()));
                }
            }
            if (val != null) {
                return val;
            }
        }
        return Double.NaN;
    }

    @Override
    public Color getColorForValue(double value) {
        if (((Boolean)this.hideNansParam.getValue()).booleanValue() && Double.isNaN(value)) {
            return null;
        }
        return super.getColorForValue(value);
    }

    @Override
    public ParameterList getColorerParameters() {
        return this.params;
    }

    private void loadCatalogs() {
        this.catalogs = null;
        File file = (File)this.catalogFileParam.getValue();
        Preconditions.checkState((boolean)file.exists(), (Object)"File doesn't exist");
        try {
            this.catalogs = ETAS_CatalogIO.loadCatalogs((File)file);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        this.loadFaultAssociations();
        this.clearUCERF3();
        this.updateUCERF3();
        this.fireColorerChangeEvent();
    }

    @Override
    protected void fireColorerChangeEvent() {
        super.fireColorerChangeEvent();
        this.clearBoxes();
        if (((Boolean)this.displayBoxesParam.getValue()).booleanValue()) {
            this.displayBoxes();
        }
    }

    private long getMaxOccurTime() {
        double maxDays = (Double)this.maxDaysParam.getValue();
        List<Object> catalog = null;
        if (this.catalogs == null) {
            catalog = new ArrayList<ETAS_EqkRupture>();
        } else {
            for (List list : this.catalogs) {
                if (list.isEmpty()) continue;
                catalog = list;
                break;
            }
            if (catalog == null) {
                catalog = new ArrayList();
            }
        }
        long ot = ETASCatalogAnim.detectScenarioOT(catalog);
        return ot + (long)(maxDays * 8.64E7);
    }

    /*
     * WARNING - void declaration
     */
    private void loadFaultAssociations() {
        this.etasFaultRatesMap = null;
        this.faultRups = null;
        if (this.catalogs == null || this.catalogs.isEmpty() || this.rupSet == null) {
            return;
        }
        double fractRate = 1.0 / (double)this.catalogs.size();
        double minMag = (Double)this.minMagParam.getValue();
        long maxTime = this.getMaxOccurTime();
        this.etasFaultRatesMap = new HashMap<Integer, Double>();
        this.faultRups = new HashSet();
        int descendantsOf = (Integer)this.descendantsOfParam.getValue();
        block0: for (List list : this.catalogs) {
            void var9_6;
            if (descendantsOf >= 0) {
                ETAS_CatalogIO.ETAS_Catalog eTAS_Catalog = ETAS_SimAnalysisTools.getChildrenFromCatalog((List)list, (int[])new int[]{descendantsOf});
            }
            for (ETAS_EqkRupture rup : var9_6) {
                if (rup.getMag() < minMag) continue;
                if (rup.getOriginTime() > maxTime) continue block0;
                if (rup.getFSSIndex() < 0) continue;
                Iterator iterator = this.rupSet.getSectionsIndicesForRup(rup.getFSSIndex()).iterator();
                while (iterator.hasNext()) {
                    int id = (Integer)iterator.next();
                    Double val = this.etasFaultRatesMap.get(id);
                    if (val == null) {
                        val = 0.0;
                    }
                    val = val + fractRate;
                    this.etasFaultRatesMap.put(id, val);
                }
                this.faultRups.add(rup);
            }
        }
        System.out.println("Loaded " + this.faultRups.size() + " fault rups on " + this.etasFaultRatesMap.size() + " sections");
    }

    private void clearUCERF3() {
        this.timeIndepFaultRates = null;
        this.timeDepFaultRates = null;
    }

    private void updateUCERF3() {
        DisplayType display = (DisplayType)((Object)this.displayTypeParam.getValue());
        if (this.timeIndepFaultRates == null && display.usesTimeIndep()) {
            this.calcUCERF3Probs(false);
        }
        if (this.timeDepFaultRates == null && display.usesTimeDep()) {
            this.calcUCERF3Probs(true);
        }
    }

    private synchronized void calcUCERF3Probs(boolean timeDep) {
        int index = (Integer)this.scenIndexParam.getValue();
        if (timeDep) {
            this.timeDepFaultRates = null;
        } else {
            this.timeIndepFaultRates = null;
        }
        if (this.sol == null || this.etasFaultRatesMap == null) {
            return;
        }
        System.out.println("Calculating UCERF3 Probabilities! timeDep=" + timeDep);
        List<Object> catalog = null;
        if (this.catalogs == null) {
            catalog = new ArrayList<ETAS_EqkRupture>();
        } else {
            for (List list : this.catalogs) {
                if (list.isEmpty()) continue;
                catalog = list;
                break;
            }
            if (catalog == null) {
                catalog = new ArrayList();
            }
        }
        int startYear = ETASCatalogAnim.detectScenarioYear(catalog);
        double d = (Double)this.maxDaysParam.getValue() / 365.25;
        if (this.erf == null) {
            this.erf = new FaultSystemSolutionERF(this.sol);
            this.erf.setParameter("Background Seismicity", (Object)IncludeBackgroundOption.EXCLUDE);
            this.erf.setParameter("Apply Aftershock Filter", (Object)false);
            this.erf.setParameter("Probability Model", (Object)ProbabilityModelOptions.U3_PREF_BLEND);
            BPTAveragingTypeOptions aveType = BPTAveragingTypeOptions.AVE_RI_AVE_NORM_TIME_SINCE;
            this.erf.setParameter("BPT Averaging Type", (Object)aveType);
            this.erf.setParameter("Historic Open Interval", (Object)((double)startYear - 1875.0));
            this.erf.setParameter("Aleatory Mag-Area StdDev", (Object)0.0);
        }
        if (timeDep) {
            this.erf.setParameter("Probability Model", (Object)ProbabilityModelOptions.U3_PREF_BLEND);
            this.erf.getTimeSpan().setStartTime(startYear);
            if (this.lastEventData == null) {
                try {
                    this.lastEventData = LastEventData.load();
                }
                catch (IOException e) {
                    ExceptionUtils.throwAsRuntimeException((Throwable)e);
                }
            }
            for (FaultSection sect : this.rupSet.getFaultSectionDataList()) {
                sect.setDateOfLastEvent(Long.MIN_VALUE);
            }
            LastEventData.populateSubSects((List)this.rupSet.getFaultSectionDataList(), this.lastEventData);
            if (index >= 0) {
                long ot = this.erf.getTimeSpan().getStartTimeInMillis() - 1L;
                this.erf.setFltSystemSourceOccurranceTimeForFSSIndex(index, Long.valueOf(ot));
            }
        } else {
            this.erf.setParameter("Probability Model", (Object)ProbabilityModelOptions.POISSON);
        }
        this.erf.getTimeSpan().setDuration(d);
        this.erf.updateForecast();
        if (timeDep) {
            Preconditions.checkState((this.erf.getTimeSpan().getStartTimeYear() == startYear ? 1 : 0) != 0);
        }
        double[] erfParticRates = FaultSysSolutionERF_Calc.calcParticipationRateForAllSects((FaultSystemSolutionERF)this.erf, (double)((Double)this.minMagParam.getValue()));
        if (d != 1.0) {
            int i = 0;
            while (i < erfParticRates.length) {
                int n = i++;
                erfParticRates[n] = erfParticRates[n] * d;
            }
        }
        if (timeDep) {
            this.timeDepFaultRates = erfParticRates;
        } else {
            this.timeIndepFaultRates = erfParticRates;
        }
    }

    public void parameterChange(ParameterChangeEvent event) {
        if (event.getParameter() == this.catalogFileParam) {
            this.loadCatalogs();
        } else if (event.getParameter() == this.minMagParam || event.getParameter() == this.maxDaysParam) {
            this.clearUCERF3();
            this.updateUCERF3();
            if (this.catalogs != null) {
                this.loadFaultAssociations();
            }
            this.fireColorerChangeEvent();
        } else if (event.getParameter() == this.displayBoxesParam || event.getParameter() == this.opacityParam) {
            this.clearBoxes();
            if (((Boolean)this.displayBoxesParam.getValue()).booleanValue()) {
                this.displayBoxes();
            }
        } else if (event.getParameter() == this.hideNansParam) {
            if (this.catalogs != null) {
                this.fireColorerChangeEvent();
            }
        } else if (event.getParameter() == this.descendantsOfParam) {
            if (this.catalogs != null) {
                this.loadFaultAssociations();
                if (((DisplayType)((Object)this.displayTypeParam.getValue())).usesETAS()) {
                    this.fireColorerChangeEvent();
                }
            }
        } else if (event.getParameter() == this.scenIndexParam) {
            this.erf = null;
            this.timeDepFaultRates = null;
            this.updateUCERF3();
            if (((DisplayType)((Object)this.displayTypeParam.getValue())).usesTimeDep()) {
                this.fireColorerChangeEvent();
            }
        } else if (event.getParameter() == this.displayTypeParam) {
            DisplayType display = (DisplayType)((Object)this.displayTypeParam.getValue());
            this.updateUCERF3();
            DisplayType prevDisplay = (DisplayType)((Object)event.getOldValue());
            if (display.isGain() && !prevDisplay.isGain()) {
                this.rateCPT = this.getCPT();
                this.rateCPTLog = this.isCPTLog();
                if (this.gainCPT == null) {
                    this.gainCPT = ETASMultiCatalogColorer.getDefaultGainCPT();
                }
                this.setCPT(this.gainCPT, this.gainCPTLog);
            } else if (!display.isGain() && prevDisplay.isGain()) {
                this.gainCPT = this.getCPT();
                this.gainCPTLog = this.isCPTLog();
                if (this.rateCPT == null) {
                    this.rateCPT = ETASMultiCatalogColorer.getDefaultCPT();
                }
                this.setCPT(this.rateCPT, this.rateCPTLog);
            }
            this.fireColorerChangeEvent();
        }
    }

    @Override
    public void setRupSet(FaultSystemRupSet rupSet, FaultSystemSolution sol) {
        this.rupSet = rupSet;
        this.sol = sol;
        this.clearUCERF3();
        this.updateUCERF3();
        if (this.catalogs != null) {
            this.loadFaultAssociations();
            this.fireColorerChangeEvent();
        }
    }

    private void clearBoxes() {
        if (this.boxActor != null) {
            this.actors.removeActor((vtkProp)this.boxActor);
            this.boxActor = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void displayBoxes() {
        void var11_13;
        this.clearBoxes();
        if (this.catalogs == null || this.catalogs.isEmpty()) {
            return;
        }
        double minMag = (Double)this.minMagParam.getValue();
        long maxTime = this.getMaxOccurTime();
        double fractRate = 1.0 / (double)this.catalogs.size();
        CaliforniaRegions.RELM_TESTING_GRIDDED reg = new CaliforniaRegions.RELM_TESTING_GRIDDED();
        GriddedGeoDataSet xyz = new GriddedGeoDataSet((GriddedRegion)reg, false);
        int descendantsOf = (Integer)this.descendantsOfParam.getValue();
        block0: for (List list : this.catalogs) {
            void var11_9;
            if (descendantsOf >= 0) {
                ETAS_CatalogIO.ETAS_Catalog eTAS_Catalog = ETAS_SimAnalysisTools.getChildrenFromCatalog((List)list, (int[])new int[]{descendantsOf});
            }
            for (ETAS_EqkRupture rup : var11_9) {
                if (this.faultRups.contains(rup) || rup.getMag() < minMag) continue;
                if (rup.getOriginTime() > maxTime) continue block0;
                Location loc = rup.getHypocenterLocation();
                int index = reg.indexForLocation(loc);
                if (index < 0) continue;
                xyz.set(index, xyz.get(index) + fractRate);
            }
        }
        boolean hideNans = (Boolean)this.hideNansParam.getValue();
        boolean bl = false;
        while (var11_13 < xyz.size() && hideNans) {
            if (xyz.get((int)var11_13) == 0.0) {
                xyz.set((int)var11_13, Double.NaN);
            }
            ++var11_13;
        }
        this.boxActor = ParticipationRateColorer.buildActorForGriddedData(xyz, this.isCPTLog(), this.getCPT(), 0.0, hideNans, 0.7);
        this.actors.addActor((vtkProp)this.boxActor);
        MainGUI.updateRenderWindow();
    }

    private static enum DisplayType {
        ETAS_ALL("ETAS All"),
        UCERF3_TI("UCERF3-TI"),
        UCERF3_TD("UCERF3-TD"),
        UCERF3_TD_GAIN("UCERF3-TD/TI Gain"),
        ETAS_GAIN("ETAS/UCERF3-TD Gain");

        private String name;

        private DisplayType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public boolean usesETAS() {
            return this == ETAS_ALL || this == ETAS_GAIN;
        }

        public boolean usesTimeIndep() {
            return this == UCERF3_TI || this == UCERF3_TD_GAIN;
        }

        public boolean usesTimeDep() {
            return this == UCERF3_TD || this == UCERF3_TD_GAIN || this == ETAS_GAIN;
        }

        public boolean isGain() {
            return this == ETAS_GAIN || this == UCERF3_TD_GAIN;
        }
    }
}

