/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.plugins.opensha.ucerf3Rups.colorers;

import com.google.common.base.Preconditions;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import org.apache.commons.math3.stat.StatUtils;
import org.opensha.commons.data.CSVFile;
import org.opensha.commons.mapping.gmt.elements.GMT_CPT_Files;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.constraint.impl.StringConstraint;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.impl.ButtonParameter;
import org.opensha.commons.param.impl.FileParameter;
import org.opensha.commons.param.impl.StringParameter;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.commons.util.cpt.CPT;
import org.scec.vtk.commons.opensha.faults.AbstractFaultSection;
import org.scec.vtk.commons.opensha.faults.colorers.CPTBasedColorer;

public class EternalDatasetColorer
extends CPTBasedColorer
implements ParameterChangeListener {
    private FileParameter browseParam;
    private StringParameter columnParam;
    private ButtonParameter rescaleParam;
    private ParameterList params = new ParameterList();
    private double[] curScalars;
    private CSVFile<String> csv;

    private static CPT getDefaultCPT() {
        try {
            CPT cpt = GMT_CPT_Files.MAX_SPECTRUM.instance();
            cpt.setNanColor(Color.GRAY);
            return cpt.rescale(0.0, 1.0);
        }
        catch (IOException e) {
            throw ExceptionUtils.asRuntimeException((Throwable)e);
        }
    }

    public EternalDatasetColorer() {
        super(EternalDatasetColorer.getDefaultCPT(), false);
        this.browseParam = new FileParameter("Load CSV File");
        this.browseParam.setInfo("CSV file should have 1 row for each subsection, plus a header row. Multiple data columns are allowed and will be user selectable. Values must be numerical.");
        this.browseParam.addParameterChangeListener((ParameterChangeListener)this);
        this.params.addParameter((Parameter)this.browseParam);
        this.rescaleParam = new ButtonParameter("CPT Range", "Rescale From Data");
        this.rescaleParam.addParameterChangeListener((ParameterChangeListener)this);
        this.params.addParameter((Parameter)this.rescaleParam);
        ArrayList<String> strings = new ArrayList<String>();
        strings.add("(none)");
        this.columnParam = new StringParameter("CSV Column", strings);
        this.columnParam.addParameterChangeListener((ParameterChangeListener)this);
        this.columnParam.setValue((Object)((String)strings.get(0)));
        this.params.addParameter((Parameter)this.columnParam);
    }

    public String getName() {
        return "External Dataset Colorer";
    }

    @Override
    public double getValue(AbstractFaultSection fault) {
        int id = fault.getId();
        if (this.curScalars != null && id < this.curScalars.length) {
            return this.curScalars[id];
        }
        return Double.NaN;
    }

    public void parameterChange(ParameterChangeEvent event) {
        if (event.getParameter() == this.browseParam) {
            this.loadFile((File)this.browseParam.getValue());
            this.fireColorerChangeEvent();
        } else if (event.getParameter() == this.columnParam) {
            this.updateScalars();
            this.fireColorerChangeEvent();
        } else if (event.getParameter() == this.rescaleParam && this.curScalars != null) {
            double max = StatUtils.max((double[])this.curScalars);
            if (this.isCPTLog()) {
                double minNonZero = Double.POSITIVE_INFINITY;
                for (double val : this.curScalars) {
                    if (!(val > 0.0)) continue;
                    minNonZero = Math.min(val, minNonZero);
                }
                double logMin = Math.floor(Math.log10(minNonZero));
                double logMax = Math.ceil(Math.log10(max));
                this.setCPT(this.getCPT().rescale(logMin, logMax), true);
            } else {
                double min = StatUtils.min((double[])this.curScalars);
                if (min == max) {
                    max += 1.0;
                }
                this.setCPT(this.getCPT().rescale(min, max), false);
            }
            this.fireColorerChangeEvent();
        }
    }

    private void loadFile(File file) {
        this.csv = null;
        this.curScalars = null;
        if (file != null) {
            try {
                this.csv = CSVFile.readFile((File)file, (boolean)true);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, e.getMessage(), "Error loading CSV", 0);
                return;
            }
            ArrayList headers = new ArrayList(this.csv.getLine(0));
            this.columnParam.removeParameterChangeListener((ParameterChangeListener)this);
            ((StringConstraint)this.columnParam.getConstraint()).setStrings(headers);
            this.columnParam.setValue((Object)((String)headers.get(0)));
            this.columnParam.getEditor().refreshParamEditor();
            this.columnParam.addParameterChangeListener((ParameterChangeListener)this);
            this.updateScalars();
        }
    }

    private void updateScalars() {
        this.curScalars = null;
        if (this.csv != null) {
            String header = (String)this.columnParam.getValue();
            int col = this.csv.getLine(0).indexOf(header);
            System.out.println("Loading scalars from column " + col);
            Preconditions.checkState((col >= 0 ? 1 : 0) != 0);
            this.curScalars = new double[this.csv.getNumRows() - 1];
            for (int row = 1; row < this.csv.getNumRows(); ++row) {
                try {
                    this.curScalars[row - 1] = this.csv.getDouble(row, col);
                    continue;
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(null, e.getMessage(), "Error reading CSV data", 0);
                    this.csv = null;
                    this.curScalars = null;
                    break;
                }
            }
            System.out.println("Loaded " + this.curScalars.length + " scalars");
        }
    }

    @Override
    public ParameterList getColorerParameters() {
        return this.params;
    }
}

