/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.plugins.opensha.ucerf3Rups.colorers;

import java.util.EnumSet;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.impl.EnumParameter;
import org.opensha.commons.util.cpt.CPT;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.faultSysSolution.modules.AveSlipModule;
import org.opensha.sha.earthquake.faultSysSolution.modules.SlipAlongRuptureModel;
import org.opensha.sha.faultSurface.FaultSection;
import org.scec.vtk.commons.opensha.faults.AbstractFaultSection;
import org.scec.vtk.commons.opensha.faults.colorers.CPTBasedColorer;
import org.scec.vtk.commons.opensha.faults.colorers.SlipRateColorer;
import org.scec.vtk.commons.opensha.faults.faultSectionImpl.PrefDataSection;
import org.scec.vtk.plugins.opensha.ucerf3Rups.UCERF3RupSetChangeListener;
import scratch.UCERF3.U3AverageFaultSystemSolution;

public class InversionSlipRateColorer
extends CPTBasedColorer
implements UCERF3RupSetChangeListener,
ParameterChangeListener {
    private static final long serialVersionUID = 1L;
    private FaultSystemRupSet rupSet;
    private FaultSystemSolution sol;
    private static final String TYPE_PARAM_NAME = "Slip Rate To Plot";
    private EnumParameter<SlipRateTypes> typeParam = new EnumParameter("Slip Rate To Plot", EnumSet.allOf(SlipRateTypes.class), (Enum)SlipRateTypes.ORIGINAL, null);
    private ParameterList params;
    private static final String NAME = "Slip Rate (mm/yr)";

    public InversionSlipRateColorer() {
        this(SlipRateColorer.getDefaultCPT(), false);
    }

    public InversionSlipRateColorer(CPT cpt, boolean cptLog) {
        super(cpt, cptLog);
        this.typeParam.addParameterChangeListener((ParameterChangeListener)this);
        this.params = new ParameterList();
        this.params.addParameter(this.typeParam);
    }

    @Override
    public double getValue(AbstractFaultSection fault) {
        if (fault instanceof PrefDataSection) {
            PrefDataSection prefFault = (PrefDataSection)fault;
            FaultSection pref = prefFault.getFaultSection();
            switch (((SlipRateTypes)((Object)this.typeParam.getValue())).ordinal()) {
                case 0: {
                    return pref.getOrigAveSlipRate();
                }
                case 1: {
                    return pref.getReducedAveSlipRate();
                }
                case 2: {
                    if (this.rupSet != null) {
                        return this.rupSet.getSlipRateForSection(pref.getSectionId()) * 1000.0;
                    }
                }
                case 3: {
                    if (this.sol != null && this.rupSet.hasModule(SlipAlongRuptureModel.class) && this.rupSet.hasModule(AveSlipModule.class)) {
                        return ((SlipAlongRuptureModel)this.rupSet.getModule(SlipAlongRuptureModel.class)).calcSlipRateForSect(this.sol, (AveSlipModule)this.rupSet.getModule(AveSlipModule.class), pref.getSectionId()) * 1000.0;
                    }
                }
                case 4: {
                    if (this.sol == null || !(this.sol instanceof U3AverageFaultSystemSolution)) break;
                    return ((U3AverageFaultSystemSolution)this.sol).getRupSet().getSlipRateStdDevForSection(pref.getSectionId()) * 1000.0;
                }
            }
        }
        return Double.NaN;
    }

    public String getName() {
        return NAME;
    }

    @Override
    public void setRupSet(FaultSystemRupSet rupSet, FaultSystemSolution sol) {
        this.rupSet = rupSet;
        this.sol = sol;
    }

    public void parameterChange(ParameterChangeEvent event) {
        if (event.getParameter() == this.typeParam) {
            this.fireColorerChangeEvent();
        }
    }

    @Override
    public ParameterList getColorerParameters() {
        return this.params;
    }

    private static enum SlipRateTypes {
        ORIGINAL("Original Non Reduced"),
        CREEP_REDUCED("Creep Reduced"),
        SUBSEISMOGENIC_REDUCED("Subseismogenic & Creep Reduced"),
        SOLUTION("Solution"),
        SOLUTION_STD_DEV("Solution Std Dev (avg solutions only)");

        private String name;

        private SlipRateTypes(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

