/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.plugins.opensha.ucerf3Rups.colorers;

import com.google.common.collect.Lists;
import java.awt.Color;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.opensha.commons.data.CSVFile;
import org.opensha.commons.mapping.gmt.elements.GMT_CPT_Files;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.impl.BooleanParameter;
import org.opensha.commons.param.impl.ButtonParameter;
import org.opensha.commons.param.impl.DoubleParameter;
import org.opensha.commons.param.impl.EnumParameter;
import org.opensha.commons.param.impl.IntegerParameter;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.commons.util.cpt.CPT;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.scec.vtk.commons.opensha.faults.AbstractFaultSection;
import org.scec.vtk.commons.opensha.faults.colorers.CPTBasedColorer;
import org.scec.vtk.commons.opensha.faults.faultSectionImpl.PrefDataSection;
import org.scec.vtk.commons.opensha.surfaces.LineSurfaceGenerator;
import org.scec.vtk.commons.opensha.surfaces.params.ColorParameter;
import org.scec.vtk.plugins.opensha.ucerf3Rups.UCERF3RupSetChangeListener;
import org.scec.vtk.tools.picking.PickEnabledActor;
import org.scec.vtk.tools.picking.PickHandler;
import vtk.vtkCellPicker;

public class MultiFaultRupColorer
extends CPTBasedColorer
implements PickHandler<AbstractFaultSection>,
UCERF3RupSetChangeListener,
ParameterChangeListener {
    private HashSet<Integer> includeIDs = new HashSet();
    private HashSet<Integer> excludeIDs = new HashSet();
    private FaultSystemSolution sol;
    private static final String DISPLAY_PARAM_NAME = "Display Rups";
    private BooleanParameter displayParam;
    private static final String MAX_RUPS_PARAM_NAME = "Max # Rups to Display";
    private static final Integer MAX_RUPS_DEFAULT = 1000;
    private static final Integer MAX_RUPS_MIN = 1;
    private static final Integer MAX_RUPS_MAX = Integer.MAX_VALUE;
    private IntegerParameter maxRupsParam;
    private static final String OR_PARAM_NAME = "Selection OR";
    private BooleanParameter orParam;
    private static final String EXCLUDE_PARAM_NAME = "Selection Exclude";
    private BooleanParameter excludeParam;
    private static final String PARENT_SECT_PARAM_NAME = "Select Parent Sects";
    private BooleanParameter parentSectParam;
    private static final String COMP_PARAM_NAME = "Sort By";
    private EnumParameter<CompareType> compParam;
    private static final String REVERSED_PARAM_NAME = "Reversed";
    private BooleanParameter reversedParam;
    private ParameterList params = new ParameterList();
    private LineSurfaceGenerator lineGen;
    private HashMap<Integer, Double> asDiscrRates = new HashMap();
    private HashMap<Integer, Double> rates = new HashMap();
    private static final String HIGHLIGHT_COLOR_PARAM_NAME = "Highlight Color";
    private static final Color HIGHLI_COLOR_DEFAULT = Color.WHITE;
    private ColorParameter highlightColorParam;
    private static final String HIDE_NAN_PARAM_NAME = "Hide NaN's?";
    private BooleanParameter hideNansParam;
    private DoubleParameter magMinParam;
    private double min = 0.0;
    private double max = 10.0;
    private DoubleParameter magMaxParam;
    private DoubleParameter minRateParam;
    private double min_rate_min = 0.0;
    private double min_rate_max = 1.0;
    private BooleanParameter riParam;
    private BooleanParameter asDiscrParam;
    private JFileChooser exportChoose;
    private ButtonParameter exportParam;

    private static CPT getDefaultCPT() {
        CPT cpt;
        try {
            cpt = GMT_CPT_Files.MAX_SPECTRUM.instance();
        }
        catch (IOException e) {
            throw ExceptionUtils.asRuntimeException((Throwable)e);
        }
        cpt = cpt.rescale(-10.0, -2.0);
        cpt.setNanColor(Color.GRAY);
        return cpt;
    }

    private static CPT getRICPT() {
        CPT cpt;
        try {
            cpt = GMT_CPT_Files.MAX_SPECTRUM.instance();
        }
        catch (IOException e) {
            throw ExceptionUtils.asRuntimeException((Throwable)e);
        }
        cpt = cpt.reverse();
        cpt = cpt.rescale(2.0, 5.0);
        cpt.setNanColor(Color.GRAY);
        return cpt;
    }

    public MultiFaultRupColorer() {
        super(MultiFaultRupColorer.getDefaultCPT(), true);
        this.displayParam = new BooleanParameter(DISPLAY_PARAM_NAME, Boolean.valueOf(false));
        this.displayParam.addParameterChangeListener((ParameterChangeListener)this);
        this.params.addParameter((Parameter)this.displayParam);
        this.maxRupsParam = new IntegerParameter(MAX_RUPS_PARAM_NAME, MAX_RUPS_MIN, MAX_RUPS_MAX, MAX_RUPS_DEFAULT);
        this.maxRupsParam.addParameterChangeListener((ParameterChangeListener)this);
        this.params.addParameter((Parameter)this.maxRupsParam);
        this.orParam = new BooleanParameter(OR_PARAM_NAME, Boolean.valueOf(false));
        this.orParam.addParameterChangeListener((ParameterChangeListener)this);
        this.params.addParameter((Parameter)this.orParam);
        this.parentSectParam = new BooleanParameter(PARENT_SECT_PARAM_NAME, Boolean.valueOf(false));
        this.parentSectParam.addParameterChangeListener((ParameterChangeListener)this);
        this.params.addParameter((Parameter)this.parentSectParam);
        this.compParam = new EnumParameter(COMP_PARAM_NAME, EnumSet.allOf(CompareType.class), (Enum)CompareType.RATE, null);
        this.compParam.addParameterChangeListener((ParameterChangeListener)this);
        this.params.addParameter(this.compParam);
        this.reversedParam = new BooleanParameter(REVERSED_PARAM_NAME, Boolean.valueOf(false));
        this.reversedParam.addParameterChangeListener((ParameterChangeListener)this);
        this.params.addParameter((Parameter)this.reversedParam);
        this.highlightColorParam = new ColorParameter(HIGHLIGHT_COLOR_PARAM_NAME, HIGHLI_COLOR_DEFAULT);
        this.highlightColorParam.addParameterChangeListener(this);
        this.params.addParameter((Parameter)this.highlightColorParam);
        this.excludeParam = new BooleanParameter(EXCLUDE_PARAM_NAME, Boolean.valueOf(false));
        this.excludeParam.addParameterChangeListener((ParameterChangeListener)this);
        this.params.addParameter((Parameter)this.excludeParam);
        this.hideNansParam = new BooleanParameter(HIDE_NAN_PARAM_NAME, Boolean.valueOf(false));
        this.hideNansParam.addParameterChangeListener((ParameterChangeListener)this);
        this.params.addParameter((Parameter)this.hideNansParam);
        this.magMinParam = new DoubleParameter("Min Mag", 0.0, 10.0);
        this.magMinParam.setValue(this.min);
        this.magMinParam.addParameterChangeListener((ParameterChangeListener)this);
        this.params.addParameter((Parameter)this.magMinParam);
        this.magMaxParam = new DoubleParameter("Max Mag", 0.0, 10.0);
        this.magMaxParam.setValue(this.max);
        this.magMaxParam.addParameterChangeListener((ParameterChangeListener)this);
        this.params.addParameter((Parameter)this.magMaxParam);
        this.minRateParam = new DoubleParameter("Min Rup Rate", this.min_rate_min, this.min_rate_max);
        this.minRateParam.setValue(this.min_rate_min);
        this.minRateParam.setInfo("Min rate to display for stacked ruptures");
        this.minRateParam.addParameterChangeListener((ParameterChangeListener)this);
        this.params.addParameter((Parameter)this.minRateParam);
        this.riParam = new BooleanParameter("Recurrence Intervals", Boolean.valueOf(false));
        this.riParam.addParameterChangeListener((ParameterChangeListener)this);
        this.params.addParameter((Parameter)this.riParam);
        this.asDiscrParam = new BooleanParameter("As Discretized", Boolean.valueOf(false));
        this.asDiscrParam.addParameterChangeListener((ParameterChangeListener)this);
        this.params.addParameter((Parameter)this.asDiscrParam);
        this.exportParam = new ButtonParameter("CSV File", "Export");
        this.exportParam.addParameterChangeListener((ParameterChangeListener)this);
        this.params.addParameter((Parameter)this.exportParam);
        this.lineGen = new LineSurfaceGenerator();
        this.lineGen.setSize(2.0);
    }

    public String getName() {
        return "Multi Fault Rup Rates";
    }

    @Override
    public Color getColor(AbstractFaultSection fault) {
        int id = fault.getId();
        if (!((Boolean)this.parentSectParam.getValue()).booleanValue() && this.includeIDs.contains(id)) {
            return (Color)this.highlightColorParam.getValue();
        }
        if (this.excludeIDs.contains(id)) {
            Color origColor = (Color)this.highlightColorParam.getValue();
            return new Color(255 - origColor.getRed(), 255 - origColor.getGreen(), 255 - origColor.getBlue());
        }
        double value = this.getValue(fault);
        if (((Boolean)this.hideNansParam.getValue()).booleanValue() && Double.isNaN(value) && this.rates != null && !this.rates.isEmpty()) {
            return null;
        }
        return super.getColorForValue(value);
    }

    @Override
    public double getValue(AbstractFaultSection fault) {
        Double rate = this.rates.get(fault.getId());
        if (rate == null) {
            return Double.NaN;
        }
        if (((Boolean)this.riParam.getValue()).booleanValue()) {
            return 1.0 / rate;
        }
        if (((Boolean)this.asDiscrParam.getValue()).booleanValue()) {
            return this.asDiscrRates.get(fault.getId());
        }
        return rate;
    }

    private void update() {
        Object rupsForSect;
        this.rates.clear();
        this.asDiscrRates.clear();
        double totRate = 0.0;
        int totNumRups = 0;
        this.updateParentBGDisplay();
        if (this.sol == null) {
            return;
        }
        List<Rupture> rups = new ArrayList();
        HashSet<Integer> rupIDs = new HashSet<Integer>();
        double minMag = (Double)this.magMinParam.getValue();
        double maxMag = (Double)this.magMaxParam.getValue();
        for (int sect : this.includeIDs) {
            rupsForSect = (Boolean)this.parentSectParam.getValue() != false ? this.sol.getRupSet().getRupturesForParentSection(sect) : this.sol.getRupSet().getRupturesForSection(sect);
            Iterator iterator = rupsForSect.iterator();
            while (iterator.hasNext()) {
                double mag;
                int rupID = (Integer)iterator.next();
                if (rupIDs.contains(rupID) || (mag = this.sol.getRupSet().getMagForRup(rupID)) < minMag || mag > maxMag) continue;
                List sects = this.sol.getRupSet().getSectionsIndicesForRup(rupID);
                boolean match = true;
                if (!((Boolean)this.orParam.getValue()).booleanValue()) {
                    if (((Boolean)this.parentSectParam.getValue()).booleanValue()) {
                        Iterator<Integer> rupParents = new HashSet();
                        Iterator<Object> iterator2 = sects.iterator();
                        while (iterator2.hasNext()) {
                            int sect2 = (Integer)iterator2.next();
                            int parent = this.sol.getRupSet().getFaultSectionData(sect2).getParentSectionId();
                            if (((HashSet)((Object)rupParents)).contains(parent)) continue;
                            ((HashSet)((Object)rupParents)).add(parent);
                        }
                        iterator2 = this.includeIDs.iterator();
                        while (iterator2.hasNext()) {
                            int parent = (Integer)iterator2.next();
                            if (((HashSet)((Object)rupParents)).contains(parent)) continue;
                            match = false;
                            break;
                        }
                    } else {
                        for (int sect2 : this.includeIDs) {
                            if (sect == sect2 || sects.contains(sect2)) continue;
                            match = false;
                            break;
                        }
                    }
                }
                for (int sect2 : this.excludeIDs) {
                    if (!sects.contains(sect2)) continue;
                    match = false;
                    break;
                }
                if (!match) continue;
                Rupture rup = new Rupture(rupID, sects, this.sol.getRateForRup(rupID));
                rupIDs.add(rupID);
                rups.add(rup);
                totRate += rup.rate;
                ++totNumRups;
                Iterator iterator3 = sects.iterator();
                while (iterator3.hasNext()) {
                    int sectID = (Integer)iterator3.next();
                    Double sectRate = this.rates.get(sectID);
                    Double sectAsDiscrRate = this.asDiscrRates.get(sectID);
                    if (sectRate == null) {
                        sectRate = 0.0;
                        sectAsDiscrRate = 0.0;
                    }
                    sectRate = sectRate + rup.rate;
                    sectAsDiscrRate = sectAsDiscrRate + 1.0;
                    this.rates.put(sectID, sectRate);
                    this.asDiscrRates.put(sectID, sectAsDiscrRate);
                }
            }
        }
        double asDiscrScale = totRate / (double)totNumRups;
        rupsForSect = this.asDiscrRates.keySet().iterator();
        while (rupsForSect.hasNext()) {
            int sectID = rupsForSect.next();
            this.asDiscrRates.put(sectID, asDiscrScale * this.asDiscrRates.get(sectID));
        }
        Collections.sort(rups);
        if (((Boolean)this.reversedParam.getValue()).booleanValue()) {
            Collections.reverse(rups);
        }
        this.fireColorerChangeEvent();
        int maxRups = (Integer)this.maxRupsParam.getValue();
        if (((Boolean)this.displayParam.getValue()).booleanValue()) {
            double minRate = (Double)this.minRateParam.getValue();
            if (minRate > 0.0) {
                ArrayList newRups = Lists.newArrayList();
                for (Rupture rup : rups) {
                    if (!(rup.rate >= minRate)) continue;
                    newRups.add(rup);
                }
                rups = newRups;
            }
            if (rups.size() > maxRups) {
                JOptionPane.showMessageDialog(null, "Only the first " + maxRups + " ruptures are being displayed", "WARNING: Too many ruptures", 2);
                rups = rups.subList(0, maxRups);
            }
            double alt = 3.0;
            if (((Boolean)this.parentSectParam.getValue()).booleanValue()) {
                alt += 3.0;
            }
            for (Rupture rup : rups) {
                double d = alt;
                alt = d + 1.0;
                this.display(rup, d);
            }
            this.displayParam.getEditor().refreshParamEditor();
            if (!((Boolean)this.displayParam.getValue()).booleanValue()) {
                this.displayParam.removeParameterChangeListener((ParameterChangeListener)this);
                this.displayParam.setValue((Object)true);
                this.displayParam.getEditor().refreshParamEditor();
                this.displayParam.addParameterChangeListener((ParameterChangeListener)this);
            }
        }
    }

    private void display(Rupture rup, double alt) {
        double rate = rup.rate;
        if (((Boolean)this.riParam.getValue()).booleanValue()) {
            rate = 1.0 / rate;
        }
        Color color = this.getCPT().getColor((float)Math.log10(rate));
        ArrayList indices = Lists.newArrayList(rup.indices);
        Collections.sort(indices);
    }

    private void updateParentBGDisplay() {
    }

    @Override
    public void actorPicked(PickEnabledActor<AbstractFaultSection> actor, AbstractFaultSection reference, vtkCellPicker picker, MouseEvent e) {
        if (reference instanceof PrefDataSection) {
            PrefDataSection fault = (PrefDataSection)reference;
            if (e.getButton() == 1 && e.isShiftDown()) {
                System.out.println("shift down");
                int id = (Boolean)this.parentSectParam.getValue() != false ? fault.getFaultSection().getParentSectionId() : fault.getId();
                if (((Boolean)this.excludeParam.getValue()).booleanValue()) {
                    id = fault.getId();
                    if (this.excludeIDs.contains(id)) {
                        this.excludeIDs.remove(id);
                    } else {
                        this.excludeIDs.add(id);
                    }
                } else if (this.includeIDs.contains(id)) {
                    this.includeIDs.remove(id);
                } else if (e.isControlDown()) {
                    if (!this.includeIDs.contains(id)) {
                        this.includeIDs.add(id);
                    }
                } else {
                    this.includeIDs.clear();
                    this.excludeIDs.clear();
                    this.includeIDs.add(id);
                }
                this.update();
            }
        }
    }

    @Override
    public void setRupSet(FaultSystemRupSet rupSet, FaultSystemSolution sol) {
        this.sol = null;
        this.update();
        if (sol == null && rupSet != null) {
            double[] fakeRates = new double[rupSet.getNumRuptures()];
            double rate = 1.0 / (double)fakeRates.length;
            for (int r = 0; r < fakeRates.length; ++r) {
                fakeRates[r] = rate;
            }
            sol = new FaultSystemSolution(rupSet, fakeRates);
        }
        this.sol = sol;
        this.update();
    }

    public void parameterChange(ParameterChangeEvent event) {
        Parameter param = event.getParameter();
        if (param == this.compParam || param == this.reversedParam || param == this.maxRupsParam || param == this.orParam) {
            this.update();
        } else if (param == this.parentSectParam) {
            if (((Boolean)this.parentSectParam.getValue()).booleanValue()) {
                if (this.sol == null) {
                    this.includeIDs.clear();
                    this.excludeIDs.clear();
                } else {
                    HashSet<Integer> newSectIDs = new HashSet<Integer>();
                    for (int sectID : this.includeIDs) {
                        int parentID = this.sol.getRupSet().getFaultSectionData(sectID).getParentSectionId();
                        if (newSectIDs.contains(parentID)) continue;
                        newSectIDs.add(parentID);
                    }
                    this.includeIDs = newSectIDs;
                }
            } else {
                this.includeIDs.clear();
                this.excludeIDs.clear();
            }
            this.update();
        } else if (param == this.highlightColorParam) {
            this.updateParentBGDisplay();
            this.fireColorerChangeEvent();
        } else if (param == this.displayParam) {
            this.update();
        } else if (param == this.hideNansParam) {
            this.fireColorerChangeEvent();
        } else if (param == this.magMinParam || param == this.magMaxParam) {
            this.update();
        } else if (param == this.minRateParam) {
            this.update();
        } else if (param == this.riParam) {
            if (((Boolean)this.riParam.getValue()).booleanValue()) {
                this.setCPT(MultiFaultRupColorer.getRICPT(), true);
            } else {
                this.setCPT(MultiFaultRupColorer.getDefaultCPT(), true);
            }
            this.update();
        } else if (param == this.asDiscrParam) {
            this.fireColorerChangeEvent();
        } else if (param == this.exportParam && this.rates != null) {
            int ret;
            if (this.exportChoose == null) {
                this.exportChoose = new JFileChooser();
            }
            if ((ret = this.exportChoose.showSaveDialog(null)) == 0) {
                File file = this.exportChoose.getSelectedFile();
                CSVFile csv = new CSVFile(true);
                csv.addLine((Object[])new String[]{"Section ID", "Multi Fault Participation Rate"});
                for (Integer id : this.rates.keySet()) {
                    csv.addLine((Object[])new String[]{"" + id, String.valueOf(this.rates.get(id))});
                }
                try {
                    csv.writeToFile(file);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(null, e.toString(), "Error saving file", 0);
                }
            }
        }
    }

    @Override
    public ParameterList getColorerParameters() {
        return this.params;
    }

    private static enum CompareType {
        RATE("Rupture Rate"),
        NUM_SECTIONS("Num Sections"),
        RUP_ID("Rupture ID");

        private String name;

        private CompareType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    private class Rupture
    implements Comparable<Rupture> {
        private int id;
        private List<Integer> indices;
        private double rate;

        public Rupture(int id, List<Integer> indices, double rate) {
            this.id = id;
            this.indices = indices;
            this.rate = rate;
        }

        @Override
        public int compareTo(Rupture o) {
            switch (((CompareType)((Object)MultiFaultRupColorer.this.compParam.getValue())).ordinal()) {
                case 0: {
                    return -Double.compare(this.rate, o.rate);
                }
                case 1: {
                    return Double.compare(this.indices.size(), o.indices.size());
                }
                case 2: {
                    return Double.compare(this.id, o.id);
                }
            }
            throw new IllegalStateException("unknown comp type: " + String.valueOf(MultiFaultRupColorer.this.compParam.getValue()));
        }
    }
}

