/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.plugins.opensha.ucerf3Rups.colorers;

import java.awt.Color;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.gui.plot.GraphWindow;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.commons.gui.plot.PlotSpec;
import org.opensha.commons.mapping.gmt.elements.GMT_CPT_Files;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.impl.DoubleParameter;
import org.opensha.commons.util.cpt.CPT;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.faultSurface.FaultSection;
import org.scec.vtk.commons.opensha.faults.AbstractFaultSection;
import org.scec.vtk.commons.opensha.faults.colorers.CPTBasedColorer;
import org.scec.vtk.plugins.opensha.ucerf3Rups.UCERF3RupSetChangeListener;
import org.scec.vtk.tools.picking.PickEnabledActor;
import org.scec.vtk.tools.picking.PickHandler;
import vtk.vtkCellPicker;

public class NucleationRateColorer
extends CPTBasedColorer
implements UCERF3RupSetChangeListener,
ParameterChangeListener,
PickHandler<AbstractFaultSection> {
    private ParameterList params;
    private DoubleParameter magMinParam;
    private double min = 6.5;
    private double max = 10.0;
    private DoubleParameter magMaxParam;
    private FaultSystemSolution sol;
    private static final double cpt_min = 1.0E-6;
    private static final double cpt_max = 0.01;

    protected static CPT getDefaultCPT() {
        try {
            CPT cpt = GMT_CPT_Files.MAX_SPECTRUM.instance();
            cpt = cpt.rescale(1.0E-6, 0.01);
            return cpt;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public NucleationRateColorer() {
        super(NucleationRateColorer.getDefaultCPT(), false);
        this.setCPTLog(true);
        this.params = new ParameterList();
        this.magMinParam = new DoubleParameter("Min Mag", 0.0, 10.0);
        this.magMinParam.setValue(this.min);
        this.magMinParam.addParameterChangeListener((ParameterChangeListener)this);
        this.params.addParameter((Parameter)this.magMinParam);
        this.magMaxParam = new DoubleParameter("Max Mag", 0.0, 10.0);
        this.magMaxParam.setValue(this.max);
        this.magMaxParam.addParameterChangeListener((ParameterChangeListener)this);
        this.params.addParameter((Parameter)this.magMaxParam);
    }

    @Override
    public double getValue(AbstractFaultSection fault) {
        if (this.sol == null) {
            return Double.NaN;
        }
        int sectIndex = fault.getId();
        return this.sol.calcNucleationRateForSect(sectIndex, this.min, this.max);
    }

    public String getName() {
        return "Solution Nucleation Rates (events/yr)";
    }

    @Override
    public void setRupSet(FaultSystemRupSet rupSet, FaultSystemSolution sol) {
        this.sol = sol;
    }

    @Override
    public ParameterList getColorerParameters() {
        return this.params;
    }

    public void parameterChange(ParameterChangeEvent event) {
        if (event.getParameter() == this.magMinParam) {
            double newMin = (Double)this.magMinParam.getValue();
            if (newMin < this.max) {
                this.min = newMin;
                this.fireColorerChangeEvent();
            } else {
                this.magMinParam.removeParameterChangeListener((ParameterChangeListener)this);
                this.magMinParam.setValue(this.min);
                this.magMinParam.addParameterChangeListener((ParameterChangeListener)this);
                this.magMinParam.getEditor().refreshParamEditor();
                JOptionPane.showMessageDialog(null, "Min must be < Max!", "Invalid Range", 0);
            }
        } else if (event.getParameter() == this.magMaxParam) {
            double newMax = (Double)this.magMaxParam.getValue();
            if (newMax > this.min) {
                this.max = newMax;
                this.fireColorerChangeEvent();
            } else {
                this.magMaxParam.removeParameterChangeListener((ParameterChangeListener)this);
                this.magMaxParam.setValue(this.max);
                this.magMaxParam.addParameterChangeListener((ParameterChangeListener)this);
                this.magMaxParam.getEditor().refreshParamEditor();
                JOptionPane.showMessageDialog(null, "Max must be > Min!", "Invalid Range", 0);
            }
        }
    }

    @Override
    public void actorPicked(PickEnabledActor<AbstractFaultSection> actor, AbstractFaultSection fault, vtkCellPicker picker, MouseEvent e) {
        int clickCount = e.getClickCount();
        if (this.sol == null || clickCount < 2 || e.getButton() != 1) {
            return;
        }
        int faultID = fault.getId();
        FaultSection sect = this.sol.getRupSet().getFaultSectionData(faultID);
        GraphWindow graph = null;
        for (boolean parent : new boolean[]{false, true}) {
            Object mfd = parent ? this.sol.calcNucleationMFD_forParentSect(sect.getParentSectionId(), 5.55, 8.55, 31) : this.sol.calcNucleationMFD_forSect(faultID, 5.55, 8.55, 31);
            mfd.setName("Incremental MFD");
            mfd.setInfo(" ");
            EvenlyDiscretizedFunc cumMFD = mfd.getCumRateDistWithOffset();
            cumMFD.setName("Cumulative MFD");
            cumMFD.setInfo(" ");
            ArrayList<Object> funcs = new ArrayList<Object>();
            ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
            funcs.add(mfd);
            chars.add(new PlotCurveCharacterstics(PlotLineType.HISTOGRAM, 1.0f, Color.BLUE));
            funcs.add(cumMFD);
            chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLACK));
            String name = parent ? sect.getParentSectionName() : fault.getName();
            PlotSpec spec = new PlotSpec(funcs, chars, name, "Magnitude", "Nucleation Rate (1/yr)");
            spec.setLegendVisible(true);
            if (graph == null) {
                graph = new GraphWindow(spec, false);
            } else {
                graph.addTab(spec);
            }
            graph.setYLog(true);
            graph.setAxisRange(6.0, 9.0, 1.0E-10, 0.1);
        }
        graph.setSelectedTab(0);
        graph.setVisible(true);
    }
}

