/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.plugins.opensha.ucerf3Rups.colorers;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.data.region.CaliforniaRegions;
import org.opensha.commons.data.xyz.EvenlyDiscrXYZ_DataSet;
import org.opensha.commons.data.xyz.GeoDataSet;
import org.opensha.commons.data.xyz.GriddedGeoDataSet;
import org.opensha.commons.geo.GriddedRegion;
import org.opensha.commons.geo.Location;
import org.opensha.commons.gui.plot.GraphWindow;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.commons.gui.plot.PlotSpec;
import org.opensha.commons.mapping.gmt.elements.GMT_CPT_Files;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.impl.BooleanParameter;
import org.opensha.commons.param.impl.DoubleParameter;
import org.opensha.commons.param.impl.EnumParameter;
import org.opensha.commons.param.impl.IntegerParameter;
import org.opensha.commons.param.impl.StringParameter;
import org.opensha.commons.util.DataUtils;
import org.opensha.commons.util.cpt.CPT;
import org.opensha.commons.util.interp.BicubicInterpolation2D;
import org.opensha.sha.earthquake.ERF;
import org.opensha.sha.earthquake.ProbEqkRupture;
import org.opensha.sha.earthquake.calc.ERF_Calculator;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.faultSysSolution.reports.plots.SolMFDPlot;
import org.opensha.sha.earthquake.param.IncludeBackgroundOption;
import org.opensha.sha.earthquake.param.ProbabilityModelOptions;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.faultSurface.RupNodesCache;
import org.opensha.sha.gui.infoTools.CalcProgressBar;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import org.scec.vtk.commons.opensha.faults.AbstractFaultSection;
import org.scec.vtk.commons.opensha.faults.colorers.CPTBasedColorer;
import org.scec.vtk.commons.opensha.geoDataSet.GeoDataSetGeometryGenerator;
import org.scec.vtk.main.MainGUI;
import org.scec.vtk.plugins.PluginActors;
import org.scec.vtk.plugins.opensha.ucerf3Rups.UCERF3RupSetChangeListener;
import org.scec.vtk.tools.picking.PickEnabledActor;
import org.scec.vtk.tools.picking.PickHandler;
import scratch.UCERF3.analysis.CompoundFSSPlots;
import scratch.UCERF3.analysis.FaultSysSolutionERF_Calc;
import scratch.UCERF3.erf.FaultSystemSolutionERF;
import scratch.UCERF3.inversion.InversionFaultSystemSolution;
import vtk.vtkActor;
import vtk.vtkCellPicker;
import vtk.vtkProp;

public class ParticipationRateColorer
extends CPTBasedColorer
implements UCERF3RupSetChangeListener,
ParameterChangeListener,
PickHandler<AbstractFaultSection> {
    private ParameterList params;
    private DoubleParameter magMinParam;
    private double min = 6.5;
    private double max = 10.0;
    private DoubleParameter magMaxParam;
    private BooleanParameter probabilityParam;
    private DoubleParameter probDurationParam;
    private EnumParameter<PlotType> plotTypeParam;
    private IntegerParameter tdStartYearParam;
    private FaultSystemSolution sol;
    private CPT rateCPT;
    private boolean rateCPTLog;
    private CPT ratioCPT = ParticipationRateColorer.getDefaultRatioCPT();
    private boolean ratioCPTLog = true;
    private BooleanParameter displayGriddedParam;
    private BooleanParameter includeFaultsInGriddedParam;
    private DoubleParameter griddedDepthParam;
    private DoubleParameter griddedDataOpacityParam;
    private GriddedGeoDataSet loadedGriddedData;
    private vtkActor griddedDataActor;
    private PluginActors actors;
    private double[] tdProbsCache;

    private static CPT getDefaultRateCPT() {
        try {
            CPT cpt = GMT_CPT_Files.MAX_SPECTRUM.instance();
            cpt = cpt.rescale(-6.0, -2.0);
            cpt.setNanColor(Color.GRAY);
            return cpt;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static CPT getDefaultRatioCPT() {
        try {
            CPT cpt = GMT_CPT_Files.GMT_POLAR.instance();
            cpt = cpt.rescale(-2.0, 2.0);
            cpt.setNanColor(Color.GRAY);
            return cpt;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ParticipationRateColorer(PluginActors actors) {
        super(ParticipationRateColorer.getDefaultRateCPT(), true);
        this.rateCPT = this.getCPT();
        this.rateCPTLog = this.isCPTLog();
        this.actors = actors;
        this.params = new ParameterList();
        this.magMinParam = new DoubleParameter("Min Mag", 0.0, 10.0);
        this.magMinParam.setValue(this.min);
        this.magMinParam.addParameterChangeListener((ParameterChangeListener)this);
        this.params.addParameter((Parameter)this.magMinParam);
        this.magMaxParam = new DoubleParameter("Max Mag", 0.0, 10.0);
        this.magMaxParam.setValue(this.max);
        this.magMaxParam.addParameterChangeListener((ParameterChangeListener)this);
        this.params.addParameter((Parameter)this.magMaxParam);
        this.displayGriddedParam = new BooleanParameter("Display Gridded Seismicity", Boolean.valueOf(false));
        this.displayGriddedParam.addParameterChangeListener((ParameterChangeListener)this);
        this.params.addParameter((Parameter)this.displayGriddedParam);
        this.includeFaultsInGriddedParam = new BooleanParameter("Include Faults in Gridded", Boolean.valueOf(false));
        this.includeFaultsInGriddedParam.addParameterChangeListener((ParameterChangeListener)this);
        this.params.addParameter((Parameter)this.includeFaultsInGriddedParam);
        this.griddedDepthParam = new DoubleParameter("Gridded Display Depth", 0.0, 30.0);
        this.griddedDepthParam.setValue(0.0);
        this.griddedDepthParam.addParameterChangeListener((ParameterChangeListener)this);
        this.params.addParameter((Parameter)this.griddedDepthParam);
        this.griddedDataOpacityParam = new DoubleParameter("Gridded Data Opacity", 0.0, 1.0);
        this.griddedDataOpacityParam.setDefaultValue((Object)0.7);
        this.griddedDataOpacityParam.setValue((Object)((Double)this.griddedDataOpacityParam.getDefaultValue()));
        this.griddedDataOpacityParam.addParameterChangeListener((ParameterChangeListener)this);
        this.params.addParameter((Parameter)this.griddedDataOpacityParam);
        this.probabilityParam = new BooleanParameter("Probabilities", Boolean.valueOf(false));
        this.probabilityParam.addParameterChangeListener((ParameterChangeListener)this);
        this.probabilityParam.setInfo("If selected, Poisson probabilities with the given duration. Otherwise annualized rates");
        this.params.addParameter((Parameter)this.probabilityParam);
        this.probDurationParam = new DoubleParameter("Duration", 0.0027378507871321013, 100000.0, "Years");
        this.probDurationParam.setValue(30.0);
        this.probDurationParam.addParameterChangeListener((ParameterChangeListener)this);
        this.probDurationParam.getEditor().setEnabled(false);
        this.params.addParameter((Parameter)this.probDurationParam);
        this.plotTypeParam = new EnumParameter("Plot Type", EnumSet.allOf(PlotType.class), (Enum)PlotType.TIME_INDEP, null);
        this.plotTypeParam.addParameterChangeListener((ParameterChangeListener)this);
        this.params.addParameter(this.plotTypeParam);
        this.tdStartYearParam = new IntegerParameter("TD Start Year", 2012, 3000);
        this.tdStartYearParam.setValue((Object)new GregorianCalendar().get(1));
        this.tdStartYearParam.addParameterChangeListener((ParameterChangeListener)this);
        this.tdStartYearParam.getEditor().setEnabled(false);
        this.params.addParameter((Parameter)this.tdStartYearParam);
    }

    @Override
    public double getValue(AbstractFaultSection fault) {
        if (this.sol == null) {
            return Double.NaN;
        }
        int sectIndex = fault.getId();
        return this.getValue(sectIndex);
    }

    public double getValue(int sectIndex) {
        switch (((PlotType)((Object)this.plotTypeParam.getValue())).ordinal()) {
            case 0: {
                return this.getTI(sectIndex);
            }
            case 1: {
                return this.getTD(sectIndex);
            }
            case 2: {
                double tiVal = this.getTI(sectIndex);
                double tdVal = this.getTD(sectIndex);
                return tdVal / tiVal;
            }
        }
        throw new IllegalStateException("Unknown plot type!");
    }

    private synchronized double getTI(int sectIndex) {
        return this.getProbIfApplicable(this.sol.calcParticRateForSect(sectIndex, this.min, this.max));
    }

    private synchronized double getTD(int sectIndex) {
        if (this.tdProbsCache == null) {
            CalcProgressBar p = new CalcProgressBar("Calculating UCERF3-TD Participation Rates", "Calculating Participation Rates");
            FaultSystemSolutionERF erf = new FaultSystemSolutionERF(this.sol);
            erf.setParameter("Probability Model", (Object)ProbabilityModelOptions.U3_PREF_BLEND);
            erf.setParameter("Aleatory Mag-Area StdDev", (Object)0.0);
            int startYear = (Integer)this.tdStartYearParam.getValue();
            double duration = (Double)this.probDurationParam.getValue();
            erf.setParameter("Historic Open Interval", (Object)((double)startYear - 1875.0));
            erf.getTimeSpan().setStartTime(startYear);
            erf.getTimeSpan().setDuration(duration);
            erf.setParameter("Background Seismicity", (Object)IncludeBackgroundOption.EXCLUDE);
            erf.updateForecast();
            FaultSystemRupSet rupSet = this.sol.getRupSet();
            ArrayList rupProbs = Lists.newArrayList();
            for (int r = 0; r < rupSet.getNumSections(); ++r) {
                rupProbs.add(new ArrayList());
            }
            for (int sourceID = 0; sourceID < erf.getNumFaultSystemSources(); ++sourceID) {
                int fssIndex = erf.getFltSysRupIndexForSource(sourceID);
                Preconditions.checkState((fssIndex >= 0 ? 1 : 0) != 0);
                for (ProbEqkRupture rup : erf.getSource(sourceID)) {
                    if (!(rup.getMag() >= this.min) || !(rup.getMag() <= this.max)) continue;
                    double prob = rup.getProbability();
                    Iterator iterator = rupSet.getSectionsIndicesForRup(fssIndex).iterator();
                    while (iterator.hasNext()) {
                        int s = (Integer)iterator.next();
                        ((List)rupProbs.get(s)).add(prob);
                    }
                }
            }
            this.tdProbsCache = new double[rupSet.getNumSections()];
            for (int s = 0; s < this.tdProbsCache.length; ++s) {
                this.tdProbsCache[s] = FaultSysSolutionERF_Calc.calcSummedProbs((List)((List)rupProbs.get(s)));
            }
            p.dispose();
        }
        double prob = this.tdProbsCache[sectIndex];
        if (((Boolean)this.probabilityParam.getValue()).booleanValue()) {
            return prob;
        }
        double rate = -Math.log(1.0 - prob) / (Double)this.probDurationParam.getValue();
        return rate;
    }

    private double getProbIfApplicable(double rate) {
        if (((Boolean)this.probabilityParam.getValue()).booleanValue()) {
            double duration = (Double)this.probDurationParam.getValue();
            double prob = 1.0 - Math.exp(-rate * duration);
            return prob;
        }
        return rate;
    }

    public String getName() {
        return "Solution Participation Rates (events/yr)";
    }

    @Override
    public void setRupSet(FaultSystemRupSet rupSet, FaultSystemSolution sol) {
        this.sol = sol;
        this.loadedGriddedData = null;
    }

    @Override
    public ParameterList getColorerParameters() {
        return this.params;
    }

    public void parameterChange(ParameterChangeEvent event) {
        if (event.getParameter() == this.magMinParam) {
            double newMin = (Double)this.magMinParam.getValue();
            if (newMin < this.max) {
                this.min = newMin;
                this.fireColorerChangeEvent();
            } else {
                this.magMinParam.removeParameterChangeListener((ParameterChangeListener)this);
                this.magMinParam.setValue(this.min);
                this.magMinParam.addParameterChangeListener((ParameterChangeListener)this);
                this.magMinParam.getEditor().refreshParamEditor();
                JOptionPane.showMessageDialog(null, "Min must be < Max!", "Invalid Range", 0);
            }
            this.loadedGriddedData = null;
            this.tdProbsCache = null;
        } else if (event.getParameter() == this.magMaxParam) {
            double newMax = (Double)this.magMaxParam.getValue();
            if (newMax > this.min) {
                this.max = newMax;
                this.fireColorerChangeEvent();
            } else {
                this.magMaxParam.removeParameterChangeListener((ParameterChangeListener)this);
                this.magMaxParam.setValue(this.max);
                this.magMaxParam.addParameterChangeListener((ParameterChangeListener)this);
                this.magMaxParam.getEditor().refreshParamEditor();
                JOptionPane.showMessageDialog(null, "Max must be > Min!", "Invalid Range", 0);
            }
            this.loadedGriddedData = null;
            this.tdProbsCache = null;
        } else if (event.getParameter() == this.displayGriddedParam || event.getParameter() == this.includeFaultsInGriddedParam || event.getParameter() == this.griddedDepthParam) {
            if (event.getParameter() == this.displayGriddedParam || event.getParameter() == this.includeFaultsInGriddedParam) {
                this.loadedGriddedData = null;
            }
            this.displayGriddedData();
        } else if (event.getParameter() == this.griddedDataOpacityParam) {
            if (this.griddedDataActor != null) {
                this.griddedDataActor.GetProperty().SetOpacity(((Double)this.griddedDataOpacityParam.getValue()).doubleValue());
                this.griddedDataActor.Modified();
                MainGUI.updateRenderWindow();
            }
        } else if (event.getParameter() == this.probabilityParam) {
            this.probDurationParam.getEditor().setEnabled((Boolean)this.probabilityParam.getValue() != false || ((PlotType)((Object)this.plotTypeParam.getValue())).usesTD());
            this.fireColorerChangeEvent();
        } else if (event.getParameter() == this.probDurationParam) {
            this.tdProbsCache = null;
            this.fireColorerChangeEvent();
        } else if (event.getParameter() == this.plotTypeParam) {
            if (this.plotTypeParam.getValue() == PlotType.TIME_INDEP || this.plotTypeParam.getValue() == PlotType.TIME_DEP) {
                if (event.getOldValue().equals((Object)PlotType.RATIO)) {
                    this.ratioCPT = this.getCPT();
                    this.ratioCPTLog = this.isCPTLog();
                    this.setCPT(this.rateCPT, this.rateCPTLog);
                }
            } else {
                this.rateCPT = this.getCPT();
                this.rateCPTLog = this.isCPTLog();
                this.setCPT(this.ratioCPT, this.ratioCPTLog);
            }
            boolean usesTD = ((PlotType)((Object)this.plotTypeParam.getValue())).usesTD();
            this.displayGriddedParam.getEditor().setEnabled(!usesTD);
            if (usesTD && ((Boolean)this.displayGriddedParam.getValue()).booleanValue()) {
                this.displayGriddedParam.setValue((Object)false);
            }
            this.tdStartYearParam.getEditor().setEnabled(usesTD);
            this.fireColorerChangeEvent();
        } else if (event.getParameter() == this.tdStartYearParam) {
            this.tdProbsCache = null;
            if (((PlotType)((Object)this.plotTypeParam.getValue())).usesTD()) {
                this.fireColorerChangeEvent();
            }
        }
    }

    @Override
    public void actorPicked(PickEnabledActor<AbstractFaultSection> actor, AbstractFaultSection fault, vtkCellPicker picker, MouseEvent e) {
        int clickCount = e.getClickCount();
        if (this.sol == null || clickCount < 2 || e.getButton() != 1) {
            return;
        }
        int faultID = fault.getId();
        GraphWindow graph = null;
        FaultSystemRupSet rupSet = this.sol.getRupSet();
        FaultSection sect = this.sol.getRupSet().getFaultSectionData(faultID);
        double minMag = Double.POSITIVE_INFINITY;
        double maxMag = Double.NEGATIVE_INFINITY;
        for (FaultSection oSect : rupSet.getFaultSectionDataList()) {
            if (oSect.getParentSectionId() != sect.getParentSectionId()) continue;
            minMag = Math.min(minMag, rupSet.getMinMagForSection(oSect.getSectionId()));
            maxMag = Math.max(maxMag, rupSet.getMaxMagForSection(oSect.getSectionId()));
        }
        IncrementalMagFreqDist refXVals = SolMFDPlot.initDefaultMFD((double)minMag, (double)maxMag);
        System.out.println("MFD range: " + refXVals.size() + " values, [" + (float)refXVals.getMinX() + "," + (float)refXVals.getMaxX() + "]");
        for (boolean parent : new boolean[]{false, true}) {
            IncrementalMagFreqDist mfd = parent ? this.sol.calcParticipationMFD_forParentSect(sect.getParentSectionId(), refXVals.getMinX(), refXVals.getMaxX(), refXVals.size()) : this.sol.calcParticipationMFD_forSect(faultID, refXVals.getMinX(), refXVals.getMaxX(), refXVals.size());
            mfd.setName("Incremental MFD");
            mfd.setInfo(" ");
            EvenlyDiscretizedFunc cumMFD = mfd.getCumRateDistWithOffset();
            cumMFD.setName("Cumulative MFD");
            cumMFD.setInfo(" ");
            ArrayList<Object> funcs = new ArrayList<Object>();
            ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
            funcs.add(mfd);
            chars.add(new PlotCurveCharacterstics(PlotLineType.HISTOGRAM, 1.0f, Color.BLUE));
            funcs.add(cumMFD);
            chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLACK));
            String name = parent ? sect.getParentSectionName() : fault.getName();
            PlotSpec spec = new PlotSpec(funcs, chars, name, "Magnitude", "Participation Rate (1/yr)");
            spec.setLegendVisible(true);
            if (graph == null) {
                graph = new GraphWindow(spec, false);
            } else {
                graph.addTab(spec);
            }
            graph.setYLog(true);
            graph.setAxisRange(mfd.getMinX() - 0.5 * mfd.getDelta(), mfd.getMaxX() + 0.5 * mfd.getDelta(), 1.0E-10, 0.1);
        }
        graph.setSelectedTab(0);
        graph.setVisible(true);
    }

    static GriddedGeoDataSet loadGriddedData(FaultSystemSolution sol, GriddedRegion griddedRegion, double minMag, double maxMag, CompoundFSSPlots.FSSRupNodesCache cache, boolean participation, boolean includeFaultsInGridded) {
        if (!(sol instanceof InversionFaultSystemSolution) && sol.getGridSourceProvider() == null) {
            JFileChooser choose;
            int ret = JOptionPane.showConfirmDialog(null, "Must be an InversionFaultSystemSolution or have gridded\nsource data embedded to calculate gridded rates.\nWould you like to load in a COMPOUND_PLOT xml file?", "Can't Load Gridded Data", 0);
            if (ret == 0 && (ret = (choose = new JFileChooser()).showOpenDialog(null)) == 0) {
                try {
                    List datas = CompoundFSSPlots.MapBasedPlot.loadPlotData((File)choose.getSelectedFile());
                    ArrayList strings = Lists.newArrayList();
                    for (CompoundFSSPlots.MapPlotData data : datas) {
                        strings.add(data.getLabel());
                    }
                    StringParameter sparam = new StringParameter("Select Dataset", strings, (String)strings.get(0));
                    sparam.getEditor().getComponent().setPreferredSize(new Dimension(500, 50));
                    ret = JOptionPane.showConfirmDialog(null, sparam.getEditor().getComponent(), "Dataset From File", 2);
                    String selected = (String)sparam.getValue();
                    if (ret == 0) {
                        for (CompoundFSSPlots.MapPlotData data : datas) {
                            GriddedGeoDataSet gridded;
                            if (!data.getLabel().equals(selected)) continue;
                            boolean log = selected.contains("Log10");
                            GeoDataSet geo = data.getGriddedData();
                            if (geo instanceof GriddedGeoDataSet) {
                                gridded = (GriddedGeoDataSet)data.getGriddedData();
                            } else {
                                gridded = new GriddedGeoDataSet((GriddedRegion)new CaliforniaRegions.RELM_TESTING_GRIDDED(0.1), true);
                                Preconditions.checkState((gridded.size() == geo.size() ? 1 : 0) != 0, (Object)"Can't map to gridded geo dataset!");
                                for (int i = 0; i < gridded.size(); ++i) {
                                    gridded.set(i, geo.get(i));
                                }
                            }
                            if (log) {
                                gridded.exp(10.0);
                            }
                            return gridded;
                        }
                    }
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(null, e, "Error Loading Plot Data", 0);
                }
            }
            return null;
        }
        FaultSystemSolutionERF erf = new FaultSystemSolutionERF(sol);
        erf.getParameter("Apply Aftershock Filter").setValue((Object)false);
        if (includeFaultsInGridded) {
            erf.setParameter("Background Seismicity", (Object)IncludeBackgroundOption.INCLUDE);
        } else {
            erf.setParameter("Background Seismicity", (Object)IncludeBackgroundOption.ONLY);
        }
        erf.updateForecast();
        if (participation) {
            return ERF_Calculator.getParticipationRatesInRegion((ERF)erf, (GriddedRegion)griddedRegion, (double)minMag, (double)maxMag, (RupNodesCache)cache);
        }
        return ERF_Calculator.getNucleationRatesInRegion((ERF)erf, (GriddedRegion)griddedRegion, (double)minMag, (double)maxMag, (RupNodesCache)cache);
    }

    static vtkActor buildActorForGriddedData(GriddedGeoDataSet geo, boolean cptLog, CPT cpt, double depth, boolean skipNaN, double opacity) {
        if (cptLog) {
            geo = geo.copy();
            geo.log10();
        }
        geo = ParticipationRateColorer.superSample(geo, 0.05);
        vtkActor actor = GeoDataSetGeometryGenerator.buildPolygonSurface(geo, cpt, true);
        actor.GetProperty().SetOpacity(opacity);
        return actor;
    }

    private static GriddedGeoDataSet superSample(GriddedGeoDataSet in, double targetSpacing) {
        GriddedRegion inReg = in.getRegion();
        double inSpacing = inReg.getLatSpacing();
        System.out.println("Super-sampling with inSpacing=" + inSpacing + ", target=" + targetSpacing);
        Preconditions.checkState(((float)inSpacing == (float)inReg.getLonSpacing() ? 1 : 0) != 0, (Object)"latSpacing != lonSpacing");
        if (inSpacing <= targetSpacing) {
            return in;
        }
        double outSpacing = inSpacing;
        int numPer = 1;
        while (outSpacing > targetSpacing) {
            outSpacing = inSpacing / (double)(++numPer);
        }
        System.out.println("Output spacing: " + outSpacing + ", numPer=" + numPer);
        DataUtils.MinMaxAveTracker latTrack = new DataUtils.MinMaxAveTracker();
        DataUtils.MinMaxAveTracker lonTrack = new DataUtils.MinMaxAveTracker();
        for (Location loc : inReg.getNodeList()) {
            latTrack.addValue(loc.getLatitude());
            lonTrack.addValue(loc.getLongitude());
        }
        int inNX = (int)((lonTrack.getMax() - lonTrack.getMin()) / inSpacing + 0.5) + 1;
        int inNY = (int)((latTrack.getMax() - latTrack.getMin()) / inSpacing + 0.5) + 1;
        EvenlyDiscrXYZ_DataSet inXYZ = new EvenlyDiscrXYZ_DataSet(inNX, inNY, lonTrack.getMin(), latTrack.getMin(), inSpacing);
        for (int i = 0; i < inXYZ.size(); ++i) {
            inXYZ.set(i, Double.NaN);
        }
        EvenlyDiscrXYZ_DataSet outXYZ = new EvenlyDiscrXYZ_DataSet(inNX * numPer, inNY * numPer, lonTrack.getMin(), latTrack.getMin(), outSpacing);
        for (int i = 0; i < outXYZ.size(); ++i) {
            outXYZ.set(i, Double.NaN);
        }
        for (Location loc : inReg.getNodeList()) {
            inXYZ.set(loc.getLongitude(), loc.getLatitude(), in.get(loc));
        }
        double each = 1.0 / (double)numPer;
        for (int x = 0; x < inXYZ.getNumX() - 1; ++x) {
            for (int y = 0; y < inXYZ.getNumY() - 1; ++y) {
                double[][] G = new double[][]{ParticipationRateColorer.getG_row(x, y, 0, inXYZ), ParticipationRateColorer.getG_row(x, y, 1, inXYZ), ParticipationRateColorer.getG_row(x, y, 2, inXYZ), ParticipationRateColorer.getG_row(x, y, 3, inXYZ)};
                BicubicInterpolation2D interp = new BicubicInterpolation2D((double[][])G);
                int outX = x * numPer;
                int outY = y * numPer;
                for (int i = 0; i < numPer; ++i) {
                    double x1 = each * (double)i;
                    for (int j = 0; j < numPer; ++j) {
                        double y1 = each * (double)j;
                        double val = interp.eval(x1, y1);
                        outXYZ.set(outX + i, outY + j, val);
                    }
                }
            }
        }
        Location lowerLeft = new Location(inXYZ.getMinY(), inXYZ.getMinX());
        Location upperRight = new Location(inXYZ.getMaxY(), inXYZ.getMaxX());
        GriddedRegion outReg = new GriddedRegion(lowerLeft, upperRight, outSpacing, lowerLeft);
        GriddedGeoDataSet out = new GriddedGeoDataSet(outReg, in.isLatitudeX());
        for (int i = 0; i < outXYZ.size(); ++i) {
            Point2D pt = outXYZ.getPoint(i);
            Location loc = new Location(pt.getY(), pt.getX());
            if (!out.contains(loc)) continue;
            out.set(loc, outXYZ.get(i));
        }
        return out;
    }

    private static double[] getG_row(int x, int y, int row, EvenlyDiscrXYZ_DataSet inXYZ) {
        double[] ret = new double[4];
        if ((y += row - 1) < 0 || y >= inXYZ.getNumY()) {
            for (int i = 0; i < 4; ++i) {
                ret[i] = Double.NaN;
            }
            return ret;
        }
        for (int i = 0; i < 4; ++i) {
            int myX = x + (i - 1);
            ret[i] = myX < 0 || myX >= inXYZ.getNumX() ? Double.NaN : inXYZ.get(x, y);
        }
        return ret;
    }

    private void displayGriddedData() {
        if (this.griddedDataActor != null) {
            this.actors.removeActor((vtkProp)this.griddedDataActor);
            this.griddedDataActor = null;
            MainGUI.updateRenderWindow();
        }
        if (!((Boolean)this.displayGriddedParam.getValue()).booleanValue()) {
            return;
        }
        if (this.sol == null) {
            return;
        }
        if (this.loadedGriddedData == null) {
            CaliforniaRegions.RELM_TESTING_GRIDDED griddedRegion = new CaliforniaRegions.RELM_TESTING_GRIDDED(0.1);
            double minMag = (Double)this.magMinParam.getValue();
            double maxMag = (Double)this.magMaxParam.getValue();
            this.loadedGriddedData = ParticipationRateColorer.loadGriddedData(this.sol, (GriddedRegion)griddedRegion, minMag, maxMag, null, true, (Boolean)this.includeFaultsInGriddedParam.getValue());
        }
        if (this.loadedGriddedData == null) {
            this.displayGriddedParam.setValue((Object)false);
        } else {
            this.griddedDataActor = ParticipationRateColorer.buildActorForGriddedData(this.loadedGriddedData, this.isCPTLog(), this.getCPT(), (Double)this.griddedDepthParam.getValue(), false, (Double)this.griddedDataOpacityParam.getValue());
            this.actors.addActor((vtkProp)this.griddedDataActor);
            MainGUI.updateRenderWindow();
        }
    }

    @Override
    public String getLegendLabel() {
        Object label = ((PlotType)((Object)this.plotTypeParam.getValue())).toString();
        label = this.max < 9.0 ? this.smartMagLabel(this.min) + "\u2264M\u2264" + this.smartMagLabel(this.max) + " " + (String)label : "M\u2265" + this.smartMagLabel(this.min) + " " + (String)label;
        if (((Boolean)this.probabilityParam.getValue()).booleanValue()) {
            double duration = (Double)this.probDurationParam.getValue();
            String probStr = duration == (double)((int)duration) ? (int)duration + "yr" : (float)duration + "yr";
            probStr = probStr + " Prob";
            label = ((String)label).replace("Rate", probStr);
        }
        return label;
    }

    private String smartMagLabel(double mag) {
        if (mag == (double)((int)mag)) {
            return "" + (int)mag;
        }
        return "" + (float)mag;
    }

    private static enum PlotType {
        TIME_INDEP("Long Term Rate"),
        TIME_DEP("UCERF3-TD Rate"),
        RATIO("Ratio TD/TI");

        private String name;

        private PlotType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public boolean usesTD() {
            return this == TIME_DEP || this == RATIO;
        }
    }
}

